/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.sesame.query.BinaryTableResultConstants;
import org.openrdf.sesame.query.QueryErrorType;
import org.openrdf.sesame.query.TableQueryResultListener;

public class BinaryTableResultWriter
implements BinaryTableResultConstants,
TableQueryResultListener {
    private DataOutputStream _out;
    private Map _namespaceTable = new HashMap(32);
    private int _nextNamespaceID;
    private Value[] _previousRow;
    private int _columnIdx;

    public BinaryTableResultWriter(OutputStream out) {
        this._out = new DataOutputStream(out);
    }

    public void startTableQueryResult() throws IOException {
        throw new RuntimeException("Column headers must be specified for binary table results.");
    }

    public void startTableQueryResult(String[] columnHeaders) throws IOException {
        this._out.write(MAGIC_NUMBER);
        this._out.writeInt(1);
        this._out.writeInt(columnHeaders.length);
        for (int i = 0; i < columnHeaders.length; ++i) {
            this._out.writeUTF(columnHeaders[i]);
        }
        this._previousRow = new Value[columnHeaders.length];
        this._nextNamespaceID = 0;
    }

    public void endTableQueryResult() throws IOException {
        this._out.writeByte(127);
        this._out.flush();
    }

    public void startTuple() throws IOException {
        this._columnIdx = -1;
    }

    public void endTuple() throws IOException {
    }

    public void tupleValue(Value value2) throws IOException {
        ++this._columnIdx;
        if (value2 == null) {
            this._writeNull();
        } else if (value2.equals(this._previousRow[this._columnIdx])) {
            this._writeRepeat();
        } else if (value2 instanceof URI) {
            this._writeQName((URI)value2);
        } else if (value2 instanceof BNode) {
            this._writeBNode((BNode)value2);
        } else if (value2 instanceof Literal) {
            this._writeLiteral((Literal)value2);
        } else {
            throw new IOException("Unknown Value object type: " + value2.getClass());
        }
        this._previousRow[this._columnIdx] = value2;
    }

    private void _writeNull() throws IOException {
        this._out.writeByte(0);
    }

    private void _writeRepeat() throws IOException {
        this._out.writeByte(1);
    }

    private void _writeQName(URI uri2) throws IOException {
        String namespace = uri2.getNamespace();
        Integer nsID = (Integer)this._namespaceTable.get(namespace);
        if (nsID == null) {
            nsID = this._writeNamespace(namespace);
        }
        this._out.writeByte(3);
        this._out.writeInt(nsID);
        this._out.writeUTF(uri2.getLocalName());
    }

    private void _writeBNode(BNode bnode) throws IOException {
        this._out.writeByte(5);
        this._out.writeUTF(bnode.getID());
    }

    private void _writeLiteral(Literal literal) throws IOException {
        String label = literal.getLabel();
        String language2 = literal.getLanguage();
        URI datatype = literal.getDatatype();
        int marker = 6;
        if (datatype != null) {
            String namespace = datatype.getNamespace();
            if (!this._namespaceTable.containsKey(namespace)) {
                this._writeNamespace(namespace);
            }
            marker = 8;
        } else if (language2 != null) {
            marker = 7;
        }
        this._out.writeByte(marker);
        this._out.writeUTF(label);
        if (datatype != null) {
            this._writeQName(datatype);
        } else if (language2 != null) {
            this._out.writeUTF(language2);
        }
    }

    public void error(QueryErrorType errType, String msg) throws IOException {
        this._out.writeByte(126);
        if (errType == QueryErrorType.MALFORMED_QUERY_ERROR) {
            this._out.writeByte(1);
        } else {
            this._out.writeByte(2);
        }
        this._out.writeUTF(msg);
    }

    private Integer _writeNamespace(String namespace) throws IOException {
        this._out.writeByte(2);
        this._out.writeInt(this._nextNamespaceID);
        this._out.writeUTF(namespace);
        Integer result2 = new Integer(this._nextNamespaceID);
        this._namespaceTable.put(namespace, result2);
        ++this._nextNamespaceID;
        return result2;
    }
}

