/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.sesame.query.BinaryTableResultConstants;
import org.openrdf.sesame.query.QueryErrorType;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.util.io.IOUtil;

public class BinaryTableResultReader
implements BinaryTableResultConstants {
    private ValueFactory _valFactory;
    private TableQueryResultListener _listener;
    private DataInputStream _in;
    private int _columnIdx;
    private int _columnCount;
    private Value[] _previousRow;
    private String[] _namespaceArray = new String[32];

    public BinaryTableResultReader() {
        this(new ValueFactoryImpl());
    }

    public BinaryTableResultReader(ValueFactory valueFactory) {
        this._valFactory = valueFactory;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void read(InputStream in, TableQueryResultListener listener) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("Input stream can not be 'null'");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener can not be 'null'");
        }
        this._in = new DataInputStream(in);
        this._listener = listener;
        byte[] magicNumber = IOUtil.readBytes((InputStream)this._in, (int)MAGIC_NUMBER.length);
        if (!Arrays.equals(magicNumber, MAGIC_NUMBER)) {
            throw new IOException("File does not contain a binary RDF table result");
        }
        int formatVersion = this._in.readInt();
        if (formatVersion != 1) {
            throw new IOException("Incompatible format version: " + formatVersion);
        }
        this._columnCount = this._in.readInt();
        if (this._columnCount < 1) {
            throw new IOException("Illegal column count specified: " + this._columnCount);
        }
        String[] columnHeaders = new String[this._columnCount];
        for (int i = 0; i < this._columnCount; ++i) {
            columnHeaders[i] = this._in.readUTF();
        }
        this._listener.startTableQueryResult(columnHeaders);
        this._previousRow = new Value[this._columnCount];
        this._columnIdx = 0;
        byte recordTypeMarker = this._in.readByte();
        while (recordTypeMarker != 127) {
            if (recordTypeMarker == 126) {
                this._processError();
            } else if (recordTypeMarker == 2) {
                this._processNamespace();
            } else {
                void var7_7;
                switch (recordTypeMarker) {
                    case 0: {
                        Value value2 = null;
                        break;
                    }
                    case 1: {
                        Value value2 = this._previousRow[this._columnIdx];
                        break;
                    }
                    case 3: {
                        Value value2 = this._readQName();
                        break;
                    }
                    case 4: {
                        Value value2 = this._readURI();
                        break;
                    }
                    case 5: {
                        Value value2 = this._readBnode();
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        Value value2 = this._readLiteral(recordTypeMarker);
                        break;
                    }
                    default: {
                        throw new IOException("Unkown record type: " + recordTypeMarker);
                    }
                }
                this._previousRow[this._columnIdx] = var7_7;
                if (this._columnIdx == 0) {
                    this._listener.startTuple();
                }
                this._listener.tupleValue((Value)var7_7);
                ++this._columnIdx;
                if (this._columnIdx == this._columnCount) {
                    this._listener.endTuple();
                    this._columnIdx = 0;
                }
            }
            recordTypeMarker = this._in.readByte();
        }
        this._listener.endTableQueryResult();
    }

    private void _processError() throws IOException {
        byte errTypeFlag = this._in.readByte();
        QueryErrorType errType = null;
        if (errTypeFlag == 1) {
            errType = QueryErrorType.MALFORMED_QUERY_ERROR;
        } else if (errTypeFlag == 2) {
            errType = QueryErrorType.QUERY_EVALUATION_ERROR;
        } else {
            throw new IOException("Unkown error type: " + errTypeFlag);
        }
        String msg = this._in.readUTF();
        this._listener.error(errType, msg);
    }

    private void _processNamespace() throws IOException {
        int namespaceID = this._in.readInt();
        String namespace = this._in.readUTF();
        if (namespaceID >= this._namespaceArray.length) {
            int newSize = Math.max(namespaceID, this._namespaceArray.length * 2);
            String[] newArray = new String[newSize];
            System.arraycopy(this._namespaceArray, 0, newArray, 0, this._namespaceArray.length);
            this._namespaceArray = newArray;
        }
        this._namespaceArray[namespaceID] = namespace;
    }

    private URI _readQName() throws IOException {
        int nsID = this._in.readInt();
        String localName = this._in.readUTF();
        return this._valFactory.createURI(this._namespaceArray[nsID], localName);
    }

    private URI _readURI() throws IOException {
        String uri2 = this._in.readUTF();
        return this._valFactory.createURI(uri2);
    }

    private BNode _readBnode() throws IOException {
        String bnodeID = this._in.readUTF();
        return this._valFactory.createBNode(bnodeID);
    }

    private Literal _readLiteral(int recordTypeMarker) throws IOException {
        String label = this._in.readUTF();
        if (recordTypeMarker == 8) {
            URI datatype = null;
            byte dtTypeMarker = this._in.readByte();
            switch (dtTypeMarker) {
                case 3: {
                    datatype = this._readQName();
                    break;
                }
                case 4: {
                    datatype = this._readURI();
                    break;
                }
                default: {
                    throw new IOException("Illegal record type marker for literal's datatype");
                }
            }
            return this._valFactory.createLiteral(label, datatype);
        }
        if (recordTypeMarker == 7) {
            String language2 = this._in.readUTF();
            return this._valFactory.createLiteral(label, language2);
        }
        return this._valFactory.createLiteral(label);
    }
}

