/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.config.ui;

import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import org.openrdf.sesame.config.SystemConfig;
import org.openrdf.sesame.config.UserInfo;
import org.openrdf.sesame.config.ui.ColumnData;
import org.openrdf.sesame.config.ui.XTableModel;

public class UserTableModel
extends XTableModel {
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_LOGIN = 1;
    public static final int COLUMN_FULL_NAME = 2;
    public static final int COLUMN_PASSWORD = 3;

    public UserTableModel(SystemConfig config) {
        super(config, new ColumnData[]{new ColumnData("Id", 50, 2), new ColumnData("Login", 100, 2), new ColumnData("Full name", 200, 2), new ColumnData("Password", 100, 2)});
    }

    public int getIdentifyingColumn() {
        return 1;
    }

    public Object getValueAt(int row, int column) {
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        UserData userData = (UserData)this._rows.get(row);
        switch (column) {
            case 0: {
                return new Integer(userData.getId());
            }
            case 1: {
                return userData.getLogin();
            }
            case 2: {
                return userData.getFullName();
            }
            case 3: {
                return userData.getPassword();
            }
        }
        return null;
    }

    public void setValueAt(Object value2, int row, int column) {
        if (row < 0 || row >= this.getRowCount()) {
            return;
        }
        UserData userData = (UserData)this._rows.get(row);
        switch (column) {
            case 0: {
                int id = 0;
                try {
                    id = Integer.parseInt(value2.toString());
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (userData.getId() == id) break;
                this._config.setUserId(userData.getLogin(), id);
                break;
            }
            case 1: {
                String newLogin = value2.toString();
                if (userData.isNew()) {
                    userData.setLogin(newLogin);
                    this.fireTableRowsUpdated(row, row);
                    break;
                }
                String oldLogin = userData.getLogin();
                if (oldLogin.equals(newLogin)) break;
                this._config.setUserLogin(oldLogin, newLogin);
                break;
            }
            case 2: {
                String newFullName = value2.toString();
                if (userData.isNew()) {
                    userData.setFullName(newFullName);
                    this.fireTableRowsUpdated(row, row);
                    break;
                }
                if (userData.getFullName().equals(newFullName)) break;
                this._config.setUserFullName(userData.getLogin(), newFullName);
                break;
            }
            case 3: {
                String newPassword = value2.toString();
                if (userData.isNew()) {
                    userData.setPassword(newPassword);
                    this._config.addUser(userData.getId(), userData.getLogin(), userData.getFullName(), userData.getPassword());
                    break;
                }
                if (userData.getPassword().equals(newPassword)) break;
                this._config.setUserPassword(userData.getLogin(), newPassword);
            }
        }
    }

    public void configurationChanged() {
        this._updateTable();
    }

    protected void _updateTable() {
        ListIterator rowsIter = this._rows.listIterator();
        while (rowsIter.hasNext()) {
            UserData userData = (UserData)rowsIter.next();
            if (!userData.isNew()) continue;
            return;
        }
        this._rows.clear();
        Iterator userInfoIter = this._config.getUserInfoList().iterator();
        while (userInfoIter.hasNext()) {
            UserInfo userInfo = (UserInfo)userInfoIter.next();
            this._rows.add(new UserData(userInfo.getID(), userInfo.getLogin(), userInfo.getFullName(), userInfo.getPassword()));
        }
        Collections.sort(this._rows);
        this.fireTableDataChanged();
    }

    protected XTableModel.RowData _createRow() {
        return new UserData(this._config.getUnusedUserId());
    }

    protected class UserData
    extends XTableModel.RowData {
        protected int _id;
        protected String _login;
        protected String _fullName;
        protected String _password;

        public UserData(int id) {
            super(UserTableModel.this);
            this._id = id;
        }

        public UserData(int id, String login, String fullName, String password) {
            super(UserTableModel.this);
            this._id = id;
            this._login = login;
            this._fullName = fullName;
            this._password = password;
        }

        public String getIdentifier() {
            return this.getLogin();
        }

        public int getId() {
            return this._id;
        }

        public String getLogin() {
            return this._login;
        }

        public void setLogin(String login) {
            this._login = login;
        }

        public String getFullName() {
            return this._fullName;
        }

        public void setFullName(String fullName) {
            this._fullName = fullName;
        }

        public String getPassword() {
            return this._password;
        }

        public void setPassword(String password) {
            this._password = password;
        }

        public boolean isNew() {
            return this._login == null || this._fullName == null || this._password == null;
        }
    }
}

