/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.config.ui;

import java.util.Iterator;
import org.openrdf.sesame.config.SailConfig;
import org.openrdf.sesame.config.SystemConfig;
import org.openrdf.sesame.config.ui.ColumnData;
import org.openrdf.sesame.config.ui.XTableModel;

public class SailTableModel
extends XTableModel {
    public static final int COLUMN_CLASS = 0;
    protected String _id;

    public SailTableModel(String id, SystemConfig config) {
        super(config, new ColumnData[]{new ColumnData("Class", 133, 2)});
        this._id = id;
        this._updateTable();
    }

    public int getIdentifyingColumn() {
        return 0;
    }

    public Object getValueAt(int row, int column) {
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        SailData sail = (SailData)this._rows.get(row);
        switch (column) {
            case 0: {
                return sail.getSailClass();
            }
        }
        return null;
    }

    public void setValueAt(Object value2, int row, int column) {
        if (row < 0 || row >= this.getRowCount()) {
            return;
        }
        SailData sailData = (SailData)this._rows.get(row);
        String stringValue = value2.toString();
        switch (column) {
            case 0: {
                if (sailData.isNew()) {
                    sailData.setSailClass(stringValue);
                    this._config.addSail(this._id, sailData.getSailClass(), row);
                    break;
                }
                String sailClass = sailData.getSailClass();
                if (sailClass.equals(stringValue)) break;
                this._config.setSail(this._id, sailClass, stringValue);
            }
        }
    }

    public void configurationChanged() {
        this._updateTable();
    }

    protected void _updateTable() {
        Iterator rowsIter = this._rows.iterator();
        while (rowsIter.hasNext()) {
            SailData sailData = (SailData)rowsIter.next();
            if (!sailData.isNew()) continue;
            return;
        }
        this._rows.clear();
        if (!this._config.hasRepository(this._id)) {
            this._id = null;
        } else {
            Iterator sailInfoIter = this._config.getSails(this._id).iterator();
            while (sailInfoIter.hasNext()) {
                SailConfig sailConfig = (SailConfig)sailInfoIter.next();
                this._rows.add(new SailData(sailConfig.getSailClass()));
            }
        }
        this.fireTableDataChanged();
    }

    protected XTableModel.RowData _createRow() {
        return new SailData();
    }

    protected class SailData
    extends XTableModel.RowData {
        protected String _sailClass;

        public SailData() {
            super(SailTableModel.this);
        }

        public SailData(String sailClass) {
            super(SailTableModel.this);
            this._sailClass = sailClass;
        }

        public String getIdentifier() {
            return this.getSailClass();
        }

        public String getSailClass() {
            return this._sailClass;
        }

        public void setSailClass(String sailClass) {
            this._sailClass = sailClass;
        }

        public boolean isNew() {
            return this._sailClass == null;
        }
    }
}

