/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.config.ui;

import java.util.Collections;
import java.util.Iterator;
import org.openrdf.sesame.config.RepositoryInfo;
import org.openrdf.sesame.config.SystemConfig;
import org.openrdf.sesame.config.ui.ColumnData;
import org.openrdf.sesame.config.ui.XTableModel;

public class RepositoryTableModel
extends XTableModel {
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_TITLE = 1;

    public RepositoryTableModel(SystemConfig config) {
        super(config, new ColumnData[]{new ColumnData("Id", 125, 2), new ColumnData("Title", 325, 2)});
    }

    public int getIdentifyingColumn() {
        return 0;
    }

    public Object getValueAt(int row, int column) {
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        RepositoryData repository = (RepositoryData)this._rows.get(row);
        switch (column) {
            case 0: {
                return repository.getId();
            }
            case 1: {
                return repository.getTitle();
            }
        }
        return null;
    }

    public void setValueAt(Object value2, int row, int column) {
        if (row < 0 || row >= this.getRowCount()) {
            return;
        }
        RepositoryData repository = (RepositoryData)this._rows.get(row);
        String stringValue = value2.toString();
        switch (column) {
            case 0: {
                if (repository.isNew()) {
                    repository.setId(stringValue);
                    this.fireTableRowsUpdated(row, row);
                    break;
                }
                String id = repository.getId();
                if (id.equals(stringValue)) break;
                this._config.setRepositoryId(id, stringValue);
                break;
            }
            case 1: {
                if (repository.isNew()) {
                    repository.setTitle(stringValue);
                    this._config.addRepository(repository.getId(), repository.getTitle());
                    break;
                }
                if (repository.getTitle().equals(stringValue)) break;
                this._config.setRepositoryTitle(repository.getId(), stringValue);
            }
        }
    }

    public void configurationChanged() {
        this._updateTable();
    }

    protected void _updateTable() {
        Iterator rowsIter = this._rows.iterator();
        while (rowsIter.hasNext()) {
            RepositoryData repData = (RepositoryData)rowsIter.next();
            if (!repData.isNew()) continue;
            return;
        }
        this._rows.clear();
        Iterator repInfoIter = this._config.getRepositoryConfigList().iterator();
        while (repInfoIter.hasNext()) {
            RepositoryInfo repInfo = (RepositoryInfo)repInfoIter.next();
            this._rows.add(new RepositoryData(repInfo.getRepositoryId(), repInfo.getTitle()));
        }
        Collections.sort(this._rows);
        this.fireTableDataChanged();
    }

    public String cloneRow(int rowIdx) {
        RepositoryData orig = (RepositoryData)this._rows.get(rowIdx);
        String origId = orig.getId();
        String cloneId = null;
        int i = 1;
        boolean isNewID = false;
        block0: while (!isNewID) {
            cloneId = origId + "-" + ++i;
            isNewID = true;
            Iterator rowsIter = this._rows.iterator();
            while (rowsIter.hasNext()) {
                RepositoryData repData = (RepositoryData)rowsIter.next();
                if (!repData.getId().equals(cloneId)) continue;
                isNewID = false;
                continue block0;
            }
        }
        this._config.cloneRepository(origId, cloneId);
        return cloneId;
    }

    protected XTableModel.RowData _createRow() {
        return new RepositoryData();
    }

    protected class RepositoryData
    extends XTableModel.RowData {
        protected String _id;
        protected String _title;

        public RepositoryData() {
            super(RepositoryTableModel.this);
        }

        public RepositoryData(String id, String title) {
            super(RepositoryTableModel.this);
            this._id = id;
            this._title = title;
        }

        public String getIdentifier() {
            return this.getId();
        }

        public String getId() {
            return this._id;
        }

        public String getTitle() {
            return this._title;
        }

        public void setId(String id) {
            this._id = id;
        }

        public void setTitle(String title) {
            this._title = title;
        }

        public boolean isNew() {
            return this._id == null || this._title == null;
        }
    }
}

