/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.config.ui;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.openrdf.sesame.config.SystemConfig;
import org.openrdf.sesame.config.ui.ColumnData;
import org.openrdf.sesame.config.ui.XTableModel;

public class ParameterTableModel
extends XTableModel {
    public static final int COLUMN_KEY = 0;
    public static final int COLUMN_VALUE = 1;
    protected String _id;
    protected String _sailClass;

    public ParameterTableModel(String id, SystemConfig config) {
        super(config, new ColumnData[]{new ColumnData("Key", 133, 2), new ColumnData("Value", 267, 2)});
        this._id = id;
        this._updateTable();
    }

    public int getIdentifyingColumn() {
        return 0;
    }

    public Object getValueAt(int row, int column) {
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        ParameterData parameter = (ParameterData)this._rows.get(row);
        switch (column) {
            case 0: {
                return parameter.getKey();
            }
            case 1: {
                return parameter.getValue();
            }
        }
        return null;
    }

    public void setValueAt(Object value2, int row, int column) {
        if (row < 0 || row >= this.getRowCount()) {
            return;
        }
        ParameterData parameter = (ParameterData)this._rows.get(row);
        String stringValue = value2.toString();
        switch (column) {
            case 0: {
                if (parameter.isNew()) {
                    parameter.setKey(stringValue);
                    this.fireTableRowsUpdated(row, row);
                    break;
                }
                String key = parameter.getKey();
                if (key.equals(stringValue)) break;
                this._config.setParameterKey(this._id, this._sailClass, key, stringValue);
                break;
            }
            case 1: {
                if (parameter.isNew()) {
                    parameter.setValue(stringValue);
                    this._config.setParameter(this._id, this._sailClass, parameter.getKey(), parameter.getValue());
                    break;
                }
                if (parameter.getValue().equals(stringValue)) break;
                this._config.setParameterValue(this._id, this._sailClass, parameter.getKey(), stringValue);
            }
        }
    }

    public void setSailClass(String sailClass) {
        this._sailClass = sailClass;
        this._updateTable();
    }

    public void configurationChanged() {
        this._updateTable();
    }

    protected void _updateTable() {
        Iterator rowsIter = this._rows.iterator();
        while (rowsIter.hasNext()) {
            ParameterData parameter = (ParameterData)rowsIter.next();
            if (!parameter.isNew()) continue;
            return;
        }
        this._rows.clear();
        if (!this._config.hasRepository(this._id)) {
            this._id = null;
        } else if (!this._config.hasSail(this._id, this._sailClass)) {
            this._sailClass = null;
        } else if (this._sailClass != null) {
            Map parameters = this._config.getParameters(this._id, this._sailClass);
            Iterator keyIter = parameters.keySet().iterator();
            while (keyIter.hasNext()) {
                String key = (String)keyIter.next();
                String value2 = (String)parameters.get(key);
                this._rows.add(new ParameterData(key, value2));
            }
            Collections.sort(this._rows);
        }
        this.fireTableDataChanged();
    }

    protected XTableModel.RowData _createRow() {
        return new ParameterData();
    }

    protected class ParameterData
    extends XTableModel.RowData {
        protected String _key;
        protected String _value;

        public ParameterData() {
            super(ParameterTableModel.this);
        }

        public ParameterData(String key, String value2) {
            super(ParameterTableModel.this);
            this._key = key;
            this._value = value2;
        }

        public String getIdentifier() {
            return this.getKey();
        }

        public String getKey() {
            return this._key;
        }

        public String getValue() {
            return this._value;
        }

        public void setKey(String key) {
            this._key = key;
        }

        public void setValue(String value2) {
            this._value = value2;
        }

        public boolean isNew() {
            return this._key == null || this._value == null;
        }
    }
}

