/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.config.ui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openrdf.sesame.config.SystemConfig;
import org.openrdf.sesame.config.ui.AccessControlTable;
import org.openrdf.sesame.config.ui.ParameterTable;
import org.openrdf.sesame.config.ui.SailTable;
import org.openrdf.sesame.config.ui.util.GridBagUtil;
import org.openrdf.sesame.config.ui.util.Util;

public class AdvancedDialog
extends JDialog
implements ActionListener {
    protected static final int DEFAULT_HEIGHT = 84;
    protected String _id;
    protected SystemConfig _config;
    protected AccessControlTable _accessControlTable;
    protected SailTable _sailTable;
    protected ParameterTable _parameterTable;
    protected JButton _okButton;
    protected JButton _cancelButton;

    public AdvancedDialog(Frame owner, String id, SystemConfig config) {
        super(owner, "Details for repository " + id, true);
        this._id = id;
        this._config = config;
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        URL url = this.getClass().getResource("icons/details-repository.png");
        JLabel icon = new JLabel(new ImageIcon(url));
        GridBagUtil.constrain(contentPane, icon, 0, 0, 1, 1, 0, 10, 0.0, 0.0, 8, 8, 4, 4);
        JTextArea explanation = Util.createReadOnlyTextArea("Use the lists below to configure the sail stack and access rights.", this.getBackground());
        GridBagUtil.constrain(contentPane, explanation, 1, 0, 1, 1, 0, 17, 0.0, 0.0, 8, 4, 0, 8);
        JTabbedPane tabbedPane = new JTabbedPane();
        GridBagUtil.constrain(contentPane, tabbedPane, 0, 1, 2, 1, 1, 10, 1.0, 1.0, 4, 8, 0, 8);
        tabbedPane.add("Sail configuration", new SailStackPanel());
        tabbedPane.add("Access rights", new AccessControlPanel());
        GridBagUtil.constrain(contentPane, this._createButtons(), 0, 2, 2, 1, 0, 10, 1.0, 0.0, 8, 8, 8, 8);
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    protected JPanel _createButtons() {
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 4, 0));
        this._okButton = new JButton("OK");
        this._okButton.setToolTipText("Apply changes and close window");
        buttonPanel.add(this._okButton);
        this._okButton.addActionListener(this);
        this._cancelButton = new JButton("Cancel");
        this._cancelButton.setToolTipText("Cancel changes and close window");
        buttonPanel.add(this._cancelButton);
        this._cancelButton.addActionListener(this);
        return buttonPanel;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this._okButton) {
            if (this._accessControlTable.stopCellEditing() && this._sailTable.stopCellEditing() && this._parameterTable.stopCellEditing()) {
                this.setVisible(false);
                this.dispose();
            } else {
                this.requestFocus();
            }
        } else if (source == this._cancelButton) {
            this.setVisible(false);
            this.dispose();
        }
    }

    public void requestFocus() {
        if (this._accessControlTable.isEditing()) {
            this._accessControlTable.requestFocus();
        } else if (this._sailTable.isEditing()) {
            this._sailTable.requestFocus();
        } else if (this._parameterTable.isEditing()) {
            this._parameterTable.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    protected class SailStackPanel
    extends JPanel
    implements ActionListener,
    ListSelectionListener {
        protected JButton _upButton;
        protected JButton _downButton;
        protected JButton _addButton;
        protected JButton _removeButton;

        public SailStackPanel() {
            this.setLayout(new GridBagLayout());
            Border emptyBorder = BorderFactory.createEmptyBorder(8, 8, 8, 8);
            this.setBorder(emptyBorder);
            JLabel title = new JLabel("Sail stack:");
            GridBagUtil.constrain(this, title, 0, 0, 1, 1, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
            GridBagUtil.constrain(this, this._createList(), 0, 1, 1, 1, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
            GridBagUtil.constrain(this, this._createUpDownButtons(), 1, 1, 1, 1, 0, 13, 0.0, 0.0, 0, 4, 0, 0);
            GridBagUtil.constrain(this, this._createOkCancelButtons(), 0, 2, 1, 1, 0, 13, 1.0, 0.0, 4, 0, 0, 0);
            ParameterPanel parameterPanel = new ParameterPanel();
            GridBagUtil.constrain(this, parameterPanel, 0, 3, 1, 1, 1, 10, 1.0, 1.0, 12, 0, 0, 0);
            AdvancedDialog.this._sailTable.getSelectionModel().addListSelectionListener(this);
            AdvancedDialog.this._sailTable.getSelectionModel().addListSelectionListener(parameterPanel);
            this._updateButtonStatus();
        }

        protected JScrollPane _createList() {
            JScrollPane scrollPane = new JScrollPane();
            AdvancedDialog.this._sailTable = new SailTable(AdvancedDialog.this._id, AdvancedDialog.this._config);
            JViewport viewport = scrollPane.getViewport();
            viewport.add(AdvancedDialog.this._sailTable);
            viewport.setBackground(Color.white);
            scrollPane.setVerticalScrollBarPolicy(22);
            Insets insets = scrollPane.getInsets();
            Dimension scrollBarSize = scrollPane.getVerticalScrollBar().getPreferredSize();
            Dimension tableSize = AdvancedDialog.this._sailTable.getPreferredSize();
            int width = insets.left + scrollBarSize.width + tableSize.width + insets.right;
            scrollPane.setPreferredSize(new Dimension(width, 84));
            return scrollPane;
        }

        protected JPanel _createUpDownButtons() {
            JPanel buttonPanel = new JPanel(new GridLayout(2, 1, 0, 4));
            URL upArrowImg = this.getClass().getResource("icons/uparrow.png");
            this._upButton = new JButton(new ImageIcon(upArrowImg));
            this._upButton.setToolTipText("Move Sail upwards in stack");
            buttonPanel.add(this._upButton);
            this._upButton.addActionListener(this);
            URL downArrowImg = this.getClass().getResource("icons/downarrow.png");
            this._downButton = new JButton(new ImageIcon(downArrowImg));
            this._downButton.setToolTipText("Move Sail downwards in stack");
            buttonPanel.add(this._downButton);
            this._downButton.addActionListener(this);
            return buttonPanel;
        }

        protected JPanel _createOkCancelButtons() {
            JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 4, 0));
            this._addButton = new JButton("Add...");
            this._addButton.setToolTipText("Add new Sail to stack");
            buttonPanel.add(this._addButton);
            this._addButton.addActionListener(this);
            this._removeButton = new JButton("Remove");
            this._removeButton.setToolTipText("Remove Sail from stack");
            buttonPanel.add(this._removeButton);
            this._removeButton.addActionListener(this);
            return buttonPanel;
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (AdvancedDialog.this._sailTable.stopCellEditing()) {
                if (source == this._upButton) {
                    AdvancedDialog.this._sailTable.sailUp();
                } else if (source == this._downButton) {
                    AdvancedDialog.this._sailTable.sailDown();
                } else if (AdvancedDialog.this._parameterTable.stopCellEditing()) {
                    if (source == this._addButton) {
                        AdvancedDialog.this._sailTable.addNewRow();
                    } else if (source == this._removeButton) {
                        AdvancedDialog.this._sailTable.removeRow();
                    }
                }
            }
            if (AdvancedDialog.this._sailTable.isEditing()) {
                AdvancedDialog.this._sailTable.requestFocus();
            } else if (AdvancedDialog.this._parameterTable.isEditing()) {
                AdvancedDialog.this._parameterTable.requestFocus();
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            this._updateButtonStatus();
        }

        protected void _updateButtonStatus() {
            int selectedRow = AdvancedDialog.this._sailTable.getSelectedRow();
            if (selectedRow == -1) {
                this._removeButton.setEnabled(false);
                this._upButton.setEnabled(false);
                this._downButton.setEnabled(false);
            } else {
                this._removeButton.setEnabled(true);
                this._upButton.setEnabled(selectedRow > 0);
                this._downButton.setEnabled(selectedRow < AdvancedDialog.this._sailTable.getRowCount() - 1);
            }
        }

        protected class ParameterPanel
        extends JPanel
        implements ActionListener,
        ListSelectionListener {
            protected String _class;
            protected JScrollPane _scrollPane;
            protected JLabel _title;
            protected JButton _addButton;
            protected JButton _removeButton;

            public ParameterPanel() {
                this.setLayout(new GridBagLayout());
                this._title = new JLabel("Parameters for selected Sail:");
                GridBagUtil.constrain(this, this._title, 0, 0, 1, 1, 0, 17, 1.0, 0.0, 0, 0, 0, 0);
                GridBagUtil.constrain(this, this._createList(), 0, 1, 1, 1, 1, 10, 1.0, 1.0, 4, 0, 0, 0);
                GridBagUtil.constrain(this, this._createButtons(), 0, 2, 1, 1, 0, 13, 1.0, 0.0, 4, 0, 0, 0);
                this._enableDisableComponents();
            }

            protected JScrollPane _createList() {
                ((SailStackPanel)SailStackPanel.this).AdvancedDialog.this._parameterTable = new ParameterTable(((SailStackPanel)SailStackPanel.this).AdvancedDialog.this._id, ((SailStackPanel)SailStackPanel.this).AdvancedDialog.this._config);
                this._scrollPane = new JScrollPane();
                JViewport viewport = this._scrollPane.getViewport();
                viewport.add(((SailStackPanel)SailStackPanel.this).AdvancedDialog.this._parameterTable);
                viewport.setBackground(Color.white);
                this._scrollPane.setVerticalScrollBarPolicy(22);
                Insets insets = this._scrollPane.getInsets();
                Dimension scrollBarSize = this._scrollPane.getVerticalScrollBar().getPreferredSize();
                Dimension tableSize = ((SailStackPanel)SailStackPanel.this).AdvancedDialog.this._parameterTable.getPreferredSize();
                int width = insets.left + scrollBarSize.width + tableSize.width + insets.right;
                this._scrollPane.setPreferredSize(new Dimension(width, 84));
                return this._scrollPane;
            }

            protected JPanel _createButtons() {
                JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 4, 0));
                this._addButton = new JButton("Add...");
                this._addButton.setToolTipText("Add new parameter to list");
                buttonPanel.add(this._addButton);
                this._addButton.addActionListener(this);
                this._removeButton = new JButton("Remove");
                this._removeButton.setToolTipText("Remove parameter from list");
                buttonPanel.add(this._removeButton);
                this._removeButton.addActionListener(this);
                return buttonPanel;
            }

            protected void _enableDisableComponents() {
                int selectedSailIdx = ((SailStackPanel)SailStackPanel.this).AdvancedDialog.this._sailTable.getSelectedRow();
                if (selectedSailIdx == -1) {
                    this._title.setEnabled(false);
                    this._scrollPane.setEnabled(false);
                    this._scrollPane.getViewport().setBackground(this.getBackground());
                    this._addButton.setEnabled(false);
                    this._removeButton.setEnabled(false);
                } else {
                    this._title.setEnabled(true);
                    this._scrollPane.setEnabled(true);
                    this._scrollPane.getViewport().setBackground(Color.white);
                    this._addButton.setEnabled(true);
                    int selectedParamIdx = ((SailStackPanel)SailStackPanel.this).AdvancedDialog.this._parameterTable.getSelectedRow();
                    this._removeButton.setEnabled(selectedParamIdx >= 0);
                }
            }

            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (((SailStackPanel)SailStackPanel.this).AdvancedDialog.this._sailTable.stopCellEditing() && ((SailStackPanel)SailStackPanel.this).AdvancedDialog.this._parameterTable.stopCellEditing()) {
                    if (source == this._addButton) {
                        ((SailStackPanel)SailStackPanel.this).AdvancedDialog.this._parameterTable.addNewRow();
                    } else if (source == this._removeButton) {
                        ((SailStackPanel)SailStackPanel.this).AdvancedDialog.this._parameterTable.removeRow();
                    }
                }
                if (((SailStackPanel)SailStackPanel.this).AdvancedDialog.this._sailTable.isEditing()) {
                    ((SailStackPanel)SailStackPanel.this).AdvancedDialog.this._sailTable.requestFocus();
                } else if (((SailStackPanel)SailStackPanel.this).AdvancedDialog.this._parameterTable.isEditing()) {
                    ((SailStackPanel)SailStackPanel.this).AdvancedDialog.this._parameterTable.requestFocus();
                }
            }

            public void valueChanged(ListSelectionEvent e) {
                String sailClass = ((SailStackPanel)SailStackPanel.this).AdvancedDialog.this._sailTable.getIdentifierForSelectedRow();
                ((SailStackPanel)SailStackPanel.this).AdvancedDialog.this._parameterTable.setSailClass(sailClass);
                this._enableDisableComponents();
            }
        }
    }

    protected class AccessControlPanel
    extends JPanel
    implements ActionListener,
    ListSelectionListener {
        protected JButton _addButton;
        protected JButton _removeButton;

        public AccessControlPanel() {
            this.setLayout(new GridBagLayout());
            Border emptyBorder = BorderFactory.createEmptyBorder(8, 8, 8, 8);
            this.setBorder(emptyBorder);
            JLabel title = new JLabel("Access Control List:");
            GridBagUtil.constrain(this, title, 0, 0, 1, 1, 0, 17, 1.0, 0.0, 0, 0, 0, 0);
            GridBagUtil.constrain(this, this._createList(), 0, 1, 1, 1, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
            GridBagUtil.constrain(this, this._createButtons(), 0, 2, 1, 1, 0, 13, 1.0, 0.0, 4, 0, 0, 0);
            AdvancedDialog.this._accessControlTable.getSelectionModel().addListSelectionListener(this);
            this._updateButtonStatus();
        }

        protected JScrollPane _createList() {
            JScrollPane list2 = new JScrollPane();
            AdvancedDialog.this._accessControlTable = new AccessControlTable(AdvancedDialog.this._id, AdvancedDialog.this._config);
            JViewport viewport = list2.getViewport();
            viewport.add(AdvancedDialog.this._accessControlTable);
            viewport.setBackground(Color.white);
            list2.setVerticalScrollBarPolicy(22);
            Insets insets = list2.getInsets();
            Dimension scrollBarSize = list2.getVerticalScrollBar().getPreferredSize();
            Dimension tableSize = AdvancedDialog.this._accessControlTable.getPreferredSize();
            int width = insets.left + scrollBarSize.width + tableSize.width + insets.right;
            list2.setPreferredSize(new Dimension(width, 84));
            return list2;
        }

        protected JPanel _createButtons() {
            JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 4, 0));
            this._addButton = new JButton("Add...");
            this._addButton.setToolTipText("Add new user to list");
            buttonPanel.add(this._addButton);
            this._addButton.addActionListener(this);
            this._removeButton = new JButton("Remove");
            this._removeButton.setToolTipText("Remove user from list");
            buttonPanel.add(this._removeButton);
            this._removeButton.addActionListener(this);
            return buttonPanel;
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (AdvancedDialog.this._accessControlTable.stopCellEditing()) {
                if (source == this._addButton) {
                    AdvancedDialog.this._accessControlTable.addNewRow();
                } else if (source == this._removeButton) {
                    AdvancedDialog.this._accessControlTable.removeRow();
                }
            }
            if (AdvancedDialog.this._accessControlTable.isEditing()) {
                AdvancedDialog.this._accessControlTable.requestFocus();
            } else {
                this.requestFocus();
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            this._updateButtonStatus();
        }

        protected void _updateButtonStatus() {
            int selectedRow = AdvancedDialog.this._accessControlTable.getSelectedRow();
            this._removeButton.setEnabled(selectedRow > 0);
        }
    }
}

