/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.config.ui;

import java.util.Collections;
import java.util.Iterator;
import org.openrdf.sesame.config.SystemConfig;
import org.openrdf.sesame.config.ui.ColumnData;
import org.openrdf.sesame.config.ui.XTableModel;

public class AccessControlTableModel
extends XTableModel {
    public static final int COLUMN_LOGIN = 0;
    public static final int COLUMN_READ = 1;
    public static final int COLUMN_WRITE = 2;
    public static final String ANONYMOUS_LOGIN = "-anonymous-";
    protected String _id;

    public AccessControlTableModel(String id, SystemConfig config) {
        super(config, new ColumnData[]{new ColumnData("Login", 100, 2), new ColumnData("Read", 25, 0), new ColumnData("Write", 25, 0)});
        this._id = id;
        this._updateTable();
    }

    public boolean isCellEditable(int row, int column) {
        return row != 0 || column != 0;
    }

    public int getIdentifyingColumn() {
        return 0;
    }

    public Object getValueAt(int row, int column) {
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        AccessControlData accessControl = (AccessControlData)this._rows.get(row);
        switch (column) {
            case 0: {
                return accessControl.getLogin();
            }
            case 1: {
                return accessControl.hasReadAccess();
            }
            case 2: {
                return accessControl.hasWriteAccess();
            }
        }
        return null;
    }

    public void setValueAt(Object value2, int row, int column) {
        if (row < 0 || row >= this.getRowCount()) {
            return;
        }
        AccessControlData accessControl = (AccessControlData)this._rows.get(row);
        switch (column) {
            case 0: {
                String stringValue = (String)value2;
                if (accessControl.isNew()) {
                    accessControl.setLogin(stringValue);
                    this._config.setReadAccess(this._id, accessControl.getLogin(), true);
                    break;
                }
                String login = accessControl.getLogin();
                if (login.equals(stringValue)) break;
                boolean readAccess = this._config.hasReadAccess(this._id, login);
                boolean writeAccess = this._config.hasWriteAccess(this._id, login);
                this._config.setReadAccess(this._id, login, false);
                this._config.setWriteAccess(this._id, login, false);
                this._config.setReadAccess(this._id, login, readAccess);
                this._config.setWriteAccess(this._id, login, writeAccess);
                break;
            }
            case 1: {
                boolean readAccess = (Boolean)value2;
                if (row == 0) {
                    this._config.setWorldReadable(this._id, readAccess);
                    break;
                }
                this._config.setReadAccess(this._id, accessControl.getLogin(), readAccess);
                break;
            }
            case 2: {
                boolean writeAccess = (Boolean)value2;
                if (row == 0) {
                    this._config.setWorldWriteable(this._id, writeAccess);
                    break;
                }
                this._config.setWriteAccess(this._id, accessControl.getLogin(), writeAccess);
            }
        }
    }

    public void configurationChanged() {
        this._updateTable();
    }

    protected void _updateTable() {
        Iterator rowsIter = this._rows.iterator();
        while (rowsIter.hasNext()) {
            AccessControlData accessControl = (AccessControlData)rowsIter.next();
            if (!accessControl.isNew()) continue;
            return;
        }
        this._rows.clear();
        if (!this._config.hasRepository(this._id)) {
            this._id = null;
        } else {
            this._rows.add(new AccessControlData(ANONYMOUS_LOGIN, this._config.isWorldReadable(this._id), this._config.isWorldWriteable(this._id)));
            Iterator loginIter = this._config.getUsernames().iterator();
            while (loginIter.hasNext()) {
                String login = (String)loginIter.next();
                if (!this._config.hasReadOrWriteAccess(this._id, login)) continue;
                boolean readAccess = this._config.hasReadAccess(this._id, login);
                boolean writeAccess = this._config.hasWriteAccess(this._id, login);
                this._rows.add(new AccessControlData(login, readAccess, writeAccess));
            }
            Collections.sort(this._rows);
        }
        this.fireTableDataChanged();
    }

    protected XTableModel.RowData _createRow() {
        return new AccessControlData();
    }

    class AccessControlData
    extends XTableModel.RowData {
        protected String _login;
        protected boolean _readAccess;
        protected boolean _writeAccess;

        public AccessControlData() {
            super(AccessControlTableModel.this);
        }

        public AccessControlData(String login, boolean readAccess, boolean writeAccess) {
            super(AccessControlTableModel.this);
            this._login = login;
            this._readAccess = readAccess;
            this._writeAccess = writeAccess;
        }

        public String getIdentifier() {
            return this.getLogin();
        }

        public String getLogin() {
            return this._login;
        }

        public void setLogin(String login) {
            this._login = login;
        }

        public boolean hasReadAccess() {
            return this._readAccess;
        }

        public boolean hasWriteAccess() {
            return this._writeAccess;
        }

        public boolean isNew() {
            return this._login == null;
        }

        public int compareTo(Object o) {
            AccessControlData other = (AccessControlData)o;
            if (this._login == null) {
                return 1;
            }
            if (other._login == null) {
                return -1;
            }
            if (this._login.equals(AccessControlTableModel.ANONYMOUS_LOGIN)) {
                return -1;
            }
            if (other._login.equals(AccessControlTableModel.ANONYMOUS_LOGIN)) {
                return 1;
            }
            return this._login.compareTo(other._login);
        }
    }
}

