/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.config.ui;

import java.awt.Component;
import java.util.Arrays;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openrdf.sesame.config.SystemConfig;
import org.openrdf.sesame.config.ui.AccessControlTableModel;
import org.openrdf.sesame.config.ui.CheckCellRenderer;
import org.openrdf.sesame.config.ui.XCellEditor;
import org.openrdf.sesame.config.ui.XTable;
import org.openrdf.sesame.config.ui.util.Util;

public class AccessControlTable
extends XTable {
    protected String _repositoryId;

    public AccessControlTable(String repositoryId, SystemConfig config) {
        super(config);
        this._repositoryId = repositoryId;
        this.setXTableModel(new AccessControlTableModel(repositoryId, config));
        this.setRowSelectionInterval(0, 0);
    }

    protected TableCellRenderer _createCellRenderer(int columnNo) {
        if (columnNo == 0) {
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setHorizontalAlignment(this._model.getColumnAlignment(columnNo));
            return renderer;
        }
        if (columnNo == 1 || columnNo == 2) {
            CheckCellRenderer renderer = new CheckCellRenderer();
            renderer.setHorizontalAlignment(this._model.getColumnAlignment(columnNo));
            return renderer;
        }
        return null;
    }

    protected TableCellEditor _createCellEditor(int columnNo) {
        XCellEditor editor = null;
        if (columnNo == 0) {
            Object[] items = this._config.getUsernames().toArray();
            Arrays.sort(items);
            editor = new LoginCellEditor(items, this);
        } else if (columnNo == 1 || columnNo == 2) {
            JCheckBox editorCheckBox = new JCheckBox();
            editor = new XCellEditor(editorCheckBox, (XTable)this);
            editorCheckBox.setHorizontalAlignment(this._model.getColumnAlignment(columnNo));
        }
        return editor;
    }

    public void addNewRow() {
        if (!this._config.hasAnUser()) {
            this._showWarningDialog("No users configured yet.", "Add User");
            return;
        }
        int row = this.getSelectedRow();
        row = row == -1 ? 1 : ++row;
        this._model.addNewRow(row);
        this.editCellAt(row, 0);
    }

    public void removeRow() {
        String login = this.getIdentifierForSelectedRow();
        if (login == null) {
            this._showWarningDialog("No user selected.", "Remove User");
            return;
        }
        if (login.equals("-anonymous-")) {
            this._showWarningDialog("-anonymous- cannot be removed", "Remove User");
            return;
        }
        if (Util.showYesNoDialog(this._getOwner(), "Are you sure you want to remove user '" + login + "' from the Access Control List? ", "Remove User") == 0) {
            int row = this.getSelectedRow();
            this._config.setReadAccess(this._repositoryId, login, false);
            this._config.setWriteAccess(this._repositoryId, login, false);
            this.selectPreviousRowTo(row);
        }
    }

    class LoginCellEditor
    extends XCellEditor {
        protected boolean valueWasSet;

        public LoginCellEditor(Object[] items, AccessControlTable acTable) {
            super(new JComboBox<Object>(items), (XTable)acTable);
        }

        public void setValue(Object value2) {
            super.setValue(value2);
            this.valueWasSet = true;
        }

        public boolean stopCellEditing() {
            if (this.valueWasSet) {
                this.valueWasSet = false;
                return false;
            }
            return super.stopCellEditing();
        }

        public boolean isValid() {
            String oldLogin = (String)this._value;
            String newLogin = this.getCellEditorValue().toString();
            if (!newLogin.equals(oldLogin) && AccessControlTable.this._config.hasReadOrWriteAccess(AccessControlTable.this._repositoryId, newLogin)) {
                AccessControlTable.this._showWarningDialog("Access for user '" + newLogin + "' already defined.", "Edit Access");
                return false;
            }
            return true;
        }

        public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row, int column) {
            if (value2 == null) {
                JComboBox box = (JComboBox)this.getComponent();
                value2 = box.getItemAt(0);
            }
            return super.getTableCellEditorComponent(table, value2, isSelected, row, column);
        }
    }
}

