/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.config.handlers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openrdf.sesame.config.RepositoryConfig;
import org.openrdf.sesame.config.SailConfig;
import org.openrdf.sesame.config.SystemConfig;
import org.openrdf.sesame.config.UserInfo;
import org.openrdf.util.xml.XmlWriter;

class SystemConfigWriter {
    protected SystemConfig _config;
    protected XmlWriter _xmlWriter;

    public synchronized void write(SystemConfig systemConfig, OutputStream outputStream2) throws IOException {
        this._write(systemConfig, new XmlWriter(outputStream2));
    }

    public synchronized void write(SystemConfig systemConfig, Writer writer2) throws IOException {
        this._write(systemConfig, new XmlWriter(writer2));
    }

    private void _write(SystemConfig systemConfig, XmlWriter xmlWriter) throws IOException {
        this._config = systemConfig;
        this._xmlWriter = xmlWriter;
        this._xmlWriter.setPrettyPrint(true);
        this._xmlWriter.startDocument();
        this._writeHeader();
        this._xmlWriter.emptyLine();
        this._xmlWriter.comment("server parameters");
        this._writeAdmin();
        this._writeLog();
        this._writeTmp();
        this._writeRmiFactory();
        this._xmlWriter.emptyLine();
        this._xmlWriter.comment("users");
        this._writeUsers();
        this._xmlWriter.emptyLine();
        this._xmlWriter.comment("repositories");
        this._writeRepositories();
        this._writeFooter();
        this._xmlWriter.endDocument();
    }

    protected void _writeHeader() throws IOException {
        this._xmlWriter.startTag("system-conf");
    }

    protected void _writeFooter() throws IOException {
        this._xmlWriter.endTag("system-conf");
    }

    protected void _writeAdmin() throws IOException {
        this._xmlWriter.setAttribute("password", this._config.getAdminPassword());
        this._xmlWriter.emptyElement("admin");
    }

    protected void _writeLog() throws IOException {
        String logDir = this._config.getLogDir();
        if (logDir == null) {
            logDir = "";
        }
        this._xmlWriter.setAttribute("dir", logDir);
        this._xmlWriter.setAttribute("level", this._config.getLogLevel());
        this._xmlWriter.emptyElement("log");
    }

    protected void _writeTmp() throws IOException {
        String tmpDir = this._config.getTmpDir();
        if (tmpDir == null) {
            tmpDir = "";
        }
        this._xmlWriter.setAttribute("dir", tmpDir);
        this._xmlWriter.emptyElement("tmp");
    }

    protected void _writeRmiFactory() throws IOException {
        if (this._config.getRMIFactoryClass() != null) {
            this._xmlWriter.setAttribute("enabled", this._config.isRMIEnabled());
            this._xmlWriter.setAttribute("class", this._config.getRMIFactoryClass());
            this._xmlWriter.setAttribute("port", this._config.getRMIPort());
            this._xmlWriter.emptyElement("rmi-factory");
        }
    }

    protected void _writeUsers() throws IOException {
        this._xmlWriter.startTag("userlist");
        List userInfoList = this._config.getUserInfoList();
        for (int i = 0; i < userInfoList.size(); ++i) {
            UserInfo userInfo = (UserInfo)userInfoList.get(i);
            if (i > 0) {
                this._xmlWriter.emptyLine();
            }
            this._xmlWriter.setAttribute("id", userInfo.getID());
            this._xmlWriter.setAttribute("login", userInfo.getLogin());
            this._xmlWriter.startTag("user");
            this._xmlWriter.textElement("fullname", userInfo.getFullName());
            this._xmlWriter.textElement("password", userInfo.getPassword());
            this._xmlWriter.endTag("user");
        }
        this._xmlWriter.endTag("userlist");
    }

    protected void _writeRepositories() throws IOException {
        this._xmlWriter.startTag("repositorylist");
        List repConfigList = this._config.getRepositoryConfigList();
        for (int i = 0; i < repConfigList.size(); ++i) {
            RepositoryConfig repConfig = (RepositoryConfig)repConfigList.get(i);
            if (i > 0) {
                this._xmlWriter.emptyLine();
            }
            this._xmlWriter.setAttribute("id", repConfig.getRepositoryId());
            this._xmlWriter.startTag("repository");
            this._xmlWriter.textElement("title", repConfig.getTitle());
            this._writeSailStack(repConfig);
            this._writeAcl(repConfig);
            this._xmlWriter.endTag("repository");
        }
        this._xmlWriter.endTag("repositorylist");
    }

    protected void _writeSailStack(RepositoryConfig repConfig) throws IOException {
        this._xmlWriter.startTag("sailstack");
        List sailList = repConfig.getSailList();
        for (int i = 0; i < sailList.size(); ++i) {
            SailConfig sailConfig = (SailConfig)sailList.get(i);
            this._writeSail(sailConfig);
        }
        this._xmlWriter.endTag("sailstack");
    }

    protected void _writeSail(SailConfig sailConfig) throws IOException {
        Map configParams = sailConfig.getConfigParameters();
        this._xmlWriter.setAttribute("class", sailConfig.getSailClass());
        if (configParams.isEmpty()) {
            this._xmlWriter.emptyElement("sail");
        } else {
            this._xmlWriter.startTag("sail");
            Iterator paramNames = configParams.keySet().iterator();
            while (paramNames.hasNext()) {
                String name2 = (String)paramNames.next();
                String value2 = (String)configParams.get(name2);
                this._xmlWriter.setAttribute("name", name2);
                this._xmlWriter.setAttribute("value", value2);
                this._xmlWriter.emptyElement("param");
            }
            this._xmlWriter.endTag("sail");
        }
    }

    protected void _writeAcl(RepositoryConfig repConfig) throws IOException {
        List userInfoList = this._config.getUsersForRepository(repConfig);
        this._xmlWriter.setAttribute("worldReadable", repConfig.isWorldReadable());
        this._xmlWriter.setAttribute("worldWriteable", repConfig.isWorldWriteable());
        if (userInfoList.isEmpty()) {
            this._xmlWriter.emptyElement("acl");
        } else {
            this._xmlWriter.startTag("acl");
            String repositoryId = repConfig.getRepositoryId();
            for (int i = 0; i < userInfoList.size(); ++i) {
                UserInfo user = (UserInfo)userInfoList.get(i);
                this._xmlWriter.setAttribute("login", user.getLogin());
                this._xmlWriter.setAttribute("readAccess", user.hasReadAccess(repositoryId));
                this._xmlWriter.setAttribute("writeAccess", user.hasWriteAccess(repositoryId));
                this._xmlWriter.emptyElement("user");
            }
            this._xmlWriter.endTag("acl");
        }
    }
}

