/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.openrdf.sesame.config.RepositoryListListener;
import org.openrdf.util.xml.SimpleSAXAdapter;
import org.openrdf.util.xml.SimpleSAXListener;
import org.openrdf.util.xml.SimpleSAXParser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class RepositoryListReader {
    private SimpleSAXParser _simpleSAXParser;

    public RepositoryListReader(XMLReader xmlReader) {
        this._simpleSAXParser = new SimpleSAXParser(xmlReader);
    }

    public synchronized void read(InputStream in, RepositoryListListener list2) throws SAXException, IOException {
        this._simpleSAXParser.setListener((SimpleSAXListener)new XmlRepositoryListReader(list2));
        this._simpleSAXParser.parse(in);
    }

    static class XmlRepositoryListReader
    extends SimpleSAXAdapter {
        private RepositoryListListener _listener;
        private String _currentReposId;
        private boolean _currentReposReadable;
        private boolean _currentReposWritable;
        private String _currentReposTitle;

        public XmlRepositoryListReader(RepositoryListListener list2) {
            this._listener = list2;
        }

        public void startTag(String tagName, Map atts, String text2) {
            if (tagName.equals("repositorylist")) {
                this._listener.startRepositoryList();
            } else if (tagName.equals("repository")) {
                this._currentReposId = (String)atts.get("id");
                this._currentReposReadable = "true".equals(atts.get("readable"));
                this._currentReposWritable = "true".equals(atts.get("writeable"));
            } else if (tagName.equals("title")) {
                this._currentReposTitle = text2;
            }
        }

        public void endTag(String tagName) {
            if (tagName.equals("repositorylist")) {
                this._listener.endRepositoryList();
            } else if (tagName.equals("repository")) {
                this._listener.repository(this._currentReposId, this._currentReposTitle, this._currentReposReadable, this._currentReposWritable);
                this._currentReposId = null;
                this._currentReposReadable = false;
                this._currentReposWritable = false;
                this._currentReposTitle = null;
            }
        }
    }
}

