/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.impl;

import java.io.Serializable;
import org.openrdf.model.GraphException;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.sesame.sail.StatementIterator;

public class URIImpl
implements URI,
Serializable {
    public static final URI RDF_TYPE = new URIImpl("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
    public static final URI RDF_PROPERTY = new URIImpl("http://www.w3.org/1999/02/22-rdf-syntax-ns#Property");
    public static final URI RDF_XMLLITERAL = new URIImpl("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
    public static final URI RDF_SUBJECT = new URIImpl("http://www.w3.org/1999/02/22-rdf-syntax-ns#subject");
    public static final URI RDF_PREDICATE = new URIImpl("http://www.w3.org/1999/02/22-rdf-syntax-ns#predicate");
    public static final URI RDF_OBJECT = new URIImpl("http://www.w3.org/1999/02/22-rdf-syntax-ns#object");
    public static final URI RDF_STATEMENT = new URIImpl("http://www.w3.org/1999/02/22-rdf-syntax-ns#Statement");
    public static final URI RDF_ALT = new URIImpl("http://www.w3.org/1999/02/22-rdf-syntax-ns#Alt");
    public static final URI RDF_BAG = new URIImpl("http://www.w3.org/1999/02/22-rdf-syntax-ns#Bag");
    public static final URI RDF_SEQ = new URIImpl("http://www.w3.org/1999/02/22-rdf-syntax-ns#Seq");
    public static final URI RDF_VALUE = new URIImpl("http://www.w3.org/1999/02/22-rdf-syntax-ns#value");
    public static final URI RDF_LIST = new URIImpl("http://www.w3.org/1999/02/22-rdf-syntax-ns#List");
    public static final URI RDF_FIRST = new URIImpl("http://www.w3.org/1999/02/22-rdf-syntax-ns#first");
    public static final URI RDF_REST = new URIImpl("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest");
    public static final URI RDF_NIL = new URIImpl("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
    public static final URI RDFS_RESOURCE = new URIImpl("http://www.w3.org/2000/01/rdf-schema#Resource");
    public static final URI RDFS_CLASS = new URIImpl("http://www.w3.org/2000/01/rdf-schema#Class");
    public static final URI RDFS_LITERAL = new URIImpl("http://www.w3.org/2000/01/rdf-schema#Literal");
    public static final URI RDFS_SUBCLASSOF = new URIImpl("http://www.w3.org/2000/01/rdf-schema#subClassOf");
    public static final URI RDFS_SUBPROPERTYOF = new URIImpl("http://www.w3.org/2000/01/rdf-schema#subPropertyOf");
    public static final URI RDFS_DOMAIN = new URIImpl("http://www.w3.org/2000/01/rdf-schema#domain");
    public static final URI RDFS_RANGE = new URIImpl("http://www.w3.org/2000/01/rdf-schema#range");
    public static final URI RDFS_COMMENT = new URIImpl("http://www.w3.org/2000/01/rdf-schema#comment");
    public static final URI RDFS_LABEL = new URIImpl("http://www.w3.org/2000/01/rdf-schema#label");
    public static final URI RDFS_ISDEFINEDBY = new URIImpl("http://www.w3.org/2000/01/rdf-schema#isDefinedBy");
    public static final URI RDFS_SEEALSO = new URIImpl("http://www.w3.org/2000/01/rdf-schema#seeAlso");
    public static final URI RDFS_DATATYPE = new URIImpl("http://www.w3.org/2000/01/rdf-schema#Datatype");
    public static final URI RDFS_CONTAINER = new URIImpl("http://www.w3.org/2000/01/rdf-schema#Container");
    public static final URI RDFS_MEMBER = new URIImpl("http://www.w3.org/2000/01/rdf-schema#member");
    public static final URI RDFS_CONTAINERMEMBERSHIPPROPERTY = new URIImpl("http://www.w3.org/2000/01/rdf-schema#ContainerMembershipProperty");
    private String _namespace;
    private String _localName;

    public URIImpl(String uri2) {
        char c;
        int i;
        for (i = uri2.length() - 1; i >= 0 && (c = uri2.charAt(i)) != '#' && c != ':' && c != '/'; --i) {
        }
        if (i <= 0) {
            throw new IllegalArgumentException("'" + uri2 + "' is not a legal (absolute) URI");
        }
        this._namespace = uri2.substring(0, i + 1);
        this._localName = uri2.substring(i + 1);
    }

    public URIImpl(String namespace, String localName) {
        if (namespace == null) {
            throw new IllegalArgumentException("namespace must not be null");
        }
        if (localName == null) {
            throw new IllegalArgumentException("localName must not be null");
        }
        this._namespace = namespace;
        this._localName = localName;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public String getLocalName() {
        return this._localName;
    }

    public String getURI() {
        char[] result2 = new char[this._namespace.length() + this._localName.length()];
        this._namespace.getChars(0, this._namespace.length(), result2, 0);
        this._localName.getChars(0, this._localName.length(), result2, this._namespace.length());
        return new String(result2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof URI) {
            URI other = (URI)o;
            return this._localName.equals(other.getLocalName()) && this._namespace.equals(other.getNamespace());
        }
        return false;
    }

    public int hashCode() {
        return this._namespace.hashCode() ^ this._localName.hashCode();
    }

    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        Value other = (Value)o;
        if (other instanceof URI) {
            return this.getURI().compareTo(((URI)other).getURI());
        }
        return -1;
    }

    public String toString() {
        return this.getURI();
    }

    public StatementIterator getPredicateStatements() throws GraphException {
        throw new GraphException("no backing store associated");
    }

    public void addProperty(URI property, Value value2) throws GraphException {
        throw new GraphException("no backing store associated");
    }

    public StatementIterator getSubjectStatements() throws GraphException {
        throw new GraphException("no backing store associated");
    }

    public StatementIterator getObjectStatements() throws GraphException {
        throw new GraphException("no backing store associated");
    }
}

