/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.util.text.html;

import org.dbpedia.util.text.ParseException;

public class HtmlReferenceException
extends ParseException {
    public static final String NOT_CLOSED = "unclosed reference";
    public static final String EMPTY = "empty reference";
    public static final String TOO_SHORT = "invalid reference (too short)";
    public static final String TOO_LONG = "invalid reference (too long)";
    public static final String BAD_NAME = "reference to unknown entity";
    public static final String BAD_NUMBER = "invalid numeric reference";
    private final String _reference;

    public HtmlReferenceException(String input2, int position, String description, String reference) {
        super(HtmlReferenceException.buildMessage(input2, position, description, reference), input2, position, description);
        this._reference = reference;
    }

    private static String buildMessage(String input2, int position, String description, String reference) {
        StringBuilder sb = new StringBuilder();
        HtmlReferenceException.addDescription(description, sb);
        if (reference != null) {
            sb.append(" [").append(reference).append("]");
        }
        HtmlReferenceException.addDetail(input2, position, sb);
        return sb.toString();
    }

    public String getReference() {
        return this._reference;
    }
}

