/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.util;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.dbpedia.extraction.util.FileLike;
import org.dbpedia.extraction.util.IOUtils$;
import org.dbpedia.extraction.util.RichReader$;
import scala.Function1;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.io.Codec$;
import scala.runtime.BoxedUnit;

public final class IOUtils$ {
    public static final IOUtils$ MODULE$;
    private final Map<String, Function1<OutputStream, OutputStream>> zippers;
    private final Map<String, Function1<InputStream, InputStream>> unzippers;

    static {
        new IOUtils$();
    }

    public Map<String, Function1<OutputStream, OutputStream>> zippers() {
        return this.zippers;
    }

    public Map<String, Function1<InputStream, InputStream>> unzippers() {
        return this.unzippers;
    }

    private <T> T open(FileLike<?> file, Function1<FileLike<?>, T> opener, Map<String, Function1<T, T>> wrappers) {
        String name2 = file.name();
        String suffix = name2.substring(name2.lastIndexOf(46) + 1);
        return (T)((Function1)wrappers.getOrElse(suffix, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Function1<T, T> apply() {
                return new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final T apply(T x) {
                        return Predef$.MODULE$.identity(x);
                    }
                };
            }
        })).apply(opener.apply(file));
    }

    public OutputStream outputStream(FileLike<?> file) {
        return (OutputStream)this.open(file, (Function1)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final OutputStream apply(FileLike<?> x$5) {
                return x$5.outputStream(x$5.outputStream$default$1());
            }
        }), this.zippers());
    }

    public InputStream inputStream(FileLike<?> file) {
        return (InputStream)this.open(file, (Function1)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final InputStream apply(FileLike<?> x$6) {
                return x$6.inputStream();
            }
        }), this.unzippers());
    }

    public Writer writer(FileLike<?> file, Charset charset) {
        return new OutputStreamWriter(this.outputStream(file), charset);
    }

    public Charset writer$default$2() {
        return Codec$.MODULE$.UTF8().charSet();
    }

    public Reader reader(FileLike<?> file, Charset charset) {
        return new InputStreamReader(this.inputStream(file), charset);
    }

    public Charset reader$default$2() {
        return Codec$.MODULE$.UTF8().charSet();
    }

    public void readLines(FileLike<?> file, Charset charset, Function1<String, BoxedUnit> proc) {
        Reader reader2 = this.reader(file, this.reader$default$2());
        try {
            RichReader$.MODULE$.wrapReader(reader2).foreach(new Serializable(proc){
                public static final long serialVersionUID = 0L;
                private final Function1 proc$1;

                public final void apply(String line) {
                    this.proc$1.apply(line);
                }
                {
                    this.proc$1 = proc$1;
                }
            });
            return;
        }
        finally {
            reader2.close();
        }
    }

    public Charset readLines$default$2() {
        return Codec$.MODULE$.UTF8().charSet();
    }

    public void copy(InputStream in, OutputStream out) {
        byte[] buf = new byte[0x100000];
        while (true) {
            int read2;
            if ((read2 = in.read(buf)) == -1) {
                out.flush();
                return;
            }
            out.write(buf, 0, read2);
        }
    }

    private IOUtils$() {
        MODULE$ = this;
        this.zippers = (Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("gz"), new anonfun.1()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("bz2"), new anonfun.2())}));
        this.unzippers = (Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("gz"), new anonfun.3()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("bz2"), new anonfun.4())}));
    }
}

