/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.dbpedia.extraction.util.ConfigUtils$;
import org.dbpedia.extraction.util.Language;
import org.dbpedia.extraction.util.Language$;
import org.dbpedia.extraction.util.RichString$;
import org.dbpedia.extraction.util.WikiInfo;
import org.dbpedia.extraction.util.WikiInfo$;
import org.dbpedia.extraction.wikiparser.Namespace$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple2$mcII$sp;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.io.Codec$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

public final class ConfigUtils$ {
    public static final ConfigUtils$ MODULE$;
    private final Regex LanguageRegex;
    private final Regex RangeRegex;

    static {
        new ConfigUtils$();
    }

    /*
     * WARNING - void declaration
     */
    public Properties loadConfig(String file, String charset) {
        void var3_3;
        Properties config = new Properties();
        FileInputStream in = new FileInputStream(file);
        try {
            config.load(new InputStreamReader((InputStream)in, charset));
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.close();
            throw throwable;
        }
        in.close();
        return var3_3;
    }

    public <T> Seq<T> getValues(Properties config, String key, char sep, boolean required, Function1<String, T> map2) {
        return this.getStrings(config, key, sep, required).map(new Serializable(map2){
            public static final long serialVersionUID = 0L;
            private final Function1 map$1;

            public final T apply(String x$1) {
                return (T)this.map$1.apply(x$1);
            }
            {
                this.map$1 = map$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<String> getStrings(Properties config, String key, char sep, boolean required) {
        String string2 = this.getString(config, key, required);
        return string2 == null ? (WrappedArray<Object>)Seq$.MODULE$.empty() : Predef$.MODULE$.wrapRefArray((Object[])RichString$.MODULE$.wrapString(string2).trimSplit(sep));
    }

    public <T> T getValue(Properties config, String key, boolean required, Function1<String, T> map2) {
        String string2 = this.getString(config, key, required);
        return string2 == null ? null : (T)map2.apply(string2);
    }

    public String getString(Properties config, String key, boolean required) {
        String string2;
        String string3 = config.getProperty(key);
        if (string3 == null) {
            if (required) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"property '").append((Object)key).append((Object)"' not defined.").toString());
            }
            string2 = null;
        } else {
            string2 = string3;
        }
        return string2;
    }

    public Language[] parseLanguages(File baseDir, Seq<String> args) {
        Seq<String> keys = args.flatMap(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(String arg) {
                return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])arg.split("[,\\s]")).withFilter(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String key) {
                        return new StringOps(Predef$.MODULE$.augmentString(key)).nonEmpty();
                    }
                }).map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String key) {
                        return key;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
            }
        }, Seq$.MODULE$.canBuildFrom());
        ObjectRef<SortedSet> languages = new ObjectRef<SortedSet>((SortedSet)SortedSet$.MODULE$.apply(Nil$.MODULE$, Language$.MODULE$.wikiCodeOrdering()));
        HashSet<Tuple2<Object, Object>> ranges = new HashSet<Tuple2<Object, Object>>();
        keys.foreach(new Serializable(languages, ranges){
            public static final long serialVersionUID = 0L;
            private final ObjectRef languages$1;
            private final HashSet ranges$1;

            public final Object apply(String key) {
                String string2;
                block5: {
                    Object object;
                    block3: {
                        block4: {
                            block2: {
                                String string3 = string2 = key;
                                if ("@mappings" != null ? !"@mappings".equals(string3) : string3 != null) break block2;
                                this.languages$1.elem = (SortedSet)((SortedSet)this.languages$1.elem).$plus$plus(Namespace$.MODULE$.mappings().keySet());
                                object = BoxedUnit.UNIT;
                                break block3;
                            }
                            Option<List<String>> option = ConfigUtils$.MODULE$.RangeRegex().unapplySeq(string2);
                            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(2) != 0) break block4;
                            String from2 = (String)((LinearSeqOptimized)option.get()).apply(0);
                            String to2 = (String)((LinearSeqOptimized)option.get()).apply(1);
                            object = this.ranges$1.$plus$eq(ConfigUtils$.MODULE$.toRange(from2, to2));
                            break block3;
                        }
                        Option<List<String>> option = ConfigUtils$.MODULE$.LanguageRegex().unapplySeq(string2);
                        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) break block5;
                        String language2 = (String)((LinearSeqOptimized)option.get()).apply(0);
                        this.languages$1.elem = (SortedSet)((SortedSet)this.languages$1.elem).$plus(Language$.MODULE$.apply(language2));
                        object = BoxedUnit.UNIT;
                    }
                    return object;
                }
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid language / range '").append((Object)string2).append((Object)"'").toString());
            }
            {
                this.languages$1 = languages$1;
                this.ranges$1 = ranges$1;
            }
        });
        if (ranges.nonEmpty()) {
            File listFile = new File(baseDir, WikiInfo$.MODULE$.FileName());
            Predef$.MODULE$.println(new StringBuilder().append((Object)"parsing ").append(listFile).toString());
            Seq<WikiInfo> wikis = WikiInfo$.MODULE$.fromFile(listFile, Codec$.MODULE$.UTF8());
            ranges.withFilter((Function1<Tuple2<Object, Object>, Object>)((Object)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                    Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            })).foreach(new Serializable(languages, wikis){
                public static final long serialVersionUID = 0L;
                public final ObjectRef languages$1;
                private final Seq wikis$1;

                public final void apply(Tuple2<Object, Object> x$2) {
                    Tuple2<Object, Object> tuple2 = x$2;
                    if (tuple2 != null) {
                        int from2 = tuple2._1$mcI$sp();
                        int to2 = tuple2._2$mcI$sp();
                        this.wikis$1.withFilter(new Serializable(this, from2, to2){
                            public static final long serialVersionUID = 0L;
                            private final int from$1;
                            private final int to$1;

                            public final boolean apply(WikiInfo wiki) {
                                return this.from$1 <= wiki.pages() && wiki.pages() <= this.to$1;
                            }
                            {
                                this.from$1 = from$1;
                                this.to$1 = to$1;
                            }
                        }).foreach(new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.parseLanguages.3 $outer;

                            public final void apply(WikiInfo wiki) {
                                this.$outer.languages$1.elem = (SortedSet)((SortedSet)this.$outer.languages$1.elem).$plus(wiki.language());
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.languages$1 = languages$1;
                    this.wikis$1 = wikis$1;
                }
            });
        }
        return (Language[])((SortedSet)languages.elem).toArray(ClassTag$.MODULE$.apply(Language.class));
    }

    public Regex LanguageRegex() {
        return this.LanguageRegex;
    }

    public Regex RangeRegex() {
        return this.RangeRegex;
    }

    public Tuple2<Object, Object> toRange(String from2, String to2) {
        int hi;
        int lo = from2.isEmpty() ? 0 : new StringOps(Predef$.MODULE$.augmentString(from2)).toInt();
        int n = hi = to2.isEmpty() ? Integer.MAX_VALUE : new StringOps(Predef$.MODULE$.augmentString(to2)).toInt();
        if (lo > hi) {
            throw new NumberFormatException();
        }
        return new Tuple2$mcII$sp(lo, hi);
    }

    private ConfigUtils$() {
        MODULE$ = this;
        this.LanguageRegex = new StringOps(Predef$.MODULE$.augmentString("([a-z][a-z0-9-]+)")).r();
        this.RangeRegex = new StringOps(Predef$.MODULE$.augmentString("(\\d*)-(\\d*)")).r();
    }
}

