/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.destinations.formatters;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import org.dbpedia.extraction.destinations.formatters.Formatter;
import org.dbpedia.extraction.destinations.formatters.UriPolicy$;
import org.dbpedia.extraction.util.ConfigUtils$;
import org.dbpedia.extraction.util.Language$;
import org.dbpedia.extraction.util.RichString$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.Growable;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$Int$;
import scala.math.Ordering$String$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.xml.Utility$;

public final class UriPolicy$ {
    public static final UriPolicy$ MODULE$;
    private final int SUBJECT;
    private final int PREDICATE;
    private final int OBJECT;
    private final int DATATYPE;
    private final int CONTEXT;
    private final int POSITIONS;
    private final int ALL;
    private final Map<String, Tuple3<Object, Object, Function1<Function1<URI, Object>, Function1<URI, URI>>>> org$dbpedia$extraction$destinations$formatters$UriPolicy$$policies;
    private final Map<String, Function1<Function1<URI, URI>[], Formatter>> org$dbpedia$extraction$destinations$formatters$UriPolicy$$formatters;
    private final int MAX_LENGTH;

    static {
        new UriPolicy$();
    }

    public int SUBJECT() {
        return this.SUBJECT;
    }

    public int PREDICATE() {
        return this.PREDICATE;
    }

    public int OBJECT() {
        return this.OBJECT;
    }

    public int DATATYPE() {
        return this.DATATYPE;
    }

    public int CONTEXT() {
        return this.CONTEXT;
    }

    public int POSITIONS() {
        return this.POSITIONS;
    }

    public int ALL() {
        return this.ALL;
    }

    public Map<String, Tuple3<Object, Object, Function1<Function1<URI, Object>, Function1<URI, URI>>>> org$dbpedia$extraction$destinations$formatters$UriPolicy$$policies() {
        return this.org$dbpedia$extraction$destinations$formatters$UriPolicy$$policies;
    }

    public Map<String, Function1<Function1<URI, URI>[], Formatter>> org$dbpedia$extraction$destinations$formatters$UriPolicy$$formatters() {
        return this.org$dbpedia$extraction$destinations$formatters$UriPolicy$$formatters;
    }

    public Map<String, Formatter> parseFormats(Properties config, String uriPolicyPrefix, String formatPrefix) {
        Map<String, Function1<URI, URI>[]> policies = this.parsePolicies(config, uriPolicyPrefix);
        return this.parseFormats(config, formatPrefix, policies);
    }

    public Map<String, Formatter> parseFormats(Properties config, String prefix, Map<String, Function1<URI, URI>[]> policies) {
        String dottedPrefix = new StringBuilder().append((Object)prefix).append((Object)".").toString();
        HashMap<String, Formatter> formats = new HashMap<String, Formatter>();
        JavaConversions$.MODULE$.asScalaSet(config.stringPropertyNames()).foreach(new scala.Serializable(config, policies, dottedPrefix, formats){
            public static final long serialVersionUID = 0L;
            private final Properties config$2;
            public final Map policies$1;
            private final String dottedPrefix$1;
            private final HashMap formats$1;

            public final void apply(String key) {
                if (key.startsWith(this.dottedPrefix$1)) {
                    String suffix = key.substring(this.dottedPrefix$1.length());
                    Seq<String> settings = ConfigUtils$.MODULE$.getStrings(this.config$2, key, ';', true);
                    Predef$.MODULE$.require(settings.length() == 1 || settings.length() == 2, (Function0<Object>)((Object)new scala.Serializable(this, key){
                        public static final long serialVersionUID = 0L;
                        private final String key$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"key '").append((Object)this.key$1).append((Object)"' must have one or two values separated by ';' - file format and optional uri policy name").toString();
                        }
                        {
                            this.key$1 = key$1;
                        }
                    }));
                    Function1 formatter = (Function1)((Object)UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$formatters().getOrElse((String)settings.apply(false), new scala.Serializable(this, key, settings){
                        public static final long serialVersionUID = 0L;
                        private final String key$1;
                        private final Seq settings$1;

                        public final Nothing$ apply() {
                            throw UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$error(new StringBuilder().append((Object)"first value for key '").append((Object)this.key$1).append((Object)"' is '").append(this.settings$1.apply(false)).append((Object)"' but must be one of ").append((Object)((TraversableOnce)UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$formatters().keys().toSeq().sorted(Ordering$String$.MODULE$)).mkString("'", "','", "'")).toString(), UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$error$default$2());
                        }
                        {
                            this.key$1 = key$1;
                            this.settings$1 = settings$1;
                        }
                    }));
                    Function1[] policy = settings.length() == 1 ? null : (Function1[])this.policies$1.getOrElse(settings.apply(true), new scala.Serializable(this, key, settings){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.parseFormats.1 $outer;
                        private final String key$1;
                        private final Seq settings$1;

                        public final Nothing$ apply() {
                            throw UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$error(new StringBuilder().append((Object)"second value for key '").append((Object)this.key$1).append((Object)"' is '").append(this.settings$1.apply(true)).append((Object)"' but must be a configured uri-policy, i.e. one of ").append((Object)this.$outer.policies$1.keys().mkString("'", "','", "'")).toString(), UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$error$default$2());
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.key$1 = key$1;
                            this.settings$1 = settings$1;
                        }
                    });
                    this.formats$1.update(suffix, formatter.apply(policy));
                }
            }
            {
                this.config$2 = config$2;
                this.policies$1 = policies$1;
                this.dottedPrefix$1 = dottedPrefix$1;
                this.formats$1 = formats$1;
            }
        });
        return formats;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Function1<URI, URI>[]> parsePolicies(Properties config, String prefix) {
        void var3_3;
        HashMap policies = new HashMap();
        JavaConversions$.MODULE$.asScalaSet(config.stringPropertyNames()).foreach(new scala.Serializable(config, prefix, policies){
            public static final long serialVersionUID = 0L;
            private final Properties config$1;
            private final String prefix$2;
            private final HashMap policies$2;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void apply(String key) {
                if (!key.startsWith(this.prefix$2)) return;
                try {
                    this.policies$2.update(key, UriPolicy$.MODULE$.parsePolicy(this.config$1.getProperty(key)));
                    return;
                }
                catch (Exception exception) {
                    throw UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$error(new StringBuilder().append((Object)"invalid URI policy: '").append((Object)key).append((Object)"=").append((Object)this.config$1.getProperty(key)).append((Object)"'").toString(), exception);
                }
            }
            {
                this.config$1 = config$1;
                this.prefix$2 = prefix$2;
                this.policies$2 = policies$2;
            }
        });
        return var3_3;
    }

    public Function1<URI, URI>[] parsePolicy(String list2) {
        ArrayBuffer[] entries = (ArrayBuffer[])Array$.MODULE$.fill(this.POSITIONS(), new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayBuffer<Tuple2<Object, Function1<URI, URI>>> apply() {
                return new ArrayBuffer<Tuple2<Object, Function1<URI, URI>>>();
            }
        }, ClassTag$.MODULE$.apply(ArrayBuffer.class));
        Predef$.MODULE$.refArrayOps((Object[])RichString$.MODULE$.wrapString(list2).trimSplit(';')).foreach(new scala.Serializable(entries){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer[] entries$1;

            public final Object apply(String policy) {
                String[] stringArray = RichString$.MODULE$.wrapString(policy).trimSplit(':');
                Option<IndexedSeq<T>> option = Array$.MODULE$.unapplySeq(stringArray);
                if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                    Some some;
                    Tuple3 tuple3;
                    String name2 = (String)((SeqLike)option.get()).apply(0);
                    String languages = (String)((SeqLike)option.get()).apply(1);
                    Option<B> option2 = UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$policies().get(name2);
                    if (option2 instanceof Some && (tuple3 = (Tuple3)(some = (Some)option2).x()) != null) {
                        Growable growable;
                        Object object;
                        int prio = BoxesRunTime.unboxToInt(tuple3._1());
                        int position = BoxesRunTime.unboxToInt(tuple3._2());
                        Function1 factory = (Function1)tuple3._3();
                        Function1<URI, Object> predicate = UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$parsePredicate(languages);
                        Tuple2<Integer, R> entry = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(BoxesRunTime.boxToInteger(prio)), factory.apply(predicate));
                        if (position == UriPolicy$.MODULE$.ALL()) {
                            Predef$.MODULE$.refArrayOps((Object[])this.entries$1).foreach(new scala.Serializable(this, entry){
                                public static final long serialVersionUID = 0L;
                                private final Tuple2 entry$1;

                                public final ArrayBuffer<Tuple2<Object, Function1<URI, URI>>> apply(ArrayBuffer<Tuple2<Object, Function1<URI, URI>>> x$9) {
                                    return x$9.$plus$eq((Object)this.entry$1);
                                }
                                {
                                    this.entry$1 = entry$1;
                                }
                            });
                            object = BoxedUnit.UNIT;
                        } else {
                            object = this.entries$1[position].$plus$eq(entry);
                        }
                        Growable growable2 = growable = object;
                        return growable2;
                    }
                    None$ none$ = None$.MODULE$;
                    Option<B> option3 = option2;
                    if (!(none$ != null ? !none$.equals(option3) : option3 != null)) {
                        throw UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$error(new StringBuilder().append((Object)"unknown policy name '").append((Object)name2).append((Object)"' in '").append((Object)policy).append((Object)"'").toString(), UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$error$default$2());
                    }
                    throw new MatchError(option2);
                }
                throw UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$error(new StringBuilder().append((Object)"invalid format in '").append((Object)policy).append((Object)"'").toString(), UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$error$default$2());
            }
            {
                this.entries$1 = entries$1;
            }
        });
        ArrayBuffer[] ordered = (ArrayBuffer[])Predef$.MODULE$.refArrayOps((Object[])entries).map(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayBuffer<Function1<URI, URI>> apply(ArrayBuffer<Tuple2<Object, Function1<URI, URI>>> x$10) {
                return ((TraversableLike)x$10.sortBy(new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Tuple2<Object, Function1<URI, URI>> x$11) {
                        return x$11._1$mcI$sp();
                    }
                }, Ordering$Int$.MODULE$)).map(new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Function1<URI, URI> apply(Tuple2<Object, Function1<URI, URI>> x$12) {
                        return x$12._2();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ArrayBuffer.class)));
        Predef$.MODULE$.refArrayOps((Object[])ordered).foreach(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(ArrayBuffer<Function1<URI, URI>> list2) {
                return list2.isEmpty() ? list2.$plus$eq(new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final URI apply(URI x) {
                        return Predef$.MODULE$.identity(x);
                    }
                }) : BoxedUnit.UNIT;
            }
        });
        return (Function1[])Predef$.MODULE$.refArrayOps((Object[])ordered).map(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final Function1<URI, URI> apply(ArrayBuffer<Function1<URI, URI>> x$13) {
                return x$13.reduceLeft(new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Function1<URI, URI> apply(Function1<URI, URI> x$14, Function1<URI, URI> x$15) {
                        return x$14.andThen(x$15);
                    }
                });
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function1.class)));
    }

    public Function1<URI, Object> org$dbpedia$extraction$destinations$formatters$UriPolicy$$parsePredicate(String languages) {
        scala.Serializable serializable2;
        Set<String> codes2 = Predef$.MODULE$.refArrayOps((Object[])RichString$.MODULE$.wrapString(languages).trimSplit(',')).toSet();
        if (codes2.apply("*") != false) {
            serializable2 = new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(URI uri2) {
                    String host = uri2.getHost();
                    return host != null && (host.equals("dbpedia.org") || host.endsWith(".dbpedia.org"));
                }
            };
        } else {
            Set domains = codes2.map(new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String x$16) {
                    return Language$.MODULE$.apply(x$16).dbpediaDomain();
                }
            }, Set$.MODULE$.canBuildFrom());
            serializable2 = new scala.Serializable(domains){
                public static final long serialVersionUID = 0L;
                private final Set domains$1;

                public final boolean apply(URI uri2) {
                    return (boolean)this.domains$1.apply(uri2.getHost());
                }
                {
                    this.domains$1 = domains$1;
                }
            };
        }
        return serializable2;
    }

    public IllegalArgumentException org$dbpedia$extraction$destinations$formatters$UriPolicy$$error(String message, Throwable cause) {
        return new IllegalArgumentException(message, cause);
    }

    public Throwable org$dbpedia$extraction$destinations$formatters$UriPolicy$$error$default$2() {
        return null;
    }

    public Function1<URI, URI> uri(Function1<URI, Object> activeFor) {
        return new scala.Serializable(activeFor){
            public static final long serialVersionUID = 0L;
            private final Function1 activeFor$2;

            public final URI apply(URI iri) {
                return BoxesRunTime.unboxToBoolean(this.activeFor$2.apply(iri)) ? new URI(iri.toASCIIString()) : iri;
            }
            {
                this.activeFor$2 = activeFor$2;
            }
        };
    }

    public Function1<URI, URI> generic(Function1<URI, Object> activeFor) {
        return new scala.Serializable(activeFor){
            public static final long serialVersionUID = 0L;
            private final Function1 activeFor$4;

            public final URI apply(URI iri) {
                URI uRI;
                if (BoxesRunTime.unboxToBoolean(this.activeFor$4.apply(iri))) {
                    String scheme = iri.getScheme();
                    String user = iri.getRawUserInfo();
                    String host = "dbpedia.org";
                    int port = iri.getPort();
                    String path = iri.getRawPath();
                    String query2 = iri.getRawQuery();
                    String frag = iri.getRawFragment();
                    uRI = UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$uri(scheme, user, host, port, path, query2, frag);
                } else {
                    uRI = iri;
                }
                return uRI;
            }
            {
                this.activeFor$4 = activeFor$4;
            }
        };
    }

    public int MAX_LENGTH() {
        return this.MAX_LENGTH;
    }

    public Function1<URI, URI> rejectLong(Function1<URI, Object> activeFor) {
        return new scala.Serializable(activeFor){
            public static final long serialVersionUID = 0L;
            private final Function1 activeFor$1;

            public final URI apply(URI iri) {
                String str;
                if (BoxesRunTime.unboxToBoolean(this.activeFor$1.apply(iri)) && (str = iri.toString()).length() > UriPolicy$.MODULE$.MAX_LENGTH()) {
                    throw new URISyntaxException(str, new StringBuilder().append((Object)"length ").append(BoxesRunTime.boxToInteger(str.length())).append((Object)" exceeds maximum ").append(BoxesRunTime.boxToInteger(UriPolicy$.MODULE$.MAX_LENGTH())).toString());
                }
                return iri;
            }
            {
                this.activeFor$1 = activeFor$1;
            }
        };
    }

    public Function1<URI, URI> xmlSafe(Function1<URI, Object> activeFor) {
        return new scala.Serializable(activeFor){
            public static final long serialVersionUID = 0L;
            private final Function1 activeFor$3;

            public final URI apply(URI iri) {
                URI uRI;
                if (BoxesRunTime.unboxToBoolean(this.activeFor$3.apply(iri))) {
                    String scheme = iri.getScheme();
                    String user = iri.getRawUserInfo();
                    String host = iri.getHost();
                    int port = iri.getPort();
                    String path = iri.getRawPath();
                    String query2 = iri.getRawQuery();
                    String frag = iri.getRawFragment();
                    if (frag == null) {
                        if (query2 == null) {
                            path = path != null && new StringOps(Predef$.MODULE$.augmentString(path)).nonEmpty() ? UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$xmlSafe(path) : "/_";
                        } else {
                            query2 = UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$xmlSafe(query2);
                        }
                    } else {
                        frag = UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$xmlSafe(frag);
                    }
                    uRI = UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$uri(scheme, user, host, port, path, query2, frag);
                } else {
                    uRI = iri;
                }
                return uRI;
            }
            {
                this.activeFor$3 = activeFor$3;
            }
        };
    }

    public String org$dbpedia$extraction$destinations$formatters$UriPolicy$$xmlSafe(String tail) {
        int index2 = tail.length();
        while (index2 > 0) {
            if (--index2 >= 2 && tail.charAt(index2 - 2) == '%') {
                return new StringBuilder().append((Object)tail).append(BoxesRunTime.boxToCharacter('_')).toString();
            }
            char ch = tail.charAt(index2);
            if (ch != ':' && Utility$.MODULE$.isNameChar(ch)) {
                if (!Utility$.MODULE$.isNameStart(ch)) continue;
                return tail;
            }
            return new StringBuilder().append((Object)tail).append(BoxesRunTime.boxToCharacter('_')).toString();
        }
        return new StringBuilder().append((Object)tail).append(BoxesRunTime.boxToCharacter('_')).toString();
    }

    public URI org$dbpedia$extraction$destinations$formatters$UriPolicy$$uri(String scheme, String user, String host, int port, String path, String query2, String frag) {
        Serializable serializable2;
        StringBuilder sb = new StringBuilder();
        Serializable serializable3 = scheme == null ? BoxedUnit.UNIT : sb.append(scheme).append(':');
        if (host == null) {
            serializable2 = BoxedUnit.UNIT;
        } else {
            sb.append("//");
            Serializable serializable4 = user == null ? BoxedUnit.UNIT : sb.append(user).append('@');
            sb.append(host);
            serializable2 = port != -1 ? sb.append(':').append(port) : BoxedUnit.UNIT;
        }
        Serializable serializable5 = path == null ? BoxedUnit.UNIT : sb.append(path);
        Serializable serializable6 = query2 == null ? BoxedUnit.UNIT : sb.append('?').append(query2);
        Serializable serializable7 = frag == null ? BoxedUnit.UNIT : sb.append('#').append(frag);
        return new URI(sb.toString());
    }

    private UriPolicy$() {
        MODULE$ = this;
        this.SUBJECT = 0;
        this.PREDICATE = 1;
        this.OBJECT = 2;
        this.DATATYPE = 3;
        this.CONTEXT = 4;
        this.POSITIONS = 5;
        this.ALL = -1;
        Seq policies = (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3<String, Integer, anonfun.1>("reject-long", BoxesRunTime.boxToInteger(1), new anonfun.1()), new Tuple3<String, Integer, anonfun.2>("uri", BoxesRunTime.boxToInteger(2), new anonfun.2()), new Tuple3<String, Integer, anonfun.3>("xml-safe", BoxesRunTime.boxToInteger(3), new anonfun.3()), new Tuple3<String, Integer, anonfun.4>("generic", BoxesRunTime.boxToInteger(4), new anonfun.4())}));
        Seq positions = (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2<String, Integer>("", BoxesRunTime.boxToInteger(this.ALL())), new Tuple2<String, Integer>("-subjects", BoxesRunTime.boxToInteger(this.SUBJECT())), new Tuple2<String, Integer>("-predicates", BoxesRunTime.boxToInteger(this.PREDICATE())), new Tuple2<String, Integer>("-objects", BoxesRunTime.boxToInteger(this.OBJECT())), new Tuple2<String, Integer>("-datatypes", BoxesRunTime.boxToInteger(this.DATATYPE())), new Tuple2<String, Integer>("-contexts", BoxesRunTime.boxToInteger(this.CONTEXT()))}));
        Seq product2 = policies.withFilter(new anonfun.5()).flatMap(new anonfun.6(positions), Seq$.MODULE$.canBuildFrom());
        this.org$dbpedia$extraction$destinations$formatters$UriPolicy$$policies = Predef$.MODULE$.locally(product2.toMap(Predef$.MODULE$.conforms()));
        this.org$dbpedia$extraction$destinations$formatters$UriPolicy$$formatters = (Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("trix-triples"), new anonfun.7()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("trix-quads"), new anonfun.8()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("turtle-triples"), new anonfun.9()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("turtle-quads"), new anonfun.10()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("n-triples"), new anonfun.11()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("n-quads"), new anonfun.12())}));
        this.MAX_LENGTH = 500;
    }
}

