/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.compress.archivers.zip.ZipEncoding;

class FallbackZipEncoding
implements ZipEncoding {
    private final String charset;

    public FallbackZipEncoding() {
        this.charset = null;
    }

    public FallbackZipEncoding(String charset) {
        this.charset = charset;
    }

    public boolean canEncode(String name2) {
        return true;
    }

    public ByteBuffer encode(String name2) throws IOException {
        if (this.charset == null) {
            return ByteBuffer.wrap(name2.getBytes());
        }
        return ByteBuffer.wrap(name2.getBytes(this.charset));
    }

    public String decode(byte[] data2) throws IOException {
        if (this.charset == null) {
            return new String(data2);
        }
        return new String(data2, this.charset);
    }
}

