/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.server.stats;

import org.dbpedia.extraction.server.stats.TemplateStats;
import org.dbpedia.extraction.server.stats.TemplateStatsBuilder;
import org.dbpedia.extraction.server.stats.WikipediaStats;
import org.dbpedia.extraction.server.stats.WikipediaStatsFormat$;
import org.dbpedia.extraction.server.util.CollectionReader;
import org.dbpedia.extraction.util.Language;
import org.dbpedia.extraction.util.Language$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00153A!\u0001\u0002\u0001\u001b\t!r+[6ja\u0016$\u0017.Y*uCR\u001c(+Z1eKJT!a\u0001\u0003\u0002\u000bM$\u0018\r^:\u000b\u0005\u00151\u0011AB:feZ,'O\u0003\u0002\b\u0011\u0005QQ\r\u001f;sC\u000e$\u0018n\u001c8\u000b\u0005%Q\u0011a\u00023ca\u0016$\u0017.\u0019\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tA!\u001e;jY&\u00111\u0003\u0005\u0002\u0011\u0007>dG.Z2uS>t'+Z1eKJD\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006IAF\u0001\u0006Y&tWm\u001d\t\u0004/\u0005\"cB\u0001\r\u001f\u001d\tIB$D\u0001\u001b\u0015\tYB\"\u0001\u0004=e>|GOP\u0005\u0002;\u0005)1oY1mC&\u0011q\u0004I\u0001\ba\u0006\u001c7.Y4f\u0015\u0005i\u0012B\u0001\u0012$\u0005!IE/\u001a:bi>\u0014(BA\u0010!!\t)\u0013F\u0004\u0002'O5\t\u0001%\u0003\u0002)A\u00051\u0001K]3eK\u001aL!AK\u0016\u0003\rM#(/\u001b8h\u0015\tA\u0003\u0005C\u0003.\u0001\u0011\u0005a&\u0001\u0004=S:LGO\u0010\u000b\u0003_E\u0002\"\u0001\r\u0001\u000e\u0003\tAQ!\u0006\u0017A\u0002YAQa\r\u0001\u0005\u0002Q\nAA]3bIR\tQ\u0007\u0005\u00021m%\u0011qG\u0001\u0002\u000f/&\\\u0017\u000e]3eS\u0006\u001cF/\u0019;t\u0011\u0015I\u0004\u0001\"\u0003;\u00031\u0011X-\u00193SK\u0012L'/Z2u+\u0005Y\u0004\u0003\u0002\u0014=I\u0011J!!\u0010\u0011\u0003\rQ+\b\u000f\\33\u0011\u0015y\u0004\u0001\"\u0003A\u00031\u0011X-\u00193Qe>\u0004XM\u001d;z+\u0005\t\u0005\u0003\u0002\u0014=I\t\u0003\"AJ\"\n\u0005\u0011\u0003#aA%oi\u0002")
public class WikipediaStatsReader
extends CollectionReader {
    public WikipediaStats read() {
        String line = "";
        Language language = Language$.MODULE$.apply(this.readTag(WikipediaStatsFormat$.MODULE$.WikiStatsTag()));
        this.readEmpty();
        int redirCount = this.readCount(WikipediaStatsFormat$.MODULE$.RedirectsTag());
        HashMap redirects = new HashMap();
        for (int redirIndex = 0; redirIndex < redirCount; ++redirIndex) {
            redirects.$plus$eq(this.readRedirect());
        }
        this.readEmpty();
        int templateCount = this.readCount(WikipediaStatsFormat$.MODULE$.TemplatesTag());
        this.readEmpty();
        HashMap templates = new HashMap();
        for (int templateIndex = 0; templateIndex < templateCount; ++templateIndex) {
            TemplateStatsBuilder templateStats = new TemplateStatsBuilder();
            String templateName = this.readTag(WikipediaStatsFormat$.MODULE$.TemplateTag());
            templateStats.templateCount_$eq(this.readCount(WikipediaStatsFormat$.MODULE$.CountTag()));
            int propCount = this.readCount(WikipediaStatsFormat$.MODULE$.PropertiesTag());
            for (int propIndex = 0; propIndex < propCount; ++propIndex) {
                templateStats.properties().$plus$eq(this.readProperty());
            }
            templates.update((Object)templateName, (Object)templateStats.build());
            this.readEmpty();
        }
        this.readEmpty();
        return new WikipediaStats(language, (Map<String, String>)redirects.toMap(Predef$.MODULE$.conforms()), (Map<String, TemplateStats>)templates.toMap(Predef$.MODULE$.conforms()));
    }

    private Tuple2<String, String> readRedirect() {
        String tail = this.readTag(WikipediaStatsFormat$.MODULE$.RedirectTag());
        String[] pair = tail.split("\\|", -1);
        if (pair.length == 2) {
            return new Tuple2((Object)pair[0], (Object)pair[1]);
        }
        throw new Exception(new StringBuilder().append((Object)"expected line starting with '").append((Object)WikipediaStatsFormat$.MODULE$.RedirectTag()).append((Object)"' followed by two strings, found '").append((Object)WikipediaStatsFormat$.MODULE$.RedirectTag()).append((Object)tail).append((Object)"'").toString());
    }

    private Tuple2<String, Object> readProperty() {
        String tail = this.readTag(WikipediaStatsFormat$.MODULE$.PropertyTag());
        String[] pair = tail.split("\\|", -1);
        if (pair.length == 2) {
            try {
                return new Tuple2((Object)pair[0], (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(pair[1])).toInt()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new Exception(new StringBuilder().append((Object)"expected line starting with '").append((Object)WikipediaStatsFormat$.MODULE$.PropertyTag()).append((Object)"' followed by a string and an integer, found '").append((Object)WikipediaStatsFormat$.MODULE$.PropertyTag()).append((Object)tail).append((Object)"'").toString());
    }

    public WikipediaStatsReader(Iterator<String> lines) {
        super(lines);
    }
}

