/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.server.stats;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Logger;
import org.dbpedia.extraction.destinations.Quad;
import org.dbpedia.extraction.destinations.Quad$;
import org.dbpedia.extraction.server.stats.MappingStatsConfig;
import org.dbpedia.extraction.server.stats.TemplateStats;
import org.dbpedia.extraction.server.stats.TemplateStatsBuilder;
import org.dbpedia.extraction.server.stats.WikipediaStats;
import org.dbpedia.extraction.util.FileLike;
import org.dbpedia.extraction.util.IOUtils$;
import org.dbpedia.extraction.util.Language;
import org.dbpedia.extraction.util.RichFile$;
import org.dbpedia.extraction.util.StringUtils$;
import org.dbpedia.extraction.util.TurtleUtils$;
import org.dbpedia.extraction.util.WikiUtil$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005}b\u0001B\u0001\u0003\u00015\u00111#T1qa&twm\u0015;biN\u0014U/\u001b7eKJT!a\u0001\u0003\u0002\u000bM$\u0018\r^:\u000b\u0005\u00151\u0011AB:feZ,'O\u0003\u0002\b\u0011\u0005QQ\r\u001f;sC\u000e$\u0018n\u001c8\u000b\u0005%Q\u0011a\u00023ca\u0016$\u0017.\u0019\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fAi\u0011AA\u0005\u0003#\t\u0011!#T1qa&twm\u0015;biN\u001cuN\u001c4jO\"A1\u0003\u0001B\u0001B\u0003%A#\u0001\u0005ti\u0006$8\u000fR5s!\t)\"$D\u0001\u0017\u0015\t9\u0002$\u0001\u0002j_*\t\u0011$\u0001\u0003kCZ\f\u0017BA\u000e\u0017\u0005\u00111\u0015\u000e\\3\t\u0011u\u0001!\u0011!Q\u0001\ny\t\u0001\u0002\\1oOV\fw-\u001a\t\u0003?\tj\u0011\u0001\t\u0006\u0003C\u0019\tA!\u001e;jY&\u00111\u0005\t\u0002\t\u0019\u0006tw-^1hK\"AQ\u0005\u0001B\u0001B\u0003%a%\u0001\u0004qe\u0016$H/\u001f\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\b\u0005>|G.Z1o\u0011\u0015i\u0003\u0001\"\u0001/\u0003\u0019a\u0014N\\5u}Q!q\u0006M\u00193!\ty\u0001\u0001C\u0003\u0014Y\u0001\u0007A\u0003C\u0003\u001eY\u0001\u0007a\u0004C\u0003&Y\u0001\u0007a\u0005C\u00045\u0001\t\u0007I\u0011B\u001b\u0002\r1|wmZ3s+\u00051\u0004CA\u001c<\u001b\u0005A$BA\u001d;\u0003\u001dawnZ4j]\u001eT!!\t\r\n\u0005qB$A\u0002'pO\u001e,'\u000f\u0003\u0004?\u0001\u0001\u0006IAN\u0001\bY><w-\u001a:!\u0011\u001d\u0001\u0005A1A\u0005\n\u0005\u000b\u0011C]3t_V\u00148-Z+sSB\u0013XMZ5y+\u0005\u0011\u0005CA\"G\u001d\t9C)\u0003\u0002FQ\u00051\u0001K]3eK\u001aL!a\u0012%\u0003\rM#(/\u001b8h\u0015\t)\u0005\u0006\u0003\u0004K\u0001\u0001\u0006IAQ\u0001\u0013e\u0016\u001cx.\u001e:dKV\u0013\u0018\u000e\u0015:fM&D\b\u0005C\u0003M\u0001\u0011\u0005Q*\u0001\u0006ck&dGm\u0015;biN$RAT)T+^\u0003\"aJ(\n\u0005AC#\u0001B+oSRDQAU&A\u0002Q\tQB]3eSJ,7\r^:GS2,\u0007\"\u0002+L\u0001\u0004!\u0012\u0001F1si&\u001cG.\u001a+f[Bd\u0017\r^3t\r&dW\rC\u0003W\u0017\u0002\u0007A#\u0001\fuK6\u0004H.\u0019;f!\u0006\u0014\u0018-\\3uKJ\u001ch)\u001b7f\u0011\u0015A6\n1\u0001\u0015\u0003=IgNZ8c_b$Vm\u001d;GS2,\u0007\"\u0002.\u0001\t\u0013Y\u0016\u0001C3bG\"d\u0015N\\3\u0015\u0005q\u0013GC\u0001(^\u0011\u0015q\u0016\f1\u0001`\u0003\u001d\u0001(o\\2fgN\u0004Ba\n1C\u001d&\u0011\u0011\r\u000b\u0002\n\rVt7\r^5p]FBQaY-A\u0002Q\tAAZ5mK\")Q\r\u0001C\u0005M\u0006)Bn\\1e)\u0016l\u0007\u000f\\1uKJ+G-\u001b:fGR\u001cHCA4p!\u0011AWN\u0011\"\u000e\u0003%T!A[6\u0002\u000f5,H/\u00192mK*\u0011A\u000eK\u0001\u000bG>dG.Z2uS>t\u0017B\u00018j\u0005\ri\u0015\r\u001d\u0005\u0006G\u0012\u0004\r\u0001\u0006\u0005\u0006c\u0002!IA]\u0001\tO>|GMT1nKR\u0011ae\u001d\u0005\u0006iB\u0004\rAQ\u0001\u0005]\u0006lW\rC\u0003w\u0001\u0011%q/\u0001\bd_VtG\u000fV3na2\fG/Z:\u0015\t9C\u0018p \u0005\u0006GV\u0004\r\u0001\u0006\u0005\u0006uV\u0004\ra_\u0001\ne\u0016\u001cX\u000f\u001c;NCB\u0004B\u0001[7CyB\u0011q\"`\u0005\u0003}\n\u0011A\u0003V3na2\fG/Z*uCR\u001c()^5mI\u0016\u0014\bBBA\u0001k\u0002\u0007q-A\u0005sK\u0012L'/Z2ug\"9\u0011Q\u0001\u0001\u0005\n\u0005\u001d\u0011a\u00059s_B,'\u000f^=EK\u001aLg.\u001b;j_:\u001cHc\u0002(\u0002\n\u0005-\u0011Q\u0002\u0005\u0007G\u0006\r\u0001\u0019\u0001\u000b\t\ri\f\u0019\u00011\u0001|\u0011\u001d\t\t!a\u0001A\u0002\u001dDq!!\u0005\u0001\t\u0013\t\u0019\"A\bd_VtG\u000f\u0015:pa\u0016\u0014H/[3t)\u001dq\u0015QCA\f\u00033AaaYA\b\u0001\u0004!\u0002B\u0002>\u0002\u0010\u0001\u00071\u0010C\u0004\u0002\u0002\u0005=\u0001\u0019A4\t\u000f\u0005u\u0001\u0001\"\u0003\u0002 \u0005A1\u000f\u001e:jaV\u0013\u0018\u000eF\u0002C\u0003CAq!a\t\u0002\u001c\u0001\u0007!)A\u0002ve&Dq!a\n\u0001\t\u0013\tI#\u0001\u0005dY\u0016\fg.\u0016:j)\r\u0011\u00151\u0006\u0005\b\u0003G\t)\u00031\u0001C\u0011\u001d\ty\u0003\u0001C\u0005\u0003c\t!b\u00197fC:4\u0016\r\\;f)\r\u0011\u00151\u0007\u0005\b\u0003k\ti\u00031\u0001C\u0003\u00151\u0018\r\\;f\u0011\u001d\tI\u0004\u0001C\u0005\u0003w\t\u0011b\u00197fC:t\u0015-\\3\u0015\u0007\t\u000bi\u0004\u0003\u0004u\u0003o\u0001\rA\u0011")
public class MappingStatsBuilder
extends MappingStatsConfig {
    private final Language language;
    public final boolean org$dbpedia$extraction$server$stats$MappingStatsBuilder$$pretty;
    private final Logger logger;
    private final String resourceUriPrefix;

    private Logger logger() {
        return this.logger;
    }

    private String resourceUriPrefix() {
        return this.resourceUriPrefix;
    }

    public void buildStats(File redirectsFile, File articleTemplatesFile, File templateParametersFile, File infoboxTestFile) {
        HashMap templatesMap = new HashMap();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Reading redirects from ").append((Object)redirectsFile).toString());
        scala.collection.mutable.Map<String, String> redirects = this.loadTemplateRedirects(redirectsFile);
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Found ").append((Object)BoxesRunTime.boxToInteger((int)redirects.size())).append((Object)" redirects").toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Using Template namespace ").append((Object)this.templateNamespace()).append((Object)" for language ").append((Object)this.language.wikiCode()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Counting templates in ").append((Object)articleTemplatesFile).toString());
        this.countTemplates(articleTemplatesFile, (scala.collection.mutable.Map<String, TemplateStatsBuilder>)templatesMap, redirects);
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Found ").append((Object)BoxesRunTime.boxToInteger((int)templatesMap.size())).append((Object)" different templates").toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Loading property definitions from ").append((Object)templateParametersFile).toString());
        this.propertyDefinitions(templateParametersFile, (scala.collection.mutable.Map<String, TemplateStatsBuilder>)templatesMap, redirects);
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Counting properties in ").append((Object)infoboxTestFile).toString());
        this.countProperties(infoboxTestFile, (scala.collection.mutable.Map<String, TemplateStatsBuilder>)templatesMap, redirects);
        templatesMap.retain((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String k, TemplateStatsBuilder v) {
                return v.properties().nonEmpty() && BoxesRunTime.unboxToInt((Object)v.properties().values().max((Ordering)Ordering.Int$.MODULE$)) * 10 > v.templateCount();
            }
        });
        Map builtTemplatesMap = templatesMap.mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TemplateStats apply(TemplateStatsBuilder x$1) {
                return x$1.build();
            }
        });
        WikipediaStats wikiStats = new WikipediaStats(this.language, (scala.collection.immutable.Map<String, String>)redirects.toMap(Predef$.MODULE$.conforms()), (scala.collection.immutable.Map<String, TemplateStats>)builtTemplatesMap.toMap(Predef$.MODULE$.conforms()));
        this.logger().info(new StringBuilder().append((Object)"Serializing ").append((Object)this.language.wikiCode()).append((Object)" wiki statistics to ").append((Object)this.mappingStatsFile()).toString());
        OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(this.mappingStatsFile()), "UTF-8");
        try {
            wikiStats.write(output);
            return;
        }
        finally {
            output.close();
        }
    }

    private void eachLine(File file, Function1<String, BoxedUnit> process) {
        long millis = System.currentTimeMillis();
        IntRef count2 = new IntRef(0);
        IOUtils$.MODULE$.readLines((FileLike)RichFile$.MODULE$.wrapFile(file), IOUtils$.MODULE$.readLines$default$2(), (Function1)new Serializable(this, process, count2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MappingStatsBuilder $outer;
            private final Function1 process$1;
            private final IntRef count$1;

            public final void apply(String line) {
                if (line != null) {
                    this.process$1.apply((Object)line);
                    ++this.count$1.elem;
                    if (this.count$1.elem % 1000000 == 0) {
                        if (this.$outer.org$dbpedia$extraction$server$stats$MappingStatsBuilder$$pretty) {
                            Predef$.MODULE$.print((Object)new StringBuilder().append(this.count$1.elem).append((Object)" lines\r").toString());
                        } else {
                            Predef$.MODULE$.println((Object)new StringBuilder().append(this.count$1.elem).append((Object)" lines").toString());
                        }
                    }
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.process$1 = process$1;
                this.count$1 = count$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringBuilder().append(count2.elem).append((Object)" lines - ").append((Object)StringUtils$.MODULE$.prettyMillis(System.currentTimeMillis() - millis)).toString());
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.mutable.Map<String, String> loadTemplateRedirects(File file) {
        void var2_2;
        HashMap redirects = new HashMap();
        this.eachLine(file, (Function1<String, BoxedUnit>)new Serializable(this, redirects){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MappingStatsBuilder $outer;
            private final HashMap redirects$4;

            public final void apply(String line) {
                Quad quad;
                String string = line.trim();
                Option option = Quad$.MODULE$.unapply(string);
                if (!option.isEmpty() && (quad = (Quad)option.get()).datatype() == null) {
                    BoxedUnit boxedUnit;
                    String templateName = this.$outer.org$dbpedia$extraction$server$stats$MappingStatsBuilder$$cleanUri(quad.subject());
                    if (templateName.startsWith(this.$outer.templateNamespace())) {
                        this.redirects$4.update((Object)templateName, (Object)this.$outer.org$dbpedia$extraction$server$stats$MappingStatsBuilder$$cleanUri(quad.value()));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else {
                    if (new StringOps(Predef$.MODULE$.augmentString(string)).nonEmpty() && !string.startsWith("#")) {
                        throw new IllegalArgumentException(new StringBuilder().append((Object)"line did not match object triple syntax: ").append((Object)line).toString());
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.redirects$4 = redirects$4;
            }
        });
        return var2_2;
    }

    public boolean org$dbpedia$extraction$server$stats$MappingStatsBuilder$$goodName(String name) {
        Object object = new Object();
        try {
            new StringOps(Predef$.MODULE$.augmentString(name)).foreach((Function1)new Serializable(this, object){
                public static final long serialVersionUID = 0L;
                private final Object nonLocalReturnKey1$1;

                public final void apply(char c) {
                    if (c == '<' || c == '>' || c == '{' || c == '|' || c == '}') {
                        throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, false);
                    }
                }
                {
                    this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                }
            });
            return true;
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                return nonLocalReturnControl.value$mcZ$sp();
            }
            throw nonLocalReturnControl;
        }
    }

    private void countTemplates(File file, scala.collection.mutable.Map<String, TemplateStatsBuilder> resultMap, scala.collection.mutable.Map<String, String> redirects) {
        this.eachLine(file, (Function1<String, BoxedUnit>)new Serializable(this, resultMap, redirects){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MappingStatsBuilder $outer;
            private final scala.collection.mutable.Map resultMap$1;
            private final scala.collection.mutable.Map redirects$1;

            public final void apply(String line) {
                Quad quad;
                String string = line.trim();
                Option option = Quad$.MODULE$.unapply(string);
                if (!option.isEmpty() && (quad = (Quad)option.get()).datatype() == null && TurtleUtils$.MODULE$.unescapeTurtle(quad.predicate()).contains("wikiPageUsesTemplate")) {
                    BoxedUnit boxedUnit;
                    ObjectRef templateName = new ObjectRef((Object)this.$outer.org$dbpedia$extraction$server$stats$MappingStatsBuilder$$cleanUri(quad.value()));
                    if (this.$outer.org$dbpedia$extraction$server$stats$MappingStatsBuilder$$goodName((String)templateName.elem)) {
                        templateName.elem = (String)this.redirects$1.getOrElse((Object)((String)templateName.elem), (Function0)new Serializable(this, templateName){
                            public static final long serialVersionUID = 0L;
                            private final ObjectRef templateName$1;

                            public final String apply() {
                                return (String)this.templateName$1.elem;
                            }
                            {
                                this.templateName$1 = templateName$1;
                            }
                        });
                        TemplateStatsBuilder templateStatsBuilder = (TemplateStatsBuilder)this.resultMap$1.getOrElseUpdate((Object)((String)templateName.elem), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final TemplateStatsBuilder apply() {
                                return new TemplateStatsBuilder();
                            }
                        });
                        templateStatsBuilder.templateCount_$eq(templateStatsBuilder.templateCount() + 1);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else {
                    if (new StringOps(Predef$.MODULE$.augmentString(string)).nonEmpty() && !string.startsWith("#")) {
                        throw new IllegalArgumentException(new StringBuilder().append((Object)"line did not match object or datatype triple syntax: ").append((Object)line).toString());
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.resultMap$1 = resultMap$1;
                this.redirects$1 = redirects$1;
            }
        });
    }

    private void propertyDefinitions(File file, scala.collection.mutable.Map<String, TemplateStatsBuilder> resultMap, scala.collection.mutable.Map<String, String> redirects) {
        this.eachLine(file, (Function1<String, BoxedUnit>)new Serializable(this, resultMap, redirects){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MappingStatsBuilder $outer;
            private final scala.collection.mutable.Map resultMap$2;
            private final scala.collection.mutable.Map redirects$2;

            public final void apply(String line) {
                String string = line.trim();
                Option option = Quad$.MODULE$.unapply(string);
                if (option.isEmpty()) {
                    if (new StringOps(Predef$.MODULE$.augmentString(string)).nonEmpty() && !string.startsWith("#")) {
                        throw new IllegalArgumentException(new StringBuilder().append((Object)"line did not match datatype triple syntax: ").append((Object)line).toString());
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit;
                    Quad quad = (Quad)option.get();
                    ObjectRef templateName = new ObjectRef((Object)this.$outer.org$dbpedia$extraction$server$stats$MappingStatsBuilder$$cleanUri(quad.subject()));
                    String propertyName = this.$outer.org$dbpedia$extraction$server$stats$MappingStatsBuilder$$cleanValue(quad.value());
                    if (this.$outer.org$dbpedia$extraction$server$stats$MappingStatsBuilder$$goodName(propertyName)) {
                        templateName.elem = (String)this.redirects$2.getOrElse((Object)((String)templateName.elem), (Function0)new Serializable(this, templateName){
                            public static final long serialVersionUID = 0L;
                            private final ObjectRef templateName$2;

                            public final String apply() {
                                return (String)this.templateName$2.elem;
                            }
                            {
                                this.templateName$2 = templateName$2;
                            }
                        });
                        this.resultMap$2.get((Object)((String)templateName.elem)).foreach((Function1)new Serializable(this, propertyName){
                            public static final long serialVersionUID = 0L;
                            private final String propertyName$1;

                            public final Option<Object> apply(TemplateStatsBuilder stats) {
                                return stats.properties().put((Object)this.propertyName$1, (Object)BoxesRunTime.boxToInteger((int)0));
                            }
                            {
                                this.propertyName$1 = propertyName$1;
                            }
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.resultMap$2 = resultMap$2;
                this.redirects$2 = redirects$2;
            }
        });
    }

    private void countProperties(File file, scala.collection.mutable.Map<String, TemplateStatsBuilder> resultMap, scala.collection.mutable.Map<String, String> redirects) {
        this.eachLine(file, (Function1<String, BoxedUnit>)new Serializable(this, resultMap, redirects){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MappingStatsBuilder $outer;
            private final scala.collection.mutable.Map resultMap$3;
            private final scala.collection.mutable.Map redirects$3;

            public final void apply(String line) {
                Quad quad;
                String string = line.trim();
                Option option = Quad$.MODULE$.unapply(string);
                if (option.isEmpty() || (quad = (Quad)option.get()).datatype() == null) {
                    if (new StringOps(Predef$.MODULE$.augmentString(string)).nonEmpty() && !string.startsWith("#")) {
                        throw new IllegalArgumentException(new StringBuilder().append((Object)"line did not match datatype triple syntax: ").append((Object)line).toString());
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    ObjectRef templateName = new ObjectRef((Object)this.$outer.org$dbpedia$extraction$server$stats$MappingStatsBuilder$$cleanUri(quad.predicate()));
                    String propertyName = this.$outer.org$dbpedia$extraction$server$stats$MappingStatsBuilder$$cleanValue(quad.value());
                    templateName.elem = (String)this.redirects$3.getOrElse((Object)((String)templateName.elem), (Function0)new Serializable(this, templateName){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef templateName$3;

                        public final String apply() {
                            return (String)this.templateName$3.elem;
                        }
                        {
                            this.templateName$3 = templateName$3;
                        }
                    });
                    this.resultMap$3.get((Object)((String)templateName.elem)).foreach((Function1)new Serializable(this, propertyName){
                        public static final long serialVersionUID = 0L;
                        private final String propertyName$2;

                        public final Object apply(TemplateStatsBuilder stats) {
                            return stats.properties().contains((Object)this.propertyName$2) ? stats.properties().put((Object)this.propertyName$2, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)stats.properties().apply((Object)this.propertyName$2)) + 1))) : BoxedUnit.UNIT;
                        }
                        {
                            this.propertyName$2 = propertyName$2;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.resultMap$3 = resultMap$3;
                this.redirects$3 = redirects$3;
            }
        });
    }

    private String stripUri(String uri) {
        if (uri.startsWith(this.resourceUriPrefix())) {
            return WikiUtil$.MODULE$.wikiDecode(uri.substring(this.resourceUriPrefix().length()));
        }
        throw new Exception(uri);
    }

    public String org$dbpedia$extraction$server$stats$MappingStatsBuilder$$cleanUri(String uri) {
        return this.cleanName(this.stripUri(TurtleUtils$.MODULE$.unescapeTurtle(uri)));
    }

    public String org$dbpedia$extraction$server$stats$MappingStatsBuilder$$cleanValue(String value) {
        return this.cleanName(TurtleUtils$.MODULE$.unescapeTurtle(value));
    }

    private String cleanName(String name) {
        return name.replaceAll("\r|\n", "");
    }

    public MappingStatsBuilder(File statsDir, Language language, boolean pretty) {
        this.language = language;
        this.org$dbpedia$extraction$server$stats$MappingStatsBuilder$$pretty = pretty;
        super(statsDir, language);
        this.logger = Logger.getLogger(this.getClass().getName());
        this.resourceUriPrefix = language.resourceUri().append("");
    }
}

