/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.server.stats;

import java.io.File;
import java.util.logging.Logger;
import org.dbpedia.extraction.destinations.DBpediaDatasets$;
import org.dbpedia.extraction.destinations.Dataset;
import org.dbpedia.extraction.server.stats.MappingStatsBuilder;
import org.dbpedia.extraction.server.stats.MappingStatsManager;
import org.dbpedia.extraction.util.Finder;
import org.dbpedia.extraction.util.Language;
import org.dbpedia.extraction.util.Language$;
import org.dbpedia.extraction.util.RichFile;
import org.dbpedia.extraction.util.RichFile$;
import org.dbpedia.extraction.util.StringUtils$;
import org.dbpedia.extraction.wikiparser.Namespace$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;

public final class CreateMappingStats$ {
    public static final CreateMappingStats$ MODULE$;
    private final Logger logger;

    static {
        new CreateMappingStats$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void main(String[] args) {
        Predef$.MODULE$.require(args != null && args.length >= 3, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "need at least four args: input dir, output dir, file suffix ('.gz', '.bz2' or ''), pretty-printing flag. may be followed by list of language codes.";
            }
        });
        File inputDir = new File(args[0]);
        File statsDir = new File(args[1]);
        String suffix = args[2].trim();
        boolean pretty = new StringOps(Predef$.MODULE$.augmentString(args[3])).toBoolean();
        Seq languages2 = (Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])args).drop(4)).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<Language> apply(String arg) {
                return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])arg.split("[,\\s]")).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String lang) {
                        return new StringOps(Predef$.MODULE$.augmentString(lang)).nonEmpty();
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Language apply(String lang) {
                        return Language$.MODULE$.apply(lang);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Language.class))));
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        if (languages2.isEmpty()) {
            languages2 = Namespace$.MODULE$.mappings().keySet().toSeq();
        }
        ((IterableLike)languages2.sorted(Language$.MODULE$.wikiCodeOrdering())).foreach((Function1)new Serializable(inputDir, statsDir, suffix, pretty){
            public static final long serialVersionUID = 0L;
            private final File inputDir$1;
            private final File statsDir$1;
            private final String suffix$1;
            private final boolean pretty$1;

            public final void apply(Language language) {
                long millis = System.currentTimeMillis();
                CreateMappingStats$.MODULE$.logger().info(new StringBuilder().append((Object)"creating statistics for ").append((Object)language.wikiCode()).toString());
                Finder finder = new Finder((Object)this.inputDir$1, language, "wiki", (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RichFile apply(File file) {
                        return RichFile$.MODULE$.wrapFile(file);
                    }
                });
                String date = (String)finder.dates("extraction-complete", finder.dates$default$2()).last();
                File redirects = this.inputFile$1(DBpediaDatasets$.MODULE$.Redirects(), finder, date);
                File articleTemplates = this.inputFile$1(DBpediaDatasets$.MODULE$.ArticleTemplates(), finder, date);
                File templateParameters = this.inputFile$1(DBpediaDatasets$.MODULE$.TemplateParameters(), finder, date);
                File infoboxTest = this.inputFile$1(DBpediaDatasets$.MODULE$.InfoboxTest(), finder, date);
                MappingStatsBuilder builder = new MappingStatsBuilder(this.statsDir$1, language, this.pretty$1);
                builder.buildStats(redirects, articleTemplates, templateParameters, infoboxTest);
                new MappingStatsManager(this.statsDir$1, language);
                CreateMappingStats$.MODULE$.logger().info(new StringBuilder().append((Object)"created statistics for ").append((Object)language.wikiCode()).append((Object)" in ").append((Object)StringUtils$.MODULE$.prettyMillis(System.currentTimeMillis() - millis)).toString());
            }

            private final File inputFile$1(Dataset dataset, Finder finder$1, String date$1) {
                return (File)finder$1.file(date$1, new StringBuilder().append((Object)dataset.name().replace('_', '-')).append((Object)".ttl").append((Object)this.suffix$1).toString());
            }
            {
                this.inputDir$1 = inputDir$1;
                this.statsDir$1 = statsDir$1;
                this.suffix$1 = suffix$1;
                this.pretty$1 = pretty$1;
            }
        });
    }

    private CreateMappingStats$() {
        MODULE$ = this;
        this.logger = Logger.getLogger(this.getClass().getName());
    }
}

