/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.server.resources;

import java.io.StringWriter;
import java.net.URL;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.dbpedia.extraction.destinations.Destination;
import org.dbpedia.extraction.destinations.WriterDestination;
import org.dbpedia.extraction.destinations.formatters.Formatter;
import org.dbpedia.extraction.destinations.formatters.TerseFormatter;
import org.dbpedia.extraction.destinations.formatters.TerseFormatter$;
import org.dbpedia.extraction.server.Server$;
import org.dbpedia.extraction.server.resources.Extraction$;
import org.dbpedia.extraction.server.resources.stylesheets.TriX$;
import org.dbpedia.extraction.sources.Source;
import org.dbpedia.extraction.sources.WikiSource$;
import org.dbpedia.extraction.sources.XMLSource$;
import org.dbpedia.extraction.util.Language;
import org.dbpedia.extraction.util.Language$;
import org.dbpedia.extraction.wikiparser.WikiTitle;
import org.dbpedia.extraction.wikiparser.WikiTitle$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.PrefixedAttribute;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

@Path(value="/extraction/{lang}/")
@ScalaSignature(bytes="\u0006\u0001\u0005es!B\u0001\u0003\u0011\u0003i\u0011AC#yiJ\f7\r^5p]*\u00111\u0001B\u0001\ne\u0016\u001cx.\u001e:dKNT!!\u0002\u0004\u0002\rM,'O^3s\u0015\t9\u0001\"\u0001\u0006fqR\u0014\u0018m\u0019;j_:T!!\u0003\u0006\u0002\u000f\u0011\u0014\u0007/\u001a3jC*\t1\"A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u000f\u001f5\t!AB\u0003\u0011\u0005!\u0005\u0011C\u0001\u0006FqR\u0014\u0018m\u0019;j_:\u001c\"a\u0004\n\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g\u0011\u0015Ir\u0002\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\tQ\u0002C\u0004\u001d\u001f\t\u0007I\u0011B\u000f\u0002\r1|wmZ3s+\u0005q\u0002CA\u0010'\u001b\u0005\u0001#BA\u0011#\u0003\u001dawnZ4j]\u001eT!a\t\u0013\u0002\tU$\u0018\u000e\u001c\u0006\u0002K\u0005!!.\u0019<b\u0013\t9\u0003E\u0001\u0004M_\u001e<WM\u001d\u0005\u0007S=\u0001\u000b\u0011\u0002\u0010\u0002\u000f1|wmZ3sA!91f\u0004b\u0001\n\u0003a\u0013!\u00027j]\u0016\u001cX#A\u0017\u0011\t9\nD\u0007\u000e\b\u0003'=J!\u0001\r\u000b\u0002\rA\u0013X\rZ3g\u0013\t\u00114GA\u0002NCBT!\u0001\r\u000b\u0011\u00059*\u0014B\u0001\u001c4\u0005\u0019\u0019FO]5oO\"1\u0001h\u0004Q\u0001\n5\na\u0001\\5oKN\u0004c\u0001\u0002\t\u0003\u0001i\u001a\"!\u000f\n\t\u0011qJ$\u0011!Q\u0001\nQ\n\u0001\u0002\\1oO\u000e{G-\u001a\u0015\u0005wyB\u0015\n\u0005\u0002@\r6\t\u0001I\u0003\u0002B\u0005\u0006\u0011!o\u001d\u0006\u0003\u0007\u0012\u000b!a^:\u000b\u0003\u0015\u000bQA[1wCbL!a\u0012!\u0003\u0013A\u000bG\u000f\u001b)be\u0006l\u0017!\u0002<bYV,\u0017%\u0001&\u0002\t1\fgn\u001a\u0005\u00063e\"\t\u0001\u0014\u000b\u0003\u001b:\u0003\"AD\u001d\t\u000bqZ\u0005\u0019\u0001\u001b)\t9s\u0004*\u0013\u0005\b#f\u0012\r\u0011\"\u0003S\u0003!a\u0017M\\4vC\u001e,W#A*\u0011\u0005Q3V\"A+\u000b\u0005\r2\u0011BA,V\u0005!a\u0015M\\4vC\u001e,\u0007BB-:A\u0003%1+A\u0005mC:<W/Y4fA!)1,\u000fC\u00059\u0006Aq-\u001a;USRdW-F\u00015\u0011\u0015q\u0016\b\"\u0001`\u0003\r9W\r^\u000b\u0002AB\u0011\u0011\rZ\u0007\u0002E*\u00111\rF\u0001\u0004q6d\u0017BA3c\u0005\u0011)E.Z7)\tu;\u0007J\u001b\t\u0003\u007f!L!!\u001b!\u0003\u0011A\u0013x\u000eZ;dKNd\u0013a[\u0011\u0002Y\u0006)\u0012\r\u001d9mS\u000e\fG/[8o_aDG/\u001c7,q6d\u0007FA/o!\tyt.\u0003\u0002q\u0001\n\u0019q)\u0012+\t\u000bILD\u0011A:\u0002\u000f\u0015DHO]1diR)A\u0007^>\u0002\u0012!)Q/\u001da\u0001i\u0005)A/\u001b;mK\"\"Ao\u001e%{!\ty\u00040\u0003\u0002z\u0001\nQ\u0011+^3ssB\u000b'/Y7\"\u0003UDQ\u0001`9A\u0002u\fQA]3wS\u0012\u0004\"a\u0005@\n\u0005}$\"\u0001\u0002'p]\u001eDca_A\u0002\u0011\u0006%\u0001cA \u0002\u0006%\u0019\u0011q\u0001!\u0003\u0019\u0011+g-Y;miZ\u000bG.^3\"\u0005\u0005-\u0011AA\u00172Q\u0015Yx\u000fSA\bC\u0005a\bBBA\nc\u0002\u0007A'\u0001\u0004g_Jl\u0017\r\u001e\u0015\u0007\u0003#9\b*a\u0006\"\u0005\u0005M\u0001&B9h\u0011\u0006mAFAA\u000fC\t\ty\"A\bbaBd\u0017nY1uS>tw\u0006_7mQ\u0019\t\u00181\u0005%\u0002*A\u0019q(!\n\n\u0007\u0005\u001d\u0002I\u0001\u0003QCRD\u0017%\u0001:)\u0005Et\u0007B\u0002::\t\u0003\ty\u0003\u0006\u0003\u00022\u0005e\u0002\u0003BA\u001a\u0003oi!!!\u000e\u000b\u0005)#\u0013b\u0001\u001c\u00026!11-!\fA\u0002\u0001Dc!!\fh\u0011\u0006uBFAA\u000fQ\u001d\ti#!\u0011I\u0003\u000f\u00022aPA\"\u0013\r\t)\u0005\u0011\u0002\t\u0007>t7/^7fg2\u0012\u0011Q\u0004\u0015\b\u0003[\t\u0019\u0003SA\u0015Q\u0011\ti#!\u0014\u0011\u0007}\ny%C\u0002\u0002R\u0001\u0013A\u0001U(T)\"2\u0011(a\tI\u0003+\n#!a\u0016\u0002'=*\u0007\u0010\u001e:bGRLwN\\\u0018|Y\u0006tw-`\u0018")
public class Extraction {
    @PathParam(value="lang")
    public final String org$dbpedia$extraction$server$resources$Extraction$$langCode;
    private final Language language;

    public static Map<String, String> lines() {
        return Extraction$.MODULE$.lines();
    }

    private Language language() {
        return this.language;
    }

    private String getTitle() {
        return (String)Extraction$.MODULE$.lines().getOrElse((Object)this.org$dbpedia$extraction$server$resources$Extraction$$langCode, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Berlin";
            }
        });
    }

    @GET
    @Produces(value={"application/xhtml+xml"})
    public Elem get() {
        TopScope$ $tmpscope = Predef$.MODULE$.$scope();
        TopScope$ $scope = $tmpscope = new NamespaceBinding(null, "http://www.w3.org/1999/xhtml", (NamespaceBinding)$tmpscope);
        Null$ $md = Null$.MODULE$;
        $md = new PrefixedAttribute("xml", "lang", (Seq)new Text("en"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n         "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n           "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("content", (Seq)new Text("text/html; charset=UTF-8"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("http-equiv", (Seq)new Text("Content-Type"), (MetaData)$md2);
        $buf2.$amp$plus((Object)new Elem(null, "meta", (MetaData)$md2, (NamespaceBinding)$scope, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf2.$amp$plus((Object)new Text("\n         "));
        $buf.$amp$plus((Object)new Elem(null, "head", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n         "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n           "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("Extract a page"));
        $buf3.$amp$plus((Object)new Elem(null, "h2", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, false, (Seq)$buf4));
        $buf3.$amp$plus((Object)new Text("\n           "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("method", (Seq)new Text("get"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("action", (Seq)new Text("extract"), (MetaData)$md3);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n             Page title"));
        $buf5.$amp$plus((Object)new Elem(null, "br", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf5.$amp$plus((Object)new Text("\n             "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("value", this.getTitle(), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("name", (Seq)new Text("title"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("type", (Seq)new Text("text"), (MetaData)$md4);
        $buf5.$amp$plus((Object)new Elem(null, "input", (MetaData)$md4, (NamespaceBinding)$scope, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf5.$amp$plus((Object)new Elem(null, "br", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf5.$amp$plus((Object)new Text("\n             Revision ID (optional, overrides title)"));
        $buf5.$amp$plus((Object)new Elem(null, "br", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf5.$amp$plus((Object)new Text("\n             "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("name", (Seq)new Text("revid"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("type", (Seq)new Text("text"), (MetaData)$md5);
        $buf5.$amp$plus((Object)new Elem(null, "input", (MetaData)$md5, (NamespaceBinding)$scope, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf5.$amp$plus((Object)new Elem(null, "br", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf5.$amp$plus((Object)new Text("\n             Output format"));
        $buf5.$amp$plus((Object)new Elem(null, "br", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf5.$amp$plus((Object)new Text("\n             "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("name", (Seq)new Text("format"), (MetaData)$md6);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n               "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("value", (Seq)new Text("trix"), (MetaData)$md7);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("Trix"));
        $buf6.$amp$plus((Object)new Elem(null, "option", (MetaData)$md7, (NamespaceBinding)$scope, false, (Seq)$buf7));
        $buf6.$amp$plus((Object)new Text("\n               "));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("value", (Seq)new Text("turtle-triples"), (MetaData)$md8);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("Turtle-Triples"));
        $buf6.$amp$plus((Object)new Elem(null, "option", (MetaData)$md8, (NamespaceBinding)$scope, false, (Seq)$buf8));
        $buf6.$amp$plus((Object)new Text("\n               "));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("value", (Seq)new Text("turtle-quads"), (MetaData)$md9);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("Turtle-Quads"));
        $buf6.$amp$plus((Object)new Elem(null, "option", (MetaData)$md9, (NamespaceBinding)$scope, false, (Seq)$buf9));
        $buf6.$amp$plus((Object)new Text("\n               "));
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("value", (Seq)new Text("n-triples"), (MetaData)$md10);
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("N-Triples"));
        $buf6.$amp$plus((Object)new Elem(null, "option", (MetaData)$md10, (NamespaceBinding)$scope, false, (Seq)$buf10));
        $buf6.$amp$plus((Object)new Text("\n               "));
        Null$ $md11 = Null$.MODULE$;
        $md11 = new UnprefixedAttribute("value", (Seq)new Text("n-quads"), (MetaData)$md11);
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("N-Quads"));
        $buf6.$amp$plus((Object)new Elem(null, "option", (MetaData)$md11, (NamespaceBinding)$scope, false, (Seq)$buf11));
        $buf6.$amp$plus((Object)new Text("\n             "));
        $buf5.$amp$plus((Object)new Elem(null, "select", (MetaData)$md6, (NamespaceBinding)$scope, false, (Seq)$buf6));
        $buf5.$amp$plus((Object)new Elem(null, "br", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf5.$amp$plus((Object)new Text("\n             "));
        Null$ $md12 = Null$.MODULE$;
        $md12 = new UnprefixedAttribute("value", (Seq)new Text("Extract"), (MetaData)$md12);
        $md12 = new UnprefixedAttribute("type", (Seq)new Text("submit"), (MetaData)$md12);
        $buf5.$amp$plus((Object)new Elem(null, "input", (MetaData)$md12, (NamespaceBinding)$scope, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf5.$amp$plus((Object)new Text("\n           "));
        $buf3.$amp$plus((Object)new Elem(null, "form", (MetaData)$md3, (NamespaceBinding)$scope, false, (Seq)$buf5));
        $buf3.$amp$plus((Object)new Text("\n         "));
        $buf.$amp$plus((Object)new Elem(null, "body", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n       "));
        return new Elem(null, "html", (MetaData)$md, (NamespaceBinding)$scope, false, (Seq)$buf);
    }

    @GET
    @Path(value="extract")
    @Produces(value={"application/xml"})
    public String extract(@QueryParam(value="title") String title, @QueryParam(value="revid") @DefaultValue(value="-1") long revid, @QueryParam(value="format") String format) {
        Object object;
        String string;
        if (title == null && revid < 0L) {
            throw new WebApplicationException((Throwable)new Exception("title or revid must be given"), Response.Status.NOT_FOUND);
        }
        StringWriter writer = new StringWriter();
        String string2 = string = format;
        if (!("turtle-triples" != null ? !"turtle-triples".equals(string2) : string2 != null)) {
            object = new TerseFormatter(false, true, TerseFormatter$.MODULE$.$lessinit$greater$default$3());
        } else {
            String string3 = string;
            if (!("turtle-quads" != null ? !"turtle-quads".equals(string3) : string3 != null)) {
                object = new TerseFormatter(true, true, TerseFormatter$.MODULE$.$lessinit$greater$default$3());
            } else {
                String string4 = string;
                if (!("n-triples" != null ? !"n-triples".equals(string4) : string4 != null)) {
                    object = new TerseFormatter(false, false, TerseFormatter$.MODULE$.$lessinit$greater$default$3());
                } else {
                    String string5 = string;
                    object = !("n-quads" != null ? !"n-quads".equals(string5) : string5 != null) ? new TerseFormatter(true, false, TerseFormatter$.MODULE$.$lessinit$greater$default$3()) : TriX$.MODULE$.writeHeader(writer, 2);
                }
            }
        }
        TerseFormatter formatter = object;
        Source source = revid >= 0L ? WikiSource$.MODULE$.fromRevisionIDs((Iterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{revid})), new URL(this.language().apiUri()), this.language()) : WikiSource$.MODULE$.fromTitles((Iterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WikiTitle[]{WikiTitle$.MODULE$.parse(title, this.language())})), new URL(this.language().apiUri()), this.language());
        WriterDestination destination = new WriterDestination((Function0)new Serializable(this, writer){
            public static final long serialVersionUID = 0L;
            private final StringWriter writer$1;

            public final StringWriter apply() {
                return this.writer$1;
            }
            {
                this.writer$1 = writer$1;
            }
        }, (Formatter)formatter);
        Server$.MODULE$.instance().extractor().extract(source, (Destination)destination, this.language());
        return writer.toString();
    }

    @POST
    @Path(value="extract")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public String extract(Elem xml) {
        StringWriter writer = new StringWriter();
        Formatter formatter = TriX$.MODULE$.writeHeader(writer, 2);
        Source source = XMLSource$.MODULE$.fromXML(xml, this.language());
        WriterDestination destination = new WriterDestination((Function0)new Serializable(this, writer){
            public static final long serialVersionUID = 0L;
            private final StringWriter writer$2;

            public final StringWriter apply() {
                return this.writer$2;
            }
            {
                this.writer$2 = writer$2;
            }
        }, formatter);
        Server$.MODULE$.instance().extractor().extract(source, (Destination)destination, this.language());
        return writer.toString();
    }

    public Extraction(@PathParam(value="lang") String langCode) {
        this.org$dbpedia$extraction$server$resources$Extraction$$langCode = langCode;
        this.language = Language$.MODULE$.getOrElse(langCode, (Function0)new $anonfun$3(this));
        if (Server$.MODULE$.instance().managers().contains((Object)this.language())) {
            return;
        }
        throw new WebApplicationException((Throwable)new Exception(new StringBuilder().append((Object)"language ").append((Object)langCode).append((Object)" not configured in server").toString()), 404);
    }
}

