/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.server;

import java.io.File;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dbpedia.extraction.destinations.Destination;
import org.dbpedia.extraction.mappings.CompositeExtractor;
import org.dbpedia.extraction.mappings.LabelExtractor;
import org.dbpedia.extraction.mappings.Mapping;
import org.dbpedia.extraction.mappings.MappingExtractor;
import org.dbpedia.extraction.mappings.Mappings;
import org.dbpedia.extraction.mappings.MappingsLoader$;
import org.dbpedia.extraction.mappings.Redirects;
import org.dbpedia.extraction.mappings.RootExtractor;
import org.dbpedia.extraction.ontology.Ontology;
import org.dbpedia.extraction.ontology.io.OntologyReader;
import org.dbpedia.extraction.server.Paths;
import org.dbpedia.extraction.server.XMLLogHandler;
import org.dbpedia.extraction.sources.Source;
import org.dbpedia.extraction.sources.WikiPage;
import org.dbpedia.extraction.sources.WikiSource$;
import org.dbpedia.extraction.sources.XMLSource$;
import org.dbpedia.extraction.util.Language;
import org.dbpedia.extraction.util.Language$;
import org.dbpedia.extraction.wikiparser.Namespace;
import org.dbpedia.extraction.wikiparser.Namespace$;
import org.dbpedia.extraction.wikiparser.PageNode;
import org.dbpedia.extraction.wikiparser.WikiTitle;
import org.dbpedia.extraction.wikiparser.impl.simple.SimpleWikiParser;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Traversable$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.xml.Elem;

@ScalaSignature(bytes="\u0006\u0001\u0005%h!B\u0001\u0003\u0003\u0003Y!!E#yiJ\f7\r^5p]6\u000bg.Y4fe*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005\u00151\u0011AC3yiJ\f7\r^5p]*\u0011q\u0001C\u0001\bI\n\u0004X\rZ5b\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fM\"A1\u0003\u0001B\u0001B\u0003%A#A\u0005mC:<W/Y4fgB\u0019Q#\b\u0011\u000f\u0005YYbBA\f\u001b\u001b\u0005A\"BA\r\u000b\u0003\u0019a$o\\8u}%\tq\"\u0003\u0002\u001d\u001d\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u0010 \u0005\r\u0019V-\u001d\u0006\u000399\u0001\"!\t\u0013\u000e\u0003\tR!a\t\u0003\u0002\tU$\u0018\u000e\\\u0005\u0003K\t\u0012\u0001\u0002T1oOV\fw-\u001a\u0005\tO\u0001\u0011\t\u0011)A\u0005Q\u0005)\u0001/\u0019;igB\u0011\u0011FK\u0007\u0002\u0005%\u00111F\u0001\u0002\u0006!\u0006$\bn\u001d\u0005\u0006[\u0001!\tAL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007=\u0002\u0014\u0007\u0005\u0002*\u0001!)1\u0003\fa\u0001)!)q\u0005\fa\u0001Q!91\u0007\u0001b\u0001\n\u0013!\u0014A\u00027pO\u001e,'/F\u00016!\t1D(D\u00018\u0015\tA\u0014(A\u0004m_\u001e<\u0017N\\4\u000b\u0005\rR$\"A\u001e\u0002\t)\fg/Y\u0005\u0003{]\u0012a\u0001T8hO\u0016\u0014\bBB \u0001A\u0003%Q'A\u0004m_\u001e<WM\u001d\u0011\t\u000b\u0005\u0003a\u0011\u0001\"\u0002\u0013\u0015DHO]1di>\u0014HCA\"J!\t!u)D\u0001F\u0015\t1E!\u0001\u0005nCB\u0004\u0018N\\4t\u0013\tAUIA\u0007S_>$X\t\u001f;sC\u000e$xN\u001d\u0005\u0006\u0015\u0002\u0003\r\u0001I\u0001\tY\u0006tw-^1hK\")A\n\u0001D\u0001\u001b\u0006AqN\u001c;pY><\u0017\u0010F\u0001O!\ty\u0015+D\u0001Q\u0015\taE!\u0003\u0002S!\nAqJ\u001c;pY><\u0017\u0010C\u0003U\u0001\u0019\u0005Q+A\u0007p]R|Gn\\4z!\u0006<Wm\u001d\u000b\u0002-B!qKW/d\u001d\ti\u0001,\u0003\u0002Z\u001d\u00051\u0001K]3eK\u001aL!a\u0017/\u0003\u00075\u000b\u0007O\u0003\u0002Z\u001dA\u0011a,Y\u0007\u0002?*\u0011\u0001\rB\u0001\u000bo&\\\u0017\u000e]1sg\u0016\u0014\u0018B\u00012`\u0005%9\u0016n[5USRdW\r\u0005\u0002_I&\u0011Qm\u0018\u0002\t!\u0006<WMT8eK\")q\r\u0001D\u0001Q\u0006\tR.\u00199qS:<\u0007+Y4f'>,(oY3\u0015\u0005%d\u0007cA\u000bkG&\u00111n\b\u0002\f)J\fg/\u001a:tC\ndW\rC\u0003KM\u0002\u0007\u0001\u0005C\u0003G\u0001\u0019\u0005a\u000e\u0006\u0002peB\u0011A\t]\u0005\u0003c\u0016\u0013\u0001\"T1qa&twm\u001d\u0005\u0006\u00156\u0004\r\u0001\t\u0005\u0006i\u00021\t!^\u0001\u0013kB$\u0017\r^3P]R|Gn\\4z!\u0006<W\r\u0006\u0002wsB\u0011Qb^\u0005\u0003q:\u0011A!\u00168ji\")!p\u001da\u0001w\u0006!\u0001/Y4f!\tax0D\u0001~\u0015\tqH!A\u0004t_V\u00148-Z:\n\u0007\u0005\u0005QP\u0001\u0005XS.L\u0007+Y4f\u0011\u001d\t)\u0001\u0001D\u0001\u0003\u000f\t!C]3n_Z,wJ\u001c;pY><\u0017\u0010U1hKR\u0019a/!\u0003\t\u000f\u0005-\u00111\u0001a\u0001;\u0006)A/\u001b;mK\"9\u0011q\u0002\u0001\u0007\u0002\u0005E\u0011!E;qI\u0006$X-T1qa&tw\rU1hKR)a/a\u0005\u0002\u0016!1!0!\u0004A\u0002mDaASA\u0007\u0001\u0004\u0001\u0003bBA\r\u0001\u0019\u0005\u00111D\u0001\u0012e\u0016lwN^3NCB\u0004\u0018N\\4QC\u001e,G#\u0002<\u0002\u001e\u0005}\u0001bBA\u0006\u0003/\u0001\r!\u0018\u0005\u0007\u0015\u0006]\u0001\u0019\u0001\u0011\t\u000f\u0005\r\u0002A\"\u0001\u0002&\u0005IQ\u000f\u001d3bi\u0016\fE\u000e\\\u000b\u0002m\"I\u0011\u0011\u0006\u0001C\u0002\u0013E\u00111F\u0001\u0007a\u0006\u00148/\u001a:\u0016\u0005\u00055\u0002\u0003BA\u0018\u0003si!!!\r\u000b\t\u0005M\u0012QG\u0001\u0007g&l\u0007\u000f\\3\u000b\u0007\u0005]r,\u0001\u0003j[Bd\u0017\u0002BA\u001e\u0003c\u0011\u0001cU5na2,w+[6j!\u0006\u00148/\u001a:\t\u0011\u0005}\u0002\u0001)A\u0005\u0003[\tq\u0001]1sg\u0016\u0014\b\u0005C\u0004\u0002D\u0001!\t!!\u0012\u0002\u000f\u0015DHO]1diR9a/a\u0012\u0002R\u0005\u0005\u0004\u0002CA%\u0003\u0003\u0002\r!a\u0013\u0002\rM|WO]2f!\ra\u0018QJ\u0005\u0004\u0003\u001fj(AB*pkJ\u001cW\r\u0003\u0005\u0002T\u0005\u0005\u0003\u0019AA+\u0003-!Wm\u001d;j]\u0006$\u0018n\u001c8\u0011\t\u0005]\u0013QL\u0007\u0003\u00033R1!a\u0017\u0005\u00031!Wm\u001d;j]\u0006$\u0018n\u001c8t\u0013\u0011\ty&!\u0017\u0003\u0017\u0011+7\u000f^5oCRLwN\u001c\u0005\u0007\u0015\u0006\u0005\u0003\u0019\u0001\u0011\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u0002h\u0005ya/\u00197jI\u0006$X-T1qa&tw\r\u0006\u0004\u0002j\u0005U\u0014\u0011\u0010\t\u0005\u0003W\n\t(\u0004\u0002\u0002n)\u0019\u0011q\u000e\b\u0002\u0007alG.\u0003\u0003\u0002t\u00055$\u0001B#mK6Dq!a\u001e\u0002d\u0001\u0007\u0011.A\u0007nCB\u0004\u0018N\\4t!\u0006<Wm\u001d\u0005\b\u0003w\n\u0019\u00071\u0001!\u0003\u0011a\u0017M\\4\t\u000f\u0005}\u0004\u0001\"\u0001\u0002\u0002\u0006)b/\u00197jI\u0006$Xm\u00148u_2|w-\u001f)bO\u0016\u001cH\u0003BA5\u0003\u0007C!\"!\"\u0002~A\u0005\t\u0019AAD\u0003AqWm^(oi>dwnZ=QC\u001e,7\u000f\u0005\u0003\u0016\u0003\u0013[\u0018bAAF?\t!A*[:u\u0011\u001d\ty\t\u0001C\t\u0003#\u000b\u0011\u0003\\8bI>sGo\u001c7pOf\u0004\u0016mZ3t)\t\t\u0019\n\u0005\u0004\u0002\u0016\u0006}UlY\u0007\u0003\u0003/SA!!'\u0002\u001c\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003;s\u0011AC2pY2,7\r^5p]&\u00191,a&\t\u000f\u0005\r\u0006\u0001\"\u0005\u0002&\u0006\u0001Bn\\1e\u001b\u0006\u0004\b/\u001b8h!\u0006<Wm\u001d\u000b\u0003\u0003O\u0003Ba\u0016.!-\"9\u00111\u0015\u0001\u0005\u0012\u0005-Fc\u0001,\u0002.\"1!*!+A\u0002\u0001Ba!!-\u0001\t#i\u0015\u0001\u00047pC\u0012|e\u000e^8m_\u001eL\bbBA[\u0001\u0011E\u0011qW\u0001\u000fY>\fG-\u0012=ue\u0006\u001cGo\u001c:t)\t\tI\f\u0005\u0003X5\u0002\u001a\u0005bBA[\u0001\u0011E\u0011Q\u0018\u000b\u0004\u0007\u0006}\u0006bBA>\u0003w\u0003\r\u0001\t\u0005\b\u0003\u0007\u0004A\u0011CAc\u00031aw.\u00193NCB\u0004\u0018N\\4t)\t\t9\r\u0005\u0003X5\u0002z\u0007bBAb\u0001\u0011E\u00111\u001a\u000b\u0004_\u00065\u0007bBA>\u0003\u0013\u0004\r\u0001\t\u0005\n\u0003#\u0004\u0011\u0013!C\u0001\u0003'\fqD^1mS\u0012\fG/Z(oi>dwnZ=QC\u001e,7\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\t)N\u000b\u0003\u0002\b\u0006]7FAAm!\u0011\tY.!:\u000e\u0005\u0005u'\u0002BAp\u0003C\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\rh\"\u0001\u0006b]:|G/\u0019;j_:LA!a:\u0002^\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public abstract class ExtractionManager {
    private final Seq<Language> languages;
    private final Paths paths;
    private final Logger logger;
    private final SimpleWikiParser parser;

    private Logger logger() {
        return this.logger;
    }

    public abstract RootExtractor extractor(Language var1);

    public abstract Ontology ontology();

    public abstract Map<WikiTitle, PageNode> ontologyPages();

    public abstract Traversable<PageNode> mappingPageSource(Language var1);

    public abstract Mappings mappings(Language var1);

    public abstract void updateOntologyPage(WikiPage var1);

    public abstract void removeOntologyPage(WikiTitle var1);

    public abstract void updateMappingPage(WikiPage var1, Language var2);

    public abstract void removeMappingPage(WikiTitle var1, Language var2);

    public abstract void updateAll();

    public SimpleWikiParser parser() {
        return this.parser;
    }

    public void extract(Source source, Destination destination, Language language) {
        RootExtractor extract2 = this.extractor(language);
        destination.open();
        ((GenericTraversableTemplate)source.map((Function1)this.parser(), Traversable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, destination, extract2){
            public static final long serialVersionUID = 0L;
            private final Destination destination$1;
            private final RootExtractor extract$1;

            public final void apply(PageNode page) {
                this.destination$1.write((Traversable)this.extract$1.apply(page));
            }
            {
                this.destination$1 = destination$1;
                this.extract$1 = extract$1;
            }
        });
        destination.close();
    }

    public Elem validateMapping(Traversable<PageNode> mappingsPages, Language lang) {
        Logger logger = Logger.getLogger(MappingsLoader$.MODULE$.getClass().getName());
        XMLLogHandler logHandler = new XMLLogHandler();
        logHandler.setLevel(Level.WARNING);
        logger.addHandler(logHandler);
        Object context = new Object(this, mappingsPages, lang){
            private final Ontology ontology;
            private final Language language;
            private final Redirects redirects;
            private final Traversable<PageNode> mappingPageSource;

            public Ontology ontology() {
                return this.ontology;
            }

            public Language language() {
                return this.language;
            }

            public Redirects redirects() {
                return this.redirects;
            }

            public Traversable<PageNode> mappingPageSource() {
                return this.mappingPageSource;
            }
            {
                this.ontology = $outer.ontology();
                this.language = lang$3;
                this.redirects = new Redirects((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
                this.mappingPageSource = mappingsPages$1;
            }
        };
        Mappings mappings = MappingsLoader$.MODULE$.load(context);
        if (mappings.templateMappings().isEmpty() && mappings.tableMappings().isEmpty()) {
            logger.severe("no mappings found");
        }
        logger.removeHandler(logHandler);
        return logHandler.xml();
    }

    public Elem validateOntologyPages(List<WikiPage> newOntologyPages) {
        XMLLogHandler logHandler = new XMLLogHandler();
        logHandler.setLevel(Level.WARNING);
        Logger.getLogger(OntologyReader.class.getName()).addHandler(logHandler);
        Map newOntologyPagesMap = ((TraversableOnce)((TraversableLike)newOntologyPages.map((Function1)this.parser(), List$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<WikiTitle, PageNode> apply(PageNode page) {
                return new Tuple2((Object)page.title(), (Object)page);
            }
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        Iterable updatedOntologyPages = this.ontologyPages().$plus$plus((GenTraversableOnce)newOntologyPagesMap).values();
        new OntologyReader().read((Traversable)updatedOntologyPages);
        Logger.getLogger(OntologyReader.class.getName()).removeHandler(logHandler);
        return logHandler.xml();
    }

    public List<WikiPage> validateOntologyPages$default$1() {
        return Nil$.MODULE$;
    }

    public Map<WikiTitle, PageNode> loadOntologyPages() {
        Source source;
        if (this.paths.ontologyFile() != null && this.paths.ontologyFile().isFile()) {
            this.logger().warning(new StringBuilder().append((Object)"LOADING ONTOLOGY NOT FROM SERVER, BUT FROM LOCAL FILE [").append((Object)this.paths.ontologyFile()).append((Object)"] - MAY BE OUTDATED - ONLY FOR TESTING!").toString());
            source = XMLSource$.MODULE$.fromFile(this.paths.ontologyFile(), Language$.MODULE$.Mappings(), XMLSource$.MODULE$.fromFile$default$3());
        } else {
            Set namespaces = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Namespace[]{Namespace$.MODULE$.OntologyClass(), Namespace$.MODULE$.OntologyProperty()}));
            URL url = this.paths.apiUrl();
            Language language = Language$.MODULE$.Mappings();
            this.logger().info(new StringBuilder().append((Object)"Loading ontology pages from URL [").append((Object)url).append((Object)"]").toString());
            source = WikiSource$.MODULE$.fromNamespaces(namespaces, url, language);
        }
        Source source2 = source;
        return ((TraversableOnce)((TraversableLike)source2.map((Function1)this.parser(), Traversable$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<WikiTitle, PageNode> apply(PageNode page) {
                return new Tuple2((Object)page.title(), (Object)page);
            }
        }, Traversable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public Map<Language, Map<WikiTitle, PageNode>> loadMappingPages() {
        this.logger().info("Loading mapping pages");
        return ((TraversableOnce)this.languages.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExtractionManager $outer;

            public final Tuple2<Language, Map<WikiTitle, PageNode>> apply(Language lang) {
                return new Tuple2((Object)lang, this.$outer.loadMappingPages(lang));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public Map<WikiTitle, PageNode> loadMappingPages(Language language) {
        Source source;
        Namespace namespace = (Namespace)Namespace$.MODULE$.mappings().getOrElse((Object)language, (Function0)new Serializable(this, language){
            public static final long serialVersionUID = 0L;
            private final Language language$1;

            public final Nothing$ apply() {
                throw new NoSuchElementException(new StringBuilder().append((Object)"no mapping namespace for language ").append((Object)this.language$1.wikiCode()).toString());
            }
            {
                this.language$1 = language$1;
            }
        });
        if (this.paths.mappingsDir() != null && this.paths.mappingsDir().isDirectory()) {
            File file = new File(this.paths.mappingsDir(), new StringBuilder().append((Object)namespace.name(Language$.MODULE$.Mappings()).replace(' ', '_')).append((Object)".xml").toString());
            this.logger().warning(new StringBuilder().append((Object)"LOADING MAPPINGS NOT FROM SERVER, BUT FROM LOCAL FILE [").append((Object)file).append((Object)"] - MAY BE OUTDATED - ONLY FOR TESTING!").toString());
            source = XMLSource$.MODULE$.fromFile(file, language, XMLSource$.MODULE$.fromFile$default$3());
        } else {
            URL url = this.paths.apiUrl();
            source = WikiSource$.MODULE$.fromNamespaces((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Namespace[]{namespace})), url, language);
        }
        Source source2 = source;
        return ((TraversableOnce)((TraversableLike)source2.map((Function1)this.parser(), Traversable$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<WikiTitle, PageNode> apply(PageNode page) {
                return new Tuple2((Object)page.title(), (Object)page);
            }
        }, Traversable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public Ontology loadOntology() {
        return new OntologyReader().read((Traversable)this.ontologyPages().values());
    }

    /*
     * WARNING - void declaration
     */
    public Map<Language, RootExtractor> loadExtractors() {
        void var1_1;
        Map extractors = ((TraversableOnce)this.languages.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExtractionManager $outer;

            public final Tuple2<Language, RootExtractor> apply(Language lang) {
                return new Tuple2((Object)lang, (Object)this.$outer.loadExtractors(lang));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        this.logger().info(new StringBuilder().append((Object)"All extractors loaded for languages ").append((Object)((TraversableOnce)((SeqLike)this.languages.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Language x$1) {
                return x$1.wikiCode();
            }
        }, Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).mkString(",")).toString());
        return var1_1;
    }

    public RootExtractor loadExtractors(Language lang) {
        return new RootExtractor((Mapping)new CompositeExtractor((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Mapping[]{new LabelExtractor(new Object(this, lang){
            private final Ontology ontology;
            private final Language language;

            public Ontology ontology() {
                return this.ontology;
            }

            public Language language() {
                return this.language;
            }
            {
                this.ontology = $outer.ontology();
                this.language = lang$2;
            }
        }), new MappingExtractor(new Object(this, lang){
            private final Mappings mappings;
            private final Redirects redirects;

            public Mappings mappings() {
                return this.mappings;
            }

            public Redirects redirects() {
                return this.redirects;
            }
            {
                this.mappings = $outer.mappings(lang$2);
                this.redirects = new Redirects((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
            }
        })})));
    }

    public Map<Language, Mappings> loadMappings() {
        return ((TraversableOnce)this.languages.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExtractionManager $outer;

            public final Tuple2<Language, Mappings> apply(Language lang) {
                return new Tuple2((Object)lang, (Object)this.$outer.loadMappings(lang));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public Mappings loadMappings(Language lang) {
        Object context = new Object(this, lang){
            private final Ontology ontology;
            private final Language language;
            private final Redirects redirects;
            private final Traversable<PageNode> mappingPageSource;

            public Ontology ontology() {
                return this.ontology;
            }

            public Language language() {
                return this.language;
            }

            public Redirects redirects() {
                return this.redirects;
            }

            public Traversable<PageNode> mappingPageSource() {
                return this.mappingPageSource;
            }
            {
                this.ontology = $outer.ontology();
                this.language = lang$1;
                this.redirects = new Redirects((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
                this.mappingPageSource = $outer.mappingPageSource(lang$1);
            }
        };
        return MappingsLoader$.MODULE$.load(context);
    }

    public ExtractionManager(Seq<Language> languages2, Paths paths) {
        this.languages = languages2;
        this.paths = paths;
        this.logger = Logger.getLogger(ExtractionManager.class.getName());
        this.parser = new SimpleWikiParser();
    }
}

