/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.server.stats;

import org.dbpedia.extraction.server.stats.TemplateStats;
import org.dbpedia.extraction.server.stats.TemplateStatsBuilder;
import org.dbpedia.extraction.server.stats.WikipediaStats;
import org.dbpedia.extraction.server.stats.WikipediaStatsFormat$;
import org.dbpedia.extraction.server.util.CollectionReader;
import org.dbpedia.extraction.util.Language;
import org.dbpedia.extraction.util.Language$;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001!3A!\u0001\u0002\u0001\u001b\t!r+[6ja\u0016$\u0017.Y*uCR\u001c(+Z1eKJT!a\u0001\u0003\u0002\u000bM$\u0018\r^:\u000b\u0005\u00151\u0011AB:feZ,'O\u0003\u0002\b\u0011\u0005QQ\r\u001f;sC\u000e$\u0018n\u001c8\u000b\u0005%Q\u0011a\u00023ca\u0016$\u0017.\u0019\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011\u0001B;uS2L!a\u0005\t\u0003!\r{G\u000e\\3di&|gNU3bI\u0016\u0014\bCA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"aC*dC2\fwJ\u00196fGRD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u0006Y&tWm\u001d\t\u0004;\u0015BcB\u0001\u0010$\u001d\ty\"%D\u0001!\u0015\t\tC\"\u0001\u0004=e>|GOP\u0005\u0002/%\u0011AEF\u0001\ba\u0006\u001c7.Y4f\u0013\t1sE\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\t!c\u0003\u0005\u0002*Y9\u0011QCK\u0005\u0003WY\ta\u0001\u0015:fI\u00164\u0017BA\u0017/\u0005\u0019\u0019FO]5oO*\u00111F\u0006\u0005\u0006a\u0001!\t!M\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005I\"\u0004CA\u001a\u0001\u001b\u0005\u0011\u0001\"B\u000e0\u0001\u0004a\u0002\"\u0002\u001c\u0001\t\u00039\u0014\u0001\u0002:fC\u0012$\u0012\u0001\u000f\t\u0003geJ!A\u000f\u0002\u0003\u001d]K7.\u001b9fI&\f7\u000b^1ug\")A\b\u0001C\u0005{\u0005a!/Z1e%\u0016$\u0017N]3diV\ta\b\u0005\u0003\u0016\u007f!B\u0013B\u0001!\u0017\u0005\u0019!V\u000f\u001d7fe!)!\t\u0001C\u0005\u0007\u0006a!/Z1e!J|\u0007/\u001a:usV\tA\t\u0005\u0003\u0016\u007f!*\u0005CA\u000bG\u0013\t9eCA\u0002J]R\u0004")
public class WikipediaStatsReader
extends CollectionReader
implements ScalaObject {
    public WikipediaStats read() {
        String line = "";
        Language language = Language$.MODULE$.apply(this.readTag(WikipediaStatsFormat$.MODULE$.WikiStatsTag()));
        this.readEmpty();
        int redirCount = this.readCount(WikipediaStatsFormat$.MODULE$.RedirectsTag());
        HashMap redirects = new HashMap();
        for (int redirIndex = 0; redirIndex < redirCount; ++redirIndex) {
            redirects.$plus$eq(this.readRedirect());
        }
        this.readEmpty();
        int templateCount = this.readCount(WikipediaStatsFormat$.MODULE$.TemplatesTag());
        this.readEmpty();
        HashMap templates = new HashMap();
        for (int templateIndex = 0; templateIndex < templateCount; ++templateIndex) {
            TemplateStatsBuilder templateStats = new TemplateStatsBuilder();
            String templateName = this.readTag(WikipediaStatsFormat$.MODULE$.TemplateTag());
            templateStats.templateCount_$eq(this.readCount(WikipediaStatsFormat$.MODULE$.CountTag()));
            int propCount = this.readCount(WikipediaStatsFormat$.MODULE$.PropertiesTag());
            for (int propIndex = 0; propIndex < propCount; ++propIndex) {
                templateStats.properties().$plus$eq(this.readProperty());
            }
            templates.update((Object)templateName, (Object)templateStats.build());
            this.readEmpty();
        }
        this.readEmpty();
        return new WikipediaStats(language, (Map<String, String>)redirects.toMap(Predef$.MODULE$.conforms()), (Map<String, TemplateStats>)templates.toMap(Predef$.MODULE$.conforms()));
    }

    private Tuple2<String, String> readRedirect() {
        String tail = this.readTag(WikipediaStatsFormat$.MODULE$.RedirectTag());
        String[] pair = tail.split("\\|", -1);
        if (pair.length == 2) {
            return new Tuple2((Object)pair[0], (Object)pair[1]);
        }
        throw new Exception(new StringBuilder().append((Object)"expected line starting with '").append((Object)WikipediaStatsFormat$.MODULE$.RedirectTag()).append((Object)"' followed by two strings, found '").append((Object)WikipediaStatsFormat$.MODULE$.RedirectTag()).append((Object)tail).append((Object)"'").toString());
    }

    private Tuple2<String, Object> readProperty() {
        String tail = this.readTag(WikipediaStatsFormat$.MODULE$.PropertyTag());
        String[] pair = tail.split("\\|", -1);
        if (pair.length == 2) {
            try {
                return new Tuple2((Object)pair[0], (Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.augmentString(pair[1]).toInt()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new Exception(new StringBuilder().append((Object)"expected line starting with '").append((Object)WikipediaStatsFormat$.MODULE$.PropertyTag()).append((Object)"' followed by a string and an integer, found '").append((Object)WikipediaStatsFormat$.MODULE$.PropertyTag()).append((Object)tail).append((Object)"'").toString());
    }

    public WikipediaStatsReader(Iterator<String> lines) {
        super(lines);
    }
}

