/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.server.stats;

import java.io.File;
import java.util.logging.Logger;
import org.dbpedia.extraction.mappings.Mappings;
import org.dbpedia.extraction.server.stats.IgnoreList;
import org.dbpedia.extraction.server.stats.MappingStatsConfig;
import org.dbpedia.extraction.server.stats.MappingStatsHolder;
import org.dbpedia.extraction.server.stats.MappingStatsHolder$;
import org.dbpedia.extraction.server.stats.MappingStatsManager$;
import org.dbpedia.extraction.server.stats.WikipediaStats;
import org.dbpedia.extraction.server.stats.WikipediaStatsReader;
import org.dbpedia.extraction.util.Language;
import org.dbpedia.extraction.util.StringUtils$;
import scala.Function0;
import scala.ScalaObject;
import scala.collection.Iterator;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001Q4A!\u0001\u0002\u0001\u001b\t\u0019R*\u00199qS:<7\u000b^1ug6\u000bg.Y4fe*\u00111\u0001B\u0001\u0006gR\fGo\u001d\u0006\u0003\u000b\u0019\taa]3sm\u0016\u0014(BA\u0004\t\u0003))\u0007\u0010\u001e:bGRLwN\u001c\u0006\u0003\u0013)\tq\u0001\u001a2qK\u0012L\u0017MC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001aB\u0005\t\u0003\u001fAi\u0011AA\u0005\u0003#\t\u0011!#T1qa&twm\u0015;biN\u001cuN\u001c4jOB\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\tY1kY1mC>\u0013'.Z2u\u0011!I\u0002A!A!\u0002\u0013Q\u0012\u0001C:uCR\u001cH)\u001b:\u0011\u0005m\u0001S\"\u0001\u000f\u000b\u0005uq\u0012AA5p\u0015\u0005y\u0012\u0001\u00026bm\u0006L!!\t\u000f\u0003\t\u0019KG.\u001a\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u0005AA.\u00198hk\u0006<W\r\u0005\u0002&Q5\taE\u0003\u0002(\r\u0005!Q\u000f^5m\u0013\tIcE\u0001\u0005MC:<W/Y4f\u0011\u0015Y\u0003\u0001\"\u0001-\u0003\u0019a\u0014N\\5u}Q\u0019QFL\u0018\u0011\u0005=\u0001\u0001\"B\r+\u0001\u0004Q\u0002\"B\u0012+\u0001\u0004!\u0003bB\u0019\u0001\u0005\u0004%IAM\u0001\u0007Y><w-\u001a:\u0016\u0003M\u0002\"\u0001\u000e\u001d\u000e\u0003UR!AN\u001c\u0002\u000f1|wmZ5oO*\u0011qEH\u0005\u0003sU\u0012a\u0001T8hO\u0016\u0014\bBB\u001e\u0001A\u0003%1'A\u0004m_\u001e<WM\u001d\u0011\t\u000fu\u0002!\u0019!C\u0001}\u0005Q\u0011n\u001a8pe\u0016d\u0015n\u001d;\u0016\u0003}\u0002\"a\u0004!\n\u0005\u0005\u0013!AC%h]>\u0014X\rT5ti\"11\t\u0001Q\u0001\n}\n1\"[4o_J,G*[:uA!9Q\t\u0001b\u0001\n\u00031\u0015A\u00049fe\u000e,g\u000e^1hK\u001aKG.Z\u000b\u00025!1\u0001\n\u0001Q\u0001\ni\tq\u0002]3sG\u0016tG/Y4f\r&dW\r\t\u0005\b\u0015\u0002\u0011\r\u0011\"\u0001L\u0003%9\u0018n[5Ti\u0006$8/F\u0001M!\tyQ*\u0003\u0002O\u0005\tqq+[6ja\u0016$\u0017.Y*uCR\u001c\bB\u0002)\u0001A\u0003%A*\u0001\u0006xS.L7\u000b^1ug\u0002BqA\u0015\u0001A\u0002\u0013\u00051+\u0001\u0004i_2$WM]\u000b\u0002)B\u0011q\"V\u0005\u0003-\n\u0011!#T1qa&twm\u0015;biNDu\u000e\u001c3fe\"9\u0001\f\u0001a\u0001\n\u0003I\u0016A\u00035pY\u0012,'o\u0018\u0013fcR\u0011!,\u0018\t\u0003'mK!\u0001\u0018\u000b\u0003\tUs\u0017\u000e\u001e\u0005\b=^\u000b\t\u00111\u0001U\u0003\rAH%\r\u0005\u0007A\u0002\u0001\u000b\u0015\u0002+\u0002\u000f!|G\u000eZ3sA!\u0012qL\u0019\t\u0003'\rL!\u0001\u001a\u000b\u0003\u0011Y|G.\u0019;jY\u0016DQA\u001a\u0001\u0005\u0002\u001d\f1\"\u001e9eCR,7\u000b^1ugR\t!\fC\u0003g\u0001\u0011\u0005\u0011\u000e\u0006\u0002[U\")1\u000e\u001ba\u0001Y\u0006AQ.\u00199qS:<7\u000f\u0005\u0002n_6\taN\u0003\u0002l\r%\u0011\u0001O\u001c\u0002\t\u001b\u0006\u0004\b/\u001b8hg\")!\u000f\u0001C\u0005g\u0006IAn\\1e'R\fGo\u001d\u000b\u0002\u0019\u0002")
public class MappingStatsManager
extends MappingStatsConfig
implements ScalaObject {
    private final Language language;
    private final Logger logger;
    private final IgnoreList ignoreList;
    private final File percentageFile;
    private final WikipediaStats wikiStats;
    private volatile MappingStatsHolder holder;

    private Logger logger() {
        return this.logger;
    }

    public IgnoreList ignoreList() {
        return this.ignoreList;
    }

    public File percentageFile() {
        return this.percentageFile;
    }

    public WikipediaStats wikiStats() {
        return this.wikiStats;
    }

    public MappingStatsHolder holder() {
        return this.holder;
    }

    public void holder_$eq(MappingStatsHolder mappingStatsHolder) {
        this.holder = mappingStatsHolder;
    }

    public void updateStats() {
        this.updateStats(this.holder().mappings());
    }

    public void updateStats(Mappings mappings) {
        this.holder_$eq(MappingStatsHolder$.MODULE$.apply(this.wikiStats(), mappings, this.ignoreList()));
    }

    private WikipediaStats loadStats() {
        long millis = System.currentTimeMillis();
        this.logger().info(new StringBuilder().append((Object)"Loading ").append((Object)this.language.wikiCode()).append((Object)" wiki statistics from ").append((Object)this.mappingStatsFile()).toString());
        BufferedSource source = Source$.MODULE$.fromFile(this.mappingStatsFile(), "UTF-8");
        WikipediaStats exceptionResult1 = null;
        try {
            exceptionResult1 = new WikipediaStatsReader((Iterator<String>)source.getLines()).read();
            WikipediaStats wikiStats = exceptionResult1;
            this.logger().info(new StringBuilder().append((Object)"Loaded ").append((Object)this.language.wikiCode()).append((Object)" wiki statistics from ").append((Object)this.mappingStatsFile()).append((Object)" in ").append((Object)StringUtils$.MODULE$.prettyMillis(System.currentTimeMillis() - millis)).toString());
            return wikiStats;
        }
        finally {
            source.close();
        }
    }

    public MappingStatsManager(File statsDir, Language language) {
        this.language = language;
        super(statsDir, language);
        this.logger = Logger.getLogger(this.getClass().getName());
        this.ignoreList = new IgnoreList(new File(statsDir, new StringBuilder().append((Object)"ignorelist_").append((Object)language.wikiCode()).append((Object)".txt").toString()), (Function0<BoxedUnit>)new $anonfun$1(this));
        this.percentageFile = new File(statsDir, new StringBuilder().append((Object)"percentage.").append((Object)language.wikiCode()).toString());
        this.wikiStats = this.loadStats();
        this.holder = null;
    }
}

