/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.server.stats;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Logger;
import org.dbpedia.extraction.destinations.Quad;
import org.dbpedia.extraction.destinations.Quad$;
import org.dbpedia.extraction.server.stats.MappingStatsConfig;
import org.dbpedia.extraction.server.stats.TemplateStats;
import org.dbpedia.extraction.server.stats.TemplateStatsBuilder;
import org.dbpedia.extraction.server.stats.WikipediaStats;
import org.dbpedia.extraction.util.Language;
import org.dbpedia.extraction.util.StringUtils$;
import org.dbpedia.extraction.util.WikiUtil$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001B\u0001\u0003\u00015\u00111#T1qa&twm\u0015;biN\u0014U/\u001b7eKJT!a\u0001\u0003\u0002\u000bM$\u0018\r^:\u000b\u0005\u00151\u0011AB:feZ,'O\u0003\u0002\b\u0011\u0005QQ\r\u001f;sC\u000e$\u0018n\u001c8\u000b\u0005%Q\u0011a\u00023ca\u0016$\u0017.\u0019\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\n\u0011\u0005=\u0001R\"\u0001\u0002\n\u0005E\u0011!AE'baBLgnZ*uCR\u001c8i\u001c8gS\u001e\u0004\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u00111bU2bY\u0006|%M[3di\"A\u0011\u0004\u0001B\u0001B\u0003%!$\u0001\u0005ti\u0006$8\u000fR5s!\tY\u0002%D\u0001\u001d\u0015\tib$\u0001\u0002j_*\tq$\u0001\u0003kCZ\f\u0017BA\u0011\u001d\u0005\u00111\u0015\u000e\\3\t\u0011\r\u0002!\u0011!Q\u0001\n\u0011\n\u0001\u0002\\1oOV\fw-\u001a\t\u0003K!j\u0011A\n\u0006\u0003O\u0019\tA!\u001e;jY&\u0011\u0011F\n\u0002\t\u0019\u0006tw-^1hK\"A1\u0006\u0001B\u0001B\u0003%A&\u0001\u0004qe\u0016$H/\u001f\t\u0003'5J!A\f\u000b\u0003\u000f\t{w\u000e\\3b]\")\u0001\u0007\u0001C\u0001c\u00051A(\u001b8jiz\"BAM\u001a5kA\u0011q\u0002\u0001\u0005\u00063=\u0002\rA\u0007\u0005\u0006G=\u0002\r\u0001\n\u0005\u0006W=\u0002\r\u0001\f\u0005\bo\u0001\u0011\r\u0011\"\u00039\u0003\u0019awnZ4feV\t\u0011\b\u0005\u0002;}5\t1H\u0003\u0002={\u00059An\\4hS:<'BA\u0014\u001f\u0013\ty4H\u0001\u0004M_\u001e<WM\u001d\u0005\u0007\u0003\u0002\u0001\u000b\u0011B\u001d\u0002\u000f1|wmZ3sA!91\t\u0001b\u0001\n\u0013!\u0015!\u0005:fg>,(oY3Ve&\u0004&/\u001a4jqV\tQ\t\u0005\u0002G\u0013:\u00111cR\u0005\u0003\u0011R\ta\u0001\u0015:fI\u00164\u0017B\u0001&L\u0005\u0019\u0019FO]5oO*\u0011\u0001\n\u0006\u0005\u0007\u001b\u0002\u0001\u000b\u0011B#\u0002%I,7o\\;sG\u0016,&/\u001b)sK\u001aL\u0007\u0010\t\u0005\u0006\u001f\u0002!\t\u0001U\u0001\u000bEVLG\u000eZ*uCR\u001cH#B)U-bS\u0006CA\nS\u0013\t\u0019FC\u0001\u0003V]&$\b\"B+O\u0001\u0004Q\u0012!\u0004:fI&\u0014Xm\u0019;t\r&dW\rC\u0003X\u001d\u0002\u0007!$\u0001\tj]\u001a|'m\u001c=Qe>\u00048OR5mK\")\u0011L\u0014a\u00015\u0005yA/Z7qYB\u000b'/Y7t\r&dW\rC\u0003\\\u001d\u0002\u0007!$A\bqCJ\fWn]+tC\u001e,g)\u001b7f\u0011\u0015i\u0006\u0001\"\u0003_\u0003!)\u0017m\u00195MS:,GCA0f)\t\t\u0006\rC\u0003b9\u0002\u0007!-A\u0004qe>\u001cWm]:\u0011\tM\u0019W)U\u0005\u0003IR\u0011\u0011BR;oGRLwN\\\u0019\t\u000b\u0019d\u0006\u0019\u0001\u000e\u0002\t\u0019LG.\u001a\u0005\u0006Q\u0002!I![\u0001\u0016Y>\fG\rV3na2\fG/\u001a*fI&\u0014Xm\u0019;t)\tQ'\u000f\u0005\u0003la\u0016+U\"\u00017\u000b\u00055t\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003_R\t!bY8mY\u0016\u001cG/[8o\u0013\t\tHNA\u0002NCBDQAZ4A\u0002iAQ\u0001\u001e\u0001\u0005\nU\fabY8v]R$V-\u001c9mCR,7\u000f\u0006\u0003Rm^l\b\"\u00024t\u0001\u0004Q\u0002\"\u0002=t\u0001\u0004I\u0018!\u0003:fgVdG/T1q!\u0011Y\u0007/\u0012>\u0011\u0005=Y\u0018B\u0001?\u0003\u0005Q!V-\u001c9mCR,7\u000b^1ug\n+\u0018\u000e\u001c3fe\")ap\u001da\u0001U\u0006I!/\u001a3je\u0016\u001cGo\u001d\u0005\b\u0003\u0003\u0001A\u0011BA\u0002\u0003M\u0001(o\u001c9feRLH)\u001a4j]&$\u0018n\u001c8t)\u001d\t\u0016QAA\u0004\u0003\u0013AQAZ@A\u0002iAQ\u0001_@A\u0002eDQA`@A\u0002)Dq!!\u0004\u0001\t\u0013\ty!A\bd_VtG\u000f\u0015:pa\u0016\u0014H/[3t)\u001d\t\u0016\u0011CA\n\u0003+AaAZA\u0006\u0001\u0004Q\u0002B\u0002=\u0002\f\u0001\u0007\u0011\u0010\u0003\u0004\u007f\u0003\u0017\u0001\rA\u001b\u0005\b\u00033\u0001A\u0011BA\u000e\u0003!\u0019HO]5q+JLGcA#\u0002\u001e!9\u0011qDA\f\u0001\u0004)\u0015aA;sS\"9\u00111\u0005\u0001\u0005\n\u0005\u0015\u0012\u0001C2mK\u0006tWK]5\u0015\u0007\u0015\u000b9\u0003C\u0004\u0002 \u0005\u0005\u0002\u0019A#\t\u000f\u0005-\u0002\u0001\"\u0003\u0002.\u0005Q1\r\\3b]Z\u000bG.^3\u0015\u0007\u0015\u000by\u0003C\u0004\u00022\u0005%\u0002\u0019A#\u0002\u000bY\fG.^3\t\u000f\u0005U\u0002\u0001\"\u0003\u00028\u0005I1\r\\3b]:\u000bW.\u001a\u000b\u0004\u000b\u0006e\u0002bBA\u001e\u0003g\u0001\r!R\u0001\u0005]\u0006lW\rC\u0004\u0002@\u0001!I!!\u0011\u0002\u0011UtWm]2ba\u0016$2!RA\"\u0011\u001d\t\t$!\u0010A\u0002\u0015\u0003")
public class MappingStatsBuilder
extends MappingStatsConfig
implements ScalaObject {
    private final Language language;
    public final boolean org$dbpedia$extraction$server$stats$MappingStatsBuilder$$pretty;
    private final Logger logger;
    private final String resourceUriPrefix;

    private Logger logger() {
        return this.logger;
    }

    private String resourceUriPrefix() {
        return this.resourceUriPrefix;
    }

    public void buildStats(File redirectsFile, File infoboxPropsFile, File templParamsFile, File paramsUsageFile) {
        HashMap templatesMap = new HashMap();
        Predef$.MODULE$.println((Object)new scala.collection.mutable.StringBuilder().append((Object)"Reading redirects from ").append((Object)redirectsFile).toString());
        Map<String, String> redirects = this.loadTemplateRedirects(redirectsFile);
        Predef$.MODULE$.println((Object)new scala.collection.mutable.StringBuilder().append((Object)"Found ").append((Object)BoxesRunTime.boxToInteger((int)redirects.size())).append((Object)" redirects").toString());
        Predef$.MODULE$.println((Object)new scala.collection.mutable.StringBuilder().append((Object)"Using Template namespace ").append((Object)this.templateNamespace()).append((Object)" for language ").append((Object)this.language.wikiCode()).toString());
        Predef$.MODULE$.println((Object)new scala.collection.mutable.StringBuilder().append((Object)"Counting templates in ").append((Object)infoboxPropsFile).toString());
        this.countTemplates(infoboxPropsFile, (Map<String, TemplateStatsBuilder>)templatesMap, redirects);
        Predef$.MODULE$.println((Object)new scala.collection.mutable.StringBuilder().append((Object)"Found ").append((Object)BoxesRunTime.boxToInteger((int)templatesMap.size())).append((Object)" different templates").toString());
        Predef$.MODULE$.println((Object)new scala.collection.mutable.StringBuilder().append((Object)"Loading property definitions from ").append((Object)templParamsFile).toString());
        this.propertyDefinitions(templParamsFile, (Map<String, TemplateStatsBuilder>)templatesMap, redirects);
        Predef$.MODULE$.println((Object)new scala.collection.mutable.StringBuilder().append((Object)"Counting properties in ").append((Object)paramsUsageFile).toString());
        this.countProperties(paramsUsageFile, (Map<String, TemplateStatsBuilder>)templatesMap, redirects);
        WikipediaStats wikiStats = new WikipediaStats(this.language, (scala.collection.immutable.Map<String, String>)redirects.toMap(Predef$.MODULE$.conforms()), (scala.collection.immutable.Map<String, TemplateStats>)((TraversableOnce)templatesMap.map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<String, TemplateStats> apply(Tuple2<String, TemplateStatsBuilder> e) {
                return new Tuple2(e._1(), (Object)((TemplateStatsBuilder)e._2()).build());
            }
        }, HashMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms()));
        this.logger().info(new scala.collection.mutable.StringBuilder().append((Object)"Serializing ").append((Object)this.language.wikiCode()).append((Object)" wiki statistics to ").append((Object)this.mappingStatsFile()).toString());
        OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(this.mappingStatsFile()), "UTF-8");
        try {
            wikiStats.write(output);
            return;
        }
        finally {
            output.close();
        }
    }

    private void eachLine(File file, Function1<String, BoxedUnit> process$1) {
        long millis = System.currentTimeMillis();
        IntRef count$1 = new IntRef(0);
        BufferedSource source = Source$.MODULE$.fromFile(file, "UTF-8");
        try {
            source.getLines().foreach((Function1)new Serializable(this, process$1, count$1){
                public static final long serialVersionUID;
                private final MappingStatsBuilder $outer;
                private final Function1 process$1;
                private final IntRef count$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(String line) {
                    this.process$1.apply((Object)line);
                    ++this.count$1.elem;
                    if (this.count$1.elem % 1000000 == 0) {
                        if (this.$outer.org$dbpedia$extraction$server$stats$MappingStatsBuilder$$pretty) {
                            Predef$.MODULE$.print((Object)new scala.collection.mutable.StringBuilder().append(this.count$1.elem).append((Object)" lines\r").toString());
                        } else {
                            Predef$.MODULE$.println((Object)new scala.collection.mutable.StringBuilder().append(this.count$1.elem).append((Object)" lines").toString());
                        }
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.process$1 = function1;
                    this.count$1 = intRef;
                }
            });
            Predef$.MODULE$.println((Object)new scala.collection.mutable.StringBuilder().append(count$1.elem).append((Object)" lines - ").append((Object)StringUtils$.MODULE$.prettyMillis(System.currentTimeMillis() - millis)).toString());
            return;
        }
        finally {
            source.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> loadTemplateRedirects(File file) {
        void var2_2;
        HashMap redirects$4 = new HashMap();
        this.eachLine(file, (Function1<String, BoxedUnit>)new Serializable(this, redirects$4){
            public static final long serialVersionUID;
            private final MappingStatsBuilder $outer;
            private final HashMap redirects$4;

            static {
                long l = serialVersionUID = 0L;
            }

            /*
             * Enabled aggressive block sorting
             */
            public final void apply(String line) {
                String str;
                String string = line.trim();
                Option option = Quad$.MODULE$.unapply(string);
                if (option.isEmpty()) {
                    String string2 = string;
                } else {
                    Quad quad = (Quad)option.get();
                    Quad quad2 = quad;
                    if (this.gd1$1(quad2)) {
                        String templateName = this.$outer.org$dbpedia$extraction$server$stats$MappingStatsBuilder$$cleanUri(quad2.subject());
                        if (!templateName.startsWith(this.$outer.templateNamespace())) return;
                        this.redirects$4.update((Object)templateName, (Object)this.$outer.org$dbpedia$extraction$server$stats$MappingStatsBuilder$$cleanUri(quad2.value()));
                        return;
                    }
                    str = string;
                }
                if (!Predef$.MODULE$.augmentString(str).nonEmpty()) return;
                if (str.startsWith("#")) return;
                throw new IllegalArgumentException(new scala.collection.mutable.StringBuilder().append((Object)"line did not match object triple syntax: ").append((Object)line).toString());
            }

            private final boolean gd1$1(Quad quad) {
                return quad.datatype() == null;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.redirects$4 = hashMap;
            }
        });
        return var2_2;
    }

    private void countTemplates(File file, Map<String, TemplateStatsBuilder> resultMap$1, Map<String, String> redirects$1) {
        this.eachLine(file, (Function1<String, BoxedUnit>)new Serializable(this, resultMap$1, redirects$1){
            public static final long serialVersionUID;
            private final MappingStatsBuilder $outer;
            private final Map resultMap$1;
            private final Map redirects$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String line) {
                String string = line.trim();
                Option option = Quad$.MODULE$.unapply(string);
                if (option.isEmpty()) {
                    String str = string;
                    if (Predef$.MODULE$.augmentString(str).nonEmpty() && !str.startsWith("#")) {
                        throw new IllegalArgumentException(new scala.collection.mutable.StringBuilder().append((Object)"line did not match object or datatype triple syntax: ").append((Object)line).toString());
                    }
                } else {
                    Quad quad = (Quad)option.get();
                    Quad quad2 = quad;
                    if (quad2.datatype() == null && this.$outer.org$dbpedia$extraction$server$stats$MappingStatsBuilder$$unescape(quad2.predicate()).contains("wikiPageUsesTemplate")) {
                        ObjectRef templateName$1 = new ObjectRef((Object)this.$outer.org$dbpedia$extraction$server$stats$MappingStatsBuilder$$cleanUri(quad2.value()));
                        templateName$1.elem = (String)this.redirects$1.getOrElse((Object)((String)templateName$1.elem), (Function0)new Serializable(this, templateName$1){
                            public static final long serialVersionUID;
                            private final ObjectRef templateName$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return (String)this.templateName$1.elem;
                            }
                            {
                                this.templateName$1 = objectRef;
                            }
                        });
                        TemplateStatsBuilder templateStatsBuilder = (TemplateStatsBuilder)this.resultMap$1.getOrElseUpdate((Object)((String)templateName$1.elem), (Function0)new Serializable(this){
                            public static final long serialVersionUID;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final TemplateStatsBuilder apply() {
                                return new TemplateStatsBuilder();
                            }
                        });
                        templateStatsBuilder.templateCount_$eq(templateStatsBuilder.templateCount() + 1);
                    }
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.resultMap$1 = map;
                this.redirects$1 = map2;
            }
        });
    }

    private void propertyDefinitions(File file, Map<String, TemplateStatsBuilder> resultMap$2, Map<String, String> redirects$2) {
        this.eachLine(file, (Function1<String, BoxedUnit>)new Serializable(this, resultMap$2, redirects$2){
            public static final long serialVersionUID;
            private final MappingStatsBuilder $outer;
            private final Map resultMap$2;
            private final Map redirects$2;

            static {
                long l = serialVersionUID = 0L;
            }

            /*
             * Enabled aggressive block sorting
             */
            public final void apply(String line) {
                String str;
                String string = line.trim();
                Option option = Quad$.MODULE$.unapply(string);
                if (option.isEmpty()) {
                    String string2 = string;
                } else {
                    Quad quad = (Quad)option.get();
                    Quad quad2 = quad;
                    if (this.gd2$1(quad2)) {
                        ObjectRef templateName$2 = new ObjectRef((Object)this.$outer.org$dbpedia$extraction$server$stats$MappingStatsBuilder$$cleanUri(quad2.subject()));
                        String propertyName$1 = this.$outer.org$dbpedia$extraction$server$stats$MappingStatsBuilder$$cleanValue(quad2.value());
                        templateName$2.elem = (String)this.redirects$2.getOrElse((Object)((String)templateName$2.elem), (Function0)new Serializable(this, templateName$2){
                            public static final long serialVersionUID;
                            private final ObjectRef templateName$2;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return (String)this.templateName$2.elem;
                            }
                            {
                                this.templateName$2 = objectRef;
                            }
                        });
                        this.resultMap$2.get((Object)((String)templateName$2.elem)).foreach((Function1)new Serializable(this, propertyName$1){
                            public static final long serialVersionUID;
                            private final String propertyName$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final Option<Object> apply(TemplateStatsBuilder stats) {
                                return stats.properties().put((Object)this.propertyName$1, (Object)BoxesRunTime.boxToInteger((int)0));
                            }
                            {
                                this.propertyName$1 = string;
                            }
                        });
                        return;
                    }
                    str = string;
                }
                if (!Predef$.MODULE$.augmentString(str).nonEmpty()) return;
                if (str.startsWith("#")) return;
                throw new IllegalArgumentException(new scala.collection.mutable.StringBuilder().append((Object)"line did not match datatype triple syntax: ").append((Object)line).toString());
            }

            private final boolean gd2$1(Quad quad) {
                return quad.datatype() != null;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.resultMap$2 = map;
                this.redirects$2 = map2;
            }
        });
    }

    private void countProperties(File file, Map<String, TemplateStatsBuilder> resultMap$3, Map<String, String> redirects$3) {
        this.eachLine(file, (Function1<String, BoxedUnit>)new Serializable(this, resultMap$3, redirects$3){
            public static final long serialVersionUID;
            private final MappingStatsBuilder $outer;
            private final Map resultMap$3;
            private final Map redirects$3;

            static {
                long l = serialVersionUID = 0L;
            }

            /*
             * Enabled aggressive block sorting
             */
            public final void apply(String line) {
                String str;
                String string = line.trim();
                Option option = Quad$.MODULE$.unapply(string);
                if (option.isEmpty()) {
                    String string2 = string;
                } else {
                    Quad quad = (Quad)option.get();
                    Quad quad2 = quad;
                    if (this.gd3$1(quad2)) {
                        ObjectRef templateName$3 = new ObjectRef((Object)this.$outer.org$dbpedia$extraction$server$stats$MappingStatsBuilder$$cleanUri(quad2.predicate()));
                        String propertyName$2 = this.$outer.org$dbpedia$extraction$server$stats$MappingStatsBuilder$$cleanValue(quad2.value());
                        templateName$3.elem = (String)this.redirects$3.getOrElse((Object)((String)templateName$3.elem), (Function0)new Serializable(this, templateName$3){
                            public static final long serialVersionUID;
                            private final ObjectRef templateName$3;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return (String)this.templateName$3.elem;
                            }
                            {
                                this.templateName$3 = objectRef;
                            }
                        });
                        this.resultMap$3.get((Object)((String)templateName$3.elem)).foreach((Function1)new Serializable(this, propertyName$2){
                            public static final long serialVersionUID;
                            private final String propertyName$2;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final Object apply(TemplateStatsBuilder stats) {
                                return stats.properties().contains((Object)this.propertyName$2) ? stats.properties().put((Object)this.propertyName$2, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)stats.properties().apply((Object)this.propertyName$2)) + 1))) : BoxedUnit.UNIT;
                            }
                            {
                                this.propertyName$2 = string;
                            }
                        });
                        return;
                    }
                    str = string;
                }
                if (!Predef$.MODULE$.augmentString(str).nonEmpty()) return;
                if (str.startsWith("#")) return;
                throw new IllegalArgumentException(new scala.collection.mutable.StringBuilder().append((Object)"line did not match datatype triple syntax: ").append((Object)line).toString());
            }

            private final boolean gd3$1(Quad quad) {
                return quad.datatype() != null;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.resultMap$3 = map;
                this.redirects$3 = map2;
            }
        });
    }

    private String stripUri(String uri) {
        if (uri.startsWith(this.resourceUriPrefix())) {
            return WikiUtil$.MODULE$.wikiDecode(uri.substring(this.resourceUriPrefix().length()));
        }
        throw new Exception(uri);
    }

    public final String org$dbpedia$extraction$server$stats$MappingStatsBuilder$$cleanUri(String uri) {
        return this.cleanName(this.stripUri(this.org$dbpedia$extraction$server$stats$MappingStatsBuilder$$unescape(uri)));
    }

    public final String org$dbpedia$extraction$server$stats$MappingStatsBuilder$$cleanValue(String value) {
        return this.cleanName(this.org$dbpedia$extraction$server$stats$MappingStatsBuilder$$unescape(value));
    }

    private String cleanName(String name) {
        return name.replaceAll("\r|\n", "");
    }

    public final String org$dbpedia$extraction$server$stats$MappingStatsBuilder$$unescape(String value) {
        StringBuilder sb = new StringBuilder();
        int inputLength = value.length();
        block9: for (int offset = 0; offset < inputLength; ++offset) {
            char specialChar;
            StringBuilder stringBuilder;
            char c = value.charAt(offset);
            if (c != '\\') {
                stringBuilder = sb.append(c);
                continue;
            }
            char c2 = specialChar = value.charAt(++offset);
            switch (c2) {
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToCharacter((char)c2));
                }
                case 'r': {
                    stringBuilder = sb.append('\r');
                    continue block9;
                }
                case '\"': {
                    stringBuilder = sb.append('\"');
                    continue block9;
                }
                case '\\': {
                    stringBuilder = sb.append('\\');
                    continue block9;
                }
                case 'U': {
                    String codepoint = value.substring(++offset, offset + 8);
                    int character = Integer.parseInt(codepoint, 16);
                    sb.appendCodePoint(character);
                    offset += 7;
                    stringBuilder = BoxedUnit.UNIT;
                    continue block9;
                }
                case 'u': {
                    String codepoint = value.substring(++offset, offset + 4);
                    char character = (char)Integer.parseInt(codepoint, 16);
                    sb.append(character);
                    offset += 3;
                    stringBuilder = BoxedUnit.UNIT;
                    continue block9;
                }
                case 't': {
                    stringBuilder = sb.append('\t');
                    continue block9;
                }
                case 'n': {
                    stringBuilder = sb.append('\n');
                }
            }
        }
        return sb.toString();
    }

    public MappingStatsBuilder(File statsDir, Language language, boolean pretty) {
        this.language = language;
        this.org$dbpedia$extraction$server$stats$MappingStatsBuilder$$pretty = pretty;
        super(statsDir, language);
        this.logger = Logger.getLogger(this.getClass().getName());
        this.resourceUriPrefix = language.resourceUri().append("");
    }
}

