/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.server.stats;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.dbpedia.extraction.server.stats.IgnoreList$;
import org.dbpedia.extraction.server.util.CollectionReader;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.Set;
import scala.collection.mutable.SetLike;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005]q!B\u0001\u0003\u0011\u000bi\u0011AC%h]>\u0014X\rT5ti*\u00111\u0001B\u0001\u0006gR\fGo\u001d\u0006\u0003\u000b\u0019\taa]3sm\u0016\u0014(BA\u0004\t\u0003))\u0007\u0010\u001e:bGRLwN\u001c\u0006\u0003\u0013)\tq\u0001\u001a2qK\u0012L\u0017MC\u0001\f\u0003\ry'oZ\u0002\u0001!\tqq\"D\u0001\u0003\r\u0015\u0001\"\u0001#\u0002\u0012\u0005)IuM\\8sK2K7\u000f^\n\u0004\u001fIQ\u0002CA\n\u0019\u001b\u0005!\"BA\u000b\u0017\u0003\u0011a\u0017M\\4\u000b\u0003]\tAA[1wC&\u0011\u0011\u0004\u0006\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\u0006C=!\tAI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035Aq\u0001J\bC\u0002\u0013\u0005Q%\u0001\u0007UK6\u0004H.\u0019;fgR\u000bw-F\u0001'!\t\u0019r%\u0003\u0002))\t11\u000b\u001e:j]\u001eDaAK\b!\u0002\u00131\u0013!\u0004+f[Bd\u0017\r^3t)\u0006<\u0007\u0005C\u0004-\u001f\t\u0007I\u0011A\u0013\u0002\u0017Q+W\u000e\u001d7bi\u0016$\u0016m\u001a\u0005\u0007]=\u0001\u000b\u0011\u0002\u0014\u0002\u0019Q+W\u000e\u001d7bi\u0016$\u0016m\u001a\u0011\t\u000fAz!\u0019!C\u0001K\u0005i\u0001K]8qKJ$\u0018.Z:UC\u001eDaAM\b!\u0002\u00131\u0013A\u0004)s_B,'\u000f^5fgR\u000bw\r\t\u0004\u0005!\t\u0001AgE\u00024%iA\u0001BN\u001a\u0003\u0002\u0003\u0006IaN\u0001\u0005M&dW\r\u0005\u00029w5\t\u0011H\u0003\u0002;-\u0005\u0011\u0011n\\\u0005\u0003ye\u0012AAR5mK\"Aah\rB\u0001B\u0003%q(\u0001\u0004va\u0012\fG/\u001a\t\u00047\u0001\u0013\u0015BA!\u001d\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0002\u001c\u0007&\u0011A\t\b\u0002\u0005+:LG\u000fC\u0003\"g\u0011\u0005a\tF\u0002H\u0011&\u0003\"AD\u001a\t\u000bY*\u0005\u0019A\u001c\t\u000by*\u0005\u0019A \t\u000f-\u001b$\u0019!C\u0005\u0019\u0006IA/Z7qY\u0006$Xm]\u000b\u0002\u001bB\u0019ajU+\u000e\u0003=S!\u0001U)\u0002\u000f5,H/\u00192mK*\u0011!\u000bH\u0001\u000bG>dG.Z2uS>t\u0017B\u0001+P\u00055a\u0015N\\6fI\"\u000b7\u000f[*fiB\u0011a+\u0017\b\u00037]K!\u0001\u0017\u000f\u0002\rA\u0013X\rZ3g\u0013\tA#L\u0003\u0002Y9!1Al\rQ\u0001\n5\u000b!\u0002^3na2\fG/Z:!\u0011\u001dq6G1A\u0005\n}\u000b!\u0002\u001d:pa\u0016\u0014H/[3t+\u0005\u0001\u0007\u0003\u0002(b+\u000eL!AY(\u0003\u001b1Kgn[3e\u0011\u0006\u001c\b.T1q!\rqE-V\u0005\u0003K>\u00131aU3u\u0011\u001997\u0007)A\u0005A\u0006Y\u0001O]8qKJ$\u0018.Z:!\u0011\u0019I7\u0007\"\u0001\u0003U\u0006!1/\u0019<f)\u0005\u0011\u0005\"\u000274\t\u0003i\u0017!E5t)\u0016l\u0007\u000f\\1uK&;gn\u001c:fIR\u0011a.\u001d\t\u00037=L!\u0001\u001d\u000f\u0003\u000f\t{w\u000e\\3b]\")!o\u001ba\u0001+\u0006AA/Z7qY\u0006$X\rC\u0003ug\u0011\u0005Q/A\tjgB\u0013x\u000e]3sifLuM\\8sK\u0012$2A\u001c<x\u0011\u0015\u00118\u000f1\u0001V\u0011\u0015A8\u000f1\u0001V\u0003!\u0001(o\u001c9feRL\b\"\u0002>4\t\u0003Y\u0018aC1eIR+W\u000e\u001d7bi\u0016$\"A\u0011?\t\u000bIL\b\u0019A+\t\u000by\u001cD\u0011A@\u0002\u001dI,Wn\u001c<f)\u0016l\u0007\u000f\\1uKR\u0019!)!\u0001\t\u000bIl\b\u0019A+\t\u000f\u0005\u00151\u0007\"\u0001\u0002\b\u0005Y\u0011\r\u001a3Qe>\u0004XM\u001d;z)\u0015\u0011\u0015\u0011BA\u0006\u0011\u0019\u0011\u00181\u0001a\u0001+\"1\u00010a\u0001A\u0002UCq!a\u00044\t\u0003\t\t\"\u0001\bsK6|g/\u001a)s_B,'\u000f^=\u0015\u000b\t\u000b\u0019\"!\u0006\t\rI\fi\u00011\u0001V\u0011\u0019A\u0018Q\u0002a\u0001+\u0002")
public class IgnoreList
implements ScalaObject {
    private final File file;
    private final Function0<BoxedUnit> update;
    private final LinkedHashSet<String> templates;
    private final LinkedHashMap<String, Set<String>> properties;

    public static final String PropertiesTag() {
        return IgnoreList$.MODULE$.PropertiesTag();
    }

    public static final String TemplateTag() {
        return IgnoreList$.MODULE$.TemplateTag();
    }

    public static final String TemplatesTag() {
        return IgnoreList$.MODULE$.TemplatesTag();
    }

    private LinkedHashSet<String> templates() {
        return this.templates;
    }

    private LinkedHashMap<String, Set<String>> properties() {
        return this.properties;
    }

    public void save() {
        this.update.apply$mcV$sp();
        FileOutputStream out = new FileOutputStream(this.file);
        try {
            OutputStreamWriter writer$1 = new OutputStreamWriter((OutputStream)out, "UTF-8");
            writer$1.write(new StringBuilder().append((Object)IgnoreList$.MODULE$.TemplatesTag()).append((Object)BoxesRunTime.boxToInteger((int)this.templates().size())).append((Object)BoxesRunTime.boxToCharacter((char)'\n')).toString());
            this.templates().foreach((Function1)new Serializable(this, writer$1){
                public static final long serialVersionUID;
                private final OutputStreamWriter writer$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(String template) {
                    this.writer$1.write(new StringBuilder().append((Object)template).append((Object)BoxesRunTime.boxToCharacter((char)'\n')).toString());
                }
                {
                    this.writer$1 = outputStreamWriter;
                }
            });
            writer$1.write(10);
            writer$1.write(new StringBuilder().append((Object)IgnoreList$.MODULE$.PropertiesTag()).append((Object)BoxesRunTime.boxToInteger((int)this.properties().size())).append((Object)BoxesRunTime.boxToCharacter((char)'\n')).toString());
            writer$1.write(10);
            ((LinkedHashMap)this.properties().filter((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Tuple2<String, Set<String>> tuple2) {
                    Tuple2<String, Set<String>> tuple22 = tuple2;
                    return tuple22 != null;
                }
            })).foreach((Function1)new Serializable(this, writer$1){
                public static final long serialVersionUID;
                public final OutputStreamWriter writer$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Tuple2<String, Set<String>> tuple2) {
                    Tuple2<String, Set<String>> tuple22 = tuple2;
                    if (tuple22 != null) {
                        Set set;
                        Set props = set = (Set)tuple22._2();
                        this.writer$1.write(new StringBuilder().append((Object)IgnoreList$.MODULE$.TemplateTag()).append(tuple22._1()).append((Object)"\n").toString());
                        this.writer$1.write(new StringBuilder().append((Object)IgnoreList$.MODULE$.PropertiesTag()).append((Object)BoxesRunTime.boxToInteger((int)props.size())).append((Object)"\n").toString());
                        props.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID;
                            private final $anonfun$save$3 $outer;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final void apply(String prop) {
                                this.$outer.writer$1.write(new StringBuilder().append((Object)prop).append((Object)BoxesRunTime.boxToCharacter((char)'\n')).toString());
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.writer$1.write(10);
                        return;
                    }
                    throw new MatchError(tuple22);
                }
                {
                    this.writer$1 = outputStreamWriter;
                }
            });
            writer$1.close();
            return;
        }
        finally {
            out.close();
        }
    }

    public boolean isTemplateIgnored(String template) {
        IgnoreList ignoreList = this;
        synchronized (ignoreList) {
            Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.templates().contains((Object)template));
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }
    }

    public boolean isPropertyIgnored(String template, String property) {
        IgnoreList ignoreList = this;
        synchronized (ignoreList) {
            Boolean bl = BoxesRunTime.boxToBoolean((this.properties().contains((Object)template) && ((scala.collection.SetLike)this.properties().apply((Object)template)).contains((Object)property) ? 1 : 0) != 0);
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }
    }

    public void addTemplate(String template) {
        IgnoreList ignoreList = this;
        synchronized (ignoreList) {
            BoxedUnit boxedUnit;
            if (this.templates().add((Object)template)) {
                this.save();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void removeTemplate(String template) {
        IgnoreList ignoreList = this;
        synchronized (ignoreList) {
            BoxedUnit boxedUnit;
            if (this.templates().remove((Object)template)) {
                this.save();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void addProperty(String template, String property) {
        IgnoreList ignoreList = this;
        synchronized (ignoreList) {
            BoxedUnit boxedUnit;
            if (((SetLike)this.properties().getOrElseUpdate((Object)template, (Function0)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final HashSet<String> apply() {
                    return new HashSet();
                }
            })).add((Object)property)) {
                this.save();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void removeProperty(String template, String property) {
        IgnoreList ignoreList = this;
        synchronized (ignoreList) {
            BoxedUnit boxedUnit;
            if (this.properties().contains((Object)template) && ((SetLike)this.properties().apply((Object)template)).remove((Object)property)) {
                this.save();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public IgnoreList(File file, Function0<BoxedUnit> update) {
        BufferedSource source;
        this.file = file;
        this.update = update;
        this.templates = new LinkedHashSet();
        this.properties = new LinkedHashMap();
        if (file.exists()) {
            source = Source$.MODULE$.fromFile(file, "UTF-8");
            CollectionReader reader = new CollectionReader((Iterator<String>)source.getLines());
            int templateCount = reader.readCount(IgnoreList$.MODULE$.TemplatesTag());
            for (int templateIndex = 0; templateIndex < templateCount; ++templateIndex) {
                this.templates().$plus$eq((Object)reader.readLine());
            }
            reader.readEmpty();
            int propertiesCount = reader.readCount(IgnoreList$.MODULE$.PropertiesTag());
            reader.readEmpty();
            for (int propertiesIndex = 0; propertiesIndex < propertiesCount; ++propertiesIndex) {
                String template = reader.readTag(IgnoreList$.MODULE$.TemplateTag());
                Set props = (Set)this.properties().getOrElseUpdate((Object)template, (Function0)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final LinkedHashSet<String> apply() {
                        return new LinkedHashSet();
                    }
                });
                int propsCount = reader.readCount(IgnoreList$.MODULE$.PropertiesTag());
                for (int propsIndex = 0; propsIndex < propsCount; ++propsIndex) {
                    props.$plus$eq((Object)reader.readLine());
                }
                reader.readEmpty();
            }
            reader.readEnd();
        }
        return;
        finally {
            source.close();
        }
    }
}

