/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.server.stats;

import java.io.File;
import java.util.logging.Logger;
import org.dbpedia.extraction.destinations.DBpediaDatasets$;
import org.dbpedia.extraction.destinations.Dataset;
import org.dbpedia.extraction.server.stats.MappingStatsBuilder;
import org.dbpedia.extraction.server.stats.MappingStatsManager;
import org.dbpedia.extraction.util.Finder;
import org.dbpedia.extraction.util.Language;
import org.dbpedia.extraction.util.Language$;
import org.dbpedia.extraction.util.RichFile;
import org.dbpedia.extraction.util.RichFile$;
import org.dbpedia.extraction.util.StringUtils$;
import org.dbpedia.extraction.wikiparser.Namespace$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;

public final class CreateMappingStats$
implements ScalaObject {
    public static final CreateMappingStats$ MODULE$;
    private final Logger logger;

    static {
        new CreateMappingStats$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void main(String[] args) {
        Predef$.MODULE$.require(args != null && args.length >= 3, (Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "need at least three args: input dir, output dir, pretty-printing flag. may be followed by list of language codes.";
            }
        });
        File inputDir$1 = new File(args[0]);
        File statsDir$1 = new File(args[1]);
        boolean pretty$1 = Predef$.MODULE$.augmentString(args[2]).toBoolean();
        Seq languages2 = (Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])args).drop(3)).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ArrayOps<Language> apply(String arg) {
                return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])arg.split("[,\\s]")).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(String lang) {
                        return Predef$.MODULE$.augmentString(lang).nonEmpty();
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Language apply(String lang) {
                        return Language$.MODULE$.apply(lang);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(Language.class))));
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        if (languages2.isEmpty()) {
            languages2 = Namespace$.MODULE$.mappings().keySet().toSeq();
        }
        ((IterableLike)languages2.sorted(Language$.MODULE$.wikiCodeOrdering())).foreach((Function1)new Serializable(inputDir$1, statsDir$1, pretty$1){
            public static final long serialVersionUID;
            private final File inputDir$1;
            private final File statsDir$1;
            private final boolean pretty$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Language language) {
                long millis = System.currentTimeMillis();
                CreateMappingStats$.MODULE$.logger().info(new StringBuilder().append((Object)"creating statistics for ").append((Object)language.wikiCode()).toString());
                Finder finder$1 = new Finder((Object)this.inputDir$1, language, (Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final RichFile apply(File file) {
                        return RichFile$.MODULE$.wrapFile(file);
                    }
                });
                String date$1 = (String)finder$1.dates("extraction-complete", finder$1.dates$default$2()).last();
                File redirects = this.inputFile$1(DBpediaDatasets$.MODULE$.Redirects(), finder$1, date$1);
                File infoboxProperties = this.inputFile$1(DBpediaDatasets$.MODULE$.InfoboxProperties(), finder$1, date$1);
                File templateParameters = this.inputFile$1(DBpediaDatasets$.MODULE$.TemplateVariables(), finder$1, date$1);
                File infoboxTest = this.inputFile$1(DBpediaDatasets$.MODULE$.InfoboxTest(), finder$1, date$1);
                MappingStatsBuilder builder = new MappingStatsBuilder(this.statsDir$1, language, this.pretty$1);
                builder.buildStats(redirects, infoboxProperties, templateParameters, infoboxTest);
                new MappingStatsManager(this.statsDir$1, language);
                CreateMappingStats$.MODULE$.logger().info(new StringBuilder().append((Object)"created statistics for ").append((Object)language.wikiCode()).append((Object)" in ").append((Object)StringUtils$.MODULE$.prettyMillis(System.currentTimeMillis() - millis)).toString());
            }

            private final File inputFile$1(Dataset dataset, Finder finder, String string) {
                return (File)finder.file(string, new StringBuilder().append((Object)dataset.name().replace('_', '-')).append((Object)".ttl").toString());
            }
            {
                this.inputDir$1 = file;
                this.statsDir$1 = file2;
                this.pretty$1 = bl;
            }
        });
    }

    private CreateMappingStats$() {
        MODULE$ = this;
        this.logger = Logger.getLogger(this.getClass().getName());
    }
}

