/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.server.resources.ontology;

import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.dbpedia.extraction.server.Server$;
import org.dbpedia.extraction.server.util.PageUtils$;
import org.dbpedia.extraction.sources.WikiPage;
import org.dbpedia.extraction.sources.XMLSource$;
import org.dbpedia.extraction.util.Language$;
import org.dbpedia.extraction.wikiparser.PageNode;
import org.dbpedia.extraction.wikiparser.WikiTitle$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassManifest$;
import scala.reflect.ScalaSignature;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.PrefixedAttribute;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

@Path(value="/ontology/pages/")
@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001B\u0001\u0003\u0001=\u0011Q\u0001U1hKNT!a\u0001\u0003\u0002\u0011=tGo\u001c7pOfT!!\u0002\u0004\u0002\u0013I,7o\\;sG\u0016\u001c(BA\u0004\t\u0003\u0019\u0019XM\u001d<fe*\u0011\u0011BC\u0001\u000bKb$(/Y2uS>t'BA\u0006\r\u0003\u001d!'\r]3eS\u0006T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001AA\u0002CA\t\u0017\u001b\u0005\u0011\"BA\n\u0015\u0003\u0011a\u0017M\\4\u000b\u0003U\tAA[1wC&\u0011qC\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\u0006?\u0001!\t\u0001I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\u0002\"A\t\u0001\u000e\u0003\tAq\u0001\n\u0001C\u0002\u0013\u0005Q%\u0001\u0004m_\u001e<WM]\u000b\u0002MA\u0011q\u0005L\u0007\u0002Q)\u0011\u0011FK\u0001\bY><w-\u001b8h\u0015\tYC#\u0001\u0003vi&d\u0017BA\u0017)\u0005\u0019aunZ4fe\"1q\u0006\u0001Q\u0001\n\u0019\nq\u0001\\8hO\u0016\u0014\b\u0005C\u00032\u0001\u0011\u0005!'\u0001\u0005hKR\u0004\u0016mZ3t+\u0005\u0019\u0004C\u0001\u001b8\u001b\u0005)$B\u0001\u001c\u001b\u0003\rAX\u000e\\\u0005\u0003qU\u0012A!\u00127f[\"\"\u0001G\u000f#F!\tY$)D\u0001=\u0015\tid(\u0001\u0002sg*\u0011q\bQ\u0001\u0003oNT\u0011!Q\u0001\u0006U\u00064\u0018\r_\u0005\u0003\u0007r\u0012\u0001\u0002\u0015:pIV\u001cWm]\u0001\u0006m\u0006dW/\u001a\u0017\u0002\r\u0006\nq)A\u000bbaBd\u0017nY1uS>tw\u0006\u001f5u[2\\\u00030\u001c7)\u0005AJ\u0005CA\u001eK\u0013\tYEHA\u0002H\u000bRCQ!\u0014\u0001\u0005\u00029\u000bqaZ3u!\u0006<W\r\u0006\u00024\u001f\")\u0001\u000b\u0014a\u0001#\u0006)A/\u001b;mKB\u0011!+\u0016\b\u00033MK!\u0001\u0016\u000e\u0002\rA\u0013X\rZ3g\u0013\t1vK\u0001\u0004TiJLgn\u001a\u0006\u0003)jA#aT-\u0011\u0005mR\u0016BA.=\u0005\u001d)enY8eK\u0012DCaT/EAB\u00111HX\u0005\u0003?r\u0012\u0011\u0002U1uQB\u000b'/Y7\"\u0003ACC\u0001\u0014\u001eEE2\n1-I\u0001e\u0003=\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c80q6d\u0007\u0006\u0002'g\t&\u0004\"aO4\n\u0005!d$\u0001\u0002)bi\"\f\u0013A[\u0001\t_m$\u0018\u000e\u001e7f{\"\u0012A*\u0013\u0005\u0006[\u0002!\tA\\\u0001\baV$\b+Y4f)\ry'/\u001e\t\u00033AL!!\u001d\u000e\u0003\tUs\u0017\u000e\u001e\u0005\u0006!2\u0004\r!\u0015\u0015\u0003efCCA]/EA\")a\u000f\u001ca\u0001g\u00059\u0001/Y4f16c\u0005\u0006\u00027y\tn\u0004\"aO=\n\u0005id$\u0001C\"p]N,X.Z:-\u0003\rDC\u0001\u001c4ES\"\u0012AN \t\u0003w}L1!!\u0001=\u0005\r\u0001V\u000b\u0016\u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u0003)!W\r\\3uKB\u000bw-\u001a\u000b\u0004_\u0006%\u0001B\u0002)\u0002\u0004\u0001\u0007\u0011\u000bK\u0002\u0002\neCS!!\u0003^\t\u0002Dc!a\u0001y\t\u0006EA&A2)\u000b\u0005\ra\rR5)\t\u0005\r\u0011q\u0003\t\u0004w\u0005e\u0011bAA\u000ey\t1A)\u0012'F)\u0016CS\u0001\u00014E\u0003?\t#!!\t\u0002!=zg\u000e^8m_\u001eLx\u0006]1hKN|\u0003")
public class Pages
implements ScalaObject {
    private final Logger logger = Logger.getLogger(Pages.class.getName());

    public Logger logger() {
        return this.logger;
    }

    @GET
    @Produces(value={"application/xhtml+xml"})
    public Elem getPages() {
        TopScope$ $tmpscope = Predef$.MODULE$.$scope();
        TopScope$ $scope$1 = $tmpscope = new NamespaceBinding(null, "http://www.w3.org/1999/xhtml", (NamespaceBinding)$tmpscope);
        Null$ $md = Null$.MODULE$;
        $md = new PrefixedAttribute("xml", "lang", (Seq)new Text("en"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n            "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("content", (Seq)new Text("text/html; charset=UTF-8"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("http-equiv", (Seq)new Text("Content-Type"), (MetaData)$md2);
        $buf2.$amp$plus((Object)new Elem(null, "meta", (MetaData)$md2, (NamespaceBinding)$scope$1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf2.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "head", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope$1, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("Ontology pages"));
        $buf3.$amp$plus((Object)new Elem(null, "h2", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope$1, (Seq)$buf4));
        $buf3.$amp$plus((Object)new Text("\n            "));
        $buf3.$amp$plus(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Server$.MODULE$.instance().extractor().ontologyPages().values().toArray(ClassManifest$.MODULE$.classType(PageNode.class))).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(PageNode pageNode) {
                return pageNode.title().decodedWithNamespace();
            }
        }, (Ordering)Ordering.String$.MODULE$)).map((Function1)new Serializable(this, (NamespaceBinding)$scope$1){
            public static final long serialVersionUID;
            private final NamespaceBinding $scope$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final NodeSeq apply(PageNode pageNode) {
                return (NodeSeq)PageUtils$.MODULE$.relativeLink(pageNode).$plus$plus((GenTraversableOnce)new Elem(null, "br", (MetaData)Null$.MODULE$, this.$scope$1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])), NodeSeq$.MODULE$.canBuildFrom());
            }
            {
                this.$scope$1 = namespaceBinding;
            }
        }, Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(NodeSeq.class))));
        $buf3.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "body", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope$1, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n        "));
        return new Elem(null, "html", (MetaData)$md, (NamespaceBinding)$scope$1, (Seq)$buf);
    }

    @GET
    @Path(value="/{title}")
    @Produces(value={"application/xml"})
    public Elem getPage(@PathParam(value="title") @Encoded String title) {
        this.logger().info(new StringBuilder().append((Object)"Get ontology page: ").append((Object)title).toString());
        return ((PageNode)Server$.MODULE$.instance().extractor().ontologyPages().apply((Object)WikiTitle$.MODULE$.parse(title, Language$.MODULE$.Mappings()))).toDumpXML();
    }

    @PUT
    @Path(value="/{title}")
    @Consumes(value={"application/xml"})
    public void putPage(@PathParam(value="title") @Encoded String title$1, Elem pageXML) {
        try {
            XMLSource$.MODULE$.fromXML(pageXML, Language$.MODULE$.Mappings()).foreach((Function1)new Serializable(this, title$1){
                public static final long serialVersionUID;
                private final Pages $outer;
                private final String title$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(WikiPage page) {
                    Server$.MODULE$.instance().extractor().updateOntologyPage(page);
                    this.$outer.logger().info(new StringBuilder().append((Object)"Updated ontology page: ").append((Object)this.title$1).toString());
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.title$1 = string;
                }
            });
            return;
        }
        catch (Exception exception) {
            this.logger().warning(new StringBuilder().append((Object)"Error updating ontology page: ").append((Object)title$1).append((Object)". Details: ").append((Object)exception.getMessage()).toString());
            throw exception;
        }
    }

    @DELETE
    @Path(value="/{title}")
    @Consumes(value={"application/xml"})
    public void deletePage(@PathParam(value="title") @Encoded String title) {
        Server$.MODULE$.instance().extractor().removeOntologyPage(WikiTitle$.MODULE$.parse(title, Language$.MODULE$.Mappings()));
        this.logger().info(new StringBuilder().append((Object)"Deleted ontology page: ").append((Object)title).toString());
    }
}

