/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.server.resources;

import java.io.StringWriter;
import java.net.URL;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.dbpedia.extraction.destinations.Destination;
import org.dbpedia.extraction.destinations.WriterDestination;
import org.dbpedia.extraction.destinations.formatters.Formatter;
import org.dbpedia.extraction.destinations.formatters.TerseFormatter;
import org.dbpedia.extraction.destinations.formatters.TerseFormatter$;
import org.dbpedia.extraction.server.Server$;
import org.dbpedia.extraction.server.resources.Extraction$;
import org.dbpedia.extraction.server.resources.stylesheets.TriX$;
import org.dbpedia.extraction.sources.Source;
import org.dbpedia.extraction.sources.WikiSource$;
import org.dbpedia.extraction.sources.XMLSource$;
import org.dbpedia.extraction.util.Language;
import org.dbpedia.extraction.util.Language$;
import org.dbpedia.extraction.wikiparser.WikiTitle;
import org.dbpedia.extraction.wikiparser.WikiTitle$;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.PrefixedAttribute;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/extraction/{lang}/")
@ScalaSignature(bytes="\u0006\u0001\u0005}s!B\u0001\u0003\u0011\u000bi\u0011AC#yiJ\f7\r^5p]*\u00111\u0001B\u0001\ne\u0016\u001cx.\u001e:dKNT!!\u0002\u0004\u0002\rM,'O^3s\u0015\t9\u0001\"\u0001\u0006fqR\u0014\u0018m\u0019;j_:T!!\u0003\u0006\u0002\u000f\u0011\u0014\u0007/\u001a3jC*\t1\"A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u000f\u001f5\t!AB\u0003\u0011\u0005!\u0015\u0011C\u0001\u0006FqR\u0014\u0018m\u0019;j_:\u001c2a\u0004\n\u001b!\t\u0019\u0002$D\u0001\u0015\u0015\t)b#\u0001\u0003mC:<'\"A\f\u0002\t)\fg/Y\u0005\u00033Q\u0011aa\u00142kK\u000e$\bCA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"aC*dC2\fwJ\u00196fGRDQ!I\b\u0005\u0002\t\na\u0001P5oSRtD#A\u0007\t\u000f\u0011z!\u0019!C\u0005K\u00051An\\4hKJ,\u0012A\n\t\u0003O1j\u0011\u0001\u000b\u0006\u0003S)\nq\u0001\\8hO&twM\u0003\u0002,-\u0005!Q\u000f^5m\u0013\ti\u0003F\u0001\u0004M_\u001e<WM\u001d\u0005\u0007_=\u0001\u000b\u0011\u0002\u0014\u0002\u000f1|wmZ3sA!9\u0011g\u0004b\u0001\n\u0003\u0011\u0014!\u00027j]\u0016\u001cX#A\u001a\u0011\tQ:$H\u000f\b\u00037UJ!A\u000e\u000f\u0002\rA\u0013X\rZ3g\u0013\tA\u0014HA\u0002NCBT!A\u000e\u000f\u0011\u0005QZ\u0014B\u0001\u001f:\u0005\u0019\u0019FO]5oO\"1ah\u0004Q\u0001\nM\na\u0001\\5oKN\u0004c\u0001\u0002\t\u0003\u0001\u0001\u001b2a\u0010\n\u001b\u0011!\u0011uH!A!\u0002\u0013Q\u0014\u0001\u00037b]\u001e\u001cu\u000eZ3)\t\u0005#ej\u0014\t\u0003\u000b2k\u0011A\u0012\u0006\u0003\u000f\"\u000b!A]:\u000b\u0005%S\u0015AA<t\u0015\u0005Y\u0015!\u00026bm\u0006D\u0018BA'G\u0005%\u0001\u0016\r\u001e5QCJ\fW.A\u0003wC2,X-I\u0001\u0016\u0011\u0015\ts\b\"\u0001R)\t\u00116\u000b\u0005\u0002\u000f\u007f!)!\t\u0015a\u0001u!\"1\u000b\u0012(P\u0011\u001d1vH1A\u0005\n]\u000b\u0001\u0002\\1oOV\fw-Z\u000b\u00021B\u0011\u0011lW\u0007\u00025*\u00111FB\u0005\u00039j\u0013\u0001\u0002T1oOV\fw-\u001a\u0005\u0007=~\u0002\u000b\u0011\u0002-\u0002\u00131\fgnZ;bO\u0016\u0004\u0003\"\u00021@\t\u0013\t\u0017\u0001C4fiRKG\u000f\\3\u0016\u0003iBQaY \u0005\u0002\u0011\f1aZ3u+\u0005)\u0007C\u00014j\u001b\u00059'B\u00015\u001d\u0003\rAX\u000e\\\u0005\u0003U\u001e\u0014A!\u00127f[\"\"!\r\u001c(p!\t)U.\u0003\u0002o\r\nA\u0001K]8ek\u000e,7\u000fL\u0001qC\u0005\t\u0018!F1qa2L7-\u0019;j_:|\u0003\u0010\u001b;nY.BX\u000e\u001c\u0015\u0003EN\u0004\"!\u0012;\n\u0005U4%aA$F)\")qo\u0010C\u0001q\u00069Q\r\u001f;sC\u000e$HC\u0002\u001ez\u0003\u0003\tY\u0002C\u0003{m\u0002\u0007!(A\u0003uSRdW\r\u000b\u0003zy:{\bCA#~\u0013\tqhI\u0001\u0006Rk\u0016\u0014\u0018\u0010U1sC6\f\u0013A\u001f\u0005\b\u0003\u00071\b\u0019AA\u0003\u0003\u0015\u0011XM^5e!\rY\u0012qA\u0005\u0004\u0003\u0013a\"\u0001\u0002'p]\u001eDs!!\u0001\u0002\u000e9\u000b\u0019\u0002E\u0002F\u0003\u001fI1!!\u0005G\u00051!UMZ1vYR4\u0016\r\\;fC\t\t)\"\u0001\u0002.c!2\u0011\u0011\u0001?O\u00033\t#!a\u0001\t\r\u0005ua\u000f1\u0001;\u0003\u00191wN]7bi\"2\u00111\u0004?O\u0003C\t#!!\b)\u000bYdg*!\n-\u0005\u0005\u001d\u0012EAA\u0015\u0003=\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c80q6d\u0007F\u0002<\u0002.9\u000b\u0019\u0004E\u0002F\u0003_I1!!\rG\u0005\u0011\u0001\u0016\r\u001e5\"\u0003]D#A^:\t\r]|D\u0011AA\u001d)\u0011\tY$a\u0010\u0011\u0007M\ti$\u0003\u0002=)!1\u0001.a\u000eA\u0002\u0015Dc!a\u000em\u001d\u0006\rCFAA\u0014Q\u001d\t9$a\u0012O\u0003\u001b\u00022!RA%\u0013\r\tYE\u0012\u0002\t\u0007>t7/^7fg2\u0012\u0011q\u0005\u0015\b\u0003o\tiCTA\u001aQ\u0011\t9$a\u0015\u0011\u0007\u0015\u000b)&C\u0002\u0002X\u0019\u0013A\u0001U(T)\"2q(!\fO\u00037\n#!!\u0018\u0002'=*\u0007\u0010\u001e:bGRLwN\\\u0018|Y\u0006tw-`\u0018")
public class Extraction
implements ScalaObject {
    @PathParam(value="lang")
    public final String org$dbpedia$extraction$server$resources$Extraction$$langCode;
    private final Language language;

    public static final Map<String, String> lines() {
        return Extraction$.MODULE$.lines();
    }

    private Language language() {
        return this.language;
    }

    private String getTitle() {
        return (String)Extraction$.MODULE$.lines().getOrElse((Object)this.org$dbpedia$extraction$server$resources$Extraction$$langCode, (Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Berlin";
            }
        });
    }

    @GET
    @Produces(value={"application/xhtml+xml"})
    public Elem get() {
        TopScope$ $tmpscope = Predef$.MODULE$.$scope();
        TopScope$ $scope = $tmpscope = new NamespaceBinding(null, "http://www.w3.org/1999/xhtml", (NamespaceBinding)$tmpscope);
        Null$ $md = Null$.MODULE$;
        $md = new PrefixedAttribute("xml", "lang", (Seq)new Text("en"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n         "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n           "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("content", (Seq)new Text("text/html; charset=UTF-8"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("http-equiv", (Seq)new Text("Content-Type"), (MetaData)$md2);
        $buf2.$amp$plus((Object)new Elem(null, "meta", (MetaData)$md2, (NamespaceBinding)$scope, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf2.$amp$plus((Object)new Text("\n         "));
        $buf.$amp$plus((Object)new Elem(null, "head", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n         "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n           "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("Extract a page"));
        $buf3.$amp$plus((Object)new Elem(null, "h2", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, (Seq)$buf4));
        $buf3.$amp$plus((Object)new Text("\n           "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("action", (Seq)new Text("extract"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("method", (Seq)new Text("get"), (MetaData)$md3);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n             Page title"));
        $buf5.$amp$plus((Object)new Elem(null, "br", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf5.$amp$plus((Object)new Text("\n             "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("value", this.getTitle(), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("type", (Seq)new Text("text"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("name", (Seq)new Text("title"), (MetaData)$md4);
        $buf5.$amp$plus((Object)new Elem(null, "input", (MetaData)$md4, (NamespaceBinding)$scope, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf5.$amp$plus((Object)new Elem(null, "br", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf5.$amp$plus((Object)new Text("\n             Revision ID (optional, overrides title)"));
        $buf5.$amp$plus((Object)new Elem(null, "br", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf5.$amp$plus((Object)new Text("\n             "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("type", (Seq)new Text("text"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("name", (Seq)new Text("revid"), (MetaData)$md5);
        $buf5.$amp$plus((Object)new Elem(null, "input", (MetaData)$md5, (NamespaceBinding)$scope, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf5.$amp$plus((Object)new Elem(null, "br", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf5.$amp$plus((Object)new Text("\n             Output format"));
        $buf5.$amp$plus((Object)new Elem(null, "br", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf5.$amp$plus((Object)new Text("\n             "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("name", (Seq)new Text("format"), (MetaData)$md6);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n               "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("value", (Seq)new Text("trix"), (MetaData)$md7);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("Trix"));
        $buf6.$amp$plus((Object)new Elem(null, "option", (MetaData)$md7, (NamespaceBinding)$scope, (Seq)$buf7));
        $buf6.$amp$plus((Object)new Text("\n               "));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("value", (Seq)new Text("turtle-triples"), (MetaData)$md8);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("Turtle-Triples"));
        $buf6.$amp$plus((Object)new Elem(null, "option", (MetaData)$md8, (NamespaceBinding)$scope, (Seq)$buf8));
        $buf6.$amp$plus((Object)new Text("\n               "));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("value", (Seq)new Text("turtle-quads"), (MetaData)$md9);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("Turtle-Quads"));
        $buf6.$amp$plus((Object)new Elem(null, "option", (MetaData)$md9, (NamespaceBinding)$scope, (Seq)$buf9));
        $buf6.$amp$plus((Object)new Text("\n               "));
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("value", (Seq)new Text("n-triples"), (MetaData)$md10);
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("N-Triples"));
        $buf6.$amp$plus((Object)new Elem(null, "option", (MetaData)$md10, (NamespaceBinding)$scope, (Seq)$buf10));
        $buf6.$amp$plus((Object)new Text("\n               "));
        Null$ $md11 = Null$.MODULE$;
        $md11 = new UnprefixedAttribute("value", (Seq)new Text("n-quads"), (MetaData)$md11);
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("N-Quads"));
        $buf6.$amp$plus((Object)new Elem(null, "option", (MetaData)$md11, (NamespaceBinding)$scope, (Seq)$buf11));
        $buf6.$amp$plus((Object)new Text("\n             "));
        $buf5.$amp$plus((Object)new Elem(null, "select", (MetaData)$md6, (NamespaceBinding)$scope, (Seq)$buf6));
        $buf5.$amp$plus((Object)new Elem(null, "br", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf5.$amp$plus((Object)new Text("\n             "));
        Null$ $md12 = Null$.MODULE$;
        $md12 = new UnprefixedAttribute("value", (Seq)new Text("Extract"), (MetaData)$md12);
        $md12 = new UnprefixedAttribute("type", (Seq)new Text("submit"), (MetaData)$md12);
        $buf5.$amp$plus((Object)new Elem(null, "input", (MetaData)$md12, (NamespaceBinding)$scope, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf5.$amp$plus((Object)new Text("\n           "));
        $buf3.$amp$plus((Object)new Elem(null, "form", (MetaData)$md3, (NamespaceBinding)$scope, (Seq)$buf5));
        $buf3.$amp$plus((Object)new Text("\n         "));
        $buf.$amp$plus((Object)new Elem(null, "body", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n       "));
        return new Elem(null, "html", (MetaData)$md, (NamespaceBinding)$scope, (Seq)$buf);
    }

    @GET
    @Path(value="extract")
    @Produces(value={"application/xml"})
    public String extract(@QueryParam(value="title") String title, @QueryParam(value="revid") @DefaultValue(value="-1") long revid, @QueryParam(value="format") String format) {
        Object object;
        String string;
        if (title == null && revid < 0L) {
            throw new WebApplicationException((Throwable)new Exception("title or revid must be given"), Response.Status.NOT_FOUND);
        }
        StringWriter writer$1 = new StringWriter();
        String string2 = string = format;
        String string3 = "turtle-triples";
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            object = new TerseFormatter(false, true, TerseFormatter$.MODULE$.init$default$3());
        } else {
            String string4 = string;
            String string5 = "turtle-quads";
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                object = new TerseFormatter(true, true, TerseFormatter$.MODULE$.init$default$3());
            } else {
                String string6 = string;
                String string7 = "n-triples";
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    object = new TerseFormatter(false, false, TerseFormatter$.MODULE$.init$default$3());
                } else {
                    String string8 = string;
                    String string9 = "n-quads";
                    object = !(string8 != null ? !string8.equals(string9) : string9 != null) ? new TerseFormatter(true, false, TerseFormatter$.MODULE$.init$default$3()) : TriX$.MODULE$.writeHeader(writer$1, 2);
                }
            }
        }
        TerseFormatter formatter = object;
        Source source = revid >= 0L ? WikiSource$.MODULE$.fromRevisionIDs((Iterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{revid})), new URL(this.language().apiUri()), this.language()) : WikiSource$.MODULE$.fromTitles((Iterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WikiTitle[]{WikiTitle$.MODULE$.parse(title, this.language())})), new URL(this.language().apiUri()), this.language());
        WriterDestination destination = new WriterDestination((Function0)new Serializable(this, writer$1){
            public static final long serialVersionUID;
            private final StringWriter writer$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final StringWriter apply() {
                return this.writer$1;
            }
            {
                this.writer$1 = stringWriter;
            }
        }, (Formatter)formatter);
        Server$.MODULE$.instance().extractor().extract(source, (Destination)destination, this.language());
        return writer$1.toString();
    }

    @POST
    @Path(value="extract")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public String extract(Elem xml) {
        StringWriter writer$2 = new StringWriter();
        Formatter formatter = TriX$.MODULE$.writeHeader(writer$2, 2);
        Source source = XMLSource$.MODULE$.fromXML(xml, this.language());
        WriterDestination destination = new WriterDestination((Function0)new Serializable(this, writer$2){
            public static final long serialVersionUID;
            private final StringWriter writer$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final StringWriter apply() {
                return this.writer$2;
            }
            {
                this.writer$2 = stringWriter;
            }
        }, formatter);
        Server$.MODULE$.instance().extractor().extract(source, (Destination)destination, this.language());
        return writer$2.toString();
    }

    public Extraction(@PathParam(value="lang") String langCode) {
        this.org$dbpedia$extraction$server$resources$Extraction$$langCode = langCode;
        this.language = Language$.MODULE$.getOrElse(langCode, (Function0)new $anonfun$3(this));
        if (Server$.MODULE$.instance().managers().contains((Object)this.language())) {
            return;
        }
        throw new WebApplicationException((Throwable)new Exception(new StringBuilder().append((Object)"language ").append((Object)langCode).append((Object)" not configured in server").toString()), 404);
    }
}

