/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.server;

import java.io.File;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dbpedia.extraction.destinations.Destination;
import org.dbpedia.extraction.mappings.CompositeExtractor;
import org.dbpedia.extraction.mappings.LabelExtractor;
import org.dbpedia.extraction.mappings.Mapping;
import org.dbpedia.extraction.mappings.MappingExtractor;
import org.dbpedia.extraction.mappings.Mappings;
import org.dbpedia.extraction.mappings.MappingsLoader$;
import org.dbpedia.extraction.mappings.Redirects;
import org.dbpedia.extraction.mappings.RootExtractor;
import org.dbpedia.extraction.ontology.Ontology;
import org.dbpedia.extraction.ontology.io.OntologyReader;
import org.dbpedia.extraction.server.Paths;
import org.dbpedia.extraction.server.XMLLogHandler;
import org.dbpedia.extraction.sources.Source;
import org.dbpedia.extraction.sources.WikiPage;
import org.dbpedia.extraction.sources.WikiSource$;
import org.dbpedia.extraction.sources.XMLSource$;
import org.dbpedia.extraction.util.Language;
import org.dbpedia.extraction.util.Language$;
import org.dbpedia.extraction.wikiparser.Namespace;
import org.dbpedia.extraction.wikiparser.Namespace$;
import org.dbpedia.extraction.wikiparser.PageNode;
import org.dbpedia.extraction.wikiparser.WikiParser;
import org.dbpedia.extraction.wikiparser.WikiParser$;
import org.dbpedia.extraction.wikiparser.WikiTitle;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Traversable$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.xml.Elem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005-h!B\u0001\u0003\u0003\u0003Y!!E#yiJ\f7\r^5p]6\u000bg.Y4fe*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005\u00151\u0011AC3yiJ\f7\r^5p]*\u0011q\u0001C\u0001\bI\n\u0004X\rZ5b\u0015\u0005I\u0011aA8sO\u000e\u00011c\u0001\u0001\r)A\u0011QBE\u0007\u0002\u001d)\u0011q\u0002E\u0001\u0005Y\u0006twMC\u0001\u0012\u0003\u0011Q\u0017M^1\n\u0005Mq!AB(cU\u0016\u001cG\u000f\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbCA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002C\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u00131\fgnZ;bO\u0016\u001c\bcA\u000f&Q9\u0011ad\t\b\u0003?\tj\u0011\u0001\t\u0006\u0003C)\ta\u0001\u0010:p_Rt\u0014\"A\f\n\u0005\u00112\u0012a\u00029bG.\fw-Z\u0005\u0003M\u001d\u00121aU3r\u0015\t!c\u0003\u0005\u0002*Y5\t!F\u0003\u0002,\t\u0005!Q\u000f^5m\u0013\ti#F\u0001\u0005MC:<W/Y4f\u0011!y\u0003A!A!\u0002\u0013\u0001\u0014!\u00029bi\"\u001c\bCA\u00193\u001b\u0005\u0011\u0011BA\u001a\u0003\u0005\u0015\u0001\u0016\r\u001e5t\u0011\u0015)\u0004\u0001\"\u00017\u0003\u0019a\u0014N\\5u}Q\u0019q\u0007O\u001d\u0011\u0005E\u0002\u0001\"B\u000e5\u0001\u0004a\u0002\"B\u00185\u0001\u0004\u0001\u0004bB\u001e\u0001\u0005\u0004%I\u0001P\u0001\u0007Y><w-\u001a:\u0016\u0003u\u0002\"A\u0010\"\u000e\u0003}R!\u0001Q!\u0002\u000f1|wmZ5oO*\u00111\u0006E\u0005\u0003\u0007~\u0012a\u0001T8hO\u0016\u0014\bBB#\u0001A\u0003%Q(A\u0004m_\u001e<WM\u001d\u0011\t\u000b\u001d\u0003a\u0011\u0001%\u0002\u0013\u0015DHO]1di>\u0014HCA%P!\tQU*D\u0001L\u0015\taE!\u0001\u0005nCB\u0004\u0018N\\4t\u0013\tq5JA\u0007S_>$X\t\u001f;sC\u000e$xN\u001d\u0005\u0006!\u001a\u0003\r\u0001K\u0001\tY\u0006tw-^1hK\")!\u000b\u0001D\u0001'\u0006AqN\u001c;pY><\u00170F\u0001U!\t)v+D\u0001W\u0015\t\u0011F!\u0003\u0002Y-\nAqJ\u001c;pY><\u0017\u0010C\u0003[\u0001\u0019\u00051,A\u0007p]R|Gn\\4z!\u0006<Wm]\u000b\u00029B!Q\fY2j\u001d\t)b,\u0003\u0002`-\u00051\u0001K]3eK\u001aL!!\u00192\u0003\u00075\u000b\u0007O\u0003\u0002`-A\u0011AmZ\u0007\u0002K*\u0011a\rB\u0001\u000bo&\\\u0017\u000e]1sg\u0016\u0014\u0018B\u00015f\u0005%9\u0016n[5USRdW\r\u0005\u0002eU&\u00111.\u001a\u0002\t!\u0006<WMT8eK\")Q\u000e\u0001D\u0001]\u0006\tR.\u00199qS:<\u0007+Y4f'>,(oY3\u0015\u0005=\u0014\bcA\u000fqS&\u0011\u0011o\n\u0002\f)J\fg/\u001a:tC\ndW\rC\u0003QY\u0002\u0007\u0001\u0006C\u0003M\u0001\u0019\u0005A\u000f\u0006\u0002vqB\u0011!J^\u0005\u0003o.\u0013\u0001\"T1qa&twm\u001d\u0005\u0006!N\u0004\r\u0001\u000b\u0005\u0006u\u00021\ta_\u0001\u0013kB$\u0017\r^3P]R|Gn\\4z!\u0006<W\r\u0006\u0002}\u007fB\u0011Q#`\u0005\u0003}Z\u0011A!\u00168ji\"9\u0011\u0011A=A\u0002\u0005\r\u0011\u0001\u00029bO\u0016\u0004B!!\u0002\u0002\f5\u0011\u0011q\u0001\u0006\u0004\u0003\u0013!\u0011aB:pkJ\u001cWm]\u0005\u0005\u0003\u001b\t9A\u0001\u0005XS.L\u0007+Y4f\u0011\u001d\t\t\u0002\u0001D\u0001\u0003'\t!C]3n_Z,wJ\u001c;pY><\u0017\u0010U1hKR\u0019A0!\u0006\t\u000f\u0005]\u0011q\u0002a\u0001G\u0006)A/\u001b;mK\"9\u00111\u0004\u0001\u0007\u0002\u0005u\u0011!E;qI\u0006$X-T1qa&tw\rU1hKR)A0a\b\u0002\"!A\u0011\u0011AA\r\u0001\u0004\t\u0019\u0001\u0003\u0004Q\u00033\u0001\r\u0001\u000b\u0005\b\u0003K\u0001a\u0011AA\u0014\u0003E\u0011X-\\8wK6\u000b\u0007\u000f]5oOB\u000bw-\u001a\u000b\u0006y\u0006%\u00121\u0006\u0005\b\u0003/\t\u0019\u00031\u0001d\u0011\u0019\u0001\u00161\u0005a\u0001Q!9\u0011q\u0006\u0001\u0007\u0002\u0005E\u0012!C;qI\u0006$X-\u00117m+\u0005a\b\"CA\u001b\u0001\t\u0007I\u0011CA\u001c\u0003\u0019\u0001\u0018M]:feV\u0011\u0011\u0011\b\t\u0004I\u0006m\u0012bAA\u001fK\nQq+[6j!\u0006\u00148/\u001a:\t\u0011\u0005\u0005\u0003\u0001)A\u0005\u0003s\tq\u0001]1sg\u0016\u0014\b\u0005C\u0004\u0002F\u0001!\t!a\u0012\u0002\u000f\u0015DHO]1diR9A0!\u0013\u0002T\u0005\r\u0004\u0002CA&\u0003\u0007\u0002\r!!\u0014\u0002\rM|WO]2f!\u0011\t)!a\u0014\n\t\u0005E\u0013q\u0001\u0002\u0007'>,(oY3\t\u0011\u0005U\u00131\ta\u0001\u0003/\n1\u0002Z3ti&t\u0017\r^5p]B!\u0011\u0011LA0\u001b\t\tYFC\u0002\u0002^\u0011\tA\u0002Z3ti&t\u0017\r^5p]NLA!!\u0019\u0002\\\tYA)Z:uS:\fG/[8o\u0011\u0019\u0001\u00161\ta\u0001Q!9\u0011q\r\u0001\u0005\u0002\u0005%\u0014a\u0004<bY&$\u0017\r^3NCB\u0004\u0018N\\4\u0015\r\u0005-\u0014qOA>!\u0011\ti'a\u001d\u000e\u0005\u0005=$bAA9-\u0005\u0019\u00010\u001c7\n\t\u0005U\u0014q\u000e\u0002\u0005\u000b2,W\u000eC\u0004\u0002z\u0005\u0015\u0004\u0019A8\u0002\u001b5\f\u0007\u000f]5oON\u0004\u0016mZ3t\u0011\u0019y\u0011Q\ra\u0001Q!9\u0011q\u0010\u0001\u0005\u0002\u0005\u0005\u0015!\u0006<bY&$\u0017\r^3P]R|Gn\\4z!\u0006<Wm\u001d\u000b\u0005\u0003W\n\u0019\t\u0003\u0006\u0002\u0006\u0006u\u0004\u0013!a\u0001\u0003\u000f\u000b\u0001C\\3x\u001f:$x\u000e\\8hsB\u000bw-Z:\u0011\u000bu\tI)a\u0001\n\u0007\u0005-uE\u0001\u0003MSN$\bbBAH\u0001\u0011E\u0011\u0011S\u0001\u0012Y>\fGm\u00148u_2|w-\u001f)bO\u0016\u001cXCAAJ!\u0019\t)*a(dS6\u0011\u0011q\u0013\u0006\u0005\u00033\u000bY*A\u0005j[6,H/\u00192mK*\u0019\u0011Q\u0014\f\u0002\u0015\r|G\u000e\\3di&|g.C\u0002b\u0003/Cq!a)\u0001\t#\t)+\u0001\tm_\u0006$W*\u00199qS:<\u0007+Y4fgV\u0011\u0011q\u0015\t\u0007\u0003+\u000by\n\u000b/\t\u000f\u0005-\u0006\u0001\"\u0005\u0002.\u0006\tBn\\1e\u001b\u0006\u0004\b/\u001b8hgB\u000bw-Z:\u0015\u0007q\u000by\u000b\u0003\u0004Q\u0003S\u0003\r\u0001\u000b\u0005\u0007\u0003g\u0003A\u0011C*\u0002\u00191|\u0017\rZ(oi>dwnZ=\t\u000f\u0005]\u0006\u0001\"\u0005\u0002:\u0006qAn\\1e\u000bb$(/Y2u_J\u001cHCAA^!\u0011i\u0006\rK%\t\u000f\u0005]\u0006\u0001\"\u0005\u0002@R\u0019\u0011*!1\t\r=\ti\f1\u0001)\u0011\u001d\t)\r\u0001C\t\u0003\u000f\fA\u0002\\8bI6\u000b\u0007\u000f]5oON$\"!!3\u0011\tu\u0003\u0007&\u001e\u0005\b\u0003\u000b\u0004A\u0011CAg)\r)\u0018q\u001a\u0005\u0007\u001f\u0005-\u0007\u0019\u0001\u0015\t\u0013\u0005M\u0007!%A\u0005\u0002\u0005U\u0017a\b<bY&$\u0017\r^3P]R|Gn\\4z!\u0006<Wm\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u001b\u0016\u0005\u0003\u000f\u000bIn\u000b\u0002\u0002\\B!\u0011Q\\At\u001b\t\tyN\u0003\u0003\u0002b\u0006\r\u0018!C;oG\",7m[3e\u0015\r\t)OF\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAu\u0003?\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public abstract class ExtractionManager
implements ScalaObject {
    private final Seq<Language> languages;
    private final Paths paths;
    private final Logger logger;
    private final WikiParser parser;

    private Logger logger() {
        return this.logger;
    }

    public abstract RootExtractor extractor(Language var1);

    public abstract Ontology ontology();

    public abstract Map<WikiTitle, PageNode> ontologyPages();

    public abstract Traversable<PageNode> mappingPageSource(Language var1);

    public abstract Mappings mappings(Language var1);

    public abstract void updateOntologyPage(WikiPage var1);

    public abstract void removeOntologyPage(WikiTitle var1);

    public abstract void updateMappingPage(WikiPage var1, Language var2);

    public abstract void removeMappingPage(WikiTitle var1, Language var2);

    public abstract void updateAll();

    public WikiParser parser() {
        return this.parser;
    }

    public void extract(Source source, Destination destination$1, Language language) {
        RootExtractor extract$1 = this.extractor(language);
        destination$1.open();
        ((GenericTraversableTemplate)source.map((Function1)this.parser(), Traversable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, destination$1, extract$1){
            public static final long serialVersionUID;
            private final Destination destination$1;
            private final RootExtractor extract$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(PageNode page) {
                this.destination$1.write(this.extract$1.apply(page));
            }
            {
                this.destination$1 = destination;
                this.extract$1 = rootExtractor;
            }
        });
        destination$1.close();
    }

    public Elem validateMapping(Traversable<PageNode> mappingsPages$1, Language lang$3) {
        Logger logger = Logger.getLogger(MappingsLoader$.MODULE$.getClass().getName());
        XMLLogHandler logHandler = new XMLLogHandler();
        logHandler.setLevel(Level.WARNING);
        logger.addHandler(logHandler);
        Object context = new Object(this, mappingsPages$1, lang$3){
            private final Ontology ontology;
            private final Language language;
            private final Redirects redirects;
            private final Traversable<PageNode> mappingPageSource;

            public Ontology ontology() {
                return this.ontology;
            }

            public Language language() {
                return this.language;
            }

            public Redirects redirects() {
                return this.redirects;
            }

            public Traversable<PageNode> mappingPageSource() {
                return this.mappingPageSource;
            }
            {
                this.ontology = $outer.ontology();
                this.language = language;
                this.redirects = new Redirects((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
                this.mappingPageSource = traversable;
            }
        };
        Mappings mappings = MappingsLoader$.MODULE$.load(context);
        if (mappings.templateMappings().isEmpty() && mappings.tableMappings().isEmpty()) {
            logger.severe("no mappings found");
        }
        logger.removeHandler(logHandler);
        return logHandler.xml();
    }

    public Elem validateOntologyPages(List<WikiPage> newOntologyPages) {
        XMLLogHandler logHandler = new XMLLogHandler();
        logHandler.setLevel(Level.WARNING);
        Logger.getLogger(OntologyReader.class.getName()).addHandler(logHandler);
        Map newOntologyPagesMap = ((TraversableOnce)((TraversableLike)newOntologyPages.map((Function1)this.parser(), List$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<WikiTitle, PageNode> apply(PageNode page) {
                return new Tuple2((Object)page.title(), (Object)page);
            }
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        Iterable updatedOntologyPages = this.ontologyPages().$plus$plus((GenTraversableOnce)newOntologyPagesMap).values();
        new OntologyReader().read((Traversable)updatedOntologyPages);
        Logger.getLogger(OntologyReader.class.getName()).removeHandler(logHandler);
        return logHandler.xml();
    }

    public List validateOntologyPages$default$1() {
        return Nil$.MODULE$;
    }

    public Map<WikiTitle, PageNode> loadOntologyPages() {
        Source source;
        if (this.paths.ontologyFile() != null && this.paths.ontologyFile().isFile()) {
            this.logger().warning(new StringBuilder().append((Object)"LOADING ONTOLOGY NOT FROM SERVER, BUT FROM LOCAL FILE [").append((Object)this.paths.ontologyFile()).append((Object)"] - MAY BE OUTDATED - ONLY FOR TESTING!").toString());
            source = XMLSource$.MODULE$.fromFile(this.paths.ontologyFile(), Language$.MODULE$.Mappings(), XMLSource$.MODULE$.fromFile$default$3());
        } else {
            Set namespaces = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Namespace[]{Namespace$.MODULE$.OntologyClass(), Namespace$.MODULE$.OntologyProperty()}));
            URL url = this.paths.apiUrl();
            Language language = Language$.MODULE$.Mappings();
            this.logger().info(new StringBuilder().append((Object)"Loading ontology pages from URL [").append((Object)url).append((Object)"]").toString());
            source = WikiSource$.MODULE$.fromNamespaces(namespaces, url, language);
        }
        Source source2 = source;
        return ((TraversableOnce)((TraversableLike)source2.map((Function1)this.parser(), Traversable$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<WikiTitle, PageNode> apply(PageNode page) {
                return new Tuple2((Object)page.title(), (Object)page);
            }
        }, Traversable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public Map<Language, Map<WikiTitle, PageNode>> loadMappingPages() {
        this.logger().info("Loading mapping pages");
        return ((TraversableOnce)this.languages.map((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final ExtractionManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<Language, Map<WikiTitle, PageNode>> apply(Language lang) {
                return new Tuple2((Object)lang, this.$outer.loadMappingsPages(lang));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public Map<WikiTitle, PageNode> loadMappingsPages(Language language$1) {
        Source source;
        Namespace namespace = (Namespace)Namespace$.MODULE$.mappings().getOrElse((Object)language$1, (Function0)new Serializable(this, language$1){
            public static final long serialVersionUID;
            private final Language language$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Nothing$ apply() {
                throw new NoSuchElementException(new StringBuilder().append((Object)"no mapping namespace for language ").append((Object)this.language$1.wikiCode()).toString());
            }
            {
                this.language$1 = language;
            }
        });
        if (this.paths.mappingsDir() != null && this.paths.mappingsDir().isDirectory()) {
            File file = new File(this.paths.mappingsDir(), new StringBuilder().append((Object)namespace.name(Language$.MODULE$.Mappings()).replace(' ', '_')).append((Object)".xml").toString());
            this.logger().warning(new StringBuilder().append((Object)"LOADING MAPPINGS NOT FROM SERVER, BUT FROM LOCAL FILE [").append((Object)file).append((Object)"] - MAY BE OUTDATED - ONLY FOR TESTING!").toString());
            source = XMLSource$.MODULE$.fromFile(file, language$1, XMLSource$.MODULE$.fromFile$default$3());
        } else {
            URL url = this.paths.apiUrl();
            source = WikiSource$.MODULE$.fromNamespaces((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Namespace[]{namespace})), url, language$1);
        }
        Source source2 = source;
        return ((TraversableOnce)((TraversableLike)source2.map((Function1)this.parser(), Traversable$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<WikiTitle, PageNode> apply(PageNode page) {
                return new Tuple2((Object)page.title(), (Object)page);
            }
        }, Traversable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public Ontology loadOntology() {
        return new OntologyReader().read((Traversable)this.ontologyPages().values());
    }

    /*
     * WARNING - void declaration
     */
    public Map<Language, RootExtractor> loadExtractors() {
        void var1_1;
        Map extractors = ((TraversableOnce)this.languages.map((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final ExtractionManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<Language, RootExtractor> apply(Language lang) {
                return new Tuple2((Object)lang, (Object)this.$outer.loadExtractors(lang));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        this.logger().info(new StringBuilder().append((Object)"All extractors loaded for languages ").append((Object)((TraversableOnce)((SeqLike)this.languages.map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(Language language) {
                return language.wikiCode();
            }
        }, Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).mkString(",")).toString());
        return var1_1;
    }

    public RootExtractor loadExtractors(Language lang$2) {
        return new RootExtractor((Mapping)new CompositeExtractor((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Mapping[]{new LabelExtractor(new Object(this, lang$2){
            private final Ontology ontology;
            private final Language language;

            public Ontology ontology() {
                return this.ontology;
            }

            public Language language() {
                return this.language;
            }
            {
                this.ontology = $outer.ontology();
                this.language = language;
            }
        }), new MappingExtractor(new Object(this, lang$2){
            private final Mappings mappings;
            private final Redirects redirects;

            public Mappings mappings() {
                return this.mappings;
            }

            public Redirects redirects() {
                return this.redirects;
            }
            {
                this.mappings = $outer.mappings(language);
                this.redirects = new Redirects((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
            }
        })})));
    }

    public Map<Language, Mappings> loadMappings() {
        return ((TraversableOnce)this.languages.map((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final ExtractionManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<Language, Mappings> apply(Language lang) {
                return new Tuple2((Object)lang, (Object)this.$outer.loadMappings(lang));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public Mappings loadMappings(Language lang$1) {
        Object context = new Object(this, lang$1){
            private final Ontology ontology;
            private final Language language;
            private final Redirects redirects;
            private final Traversable<PageNode> mappingPageSource;

            public Ontology ontology() {
                return this.ontology;
            }

            public Language language() {
                return this.language;
            }

            public Redirects redirects() {
                return this.redirects;
            }

            public Traversable<PageNode> mappingPageSource() {
                return this.mappingPageSource;
            }
            {
                this.ontology = $outer.ontology();
                this.language = language;
                this.redirects = new Redirects((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
                this.mappingPageSource = $outer.mappingPageSource(language);
            }
        };
        return MappingsLoader$.MODULE$.load(context);
    }

    public ExtractionManager(Seq<Language> languages2, Paths paths) {
        this.languages = languages2;
        this.paths = paths;
        this.logger = Logger.getLogger(ExtractionManager.class.getName());
        this.parser = WikiParser$.MODULE$.apply();
    }
}

