/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.scripts;

import java.io.File;
import java.util.Properties;
import java.util.regex.Pattern;
import org.dbpedia.extraction.destinations.formatters.Formatter;
import org.dbpedia.extraction.destinations.formatters.UriPolicy$;
import org.dbpedia.extraction.ontology.RdfNamespace$;
import org.dbpedia.extraction.scripts.WikidataSameAsToLanguageLinks;
import org.dbpedia.extraction.util.ConfigUtils$;
import org.dbpedia.extraction.util.FileLike;
import org.dbpedia.extraction.util.Finder;
import org.dbpedia.extraction.util.Language;
import org.dbpedia.extraction.util.Language$;
import org.dbpedia.extraction.util.RichFile;
import org.dbpedia.extraction.util.RichFile$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;

public final class WikidataSameAsToLanguageLinks$ {
    public static final WikidataSameAsToLanguageLinks$ MODULE$;
    private final String org$dbpedia$extraction$scripts$WikidataSameAsToLanguageLinks$$sameAs;
    private final Pattern org$dbpedia$extraction$scripts$WikidataSameAsToLanguageLinks$$DBPEDIA_URI_PATTERN;

    static {
        new WikidataSameAsToLanguageLinks$();
    }

    public String org$dbpedia$extraction$scripts$WikidataSameAsToLanguageLinks$$sameAs() {
        return this.org$dbpedia$extraction$scripts$WikidataSameAsToLanguageLinks$$sameAs;
    }

    public Pattern org$dbpedia$extraction$scripts$WikidataSameAsToLanguageLinks$$DBPEDIA_URI_PATTERN() {
        return this.org$dbpedia$extraction$scripts$WikidataSameAsToLanguageLinks$$DBPEDIA_URI_PATTERN;
    }

    /*
     * WARNING - void declaration
     */
    public void main(String[] args) {
        void var3_3;
        Predef$.MODULE$.require(args != null && args.length == 1 && new StringOps(Predef$.MODULE$.augmentString(args[0])).nonEmpty(), (Function0)new Serializable(){

            public final String apply() {
                return "missing required argument: config file name";
            }
        });
        Properties config = ConfigUtils$.MODULE$.loadConfig(args[0], "UTF-8");
        File baseDir = (File)ConfigUtils$.MODULE$.getValue(config, "base-dir", true, (Function1)new Serializable(){

            public final File apply(String x$1) {
                return new File(x$1);
            }
        });
        if (baseDir.exists()) {
            Finder inputFinder = new Finder((Object)baseDir, Language$.MODULE$.Wikidata(), "wiki", (Function1)new Serializable(){

                public final RichFile apply(File file) {
                    return RichFile$.MODULE$.wrapFile(file);
                }
            });
            String date = (String)inputFinder.dates(inputFinder.dates$default$1(), inputFinder.dates$default$2(), inputFinder.dates$default$3()).last();
            String input = ConfigUtils$.MODULE$.getString(config, "input", true);
            String suffix = ConfigUtils$.MODULE$.getString(config, "suffix", true);
            String output = ConfigUtils$.MODULE$.getString(config, "output", true);
            Language[] language = ConfigUtils$.MODULE$.parseLanguages(baseDir, ConfigUtils$.MODULE$.getStrings(config, "languages", ',', true));
            Map formats = UriPolicy$.MODULE$.parseFormats(config, "uri-policy", "format");
            RichFile wikiDataFile = RichFile$.MODULE$.wrapFile((File)inputFinder.file(date, new StringBuilder().append((Object)input).append((Object)suffix).toString()));
            WikidataSameAsToLanguageLinks processor = new WikidataSameAsToLanguageLinks(baseDir, (FileLike<?>)wikiDataFile, output, language, (Map<String, Formatter>)formats);
            processor.processLinks();
            return;
        }
        throw this.org$dbpedia$extraction$scripts$WikidataSameAsToLanguageLinks$$error(new StringBuilder().append((Object)"dir ").append((Object)var3_3).append((Object)" does not exist").toString(), this.org$dbpedia$extraction$scripts$WikidataSameAsToLanguageLinks$$error$default$2());
    }

    public IllegalArgumentException org$dbpedia$extraction$scripts$WikidataSameAsToLanguageLinks$$error(String message, Throwable cause) {
        return new IllegalArgumentException(message, cause);
    }

    public Throwable org$dbpedia$extraction$scripts$WikidataSameAsToLanguageLinks$$error$default$2() {
        return null;
    }

    private WikidataSameAsToLanguageLinks$() {
        MODULE$ = this;
        this.org$dbpedia$extraction$scripts$WikidataSameAsToLanguageLinks$$sameAs = RdfNamespace$.MODULE$.OWL().append("sameAs");
        this.org$dbpedia$extraction$scripts$WikidataSameAsToLanguageLinks$$DBPEDIA_URI_PATTERN = new StringOps(Predef$.MODULE$.augmentString("^http://([a-z-]+.)?dbpedia.org/resource/.*$")).r().pattern();
    }
}

