/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.scripts;

import java.io.File;
import java.io.Writer;
import java.util.Properties;
import org.dbpedia.extraction.destinations.CompositeDestination;
import org.dbpedia.extraction.destinations.Destination;
import org.dbpedia.extraction.destinations.Quad;
import org.dbpedia.extraction.destinations.WriterDestination;
import org.dbpedia.extraction.destinations.formatters.Formatter;
import org.dbpedia.extraction.destinations.formatters.UriPolicy$;
import org.dbpedia.extraction.ontology.RdfNamespace$;
import org.dbpedia.extraction.scripts.ProcessFreebaseLinks$;
import org.dbpedia.extraction.util.ConfigUtils$;
import org.dbpedia.extraction.util.FileLike;
import org.dbpedia.extraction.util.Finder;
import org.dbpedia.extraction.util.IOUtils$;
import org.dbpedia.extraction.util.Language;
import org.dbpedia.extraction.util.RichFile;
import org.dbpedia.extraction.util.RichFile$;
import org.dbpedia.extraction.util.StringUtils$;
import org.dbpedia.extraction.util.WikiUtil$;
import org.dbpedia.util.text.uri.UriDecoder;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Traversable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.TreeSet;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

public final class ProcessFreebaseLinks$ {
    public static final ProcessFreebaseLinks$ MODULE$;
    private final String part1;
    private final int midStart;
    private final String predicatePart;
    private final int predicatePartLength;
    private final String preLanguageCode;
    private final int preLanguageCodeLength;
    private final String wikipediaUriInfix;
    private final int wikipediaUriInfixLength;
    private final String suffix;
    private final int suffixLength;
    private final String lineTerminator;
    private final int lineTerminatorLength;
    private final String sameAs;
    private final String[] replacements;

    static {
        new ProcessFreebaseLinks$();
    }

    /*
     * WARNING - void declaration
     */
    public void main(String[] args) {
        void var3_3;
        Predef$.MODULE$.require(args != null && args.length == 1 && new StringOps(Predef$.MODULE$.augmentString(args[0])).nonEmpty(), (Function0)new Serializable(){

            public final String apply() {
                return "missing required argument: config file name";
            }
        });
        Properties config = ConfigUtils$.MODULE$.loadConfig(args[0], "UTF-8");
        File baseDir = (File)ConfigUtils$.MODULE$.getValue(config, "base-dir", true, (Function1)new Serializable(){

            public final File apply(String x$1) {
                return new File(x$1);
            }
        });
        if (baseDir.exists()) {
            String input = ConfigUtils$.MODULE$.getString(config, "input", true);
            File inputFile = new File(baseDir, input);
            String output = ConfigUtils$.MODULE$.getString(config, "output", true);
            Language[] languages = ConfigUtils$.MODULE$.parseLanguages(baseDir, ConfigUtils$.MODULE$.getStrings(config, "languages", ',', true));
            Map formats = UriPolicy$.MODULE$.parseFormats(config, "uri-policy", "format");
            HashMap<String, Destination> destinations = new HashMap<String, Destination>(){

                public Destination default(String k) {
                    return null;
                }
            };
            Predef$.MODULE$.refArrayOps((Object[])languages).foreach((Function1)new Serializable(baseDir, output, formats, (HashMap)destinations){
                private final File baseDir$1;
                public final String output$1;
                private final Map formats$1;
                private final HashMap destinations$1;

                public final void apply(Language language) {
                    Finder finder = new Finder((Object)this.baseDir$1, language, "wiki", (Function1)new Serializable(this){

                        public final RichFile apply(File file) {
                            return RichFile$.MODULE$.wrapFile(file);
                        }
                    });
                    String date = (String)finder.dates(finder.dates$default$1(), finder.dates$default$2(), finder.dates$default$3()).last();
                    ArrayBuffer formatDestinations = new ArrayBuffer();
                    this.formats$1.withFilter((Function1)new Serializable(this){

                        public final boolean apply(Tuple2<String, Formatter> check$ifrefutable$1) {
                            Tuple2<String, Formatter> tuple2 = check$ifrefutable$1;
                            boolean bl = tuple2 != null;
                            return bl;
                        }
                    }).foreach((Function1)new Serializable(this, finder, date, formatDestinations){
                        private final /* synthetic */ anonfun.main.2 $outer;
                        private final Finder finder$1;
                        private final String date$1;
                        private final ArrayBuffer formatDestinations$1;

                        public final ArrayBuffer<Destination> apply(Tuple2<String, Formatter> x$2) {
                            Tuple2<String, Formatter> tuple2 = x$2;
                            if (tuple2 != null) {
                                String suffix = (String)tuple2._1();
                                Formatter format = (Formatter)tuple2._2();
                                File file = (File)this.finder$1.file(this.date$1, new StringBuilder().append((Object)this.$outer.output$1).append((Object)BoxesRunTime.boxToCharacter((char)'.')).append((Object)suffix).toString());
                                ArrayBuffer arrayBuffer = this.formatDestinations$1.$plus$eq((Object)new WriterDestination((Function0)new Serializable(this, file){
                                    private final File file$1;

                                    public final Writer apply() {
                                        return IOUtils$.MODULE$.writer((FileLike)RichFile$.MODULE$.wrapFile(this.file$1), IOUtils$.MODULE$.writer$default$2());
                                    }
                                    {
                                        this.file$1 = file$1;
                                    }
                                }, format));
                                return arrayBuffer;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.finder$1 = finder$1;
                            this.date$1 = date$1;
                            this.formatDestinations$1 = formatDestinations$1;
                        }
                    });
                    this.destinations$1.update((Object)language.wikiCode(), (Object)new CompositeDestination(formatDestinations.toSeq()));
                }
                {
                    this.baseDir$1 = baseDir$1;
                    this.output$1 = output$1;
                    this.formats$1 = formats$1;
                    this.destinations$1 = destinations$1;
                }
            });
            TreeSet undefined = new TreeSet((Ordering)Ordering.String$.MODULE$);
            ArrayBuffer quads = new ArrayBuffer(1);
            quads.$plus$eq(null);
            long startNanos = System.nanoTime();
            Console$.MODULE$.err().println(new StringBuilder().append((Object)"reading Freebase file ").append((Object)input).append((Object)", writing DBpedia files...").toString());
            destinations.values().foreach((Function1)new Serializable(){

                public final void apply(Destination x$3) {
                    x$3.open();
                }
            });
            LongRef lineCount = LongRef.create((long)0L);
            LongRef linkCount = LongRef.create((long)0L);
            IOUtils$.MODULE$.readLines((FileLike)RichFile$.MODULE$.wrapFile(inputFile), IOUtils$.MODULE$.readLines$default$2(), (Function1)new Serializable((HashMap)destinations, undefined, quads, startNanos, lineCount, linkCount){
                private final HashMap destinations$1;
                private final TreeSet undefined$1;
                private final ArrayBuffer quads$1;
                private final long startNanos$1;
                private final LongRef lineCount$1;
                private final LongRef linkCount$1;

                public final void apply(String line) {
                    if (line != null) {
                        BoxedUnit boxedUnit;
                        Quad quad = ProcessFreebaseLinks$.MODULE$.org$dbpedia$extraction$scripts$ProcessFreebaseLinks$$parseLink(line);
                        if (quad == null) {
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            Destination destination = (Destination)this.destinations$1.apply((Object)quad.language());
                            if (destination == null) {
                                boxedUnit = this.undefined$1.$plus$eq((Object)quad.language());
                            } else {
                                this.quads$1.update(0, (Object)quad);
                                destination.write((Traversable)this.quads$1);
                                ++this.linkCount$1.elem;
                                if (this.linkCount$1.elem % 1000000L == 0L) {
                                    ProcessFreebaseLinks$.MODULE$.org$dbpedia$extraction$scripts$ProcessFreebaseLinks$$logRead("link", this.linkCount$1.elem, this.startNanos$1);
                                }
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                        ++this.lineCount$1.elem;
                        if (this.lineCount$1.elem % 1000000L == 0L) {
                            ProcessFreebaseLinks$.MODULE$.org$dbpedia$extraction$scripts$ProcessFreebaseLinks$$logRead("line", this.lineCount$1.elem, this.startNanos$1);
                        }
                    }
                }
                {
                    this.destinations$1 = destinations$1;
                    this.undefined$1 = undefined$1;
                    this.quads$1 = quads$1;
                    this.startNanos$1 = startNanos$1;
                    this.lineCount$1 = lineCount$1;
                    this.linkCount$1 = linkCount$1;
                }
            });
            destinations.values().foreach((Function1)new Serializable(){

                public final void apply(Destination x$4) {
                    x$4.close();
                }
            });
            this.org$dbpedia$extraction$scripts$ProcessFreebaseLinks$$logRead("line", lineCount.elem, startNanos);
            this.org$dbpedia$extraction$scripts$ProcessFreebaseLinks$$logRead("link", linkCount.elem, startNanos);
            Console$.MODULE$.err().println(new StringBuilder().append((Object)"links for these languages were found but not written because configuration didn't include them: ").append((Object)undefined.mkString("[", ",", "]")).toString());
            return;
        }
        throw this.error(new StringBuilder().append((Object)"dir ").append((Object)var3_3).append((Object)" does not exist").toString(), this.error$default$2());
    }

    private String part1() {
        return this.part1;
    }

    private int midStart() {
        return this.midStart;
    }

    private String predicatePart() {
        return this.predicatePart;
    }

    private int predicatePartLength() {
        return this.predicatePartLength;
    }

    private String preLanguageCode() {
        return this.preLanguageCode;
    }

    private int preLanguageCodeLength() {
        return this.preLanguageCodeLength;
    }

    private String wikipediaUriInfix() {
        return this.wikipediaUriInfix;
    }

    private int wikipediaUriInfixLength() {
        return this.wikipediaUriInfixLength;
    }

    private String suffix() {
        return this.suffix;
    }

    private int suffixLength() {
        return this.suffixLength;
    }

    private String lineTerminator() {
        return this.lineTerminator;
    }

    private int lineTerminatorLength() {
        return this.lineTerminatorLength;
    }

    private String sameAs() {
        return this.sameAs;
    }

    private String[] replacements() {
        return this.replacements;
    }

    public Quad org$dbpedia$extraction$scripts$ProcessFreebaseLinks$$parseLink(String line) {
        if (line.startsWith(this.part1())) {
            int midEnd = line.indexOf(62, this.midStart());
            if (midEnd == -1) {
                return null;
            }
            int predicatePartStart = line.indexOf(60, midEnd + 1);
            if (line.startsWith(this.predicatePart(), predicatePartStart)) {
                int langStart = predicatePartStart + this.predicatePartLength();
                int langEnd = line.indexOf(62, langStart);
                if (langEnd == -1) {
                    return null;
                }
                int titleStart = line.indexOf("\"", langEnd);
                if (titleStart == -1) {
                    return null;
                }
                int titleEnd = line.indexOf("\"", titleStart + 1);
                if (titleEnd == -1) {
                    return null;
                }
                String mid = line.substring(this.midStart(), midEnd);
                String lang = line.substring(langStart, langEnd);
                String title = this.unescapeMQL(line.substring(titleStart + 1, titleEnd));
                if ((title = UriDecoder.decode((String)title)).indexOf(35) != -1) {
                    return null;
                }
                title = StringUtils$.MODULE$.escape(title, this.replacements());
                return new Quad(lang, null, new StringBuilder().append((Object)"http://").append((Object)lang).append((Object)".dbpedia.org/resource/").append((Object)title).toString(), this.sameAs(), new StringBuilder().append((Object)"http://rdf.freebase.com/ns/m.").append((Object)mid).toString(), null, null);
            }
            return null;
        }
        return null;
    }

    private String unescapeMQL(String key) {
        char[] inputArray = key.toCharArray();
        int inputLength = inputArray.length;
        char[] res = new char[inputLength];
        int inputIndex = 0;
        int outputIndex = 0;
        while (inputIndex < inputLength) {
            if (inputArray[inputIndex] == '$') {
                res[outputIndex] = (char)Integer.parseInt(key.substring(inputIndex + 1, inputIndex + 5), 16);
                inputIndex += 5;
                ++outputIndex;
                continue;
            }
            res[outputIndex] = inputArray[inputIndex];
            ++outputIndex;
            ++inputIndex;
        }
        return new String(res, 0, outputIndex);
    }

    public void org$dbpedia$extraction$scripts$ProcessFreebaseLinks$$logRead(String name, long count, long startNanos) {
        long micros = (System.nanoTime() - startNanos) / 1000L;
        Console$.MODULE$.err().println(new StringBuilder().append((Object)name).append((Object)"s: ").append((Object)BoxesRunTime.boxToLong((long)count)).append((Object)" in ").append((Object)StringUtils$.MODULE$.prettyMillis(micros / 1000L)).append((Object)" (").append((Object)BoxesRunTime.boxToFloat((float)((float)micros / (float)count))).append((Object)" micros per ").append((Object)name).append((Object)")").toString());
    }

    private IllegalArgumentException error(String message, Throwable cause) {
        return new IllegalArgumentException(message, cause);
    }

    private Throwable error$default$2() {
        return null;
    }

    private ProcessFreebaseLinks$() {
        MODULE$ = this;
        this.part1 = "<http://rdf.freebase.com/ns/m.";
        this.midStart = this.part1().length();
        this.predicatePart = "<http://rdf.freebase.com/key/wikipedia.";
        this.predicatePartLength = this.predicatePart().length();
        this.preLanguageCode = "<http://";
        this.preLanguageCodeLength = this.preLanguageCode().length();
        this.wikipediaUriInfix = ".wikipedia.org/wiki/";
        this.wikipediaUriInfixLength = this.wikipediaUriInfix().length();
        this.suffix = ">";
        this.suffixLength = this.suffix().length();
        this.lineTerminator = ".";
        this.lineTerminatorLength = this.lineTerminator().length();
        this.sameAs = RdfNamespace$.MODULE$.OWL().append("sameAs");
        this.replacements = WikiUtil$.MODULE$.iriReplacements();
    }
}

