/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.scripts;

import java.io.File;
import java.net.URI;
import java.util.regex.Pattern;
import org.dbpedia.extraction.destinations.Quad;
import org.dbpedia.extraction.scripts.QuadMapper$;
import org.dbpedia.extraction.util.FileLike;
import org.dbpedia.extraction.util.RichFile$;
import org.dbpedia.extraction.util.WikiUtil$;
import org.dbpedia.util.text.uri.UriDecoder;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class RecodeUris$ {
    public static final RecodeUris$ MODULE$;
    private final Pattern DBPEDIA_URI;

    static {
        new RecodeUris$();
    }

    public void main(String[] args) {
        Predef$.MODULE$.require(args != null && args.length >= 3, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "need at least three args: input file suffix, output file suffix, comma- or space-separated names of input files (e.g. 'bbcwildlife,bookmashup')";
            }
        });
        String inSuffix = args[0];
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(inSuffix)).nonEmpty(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "no input file suffix";
            }
        });
        String outSuffix = args[1];
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(outSuffix)).nonEmpty(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "no output file suffix";
            }
        });
        String[] inputs = (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])args).drop(2)).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(String x$1) {
                return Predef$.MODULE$.refArrayOps((Object[])x$1.split("[,\\s]"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$2) {
                return x$2.trim();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$3) {
                return new StringOps(Predef$.MODULE$.augmentString(x$3)).nonEmpty();
            }
        });
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])inputs).nonEmpty(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "no input file names";
            }
        });
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])inputs).forall((Function1)new Serializable(inSuffix){
            public static final long serialVersionUID = 0L;
            private final String inSuffix$1;

            public final boolean apply(String x$4) {
                return x$4.endsWith(this.inSuffix$1);
            }
            {
                this.inSuffix$1 = inSuffix$1;
            }
        }), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "input file names must end with input file suffix";
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])inputs).foreach((Function1)new Serializable(inSuffix, outSuffix){
            public static final long serialVersionUID = 0L;
            private final String inSuffix$1;
            private final String outSuffix$1;

            public final void apply(String input) {
                IntRef changeCount = new IntRef(0);
                File inFile = new File(input);
                File outFile = new File(new StringBuilder().append((Object)input.substring(0, input.length() - this.inSuffix$1.length())).append((Object)this.outSuffix$1).toString());
                QuadMapper$.MODULE$.mapQuads(input, (FileLike<?>)RichFile$.MODULE$.wrapFile(inFile), (FileLike<?>)RichFile$.MODULE$.wrapFile(outFile), true, (Function1<Quad, Traversable<Quad>>)new Serializable(this, changeCount){
                    public static final long serialVersionUID = 0L;
                    private final IntRef changeCount$1;

                    /*
                     * Unable to fully structure code
                     */
                    public final List<Quad> apply(Quad quad) {
                        block9: {
                            block8: {
                                changed = false;
                                subj = RecodeUris$.MODULE$.fixUri(quad.subject());
                                if (changed) ** GOTO lbl-1000
                                v0 = subj;
                                var4_4 = quad.subject();
                                if (!(v0 != null ? v0.equals(var4_4) == false : var4_4 != null)) {
                                    v1 = false;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v1 = true;
                                }
                                changed = v1;
                                pred = RecodeUris$.MODULE$.fixUri(quad.predicate());
                                if (changed) ** GOTO lbl-1000
                                v2 = pred;
                                var6_6 = quad.predicate();
                                if (!(v2 != null ? v2.equals(var6_6) == false : var6_6 != null)) {
                                    v3 = false;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v3 = changed = true;
                                }
                                if (quad.datatype() != null) break block8;
                                obj = RecodeUris$.MODULE$.fixUri(quad.value());
                                if (changed) ** GOTO lbl-1000
                                v4 = obj;
                                var8_8 = quad.value();
                                if (!(v4 != null ? v4.equals(var8_8) == false : var8_8 != null)) {
                                    v5 = false;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v5 = changed = true;
                                }
                                if (changed) {
                                    ++this.changeCount$1.elem;
                                }
                                v6 = new Quad[1];
                                x$5 = subj;
                                x$6 = pred;
                                x$7 = obj;
                                x$8 = quad.copy$default$1();
                                x$9 = quad.copy$default$5();
                                x$10 = quad.copy$default$6();
                                x$11 = quad.copy$default$7();
                                v6[0] = quad.copy(x$8, x$5, x$6, x$7, x$9, x$10, x$11);
                                v7 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])v6));
                                break block9;
                            }
                            if (changed) {
                                ++this.changeCount$1.elem;
                            }
                            v8 = new Quad[1];
                            x$12 = subj;
                            x$13 = pred;
                            x$14 = quad.copy$default$1();
                            x$15 = quad.copy$default$4();
                            x$16 = quad.copy$default$5();
                            x$17 = quad.copy$default$6();
                            x$18 = quad.copy$default$7();
                            v8[0] = quad.copy(x$14, x$12, x$13, x$15, x$16, x$17, x$18);
                            v7 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])v8));
                        }
                        return v7;
                    }
                    {
                        this.changeCount$1 = changeCount$1;
                    }
                });
                Console$.MODULE$.err().println(new StringBuilder().append((Object)input).append((Object)": changed ").append((Object)BoxesRunTime.boxToInteger((int)changeCount.elem)).append((Object)" quads").toString());
            }
            {
                this.inSuffix$1 = inSuffix$1;
                this.outSuffix$1 = outSuffix$1;
            }
        });
    }

    private Pattern DBPEDIA_URI() {
        return this.DBPEDIA_URI;
    }

    public String fixUri(String uri) {
        String string;
        if (this.DBPEDIA_URI().matcher(uri).matches()) {
            String input = uri;
            if (uri.contains("\\")) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"URI contains backslash: [").append((Object)uri).append((Object)"]").toString());
            }
            if (uri.contains("?")) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"URI contains query: [").append((Object)uri).append((Object)"]").toString());
            }
            if (uri.contains("#")) {
                Console$.MODULE$.err().println(new StringBuilder().append((Object)"URI contains fragment: [").append((Object)uri).append((Object)"]").toString());
                input = uri.substring(0, uri.indexOf(35));
            }
            String decoded = UriDecoder.decode((String)input);
            decoded = WikiUtil$.MODULE$.cleanSpace(decoded);
            decoded = decoded.replace('\n', ' ');
            decoded = decoded.replace('\t', ' ');
            String encoded = WikiUtil$.MODULE$.wikiEncode(decoded);
            string = new URI(encoded).toASCIIString();
        } else {
            string = uri;
        }
        return string;
    }

    private RecodeUris$() {
        MODULE$ = this;
        this.DBPEDIA_URI = new StringOps(Predef$.MODULE$.augmentString("^http://([a-z-]+.)?dbpedia.org/resource/.*$")).r().pattern();
    }
}

