/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.scripts;

import java.io.File;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.dbpedia.extraction.scripts.CreateDownloadPage;
import org.dbpedia.extraction.scripts.CreateDownloadPage$;
import org.dbpedia.extraction.scripts.CreateDownloadPage$$anonfun$datasetPage$2$;
import org.dbpedia.extraction.scripts.CreateDownloadPage$Dataset$;
import org.dbpedia.extraction.util.FileLike;
import org.dbpedia.extraction.util.IOUtils$;
import org.dbpedia.extraction.util.RichFile$;
import org.dbpedia.extraction.util.RichString$;
import org.dbpedia.extraction.util.StringPlusser;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;

public final class CreateDownloadPage$ {
    public static final CreateDownloadPage$ MODULE$;
    private final String current;
    private final List<String> previous;
    private final String dumpDates;
    private final int allLanguages;
    private final List<String> languages;
    private final String l10nDatasetsSection;
    private final String dbpediaUrl;
    private final String zipSuffix;
    private final HashMap<String, String> titles;
    private final DecimalFormat formatter;
    private final String OntologyPage;
    private final String DataC14NPage;
    private final String DataL10NPage;
    private final String LinksPage;
    private final String DescPage;
    private final String NLPPage;
    private final CreateDownloadPage.Ontology ontology;
    private final List<List<CreateDownloadPage.Dataset>> datasets;
    private final List<CreateDownloadPage.Linkset> linksets;
    private File target;

    static {
        new CreateDownloadPage$();
    }

    public String current() {
        return this.current;
    }

    public List<String> previous() {
        return this.previous;
    }

    public String dumpDates() {
        return this.dumpDates;
    }

    public int allLanguages() {
        return this.allLanguages;
    }

    public List<String> languages() {
        return this.languages;
    }

    public String l10nDatasetsSection() {
        return this.l10nDatasetsSection;
    }

    public String dbpediaUrl() {
        return this.dbpediaUrl;
    }

    public String zipSuffix() {
        return this.zipSuffix;
    }

    public HashMap<String, String> titles() {
        return this.titles;
    }

    public DecimalFormat formatter() {
        return this.formatter;
    }

    public String org$dbpedia$extraction$scripts$CreateDownloadPage$$niceDecimal(long num) {
        return num < 1000L ? this.formatter().format(num) : (num < 1000000L ? new StringBuilder().append((Object)this.formatter().format((float)((double)num / 1000.0))).append((Object)"K").toString() : new StringBuilder().append((Object)this.formatter().format((float)((double)num / 1000000.0))).append((Object)"M").toString());
    }

    public String org$dbpedia$extraction$scripts$CreateDownloadPage$$niceBytes(long bytes) {
        return bytes < 1024L ? this.formatter().format(bytes) : (bytes < 0x100000L ? new StringBuilder().append((Object)this.formatter().format((float)((double)bytes / 1024.0))).append((Object)"KiB").toString() : (bytes < 0x40000000L ? new StringBuilder().append((Object)this.formatter().format((float)((double)bytes / 1048576.0))).append((Object)"MiB").toString() : new StringBuilder().append((Object)this.formatter().format((float)((double)bytes / 1.073741824E9))).append((Object)"GiB").toString()));
    }

    public void loadTitles(File file) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Object object = new Object();
            try {
                IOUtils$.MODULE$.readLines((FileLike)RichFile$.MODULE$.wrapFile(file), IOUtils$.MODULE$.readLines$default$2(), (Function1)new Serializable(object){
                    public static final long serialVersionUID = 0L;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(String line) {
                        if (line == null) {
                            throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                        }
                        String[] parts = line.split("\\s+", -1);
                        if (parts.length != 9) {
                            throw new IllegalArgumentException(new StringBuilder().append((Object)"bad line format: ").append((Object)line).toString());
                        }
                        String path = parts[0];
                        long lines = new StringOps(Predef$.MODULE$.augmentString(parts[2])).toLong();
                        long bytes = new StringOps(Predef$.MODULE$.augmentString(parts[4])).toLong();
                        long gzip = new StringOps(Predef$.MODULE$.augmentString(parts[6])).toLong();
                        long bzip2 = new StringOps(Predef$.MODULE$.augmentString(parts[8])).toLong();
                        CreateDownloadPage$.MODULE$.titles().update((Object)path, (Object)new StringBuilder().append((Object)"Lines:\u00a0").append((Object)CreateDownloadPage$.MODULE$.org$dbpedia$extraction$scripts$CreateDownloadPage$$niceDecimal(lines)).append((Object)"; File\u00a0size\u00a0(download):\u00a0").append((Object)CreateDownloadPage$.MODULE$.org$dbpedia$extraction$scripts$CreateDownloadPage$$niceBytes(bzip2)).append((Object)"; File\u00a0size\u00a0(unpacked):\u00a0").append((Object)CreateDownloadPage$.MODULE$.org$dbpedia$extraction$scripts$CreateDownloadPage$$niceBytes(bytes)).toString());
                    }
                    {
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                nonLocalReturnControl2.value$mcV$sp();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    public String OntologyPage() {
        return this.OntologyPage;
    }

    public String DataC14NPage() {
        return this.DataC14NPage;
    }

    public String DataL10NPage() {
        return this.DataL10NPage;
    }

    public String LinksPage() {
        return this.LinksPage;
    }

    public String DescPage() {
        return this.DescPage;
    }

    public String NLPPage() {
        return this.NLPPage;
    }

    public String tag(String version) {
        return version.replace(".", "");
    }

    public CreateDownloadPage.Ontology ontology() {
        return this.ontology;
    }

    public List<List<CreateDownloadPage.Dataset>> datasets() {
        return this.datasets;
    }

    public List<CreateDownloadPage.Linkset> linksets() {
        return this.linksets;
    }

    public File target() {
        return this.target;
    }

    public void target_$eq(File x$1) {
        this.target = x$1;
    }

    public void main(String[] args) {
        Predef$.MODULE$.require(args != null && args.length >= 1 && new StringOps(Predef$.MODULE$.augmentString(args[0])).nonEmpty(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "need one arg: file containing data file paths and their content numbers; second arg: target folder (optional)";
            }
        });
        this.loadTitles(new File(args[0]));
        if (args.length > 1) {
            this.target_$eq(new File(args[1]));
        }
        this.generate();
    }

    public void generate() {
        StringPlusser s = new StringPlusser().$plus((Object)this.mark("")).$plus((Object)"==DBpedia ").$plus((Object)this.current()).$plus((Object)" Downloads==\n").$plus((Object)"\n").$plus((Object)"This pages provides downloads of the DBpedia datasets. The DBpedia datasets are licensed under the terms of the ").$plus((Object)"((http://en.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License Creative Commons Attribution-ShareAlike License)) ").$plus((Object)"and the ((http://en.wikipedia.org/wiki/Wikipedia:Text_of_the_GNU_Free_Documentation_License GNU Free Documentation License)). ").$plus((Object)"http://m.okfn.org/images/ok_buttons/od_80x15_red_green.png The downloads are provided as N-Triples and N-Quads, ").$plus((Object)"where the N-Quads version contains additional provenance information for each statement. All files are ((http://www.bzip.org/ bzip2)) [[*1]] packed.\n").$plus((Object)"\n").$plus((Object)"Older Versions: ").$plus((Object)((TraversableOnce)this.previous().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String version) {
                return new StringBuilder().append((Object)"((Downloads").append((Object)CreateDownloadPage$.MODULE$.tag(version)).append((Object)" DBpedia ").append((Object)version).append((Object)"))").toString();
            }
        }, List$.MODULE$.canBuildFrom())).mkString(", ")).$plus((Object)"\n").$plus((Object)"\n").$plus((Object)"See also the ((ChangeLog change log)) for recent changes and developments.\n").$plus((Object)"\n").$plus((Object)"{{ToC numerate=1 from=h2 to=h2}}\n").$plus((Object)"\n").$plus((Object)"=== Wikipedia Input Files ===\n").$plus((Object)"\n").$plus((Object)this.dumpDates()).$plus((Object)"\n").$plus((Object)this.include(this.OntologyPage())).$plus((Object)this.include(this.DataC14NPage())).$plus((Object)this.include(this.DataL10NPage())).$plus((Object)this.include(this.LinksPage())).$plus((Object)this.include(this.DescPage())).$plus((Object)this.include(this.NLPPage())).$plus((Object)"\n").$plus((Object)"[[#1]] Most files were packed with ((http://compression.ca/pbzip2/ pbzip2)), which generates concatenated streams. ").$plus((Object)"Some older bzip2 decompressors, for example ((https://issues.apache.org/jira/browse/COMPRESS-162 Apache Commons Compress before version 1.4)), ").$plus((Object)"cannot handle this format. Please make sure that you use the latest version. ").$plus((Object)"((https://lists.sourceforge.net/lists/listinfo/dbpedia-discussion/ Let us know)) if you experience any problems.\n").$plus((Object)"\n").$plus((Object)this.mark(""));
        this.write("", s.toString());
        this.ontologyPage(this.OntologyPage(), "download-");
        this.datasetPages(this.DataC14NPage(), "download-c14n-", (Seq<List<CreateDownloadPage.Fileset>>)this.datasets());
        this.datasetPages(this.DataL10NPage(), "download-l10n-", (Seq<List<CreateDownloadPage.Fileset>>)this.datasets());
        this.datasetPages(this.LinksPage(), "download-", (Seq<List<CreateDownloadPage.Fileset>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new List[]{this.linksets()})));
        this.descriptionPage(this.DescPage());
        this.nlpPage(this.NLPPage());
    }

    public void ontologyPage(String page, String anchor) {
        String format = "owl";
        CreateDownloadPage.FileInfo file = this.ontology().file("", "", format, true);
        StringPlusser s = new StringPlusser().$plus((Object)this.mark(page)).$plus((Object)"===Ontology===\n").$plus((Object)"#||\n").$plus((Object)"||**Dataset**|**").$plus((Object)format).$plus((Object)"**||\n").$plus((Object)"||{{a name=\"").$plus((Object)this.ontology().anchor(anchor)).$plus((Object)"\"}}((#").$plus((Object)this.ontology().anchor(this.ontology().anchor$default$1())).$plus((Object)" ").$plus((Object)this.ontology().name()).$plus((Object)"))\n").$plus((Object)"|");
        this.link(s, file, format);
        s.$plus((Object)"||\n").$plus((Object)"||#\n").$plus((Object)this.mark(page));
        this.write(page, s.toString());
    }

    public void datasetPages(String page, String anchor, Seq<List<CreateDownloadPage.Fileset>> filesets) {
        String string;
        block5: {
            String string2;
            block9: {
                List list;
                block7: {
                    block8: {
                        block6: {
                            StringPlusser s;
                            block3: {
                                StringPlusser stringPlusser;
                                block4: {
                                    block2: {
                                        s = new StringPlusser();
                                        s.$plus((Object)this.mark(page));
                                        string = page;
                                        String string3 = this.DataC14NPage();
                                        String string4 = string;
                                        if (string3 != null ? !string3.equals(string4) : string4 != null) break block2;
                                        stringPlusser = s.$plus((Object)"===Canonicalized Datasets===\n").$plus((Object)"These datasets contain triples extracted from the respective Wikipedia whose subject and object resource have an equivalent English article. ((").$plus((Object)this.l10nDatasetsSection()).$plus((Object)" more...))\n").$plus((Object)"\n").$plus((Object)"All DBpedia IRIs/URIs in the canonicalized datasets use the generic namespace //~http://dbpedia.org/resource/ //. For backwards compatibility, the N-Triples files (.nt, .nq) use URIs, e.g. //~http://dbpedia.org/resource/Bras%C3%ADlia //. The Turtle (.ttl) files use IRIs, e.g. //~http://dbpedia.org/resource/Bras\u00edlia //.\n");
                                        break block3;
                                    }
                                    String string5 = this.DataL10NPage();
                                    String string6 = string;
                                    if (string5 != null ? !string5.equals(string6) : string6 != null) break block4;
                                    stringPlusser = s.$plus((Object)"===Localized Datasets===\n").$plus((Object)"These datasets contain triples extracted from the respective Wikipedia, including the ones whose URIs do not have an equivalent English article. ((").$plus((Object)this.l10nDatasetsSection()).$plus((Object)" more...))\n").$plus((Object)"\n").$plus((Object)"The localized datasets use DBpedia IRIs (not URIs) and language-specific namespaces, e.g. //~http://pt.dbpedia.org/resource/Bras\u00edlia//.\n");
                                    break block3;
                                }
                                String string7 = this.LinksPage();
                                String string8 = string;
                                if (string7 != null ? !string7.equals(string8) : string8 != null) break block5;
                                stringPlusser = s.$plus((Object)"===Links to other datasets===\n").$plus((Object)"These datasets contain triples linking DBpedia to many other datasets.\n").$plus((Object)"\n").$plus((Object)"The URIs in these dumps use the generic namespace //~http://dbpedia.org/resource/ //.\n");
                            }
                            s.$plus((Object)"\n").$plus((Object)"**NOTE: You can find DBpedia dumps in ").$plus(this.allLanguages()).$plus((Object)" languages at our ((").$plus((Object)this.dbpediaUrl()).$plus((Object)this.current()).$plus((Object)"/ DBpedia download server)).**\n").$plus((Object)"\n").$plus((Object)"//Click on the dataset names to obtain additional information. Click on the question mark next to a download link to preview file contents.//\n");
                            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), filesets.length()).foreach((Function1)new Serializable(page, s){
                                public static final long serialVersionUID = 0L;
                                private final String page$1;
                                private final StringPlusser s$1;

                                public final StringPlusser apply(int subPage) {
                                    return this.s$1.$plus((Object)CreateDownloadPage$.MODULE$.include(new StringBuilder().append((Object)this.page$1).append((Object)BoxesRunTime.boxToInteger((int)subPage)).toString()));
                                }
                                {
                                    this.page$1 = page$1;
                                    this.s$1 = s$1;
                                }
                            });
                            s.$plus((Object)this.mark(page));
                            this.write(page, s.toString());
                            string2 = page;
                            String string9 = this.DataC14NPage();
                            String string10 = string2;
                            if (string9 != null ? !string9.equals(string10) : string10 != null) break block6;
                            list = this.languages();
                            break block7;
                        }
                        String string11 = this.DataL10NPage();
                        String string12 = string2;
                        if (string11 != null ? !string11.equals(string12) : string12 != null) break block8;
                        list = this.languages().drop(1);
                        break block7;
                    }
                    String string13 = this.LinksPage();
                    String string14 = string2;
                    if (string13 != null ? !string13.equals(string14) : string14 != null) break block9;
                    list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"links"}));
                }
                List langs = list;
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), filesets.length()).foreach$mVc$sp((Function1)new Serializable(page, anchor, filesets, langs){
                    public static final long serialVersionUID = 0L;
                    private final String page$1;
                    private final String anchor$1;
                    private final Seq filesets$1;
                    private final List langs$1;

                    public final void apply(int subPage) {
                        this.apply$mcVI$sp(subPage);
                    }

                    public void apply$mcVI$sp(int subPage) {
                        CreateDownloadPage$.MODULE$.datasetPage(this.page$1, subPage, this.anchor$1, (List<CreateDownloadPage.Fileset>)((List)this.filesets$1.apply(subPage)), (Seq<String>)this.langs$1);
                    }
                    {
                        this.page$1 = page$1;
                        this.anchor$1 = anchor$1;
                        this.filesets$1 = filesets$1;
                        this.langs$1 = langs$1;
                    }
                });
                return;
            }
            throw new MatchError((Object)string2);
        }
        throw new MatchError((Object)string);
    }

    public void datasetPage(String page, int subPage, String anchor, List<CreateDownloadPage.Fileset> filesets, Seq<String> languages) {
        StringPlusser s = new StringPlusser();
        s.$plus((Object)this.mark(new StringBuilder().append((Object)page).append((Object)BoxesRunTime.boxToInteger((int)subPage)).toString())).$plus((Object)"#||\n").$plus((Object)languages.mkString("||**Dataset**|**", "**|**", "**||")).$plus((Object)"\n");
        filesets.withFilter((Function1)new Serializable(page){
            public static final long serialVersionUID = 0L;
            private final String page$2;

            public final boolean apply(CreateDownloadPage.Fileset fileset) {
                return fileset.pages() == null || fileset.pages().contains((Object)this.page$2);
            }
            {
                this.page$2 = page$2;
            }
        }).foreach((Function1)new Serializable(page, anchor, languages, s){
            public static final long serialVersionUID = 0L;
            public final String page$2;
            private final String anchor$2;
            private final Seq languages$1;
            public final StringPlusser s$2;

            public final StringPlusser apply(CreateDownloadPage.Fileset fileset) {
                this.s$2.$plus((Object)"||{{a name=\"").$plus((Object)fileset.anchor(this.anchor$2)).$plus((Object)"\"}}((#").$plus((Object)fileset.anchor(fileset.anchor$default$1())).$plus((Object)" ").$plus((Object)RichString$.MODULE$.wrapString(fileset.name()).replaceChars("~", "")).$plus((Object)"))\n");
                BooleanRef first = new BooleanRef(true);
                this.languages$1.foreach((Function1)new Serializable(this, fileset, first){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.datasetPage.2 $outer;
                    public final CreateDownloadPage.Fileset fileset$1;
                    private final BooleanRef first$1;

                    public final void apply(String language) {
                        String string;
                        block5: {
                            String string2;
                            block3: {
                                block4: {
                                    block2: {
                                        string = this.$outer.page$2;
                                        String string3 = CreateDownloadPage$.MODULE$.DataC14NPage();
                                        String string4 = string;
                                        if (string3 != null ? !string3.equals(string4) : string4 != null) break block2;
                                        String string5 = language;
                                        String string6 = "en";
                                        string2 = !(string5 != null ? !string5.equals(string6) : string6 != null) ? "" : "_en_uris";
                                        break block3;
                                    }
                                    String string7 = CreateDownloadPage$.MODULE$.DataL10NPage();
                                    String string8 = string;
                                    if (string7 != null ? !string7.equals(string8) : string8 != null) break block4;
                                    string2 = "";
                                    break block3;
                                }
                                String string9 = CreateDownloadPage$.MODULE$.LinksPage();
                                String string10 = string;
                                if (string9 != null ? !string9.equals(string10) : string10 != null) break block5;
                                string2 = "";
                            }
                            String modifier = string2;
                            this.$outer.s$2.$plus((Object)"|");
                            this.fileset$1.formats().foreach((Function1)new Serializable(this, language, modifier){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$datasetPage$2$$anonfun$apply$1 $outer;
                                private final String language$1;
                                private final String modifier$1;

                                public final Object apply(String format) {
                                    StringPlusser stringPlusser;
                                    CreateDownloadPage.FileInfo file = this.$outer.fileset$1.file(this.language$1, this.modifier$1, format, false);
                                    if (file == null) {
                                        stringPlusser = this.$outer.org$dbpedia$extraction$scripts$CreateDownloadPage$$anonfun$$anonfun$$$outer().s$2.$plus((Object)"<#--#>\n");
                                    } else {
                                        CreateDownloadPage$.MODULE$.link(this.$outer.org$dbpedia$extraction$scripts$CreateDownloadPage$$anonfun$$anonfun$$$outer().s$2, file, format);
                                        stringPlusser = BoxedUnit.UNIT;
                                    }
                                    return stringPlusser;
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.language$1 = language$1;
                                    this.modifier$1 = modifier$1;
                                }
                            });
                            this.first$1.elem = false;
                            return;
                        }
                        throw new MatchError((Object)string);
                    }

                    public /* synthetic */ anonfun.datasetPage.2 org$dbpedia$extraction$scripts$CreateDownloadPage$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.fileset$1 = fileset$1;
                        this.first$1 = first$1;
                    }
                });
                return this.s$2.$plus((Object)"||\n");
            }
            {
                this.page$2 = page$2;
                this.anchor$2 = anchor$2;
                this.languages$1 = languages$1;
                this.s$2 = s$2;
            }
        });
        s.$plus((Object)"||#\n").$plus((Object)this.mark(new StringBuilder().append((Object)page).append((Object)BoxesRunTime.boxToInteger((int)subPage)).toString()));
        this.write(new StringBuilder().append((Object)page).append((Object)BoxesRunTime.boxToInteger((int)subPage)).toString(), s.toString());
    }

    public void link(StringPlusser s, CreateDownloadPage.FileInfo file, String format) {
        s.$plus((Object)"<#<small>").$plus((Object)"<a href=\"").$plus((Object)file.downloadUrl()).$plus((Object)"\" title=\"").$plus((Object)file.title()).$plus((Object)"\">").$plus((Object)format).$plus((Object)"</a>\u00a0").$plus((Object)"<small><a href=\"").$plus((Object)file.previewUrl()).$plus((Object)"\">?</a></small>").$plus((Object)"</small>#>\n");
    }

    public void descriptionPage(String page) {
        StringPlusser s = new StringPlusser();
        s.$plus((Object)this.mark(page)).$plus((Object)"=== Dataset Descriptions ===\n").$plus((Object)"\n");
        CreateDownloadPage.Ontology ontology = this.ontology();
        ((List)((List)this.datasets().flatten((Function1)Predef$.MODULE$.conforms())).$plus$plus(this.linksets(), List$.MODULE$.canBuildFrom())).$colon$colon((Object)ontology).foreach((Function1)new Serializable(s){
            public static final long serialVersionUID = 0L;
            private final StringPlusser s$3;

            public final StringPlusser apply(CreateDownloadPage.Fileset fileset) {
                return this.s$3.$plus((Object)"{{a name=\"").$plus((Object)fileset.anchor(fileset.anchor$default$1())).$plus((Object)"\"}}\n").$plus((Object)"==== ").$plus((Object)fileset.name()).$plus((Object)" ====\n").$plus((Object)fileset.text()).$plus((Object)"\n");
            }
            {
                this.s$3 = s$3;
            }
        });
        s.$plus((Object)this.mark(page));
        this.write(page, s.toString());
    }

    public void nlpPage(String page) {
        StringPlusser s = new StringPlusser();
        s.$plus((Object)this.mark(page)).$plus((Object)"===NLP Datasets===\n").$plus((Object)"\n").$plus((Object)"DBpedia also includes a number of ((Datasets/NLP NLP Datasets)) -- datasets specifically targeted ").$plus((Object)"at supporting Computational Linguistics and Natural Language Processing (NLP) tasks. Among those, ").$plus((Object)"we highlight the Lexicalization Dataset, Topic Signatures, Thematic Concepts and Grammatical Genders.\n").$plus((Object)this.mark(page));
        this.write(page, s.toString());
    }

    public String mark(String page) {
        return new StringBuilder().append((Object)"<#<!--\n\n\nPLEASE DO NOT EDIT THIS WIKI PAGE!\n\n\nYOUR CHANGES WILL BE LOST IN THE NEXT RELEASE!\n\n\nPlease edit CreateDownloadPage.scala instead.\n\n\nPaste this result page of CreateDownloadPage.scala here:\nhttp://wiki.dbpedia.org/Downloads").append((Object)this.tag(this.current())).append((Object)page).append((Object)"/edit\n\n\n").append((Object)"-->#>\n\n\n").toString();
    }

    public String include(String page) {
        return new StringBuilder().append((Object)"{{Include page=/Downloads").append((Object)this.tag(this.current())).append((Object)page).append((Object)" nomark=1}}\n").toString();
    }

    public void write(String page, String content) {
        Writer writer2 = IOUtils$.MODULE$.writer((FileLike)RichFile$.MODULE$.wrapFile(new File(this.target(), new StringBuilder().append((Object)"Downloads").append((Object)this.tag(this.current())).append((Object)page).append((Object)".wacko").toString())), IOUtils$.MODULE$.writer$default$2());
        try {
            writer2.write(content);
            return;
        }
        finally {
            writer2.close();
        }
    }

    private CreateDownloadPage$() {
        MODULE$ = this;
        this.current = "3.9";
        this.previous = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3.8", "3.7", "3.6", "3.5.1", "3.5", "3.4", "3.3", "3.2", "3.1", "3.0", "3.0RC", "2.0"}));
        this.dumpDates = new StringBuilder().append((Object)"The datasets were extracted from ((http://dumps.wikimedia.org/ Wikipedia dumps)) generated in late March / early April 2013. We used a ((http://www.wikidata.org/ Wikidata)) cross-language link dump from June 2013 to interconnect concepts between languages. See also all ((DumpDatesDBpedia").append((Object)this.tag(this.current())).append((Object)" specific dump dates and times)).\n").toString();
        this.allLanguages = 119;
        this.languages = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"en", "ca", "de", "es", "eu", "fr", "id", "it", "ja", "ko", "nl", "pl", "pt", "ru", "tr"}));
        this.l10nDatasetsSection = "Datasets#h18-19";
        this.dbpediaUrl = "http://downloads.dbpedia.org/";
        this.zipSuffix = ".bz2";
        this.titles = new HashMap();
        this.formatter = new DecimalFormat("0.#", new DecimalFormatSymbols(Locale.ENGLISH));
        this.OntologyPage = "Ontology";
        this.DataC14NPage = "DataC14N";
        this.DataL10NPage = "DataL10N";
        this.LinksPage = "Links";
        this.DescPage = "Desc";
        this.NLPPage = "NLP";
        this.ontology = new CreateDownloadPage.Ontology("DBpedia Ontology", new StringBuilder().append((Object)"dbpedia_").append((Object)this.current()).toString(), "//The DBpedia ontology in OWL. See ((http://svn.aksw.org/papers/2013/SWJ_DBpedia/public.pdf our SWJ paper)) for more details.//");
        this.datasets = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new List[]{List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateDownloadPage.Dataset[]{new CreateDownloadPage.Dataset("Mapping-based Types", "instance_types", "//Contains triples of the form $object rdf:type $class from the mapping-based extraction.//", CreateDownloadPage$Dataset$.MODULE$.$lessinit$greater$default$4()), new CreateDownloadPage.Dataset("Mapping-based Types (Heuristic)", "instance_types_heuristic", "//Contains 3.4M additional triples of the form $object rdf:type $class that were generated using the heuristic described in ((http://www.heikopaulheim.com/documents/iswc2013.pdf Paulheim/Bizer: Type Inference on Noisy RDF Data (ISWC 2013))). The estimated precision of those statements is 95%.//", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.DataC14NPage()})))), new CreateDownloadPage.Dataset("Mapping-based Properties", "mappingbased_properties", "//High-quality data extracted from Infoboxes using the mapping-based extraction. The predicates in this dataset are in the /ontology/ namespace.//\n  Note that this data is of much higher quality than the Raw Infobox Properties in the /property/ namespace. For example, there are three different raw Wikipedia infobox properties for the birth date of a person. In the the /ontology/ namespace, they are all **mapped onto one relation** http://dbpedia.org/ontology/birthDate. It is a strong point of DBpedia to unify these relations.", CreateDownloadPage$Dataset$.MODULE$.$lessinit$greater$default$4()), new CreateDownloadPage.Dataset("Mapping-based Properties (Cleaned)", "mappingbased_properties_cleaned", "//This file contains the statements from the Mapping-based Properties, with incorrect statements identified by heuristic inference being removed.//", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.DataC14NPage()})))), new CreateDownloadPage.Dataset("Mapping-based Properties (Specific)", "specific_mappingbased_properties", "//Infobox data from the mapping-based extraction, using units of measurement more convenient for the resource type, e.g. square kilometres instead of square metres for the area of a city.//", CreateDownloadPage$Dataset$.MODULE$.$lessinit$greater$default$4())})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateDownloadPage.Dataset[]{new CreateDownloadPage.Dataset("Titles", "labels", "//Titles of all Wikipedia Articles in the corresponding language.//", CreateDownloadPage$Dataset$.MODULE$.$lessinit$greater$default$4()), new CreateDownloadPage.Dataset("Short Abstracts", "short_abstracts", "//Short Abstracts (max. 500 characters long) of Wikipedia articles.//", CreateDownloadPage$Dataset$.MODULE$.$lessinit$greater$default$4()), new CreateDownloadPage.Dataset("Extended Abstracts", "long_abstracts", "//Full abstracts of Wikipedia articles, usually the first section.//", CreateDownloadPage$Dataset$.MODULE$.$lessinit$greater$default$4()), new CreateDownloadPage.Dataset("Images", "images", "//Main image and corresponding thumbnail from Wikipedia article.//", CreateDownloadPage$Dataset$.MODULE$.$lessinit$greater$default$4())})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateDownloadPage.Dataset[]{new CreateDownloadPage.Dataset("Geographic Coordinates", "geo_coordinates", "//Geographic coordinates extracted from Wikipedia.//", CreateDownloadPage$Dataset$.MODULE$.$lessinit$greater$default$4()), new CreateDownloadPage.Dataset("Raw Infobox Properties", "raw_infobox_properties", "//Information that has been extracted from Wikipedia infoboxes. Note that this data is in the less clean /property/ namespace. The Mapping-based Properties (/ontology/ namespace) should always be preferred over this data.//", CreateDownloadPage$Dataset$.MODULE$.$lessinit$greater$default$4()), new CreateDownloadPage.Dataset("Raw Infobox Property Definitions", "raw_infobox_property_definitions", "//All properties / predicates used in infoboxes.//", CreateDownloadPage$Dataset$.MODULE$.$lessinit$greater$default$4()), new CreateDownloadPage.Dataset("Homepages", "homepages", "//Links to homepages of persons, organizations etc.//", CreateDownloadPage$Dataset$.MODULE$.$lessinit$greater$default$4())})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateDownloadPage.Dataset[]{new CreateDownloadPage.Dataset("Persondata", "persondata", "//Information about persons (date and place of birth etc.) extracted from the English and German Wikipedia, represented using the FOAF vocabulary.//", CreateDownloadPage$Dataset$.MODULE$.$lessinit$greater$default$4()), new CreateDownloadPage.Dataset("PND", "pnd", "//Dataset containing PND (Personennamendatei) identifiers.//", CreateDownloadPage$Dataset$.MODULE$.$lessinit$greater$default$4()), new CreateDownloadPage.Dataset("Inter-Language Links", "interlanguage_links", "//Dataset linking a DBpedia resource to the same resource in other languages and in ((http://www.wikidata.org Wikidata)). Since the inter-language links were moved from Wikipedia to Wikidata, we now extract these links from the Wikidata dump, not from Wikipedia pages.//", CreateDownloadPage$Dataset$.MODULE$.$lessinit$greater$default$4())})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateDownloadPage.Dataset[]{new CreateDownloadPage.Dataset("Articles Categories", "article_categories", "//Links from concepts to categories using the SKOS vocabulary.//", CreateDownloadPage$Dataset$.MODULE$.$lessinit$greater$default$4()), new CreateDownloadPage.Dataset("Categories (Labels)", "category_labels", "//Labels for Categories.//", CreateDownloadPage$Dataset$.MODULE$.$lessinit$greater$default$4()), new CreateDownloadPage.Dataset("Categories (Skos)", "skos_categories", "//Information which concept is a category and how categories are related using the SKOS Vocabulary.//", CreateDownloadPage$Dataset$.MODULE$.$lessinit$greater$default$4())})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateDownloadPage.Dataset[]{new CreateDownloadPage.Dataset("External Links", "external_links", "//Links to external web pages about a concept.//", CreateDownloadPage$Dataset$.MODULE$.$lessinit$greater$default$4()), new CreateDownloadPage.Dataset("Links to Wikipedia Article", "wikipedia_links", "//Dataset linking DBpedia resource to corresponding article in Wikipedia.//", CreateDownloadPage$Dataset$.MODULE$.$lessinit$greater$default$4()), new CreateDownloadPage.Dataset("Wikipedia Pagelinks", "page_links", "//Dataset containing internal links between DBpedia instances. The dataset was created from the internal links between Wikipedia articles. The dataset might be useful for structural analysis, data mining or for ranking DBpedia instances using Page Rank or similar algorithms.//", CreateDownloadPage$Dataset$.MODULE$.$lessinit$greater$default$4())})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateDownloadPage.Dataset[]{new CreateDownloadPage.Dataset("Redirects", "redirects", "//Dataset containing redirects between articles in Wikipedia.//", CreateDownloadPage$Dataset$.MODULE$.$lessinit$greater$default$4()), new CreateDownloadPage.Dataset("Transitive Redirects", "redirects_transitive", "//Redirects dataset in which multiple redirects have been resolved and redirect cycles have been removed.//", CreateDownloadPage$Dataset$.MODULE$.$lessinit$greater$default$4()), new CreateDownloadPage.Dataset("Disambiguation links", "disambiguations", "//Links extracted from Wikipedia ((http://en.wikipedia.org/wiki/Wikipedia:Disambiguation disambiguation)) pages. Since Wikipedia has no syntax to distinguish disambiguation links from ordinary links, DBpedia has to use heuristics.//", CreateDownloadPage$Dataset$.MODULE$.$lessinit$greater$default$4()), new CreateDownloadPage.Dataset("IRI-same-as-URI links", "iri_same_as_uri", "//owl:sameAs links between the ((http://tools.ietf.org/html/rfc3987 IRI)) and ((http://tools.ietf.org/html/rfc3986 URI)) format of DBpedia resources. Only extracted when IRI and URI are actually different.//", CreateDownloadPage$Dataset$.MODULE$.$lessinit$greater$default$4())})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateDownloadPage.Dataset[]{new CreateDownloadPage.Dataset("Page IDs", "page_ids", "//Dataset linking a DBpedia resource to the page ID of the Wikipedia article the data was extracted from.//", CreateDownloadPage$Dataset$.MODULE$.$lessinit$greater$default$4()), new CreateDownloadPage.Dataset("Revision IDs", "revision_ids", "//Dataset linking a DBpedia resource to the revision ID of the Wikipedia article the data was extracted from. Until DBpedia 3.7, these files had names like 'revisions_en.nt'. Since DBpedia 3.9, they were renamed to 'revisions_ids_en.nt' to distinguish them from the new 'revision_uris_en.nt' files.//", CreateDownloadPage$Dataset$.MODULE$.$lessinit$greater$default$4()), new CreateDownloadPage.Dataset("Revision URIs", "revision_uris", "//Dataset linking DBpedia resource to the specific Wikipedia article revision used in this DBpedia release.//", CreateDownloadPage$Dataset$.MODULE$.$lessinit$greater$default$4())}))}));
        this.linksets = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateDownloadPage.Linkset[]{new CreateDownloadPage.Linkset("Links to Amsterdam Museum data", "amsterdammuseum_links", "//Links between DBpedia and ((http://semanticweb.cs.vu.nl/lod/am/ Amsterdam Museum)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/amsterdammuseum Silk link specification)).//"), new CreateDownloadPage.Linkset("Links to BBC Wildlife Finder", "bbcwildlife_links", "//Links between DBpedia and ((http://www.bbc.co.uk/wildlifefinder/ BBC Wildlife Finder)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/bbcwildlife Silk link specification)).//"), new CreateDownloadPage.Linkset("Links to RDF Bookmashup", "bookmashup_links", "//Links between books in DBpedia and data about them provided by the ((http://www4.wiwiss.fu-berlin.de/bizer/bookmashup/ RDF Book Mashup)). Update mechanism: copy over from previous release.//"), new CreateDownloadPage.Linkset("Links to Bricklink", "bricklink_links", "//Links between DBpedia and ((http://kasabi.com/dataset/bricklink Bricklink)). Links created manually.//"), new CreateDownloadPage.Linkset("Links to CORDIS", "cordis_links", "//Links between DBpedia and ((http://www4.wiwiss.fu-berlin.de/cordis/ CORDIS)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/cordis Silk link specifications)).//"), new CreateDownloadPage.Linkset("Links to ~DailyMed", "dailymed_links", "//Links between DBpedia and ((http://www4.wiwiss.fu-berlin.de/dailymed/ DailyMed)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/dailymed Silk link specifications)).//"), new CreateDownloadPage.Linkset("Links to DBLP", "dblp_links", "//Links between computer scientists in DBpedia and their publications in the ((http://www.informatik.uni-trier.de/~ley/db/ DBLP)) database. Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/dblp Silk link specification)).//"), new CreateDownloadPage.Linkset("Links to DBTune", "dbtune_links", "//Links between DBpedia and ((http://dbtune.org/ DBTune)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/dbtune Silk link specifications)).//"), new CreateDownloadPage.Linkset("Links to Diseasome", "diseasome_links", "//Links between DBpedia and ((http://www4.wiwiss.fu-berlin.de/diseasome/ Diseasome)).  Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/diseasome Silk link specifications)).//"), new CreateDownloadPage.Linkset("Links to ~DrugBank", "drugbank_links", "//Links between DBpedia and ((http://www4.wiwiss.fu-berlin.de/drugbank/ DrugBank)).  Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/drugbank Silk link specifications)).//"), new CreateDownloadPage.Linkset("Links to EUNIS", "eunis_links", "//Links between DBpedia and ((http://eunis.eea.europa.eu EUNIS)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/eunis Silk link specification)).//"), new CreateDownloadPage.Linkset("Links to Eurostat (Linked Statistics)", "eurostat_linkedstatistics_links", "//Links between DBpedia and ((http://eurostat.linked-statistics.org Eurostat (Linked Statistics))). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/eurostat_linkedstatistics Silk link specifications)).//"), new CreateDownloadPage.Linkset("Links to Eurostat (WBSG)", "eurostat_wbsg_links", "//Links between countries and regions in DBpedia and data about them from ((http://www4.wiwiss.fu-berlin.de/eurostat/ Eurostat (WBSG))). Links created manually.//"), new CreateDownloadPage.Linkset("Links to CIA World Factbook", "factbook_links", "//Links between DBpedia and the ((http://www4.wiwiss.fu-berlin.de/factbook/ CIA World Factbook)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/factbook Silk link specifications)).//"), new CreateDownloadPage.Linkset("Links to flickr wrappr", "flickrwrappr_links", "//Links between DBpedia concepts and photo collections depicting them generated by ((http://www4.wiwiss.fu-berlin.de/flickrwrappr/ flickr wrappr)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/extraction_framework/file/dump/core/src/main/scala/org/dbpedia/extraction/mappings/FlickrWrapprLinkExtractor.scala Scala extractor)).//"), new CreateDownloadPage.Linkset("Links to Freebase", "freebase_links", "//Links between DBpedia and ((http://www.freebase.com/ Freebase (MIDs))). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/extraction_framework/file/dump/scripts/src/main/scala/org/dbpedia/extraction/scripts/CreateFreebaseLinks.scala Scala script)).//"), new CreateDownloadPage.Linkset("Links to GADM", "gadm_links", "//Links between DBpedia and ((http://gadm.geovocab.org/ GADM)). Links created by ((https://github.com/dbpedia/dbpedia-links/tree/master/datasets/dbpedia.org/gadm.geovocab.org/scripts Java program)).//"), new CreateDownloadPage.Linkset("Links to ~GeoNames", "geonames_links", "//Links between geographic places in DBpedia and data about them from ((http://www.geonames.org/ GeoNames)). Update mechanism: ((https://github.com/dbpedia/extraction-framework/blob/dump/scripts/src/main/bash/process-geonames.txt generated from latest GeoNames datasets)).//"), new CreateDownloadPage.Linkset("Links to ~GeoSpecies", "geospecies_links", "//Links between DBpedia and ((http://lod.geospecies.org/ GeoSpecies)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/geospecies Silk link specification)).//"), new CreateDownloadPage.Linkset("Links to GHO", "gho_links", "//Links between DBpedia and ((http://gho.aksw.org GHO)) (Global Health Observatory). Links created by ((http://aksw.org/Projects/LIMES LIMES)).//"), new CreateDownloadPage.Linkset("Links to Project Gutenberg", "gutenberg_links", "//Links between writers in DBpedia and data about them from ((www4.wiwiss.fu-berlin.de/gutendata/ Project Gutenberg)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/gutenberg Silk link specification)).//"), new CreateDownloadPage.Linkset("Links to Italian Public Schools", "italian_public_schools_links", "//Links between DBpedia and ((http://www.linkedopendata.it/datasets/scuole Italian Public Schools)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/italian-public-schools Silk link specification)).//"), new CreateDownloadPage.Linkset("Links to ~LinkedGeoData", "linkedgeodata_links", "//Links between DBpedia and ((http://linkedgeodata.org LinkedGeoData)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/linkedgeodata Silk link specifications)).//"), new CreateDownloadPage.Linkset("Links to ~LinkedMDB", "linkedmdb_links", "//Links between DBpedia and ((http://www.linkedmdb.org LinkedMDB)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/linkedmdb Silk link specifications)).//"), new CreateDownloadPage.Linkset("Links to ~MusicBrainz", "musicbrainz_links", "//Links between artists, albums and songs in DBpedia and data about them from ((http://musicbrainz.org/ MusicBrainz)). Update mechanism: copy over from previous release.//"), new CreateDownloadPage.Linkset("Links to New York Times", "nytimes_links", "//Links between ((http://www.nytimes.com/ New York Times)) subject headings and DBpedia concepts. Links copied from the original data set.//"), new CreateDownloadPage.Linkset("Links to ~OpenCyc", "opencyc_links", "//Links between DBpedia and ((http://opencyc.org/ OpenCyc)) concepts. ((OpenCyc Details)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/opencyc PHP script)).//"), new CreateDownloadPage.Linkset("Links to ~OpenEI (Open Energy Info)", "openei_links", "//Links between DBpedia and ((http://en.openei.org OpenEI)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/openei Silk link specifications)).//"), new CreateDownloadPage.Linkset("Links to Revyu", "revyu_links", "//Links between DBpedia and ((http://revyu.com Revyu)). Update mechanism: copy over from previous release.//"), new CreateDownloadPage.Linkset("Links to SIDER", "sider_links", "//Links between DBpedia and ((http://www4.wiwiss.fu-berlin.de/sider/ SIDER)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/sider Silk link specifications)).//"), new CreateDownloadPage.Linkset("Links to RDF-TCM", "tcm_links", "//Links between DBpedia and ((http://code.google.com/p/junsbriefcase/wiki/RDFTCMData TCMGeneDIT)). Links copied from the original data set.//"), new CreateDownloadPage.Linkset("Links to UMBEL", "umbel_links", "//Links between DBpedia and ((http://umbel.org/ UMBEL)). Update mechanism: copy over from previous release.//"), new CreateDownloadPage.Linkset("Links to US Census", "uscensus_links", "//Links between US cities and states in DBpedia and data about them from ((http://www.rdfabout.com/demo/census/ US Census)). Update mechanism: copy over from previous release.//"), new CreateDownloadPage.Linkset("Links to ~WikiCompany", "wikicompany_links", "//Links between companies in DBpedia and companies in ((http://www4.wiwiss.fu-berlin.de/wikicompany/ WikiCompany)). Update mechanism: copy over from previous release.//"), new CreateDownloadPage.Linkset("Links to ~WordNet Classes", "wordnet_links", "//Classification links to ((http://www.w3.org/TR/wordnet-rdf/ RDF representations)) of ((http://wordnet.princeton.edu/ WordNet)) classes. Update mechanism: copy over from previous release.//"), new CreateDownloadPage.Linkset("YAGO links", "yago_links", "//Dataset containing owl:sameAs links between DBpedia and ((http://www.mpi-inf.mpg.de/yago-naga/yago/ YAGO)) instances. Update mechanism: ((https://github.com/dbpedia/extraction-framework/blob/dump/scripts/src/main/bash/process-yago.txt generated from latest YAGO datasets)).//"), new CreateDownloadPage.Linkset("YAGO type links", "yago_type_links", "//Dataset containing owl:equivalentClass links between types in the ~http://dbpedia.org/class/yago/ and ~http://yago-knowledge.org/resource/ namespaces. Update mechanism: ((https://github.com/dbpedia/extraction-framework/blob/dump/scripts/src/main/bash/process-yago.txt generated from latest YAGO datasets)).//"), new CreateDownloadPage.Linkset("YAGO types", "yago_types", "//Dataset containing ((http://www.mpi-inf.mpg.de/yago-naga/yago/ YAGO)) type information for DBpedia resources. Update mechanism: ((https://github.com/dbpedia/extraction-framework/blob/dump/scripts/src/main/bash/process-yago.txt generated from latest YAGO datasets)).//"), new CreateDownloadPage.Linkset("YAGO type hierarchy", "yago_taxonomy", "//Dataset containing the hierarchy of ((http://www.mpi-inf.mpg.de/yago-naga/yago/ YAGO)) classes in the ~http://dbpedia.org/class/yago/ namespace. Update mechanism: ((https://github.com/dbpedia/extraction-framework/blob/dump/scripts/src/main/bash/process-yago.txt generated from latest YAGO datasets)).//")}));
        this.target = null;
    }
}

