/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.scripts;

import java.io.File;
import java.io.OutputStreamWriter;
import org.dbpedia.extraction.scripts.IOUtils$;
import org.dbpedia.extraction.scripts.TurtleEscaper;
import org.dbpedia.extraction.util.FileLike;
import org.dbpedia.extraction.util.RichFile$;
import org.dbpedia.extraction.util.StringUtils$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class FixNTriplesEncoding$
implements ScalaObject {
    public static final FixNTriplesEncoding$ MODULE$;

    static {
        new FixNTriplesEncoding$();
    }

    private String[] split(String arg) {
        return (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])arg.split(",")).map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(String string) {
                return string.trim();
            }
        }, Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(String.class)))).filter((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String string) {
                return Predef$.MODULE$.augmentString(string).nonEmpty();
            }
        });
    }

    public void main(String[] args) {
        Predef$.MODULE$.require(args != null && args.length == 4, (Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "need four args: directory, comma-separated names of input files (e.g. 'bbcwildlife,bookmashup'), output dataset name extension (e.g. '_fixed'), file extension (e.g. '_links.nt.gz')";
            }
        });
        File dir$1 = new File(args[0]);
        String[] inputs = this.split(args[1]);
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])inputs).nonEmpty(), (Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "no input file names";
            }
        });
        String extension$1 = args[2];
        Predef$.MODULE$.require(Predef$.MODULE$.augmentString(extension$1).nonEmpty(), (Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "no output name extension";
            }
        });
        String suffix$1 = args[3];
        Predef$.MODULE$.require(Predef$.MODULE$.augmentString(suffix$1).nonEmpty(), (Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "no input/output file suffix";
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])inputs).foreach((Function1)new Serializable(dir$1, extension$1, suffix$1){
            public static final long serialVersionUID;
            private final File dir$1;
            private final String extension$1;
            private final String suffix$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String input2) {
                File inFile = new File(this.dir$1, new StringBuilder().append((Object)input2).append((Object)this.suffix$1).toString());
                File outFile = new File(this.dir$1, new StringBuilder().append((Object)input2).append((Object)this.extension$1).append((Object)this.suffix$1).toString());
                Console$.MODULE$.err().println(new StringBuilder().append((Object)"reading ").append((Object)inFile).append((Object)" ...").toString());
                Console$.MODULE$.err().println(new StringBuilder().append((Object)"writing ").append((Object)outFile).append((Object)" ...").toString());
                IntRef lineCount$1 = new IntRef(0);
                IntRef changeCount$1 = new IntRef(0);
                long start$1 = System.nanoTime();
                OutputStreamWriter writer$1 = IOUtils$.MODULE$.write((FileLike<?>)RichFile$.MODULE$.wrapFile(outFile), IOUtils$.MODULE$.write$default$2());
                try {
                    IOUtils$.MODULE$.readLines((FileLike<?>)RichFile$.MODULE$.wrapFile(inFile), new Serializable(this, lineCount$1, changeCount$1, start$1, writer$1){
                        public static final long serialVersionUID;
                        private final IntRef lineCount$1;
                        private final IntRef changeCount$1;
                        private final long start$1;
                        private final OutputStreamWriter writer$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply(String line) {
                            String escaped = new TurtleEscaper().escapeTurtle(line);
                            this.writer$1.write(escaped);
                            this.writer$1.write(10);
                            if (line != escaped) {
                                ++this.changeCount$1.elem;
                            }
                            ++this.lineCount$1.elem;
                            if (this.lineCount$1.elem % 1000000 == 0) {
                                FixNTriplesEncoding$.MODULE$.org$dbpedia$extraction$scripts$FixNTriplesEncoding$$log(this.lineCount$1.elem, this.changeCount$1.elem, this.start$1);
                            }
                        }
                        {
                            this.lineCount$1 = intRef;
                            this.changeCount$1 = intRef2;
                            this.start$1 = l;
                            this.writer$1 = outputStreamWriter;
                        }
                    });
                    FixNTriplesEncoding$.MODULE$.org$dbpedia$extraction$scripts$FixNTriplesEncoding$$log(lineCount$1.elem, changeCount$1.elem, start$1);
                    return;
                }
                finally {
                    writer$1.close();
                }
            }
            {
                this.dir$1 = file;
                this.extension$1 = string;
                this.suffix$1 = string2;
            }
        });
    }

    public final void org$dbpedia$extraction$scripts$FixNTriplesEncoding$$log(int lines, int changed, long start) {
        long micros = (System.nanoTime() - start) / 1000L;
        Console$.MODULE$.err().println(new StringBuilder().append((Object)"read ").append((Object)BoxesRunTime.boxToInteger((int)lines)).append((Object)" lines, changed ").append((Object)BoxesRunTime.boxToInteger((int)changed)).append((Object)" lines in ").append((Object)StringUtils$.MODULE$.prettyMillis(micros / 1000L)).append((Object)" (").append((Object)BoxesRunTime.boxToFloat((float)((float)micros / (float)lines))).append((Object)" micros per line)").toString());
    }

    private FixNTriplesEncoding$() {
        MODULE$ = this;
    }
}

