/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.scripts;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.regex.Matcher;
import org.dbpedia.extraction.destinations.DBpediaDatasets$;
import org.dbpedia.extraction.destinations.Dataset;
import org.dbpedia.extraction.scripts.CreateFreebaseLinks;
import org.dbpedia.extraction.scripts.IOUtils$;
import org.dbpedia.extraction.util.FileLike;
import org.dbpedia.extraction.util.Finder;
import org.dbpedia.extraction.util.Language$;
import org.dbpedia.extraction.util.NumberUtils$;
import org.dbpedia.extraction.util.RichFile;
import org.dbpedia.extraction.util.RichFile$;
import org.dbpedia.extraction.util.RichString$;
import org.dbpedia.extraction.util.StringUtils$;
import scala.Console$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Set;
import scala.collection.mutable.SetLike;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.matching.Regex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CreateFreebaseLinks$
implements ScalaObject {
    public static final CreateFreebaseLinks$ MODULE$;
    private final Regex org$dbpedia$extraction$scripts$CreateFreebaseLinks$$WikipediaKey;
    private final String org$dbpedia$extraction$scripts$CreateFreebaseLinks$$Prefix;
    private final String org$dbpedia$extraction$scripts$CreateFreebaseLinks$$Infix;
    private final String org$dbpedia$extraction$scripts$CreateFreebaseLinks$$Suffix;
    private final Regex KeyEscape;

    static {
        new CreateFreebaseLinks$();
    }

    public final Regex org$dbpedia$extraction$scripts$CreateFreebaseLinks$$WikipediaKey() {
        return this.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$WikipediaKey;
    }

    public final String org$dbpedia$extraction$scripts$CreateFreebaseLinks$$Prefix() {
        return this.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$Prefix;
    }

    public final String org$dbpedia$extraction$scripts$CreateFreebaseLinks$$Infix() {
        return this.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$Infix;
    }

    public final String org$dbpedia$extraction$scripts$CreateFreebaseLinks$$Suffix() {
        return this.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$Suffix;
    }

    private Regex KeyEscape() {
        return this.KeyEscape;
    }

    public final void org$dbpedia$extraction$scripts$CreateFreebaseLinks$$unescapeKey(StringBuilder sb, Matcher matcher) {
        sb.append((char)NumberUtils$.MODULE$.hexToInt(matcher.group(1)));
    }

    public final String org$dbpedia$extraction$scripts$CreateFreebaseLinks$$unescapeKey(String key) {
        return RichString$.MODULE$.wrapString(key).replaceBy(this.KeyEscape().pattern(), (Function2)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(StringBuilder stringBuilder, Matcher matcher) {
                CreateFreebaseLinks$.MODULE$.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$unescapeKey(stringBuilder, matcher);
            }
        });
    }

    public void main(String[] args) {
        boolean iris = Predef$.MODULE$.augmentString(args[0]).toBoolean();
        boolean turtle = Predef$.MODULE$.augmentString(args[1]).toBoolean();
        File dir = new File(args[2]);
        String suffix$1 = args[3];
        File inFile = new File(args[4]);
        File outFile = new File(args[5]);
        Finder finder$1 = new Finder((Object)dir, Language$.MODULE$.English(), (Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final RichFile apply(File file) {
                return RichFile$.MODULE$.wrapFile(file);
            }
        });
        String date$1 = (String)finder$1.dates("download-complete", finder$1.dates$default$2()).last();
        File labels = this.find$1(DBpediaDatasets$.MODULE$.Labels(), suffix$1, finder$1, date$1);
        File redirects = this.find$1(DBpediaDatasets$.MODULE$.Redirects(), suffix$1, finder$1, date$1);
        File disambig = this.find$1(DBpediaDatasets$.MODULE$.DisambiguationLinks(), suffix$1, finder$1, date$1);
        HashSet dbpedia = new HashSet();
        this.collectUris((Set<String>)dbpedia, labels, true);
        this.collectUris((Set<String>)dbpedia, redirects, false);
        this.collectUris((Set<String>)dbpedia, disambig, false);
        new CreateFreebaseLinks(iris, turtle).findLinks((Set<String>)dbpedia, inFile, outFile);
    }

    private void collectUris(Set<String> set$1, File file, boolean add$1) {
        long start$1 = System.nanoTime();
        Console$.MODULE$.err().println(new scala.collection.mutable.StringBuilder().append((Object)(add$1 ? "Add" : "Subtract")).append((Object)"ing DBpedia URIs in ").append((Object)file).append((Object)"...").toString());
        IntRef lines$1 = new IntRef(0);
        IOUtils$.MODULE$.readLines((FileLike<?>)RichFile$.MODULE$.wrapFile(file), new Serializable(set$1, add$1, start$1, lines$1){
            public static final long serialVersionUID;
            private final Set set$1;
            private final boolean add$1;
            private final long start$1;
            private final IntRef lines$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String line) {
                if (Predef$.MODULE$.augmentString(line).nonEmpty() && line.charAt(0) != '#') {
                    int close = line.indexOf(62, CreateFreebaseLinks$.MODULE$.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$Prefix().length());
                    if (line.startsWith(CreateFreebaseLinks$.MODULE$.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$Prefix()) && close != -1) {
                        String rdfKey = line.substring(CreateFreebaseLinks$.MODULE$.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$Prefix().length(), close);
                        SetLike setLike = this.add$1 ? this.set$1.$plus$eq((Object)rdfKey) : this.set$1.$minus$eq((Object)rdfKey);
                        ++this.lines$1.elem;
                        if (this.lines$1.elem % 1000000 == 0) {
                            CreateFreebaseLinks$.MODULE$.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$log(this.lines$1.elem, this.start$1);
                        }
                    } else {
                        throw new IllegalArgumentException(line);
                    }
                }
            }
            {
                this.set$1 = set;
                this.add$1 = bl;
                this.start$1 = l;
                this.lines$1 = intRef;
            }
        });
        this.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$log(lines$1.elem, start$1);
    }

    public final void org$dbpedia$extraction$scripts$CreateFreebaseLinks$$log(int lines, long start) {
        long nanos = System.nanoTime() - start;
        Console$.MODULE$.err().println(new scala.collection.mutable.StringBuilder().append((Object)"processed ").append((Object)BoxesRunTime.boxToInteger((int)lines)).append((Object)" lines in ").append((Object)StringUtils$.MODULE$.prettyMillis(nanos / 1000000L)).append((Object)" (").append((Object)BoxesRunTime.boxToFloat((float)((float)nanos / (float)lines))).append((Object)" nanos per line)").toString());
    }

    private final File find$1(Dataset dataset, String string, Finder finder, String string2) {
        File file = (File)finder.file(string2, new scala.collection.mutable.StringBuilder().append((Object)dataset.name().replace('_', '-')).append((Object)string).toString());
        if (file.exists()) {
            return file;
        }
        throw new FileNotFoundException(file.toString());
    }

    private CreateFreebaseLinks$() {
        MODULE$ = this;
        this.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$WikipediaKey = Predef$.MODULE$.augmentString("^([^\\s]+)\\t/type/object/key\\t/wikipedia/en\\t([^\\s]+)$").r();
        this.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$Prefix = "<http://dbpedia.org/resource/";
        this.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$Infix = "> <http://www.w3.org/2002/07/owl#sameAs> <http://rdf.freebase.com/ns/";
        this.org$dbpedia$extraction$scripts$CreateFreebaseLinks$$Suffix = "> .\n";
        this.KeyEscape = Predef$.MODULE$.augmentString("\\$(\\p{XDigit}{4})").r();
    }
}

