/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.scripts;

import java.io.File;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.dbpedia.extraction.scripts.CreateDownloadPage;
import org.dbpedia.extraction.scripts.CreateDownloadPage$;
import org.dbpedia.extraction.scripts.CreateDownloadPage$$anonfun$datasetPage$1$;
import org.dbpedia.extraction.scripts.IOUtils$;
import org.dbpedia.extraction.util.FileLike;
import org.dbpedia.extraction.util.RichFile$;
import org.dbpedia.extraction.util.StringPlusser;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CreateDownloadPage$
implements ScalaObject {
    public static final CreateDownloadPage$ MODULE$;
    private final String current;
    private final String downloads;
    private final String dumps;
    private final String zipSuffix;
    private final HashMap<String, String> titles;
    private final DecimalFormat formatter;
    private final List<String> previous;
    private final String dumpDates;
    private final int allLanguages;
    private final List<String> languages;
    private final CreateDownloadPage.Ontology ontology;
    private final List<List<CreateDownloadPage.Dataset>> datasets;
    private final List<CreateDownloadPage.Linkset> linksets;
    private final String OntologyPage;
    private final String DataC14NPage;
    private final String DataI18NPage;
    private final String LinksPage;
    private final String DescPage;
    private final String NLPPage;

    static {
        new CreateDownloadPage$();
    }

    public String current() {
        return this.current;
    }

    public String downloads() {
        return this.downloads;
    }

    public String dumps() {
        return this.dumps;
    }

    public String zipSuffix() {
        return this.zipSuffix;
    }

    public HashMap<String, String> titles() {
        return this.titles;
    }

    public DecimalFormat formatter() {
        return this.formatter;
    }

    public final String org$dbpedia$extraction$scripts$CreateDownloadPage$$niceDecimal(long num) {
        return num < 1000L ? this.formatter().format(num) : (num < 1000000L ? new StringBuilder().append((Object)this.formatter().format((float)((double)num / 1000.0))).append((Object)"K").toString() : new StringBuilder().append((Object)this.formatter().format((float)((double)num / 1000000.0))).append((Object)"M").toString());
    }

    public final String org$dbpedia$extraction$scripts$CreateDownloadPage$$niceBytes(long bytes) {
        return bytes < 1024L ? this.formatter().format(bytes) : (bytes < 0x100000L ? new StringBuilder().append((Object)this.formatter().format((float)((double)bytes / 1024.0))).append((Object)"KB").toString() : (bytes < 0x40000000L ? new StringBuilder().append((Object)this.formatter().format((float)((double)bytes / 1048576.0))).append((Object)"MB").toString() : new StringBuilder().append((Object)this.formatter().format((float)((double)bytes / 1.073741824E9))).append((Object)"GB").toString()));
    }

    public void loadTitles(File file) {
        IOUtils$.MODULE$.readLines((FileLike<?>)RichFile$.MODULE$.wrapFile(file), new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String line) {
                String[] parts = line.split("\\s+", -1);
                if (parts.length != 9) {
                    throw new IllegalArgumentException("bad line format");
                }
                String path = parts[0];
                long lines = Predef$.MODULE$.augmentString(parts[2]).toLong();
                long bytes = Predef$.MODULE$.augmentString(parts[4]).toLong();
                long gzip = Predef$.MODULE$.augmentString(parts[6]).toLong();
                long bzip2 = Predef$.MODULE$.augmentString(parts[8]).toLong();
                CreateDownloadPage$.MODULE$.titles().update((Object)path, (Object)new StringBuilder().append((Object)"Lines: ").append((Object)CreateDownloadPage$.MODULE$.org$dbpedia$extraction$scripts$CreateDownloadPage$$niceDecimal(lines)).append((Object)"; Filesize(download): ").append((Object)CreateDownloadPage$.MODULE$.org$dbpedia$extraction$scripts$CreateDownloadPage$$niceBytes(bzip2)).append((Object)"; Filesize(unpacked): ").append((Object)CreateDownloadPage$.MODULE$.org$dbpedia$extraction$scripts$CreateDownloadPage$$niceBytes(bytes)).toString());
            }
        });
    }

    public String tag(String version) {
        return version.replace(".", "");
    }

    public List<String> previous() {
        return this.previous;
    }

    public String dumpDates() {
        return this.dumpDates;
    }

    public int allLanguages() {
        return this.allLanguages;
    }

    public List<String> languages() {
        return this.languages;
    }

    public CreateDownloadPage.Ontology ontology() {
        return this.ontology;
    }

    public List<List<CreateDownloadPage.Dataset>> datasets() {
        return this.datasets;
    }

    public List<CreateDownloadPage.Linkset> linksets() {
        return this.linksets;
    }

    public String OntologyPage() {
        return this.OntologyPage;
    }

    public String DataC14NPage() {
        return this.DataC14NPage;
    }

    public String DataI18NPage() {
        return this.DataI18NPage;
    }

    public String LinksPage() {
        return this.LinksPage;
    }

    public String DescPage() {
        return this.DescPage;
    }

    public String NLPPage() {
        return this.NLPPage;
    }

    public void main(String[] args) {
        Predef$.MODULE$.require(args != null && args.length == 1 && Predef$.MODULE$.augmentString(args[0]).nonEmpty(), (Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "need 1 arg: file containing data file paths and their content numbers";
            }
        });
        this.loadTitles(new File(args[0]));
        this.generate();
    }

    public void generate() {
        StringPlusser s = new StringPlusser().$plus((Object)this.mark("")).$plus((Object)"==DBpedia ").$plus((Object)this.current()).$plus((Object)" Downloads==\n").$plus((Object)"\n").$plus((Object)"This pages provides downloads of the DBpedia datasets. The DBpedia datasets are licensed under the terms of the ").$plus((Object)"((http://en.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License Creative Commons Attribution-ShareAlike License)) ").$plus((Object)"and the ((http://en.wikipedia.org/wiki/Wikipedia:Text_of_the_GNU_Free_Documentation_License GNU Free Documentation License)). ").$plus((Object)"http://m.okfn.org/images/ok_buttons/od_80x15_red_green.png The downloads are provided as N-Triples and N-Quads, ").$plus((Object)"where the N-Quads version contains additional provenance information for each statement. All files are ((http://www.bzip.org/ bzip2)) [[*1]] packed.\n").$plus((Object)"\n").$plus((Object)"Older Versions: ").$plus((Object)((TraversableOnce)this.previous().map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(String version) {
                return new StringBuilder().append((Object)"((Downloads").append((Object)CreateDownloadPage$.MODULE$.tag(version)).append((Object)" DBpedia ").append((Object)version).append((Object)"))").toString();
            }
        }, List$.MODULE$.canBuildFrom())).mkString(", ")).$plus((Object)"\n").$plus((Object)"\n").$plus((Object)"See also the ((ChangeLog change log)) for recent changes and developments.\n").$plus((Object)"\n").$plus((Object)"{{ToC numerate=1 from=h2 to=h2}}\n").$plus((Object)"\n").$plus((Object)"=== Wikipedia Input Files ===\n").$plus((Object)"\n").$plus((Object)"The datasets were extracted from ((").$plus((Object)this.dumps()).$plus((Object)" Wikipedia dumps)) generated ").$plus((Object)this.dumpDates()).$plus((Object)" (see also all ((DumpDatesDBpedia").$plus((Object)this.tag(this.current())).$plus((Object)" specific dates and times))).\n").$plus((Object)"\n").$plus((Object)this.include(this.OntologyPage())).$plus((Object)this.include(this.DataC14NPage())).$plus((Object)this.include(this.DataI18NPage())).$plus((Object)this.include(this.LinksPage())).$plus((Object)this.include(this.DescPage())).$plus((Object)this.include(this.NLPPage())).$plus((Object)"\n").$plus((Object)"[[#1]] Most files were packed with ((http://compression.ca/pbzip2/ pbzip2)), which generates concatenated streams. ").$plus((Object)"Some older bzip2 decompressors, for example ((https://issues.apache.org/jira/browse/COMPRESS-162 Apache Commons Compress before version 1.4)), ").$plus((Object)"cannot handle this format. Please make sure that you use the latest version. ").$plus((Object)"((https://lists.sourceforge.net/lists/listinfo/dbpedia-discussion/ Let us know)) if you experience any problems.\n").$plus((Object)"\n").$plus((Object)this.mark(""));
        this.write("", s.toString());
        this.ontologyPage(this.OntologyPage());
        this.datasetPages(this.DataC14NPage(), (Seq<List<CreateDownloadPage.Fileset>>)this.datasets());
        this.datasetPages(this.DataI18NPage(), (Seq<List<CreateDownloadPage.Fileset>>)this.datasets());
        this.datasetPages(this.LinksPage(), (Seq<List<CreateDownloadPage.Fileset>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new List[]{this.linksets()})));
        this.descriptionPage(this.DescPage());
        this.nlpPage(this.NLPPage());
    }

    public void ontologyPage(String page) {
        String format = "owl";
        CreateDownloadPage.FileInfo file = this.ontology().file("", "", format);
        StringPlusser s = new StringPlusser().$plus((Object)this.mark(page)).$plus((Object)"===Ontology===\n").$plus((Object)"#||\n").$plus((Object)"||**Dataset**|**").$plus((Object)format).$plus((Object)"**||\n").$plus((Object)"||((#").$plus((Object)this.ontology().anchor()).$plus((Object)" ").$plus((Object)this.ontology().name()).$plus((Object)"))\n").$plus((Object)"|").$plus((Object)"<#<small>").$plus((Object)"<a href=\"").$plus((Object)file.downloadUrl()).$plus((Object)"\" title=\"").$plus((Object)file.title()).$plus((Object)"\">").$plus((Object)format).$plus((Object)"</a> ").$plus((Object)"<small><a href=\"").$plus((Object)file.previewUrl()).$plus((Object)"\">?</a></small>").$plus((Object)"</small>#>\n").$plus((Object)"||\n").$plus((Object)"||#\n").$plus((Object)this.mark(page));
        this.write(page, s.toString());
    }

    public void datasetPages(String page$1, Seq<List<CreateDownloadPage.Fileset>> filesets$1) {
        String string;
        block5: {
            String string2;
            block9: {
                List list;
                block7: {
                    block8: {
                        block6: {
                            StringPlusser s$1;
                            block3: {
                                StringPlusser stringPlusser;
                                block4: {
                                    block2: {
                                        s$1 = new StringPlusser();
                                        s$1.$plus((Object)this.mark(page$1));
                                        string = page$1;
                                        String string3 = this.DataC14NPage();
                                        String string4 = string;
                                        if (string3 != null ? !string3.equals(string4) : string4 != null) break block2;
                                        stringPlusser = s$1.$plus((Object)"===Canonicalized Datasets===\n").$plus((Object)"These datasets contain triples extracted from the respective Wikipedia whose subject and object resource have an equivalent English article. ((Datasets#h18-19 more...))\n").$plus((Object)"\n").$plus((Object)"All DBpedia IRIs/URIs in the canonicalized datasets use the generic namespace ~http://dbpedia.org/. For backwards compatibility, the N-Triples files (.nt, .nq) use URIs, e.g. ((http://dbpedia.org/resource/Bo%C3%B6tes)). The Turtle (.ttl) files use IRIs, e.g. ((http://dbpedia.org/resource/Bo\u00f6tes)).\n");
                                        break block3;
                                    }
                                    String string5 = this.DataI18NPage();
                                    String string6 = string;
                                    if (string5 != null ? !string5.equals(string6) : string6 != null) break block4;
                                    stringPlusser = s$1.$plus((Object)"===Internationalized Datasets===\n").$plus((Object)"These datasets contain triples extracted from the respective Wikipedia, including the ones whose URIs do not have an equivalent English article. ((Datasets#h18-19 more...))\n").$plus((Object)"\n").$plus((Object)"The internationalized datasets use DBpedia IRIs (not URIs) and language-specific namespaces, e.g. <#<!--Wacko Wiki HTML-escapes some characters, even in URIs. We use percent-encoding to avoid that.-->#>((http://el.dbpedia.org/resource/%CE%92%CE%B5%CF%81%CE%BF%CE%BB%CE%AF%CE%BD%CE%BF http://el.dbpedia.org/resource/\u0392\u03b5\u03c1\u03bf\u03bb\u03af\u03bd\u03bf)).\n");
                                    break block3;
                                }
                                String string7 = this.LinksPage();
                                String string8 = string;
                                if (string7 != null ? !string7.equals(string8) : string8 != null) break block5;
                                stringPlusser = s$1.$plus((Object)"===Links to other datasets===\n").$plus((Object)"These datasets contain triples linking DBpedia to many other datasets.\n").$plus((Object)"\n").$plus((Object)"The URIs in these dumps use the generic namespace http://dbpedia.org/ .\n");
                            }
                            s$1.$plus((Object)"\n").$plus((Object)"**NOTE: You can find DBpedia dumps in ").$plus(this.allLanguages()).$plus((Object)" languages at our ((").$plus((Object)this.downloads()).$plus((Object)this.current()).$plus((Object)"/ DBpedia download server)).**\n").$plus((Object)"\n").$plus((Object)"//Click on the dataset names to obtain additional information. Click on the question mark next to a download link to preview file contents.//\n");
                            Predef$.MODULE$.intWrapper(0).until(filesets$1.length()).foreach((Function1)new Serializable(page$1, s$1){
                                public static final long serialVersionUID;
                                private final String page$1;
                                private final StringPlusser s$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final StringPlusser apply(int subPage) {
                                    return this.s$1.$plus((Object)CreateDownloadPage$.MODULE$.include(new StringBuilder().append((Object)this.page$1).append((Object)BoxesRunTime.boxToInteger((int)subPage)).toString()));
                                }
                                {
                                    this.page$1 = string;
                                    this.s$1 = stringPlusser;
                                }
                            });
                            s$1.$plus((Object)this.mark(page$1));
                            this.write(page$1, s$1.toString());
                            string2 = page$1;
                            String string9 = this.DataC14NPage();
                            String string10 = string2;
                            if (string9 != null ? !string9.equals(string10) : string10 != null) break block6;
                            list = this.languages();
                            break block7;
                        }
                        String string11 = this.DataI18NPage();
                        String string12 = string2;
                        if (string11 != null ? !string11.equals(string12) : string12 != null) break block8;
                        list = this.languages().drop(1);
                        break block7;
                    }
                    String string13 = this.LinksPage();
                    String string14 = string2;
                    if (string13 != null ? !string13.equals(string14) : string14 != null) break block9;
                    list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"links"}));
                }
                List langs$1 = list;
                Predef$.MODULE$.intWrapper(0).until(filesets$1.length()).foreach$mVc$sp((Function1)new Serializable(page$1, filesets$1, langs$1){
                    public static final long serialVersionUID;
                    private final String page$1;
                    private final Seq filesets$1;
                    private final List langs$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(int subPage) {
                        this.apply$mcVI$sp(subPage);
                    }

                    public void apply$mcVI$sp(int v1) {
                        CreateDownloadPage$.MODULE$.datasetPage(this.page$1, v1, (List<CreateDownloadPage.Fileset>)((List)this.filesets$1.apply(v1)), (Seq<String>)this.langs$1);
                    }
                    {
                        this.page$1 = string;
                        this.filesets$1 = seq;
                        this.langs$1 = list;
                    }
                });
                return;
            }
            throw new MatchError((Object)string2);
        }
        throw new MatchError((Object)string);
    }

    public void datasetPage(String page$2, int subPage, List<CreateDownloadPage.Fileset> filesets, Seq<String> languages$1) {
        StringPlusser s$2 = new StringPlusser();
        s$2.$plus((Object)this.mark(new StringBuilder().append((Object)page$2).append((Object)BoxesRunTime.boxToInteger((int)subPage)).toString())).$plus((Object)"#||\n").$plus((Object)languages$1.mkString("||**Dataset**|**", "**|**", "**||")).$plus((Object)"\n");
        filesets.foreach((Function1)new Serializable(page$2, languages$1, s$2){
            public static final long serialVersionUID;
            public final String page$2;
            private final Seq languages$1;
            public final StringPlusser s$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final StringPlusser apply(CreateDownloadPage.Fileset fileset$1) {
                this.s$2.$plus((Object)"||((#").$plus((Object)fileset$1.anchor()).$plus((Object)" ").$plus((Object)fileset$1.name()).$plus((Object)"))\n");
                BooleanRef first$1 = new BooleanRef(true);
                this.languages$1.foreach((Function1)new Serializable(this, fileset$1, first$1){
                    public static final long serialVersionUID;
                    private final anonfun.datasetPage.1 $outer;
                    public final CreateDownloadPage.Fileset fileset$1;
                    public final BooleanRef first$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(String language$1) {
                        String string;
                        block6: {
                            String string2;
                            block4: {
                                block5: {
                                    block3: {
                                        string = this.$outer.page$2;
                                        String string3 = CreateDownloadPage$.MODULE$.DataC14NPage();
                                        String string4 = string;
                                        if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
                                        String string5 = language$1;
                                        String string6 = "en";
                                        string2 = !(string5 != null ? !string5.equals(string6) : string6 != null) ? "" : "_en_uris";
                                        break block4;
                                    }
                                    String string7 = CreateDownloadPage$.MODULE$.DataI18NPage();
                                    String string8 = string;
                                    if (string7 != null ? !string7.equals(string8) : string8 != null) break block5;
                                    string2 = "";
                                    break block4;
                                }
                                String string9 = CreateDownloadPage$.MODULE$.LinksPage();
                                String string10 = string;
                                if (string9 != null ? !string9.equals(string10) : string10 != null) break block6;
                                string2 = "";
                            }
                            String modifier$1 = string2;
                            this.$outer.s$2.$plus((Object)"|");
                            this.fileset$1.formats().foreach((Function1)new Serializable(this, language$1, modifier$1){
                                public static final long serialVersionUID;
                                private final anonfun$datasetPage$1$$anonfun$apply$1 $outer;
                                private final String language$1;
                                private final String modifier$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final StringPlusser apply(String format) {
                                    CreateDownloadPage.FileInfo file = this.$outer.fileset$1.file(this.language$1, this.modifier$1, format);
                                    return file != null && (this.$outer.fileset$1.languages() || this.$outer.first$1.elem) ? this.$outer.org$dbpedia$extraction$scripts$CreateDownloadPage$$anonfun$$anonfun$$$outer().s$2.$plus((Object)"<#<small>").$plus((Object)"<a href=\"").$plus((Object)file.downloadUrl()).$plus((Object)"\" title=\"").$plus((Object)file.title()).$plus((Object)"\">").$plus((Object)format).$plus((Object)"</a> ").$plus((Object)"<small><a href=\"").$plus((Object)file.previewUrl()).$plus((Object)"\">?</a></small>").$plus((Object)"</small>#>\n") : this.$outer.org$dbpedia$extraction$scripts$CreateDownloadPage$$anonfun$$anonfun$$$outer().s$2.$plus((Object)"<#--#>\n");
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.language$1 = string;
                                    this.modifier$1 = string2;
                                }
                            });
                            this.first$1.elem = false;
                            return;
                        }
                        throw new MatchError((Object)string);
                    }

                    public anonfun.datasetPage.1 org$dbpedia$extraction$scripts$CreateDownloadPage$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.fileset$1 = fileset;
                        this.first$1 = booleanRef;
                    }
                });
                return this.s$2.$plus((Object)"||\n");
            }
            {
                this.page$2 = string;
                this.languages$1 = seq;
                this.s$2 = stringPlusser;
            }
        });
        s$2.$plus((Object)"||#\n").$plus((Object)this.mark(new StringBuilder().append((Object)page$2).append((Object)BoxesRunTime.boxToInteger((int)subPage)).toString()));
        this.write(new StringBuilder().append((Object)page$2).append((Object)BoxesRunTime.boxToInteger((int)subPage)).toString(), s$2.toString());
    }

    public void descriptionPage(String page) {
        StringPlusser s$3 = new StringPlusser();
        s$3.$plus((Object)this.mark(page)).$plus((Object)"=== Dataset Descriptions ===\n").$plus((Object)"\n");
        CreateDownloadPage.Ontology ontology = this.ontology();
        ((List)((List)this.datasets().flatten((Function1)Predef$.MODULE$.conforms())).$plus$plus(this.linksets(), List$.MODULE$.canBuildFrom())).$colon$colon((Object)ontology).foreach((Function1)new Serializable(s$3){
            public static final long serialVersionUID;
            private final StringPlusser s$3;

            static {
                long l = serialVersionUID = 0L;
            }

            public final StringPlusser apply(CreateDownloadPage.Fileset fileset) {
                return this.s$3.$plus((Object)"{{a name=\"").$plus((Object)fileset.anchor()).$plus((Object)"\"}}\n").$plus((Object)"==== ").$plus((Object)fileset.name()).$plus((Object)" ====\n").$plus((Object)fileset.text()).$plus((Object)"\n");
            }
            {
                this.s$3 = stringPlusser;
            }
        });
        s$3.$plus((Object)this.mark(page));
        this.write(page, s$3.toString());
    }

    public void nlpPage(String page) {
        StringPlusser s = new StringPlusser();
        s.$plus((Object)this.mark(page)).$plus((Object)"===NLP Datasets===\n").$plus((Object)"\n").$plus((Object)"DBpedia also includes a number of ((Datasets/NLP NLP Datasets)) -- datasets specifically targeted ").$plus((Object)"at supporting Computational Linguistics and Natural Language Processing (NLP) tasks. Among those, ").$plus((Object)"we highlight the Lexicalization Dataset, Topic Signatures, Thematic Concepts and Grammatical Genders.\n").$plus((Object)this.mark(page));
        this.write(page, s.toString());
    }

    public String mark(String page) {
        return new StringBuilder().append((Object)"<#<!--\nDO NOT EDIT - generated by CreateDownloadPage.scala\nhttp://wiki.dbpedia.org/Downloads").append((Object)this.tag(this.current())).append((Object)page).append((Object)"/edit\n").append((Object)"-->#>\n").toString();
    }

    public String include(String page) {
        return new StringBuilder().append((Object)"{{include page=/Downloads").append((Object)this.tag(this.current())).append((Object)page).append((Object)" nomark=1}}\n").toString();
    }

    public void write(String page, String content) {
        OutputStreamWriter writer = IOUtils$.MODULE$.write((FileLike<?>)RichFile$.MODULE$.wrapFile(new File(new StringBuilder().append((Object)"Downloads").append((Object)this.tag(this.current())).append((Object)page).append((Object)".wacko").toString())), IOUtils$.MODULE$.write$default$2());
        try {
            writer.write(content);
            return;
        }
        finally {
            writer.close();
        }
    }

    private CreateDownloadPage$() {
        MODULE$ = this;
        this.current = "3.8";
        this.downloads = "http://downloads.dbpedia.org/";
        this.dumps = "http://dumps.wikimedia.org/";
        this.zipSuffix = ".bz2";
        this.titles = new HashMap();
        this.formatter = new DecimalFormat("0.#", new DecimalFormatSymbols(Locale.ENGLISH));
        this.previous = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3.7", "3.6", "3.5.1", "3.5", "3.4", "3.3", "3.2", "3.1", "3.0", "3.0RC", "2.0"}));
        this.dumpDates = "in late May / early June 2012";
        this.allLanguages = 111;
        this.languages = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"en", "bg", "ca", "cs", "de", "el", "es", "fr", "hu", "it", "ko", "pl", "pt", "ru", "sl", "tr"}));
        this.ontology = new CreateDownloadPage.Ontology("DBpedia Ontology", new StringBuilder().append((Object)"dbpedia_").append((Object)this.current()).toString(), "//The DBpedia ontology in OWL. See ((http://jens-lehmann.org/files/2009/dbpedia_jws.pdf our JWS paper)) for more details.//");
        this.datasets = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new List[]{List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateDownloadPage.Dataset[]{new CreateDownloadPage.Dataset("Ontology Infobox Types", "instance_types", "//Contains triples of the form $object rdf:type $class from the ontology-based extraction.//"), new CreateDownloadPage.Dataset("Ontology Infobox Properties", "mappingbased_properties", "//High-quality data extracted from Infoboxes using the ontology-based extraction. The predicates in this dataset are in the /ontology/ namespace.//\n  Note that this data is of much higher quality than the Raw Infobox Properties in the /property/ namespace. For example, there are three different raw Wikipedia infobox properties for the birth date of a person. In the the /ontology/ namespace, they are all **mapped onto one relation** http://dbpedia.org/ontology/birthDate. It is a strong point of DBpedia to unify these relations."), new CreateDownloadPage.Dataset("Ontology Infobox Properties (Specific)", "specific_mappingbased_properties", "//Infobox data from the ontology-based extraction, using units of measurement more convenient for the resource type, e.g. square kilometres instead of square metres for the area of a city.//")})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateDownloadPage.Dataset[]{new CreateDownloadPage.Dataset("Titles", "labels", "//Titles of all Wikipedia Articles in the corresponding language.//"), new CreateDownloadPage.Dataset("Short Abstracts", "short_abstracts", "//Short Abstracts (max. 500 characters long) of Wikipedia articles.//"), new CreateDownloadPage.Dataset("Extended Abstracts", "long_abstracts", "//Full abstracts of Wikipedia articles, usually the first section.//"), new CreateDownloadPage.Dataset("Images", "images", "//Main image and corresponding thumbnail from Wikipedia article.//")})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateDownloadPage.Dataset[]{new CreateDownloadPage.Dataset("Geographic Coordinates", "geo_coordinates", "//Geographic coordinates extracted from Wikipedia.//"), new CreateDownloadPage.Dataset("Raw Infobox Properties", "infobox_properties", "//Information that has been extracted from Wikipedia infoboxes. Note that this data is in the less clean /property/ namespace. The Ontology Infobox Properties (/ontology/ namespace) should always be preferred over this data.//"), new CreateDownloadPage.Dataset("Raw Infobox Property Definitions", "infobox_property_definitions", "//All properties / predicates used in infoboxes.//"), new CreateDownloadPage.Dataset("Homepages", "homepages", "//Links to homepages of persons, organizations etc.//")})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateDownloadPage.Dataset[]{new CreateDownloadPage.Dataset("Persondata", "persondata", "//Information about persons (date and place of birth etc.) extracted from the English and German Wikipedia, represented using the FOAF vocabulary.//"), new CreateDownloadPage.Dataset("PND", "pnd", "//Dataset containing PND (Personennamendatei) identifiers.//"), new CreateDownloadPage.Dataset("Inter-Language Links", "interlanguage_links", "//Dataset linking a DBpedia resource to the same or a related resource in other languages, extracted from the ((http://en.wikipedia.org/wiki/Help:Interlanguage_links inter-language links)) of a Wikipedia article.//"), new CreateDownloadPage.Dataset("Bijective Inter-Language Links", "interlanguage_links_same_as", "//Dataset containing the bijective inter-language links between a DBpedia resource and the same resource in other languages, i.e. there is a link from a resource to the same resource in a different language and a link pointing back. When inter-language links are bijective, the Wikipedia articles are usually about the same subject.//"), new CreateDownloadPage.Dataset("Non-bijective Inter-Language Links", "interlanguage_links_see_also", "//Dataset containing the inter-language links between a DBpedia resource and related resources in other languages that are not bijective, i.e. there is a link from a resource to a related resource in a different language, but no link pointing back. When inter-language links are not bijective, the Wikipedia articles are usually not about the same subject.//")})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateDownloadPage.Dataset[]{new CreateDownloadPage.Dataset("Articles Categories", "article_categories", "//Links from concepts to categories using the SKOS vocabulary.//"), new CreateDownloadPage.Dataset("Categories (Labels)", "category_labels", "//Labels for Categories.//"), new CreateDownloadPage.Dataset("Categories (Skos)", "skos_categories", "//Information which concept is a category and how categories are related using the SKOS Vocabulary.//")})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateDownloadPage.Dataset[]{new CreateDownloadPage.Dataset("External Links", "external_links", "//Links to external web pages about a concept.//"), new CreateDownloadPage.Dataset("Links to Wikipedia Article", "wikipedia_links", "//Dataset linking DBpedia resource to corresponding article in Wikipedia.//"), new CreateDownloadPage.Dataset("Wikipedia Pagelinks", "page_links", "//Dataset containing internal links between DBpedia instances. The dataset was created from the internal links between Wikipedia articles. The dataset might be useful for structural analysis, data mining or for ranking DBpedia instances using Page Rank or similar algorithms.//")})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateDownloadPage.Dataset[]{new CreateDownloadPage.Dataset("Redirects", "redirects", "//Dataset containing redirects between articles in Wikipedia.//"), new CreateDownloadPage.Dataset("Transitive Redirects", "redirects_transitive", "//Redirects dataset in which multiple redirects have been resolved and redirect cycles have been removed.//"), new CreateDownloadPage.Dataset("Disambiguation links", "disambiguations", "//Links extracted from Wikipedia ((http://en.wikipedia.org/wiki/Wikipedia:Disambiguation disambiguation)) pages. Since Wikipedia has no syntax to distinguish disambiguation links from ordinary links, DBpedia has to use heuristics.//"), new CreateDownloadPage.Dataset("IRI-same-as-URI links", "iri_same_as_uri", "//owl:sameAs links between the ((http://tools.ietf.org/html/rfc3987 IRI)) and ((http://tools.ietf.org/html/rfc3986 URI)) format of DBpedia resources. Only extracted when IRI and URI are actually different.//")})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateDownloadPage.Dataset[]{new CreateDownloadPage.Dataset("Page IDs", "page_ids", "//Dataset linking a DBpedia resource to the page ID of the Wikipedia article the data was extracted from.//"), new CreateDownloadPage.Dataset("Revision IDs", "revision_ids", "//Dataset linking a DBpedia resource to the revision ID of the Wikipedia article the data was extracted from. Until DBpedia 3.7, these files had names like 'revisions_en.nt'. Since DBpedia 3.8, they were renamed to 'revisions_ids_en.nt' to distinguish them from the new 'revision_uris_en.nt' files.//"), new CreateDownloadPage.Dataset("Revision URIs", "revision_uris", "//Dataset linking DBpedia resource to the specific Wikipedia article revision used in this DBpedia release.//")}))}));
        this.linksets = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateDownloadPage.Linkset[]{new CreateDownloadPage.Linkset("Links to Amsterdam Museum data", "amsterdammuseum", "//Links between DBpedia and ((http://semanticweb.cs.vu.nl/lod/am/ Amsterdam Museum)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/amsterdammuseum Silk link specification)).//"), new CreateDownloadPage.Linkset("Links to BBC Wildlife Finder", "bbcwildlife", "//Links between DBpedia and ((http://www.bbc.co.uk/wildlifefinder/ BBC Wildlife Finder)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/bbcwildlife Silk link specification)).//"), new CreateDownloadPage.Linkset("Links to RDF Bookmashup", "bookmashup", "//Links between books in DBpedia and data about them provided by the ((http://www4.wiwiss.fu-berlin.de/bizer/bookmashup/ RDF Book Mashup)). Update mechanism: copy over from previous release.//"), new CreateDownloadPage.Linkset("Links to Bricklink", "bricklink", "//Links between DBpedia and ((http://kasabi.com/dataset/bricklink Bricklink)). Links created manually.//"), new CreateDownloadPage.Linkset("Links to CORDIS", "cordis", "//Links between DBpedia and ((http://www4.wiwiss.fu-berlin.de/cordis/ CORDIS)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/cordis Silk link specifications)).//"), new CreateDownloadPage.Linkset("Links to DailyMed", "dailymed", "//Links between DBpedia and ((http://www4.wiwiss.fu-berlin.de/dailymed/ DailyMed)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/dailymed Silk link specifications)).//"), new CreateDownloadPage.Linkset("Links to DBLP", "dblp", "//Links between computer scientists in DBpedia and their publications in the ((http://www.informatik.uni-trier.de/~ley/db/ DBLP)) database. Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/dblp Silk link specification)).//"), new CreateDownloadPage.Linkset("Links to DBTune", "dbtune", "//Links between DBpedia and ((http://dbtune.org/ DBTune)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/dbtune Silk link specifications)).//"), new CreateDownloadPage.Linkset("Links to Diseasome", "diseasome", "//Links between DBpedia and ((http://www4.wiwiss.fu-berlin.de/diseasome/ Diseasome)).  Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/diseasome Silk link specifications)).//"), new CreateDownloadPage.Linkset("Links to DrugBank", "drugbank", "//Links between DBpedia and ((http://www4.wiwiss.fu-berlin.de/drugbank/ DrugBank)).  Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/drugbank Silk link specifications)).//"), new CreateDownloadPage.Linkset("Links to EUNIS", "eunis", "//Links between DBpedia and ((http://eunis.eea.europa.eu EUNIS)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/eunis Silk link specification)).//"), new CreateDownloadPage.Linkset("Links to Eurostat (Linked Statistics)", "eurostat_linkedstatistics", "//Links between DBpedia and ((http://eurostat.linked-statistics.org Eurostat (Linked Statistics))). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/eurostat_linkedstatistics Silk link specifications)).//"), new CreateDownloadPage.Linkset("Links to Eurostat (WBSG)", "eurostat_wbsg", "//Links between countries and regions in DBpedia and data about them from ((http://www4.wiwiss.fu-berlin.de/eurostat/ Eurostat (WBSG))). Links created manually.//"), new CreateDownloadPage.Linkset("Links to CIA World Factbook", "factbook", "//Links between DBpedia and the ((http://www4.wiwiss.fu-berlin.de/factbook/ CIA World Factbook)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/factbook Silk link specifications)).//"), new CreateDownloadPage.Linkset("Links to flickr wrappr", "flickrwrappr", "//Links between DBpedia concepts and photo collections depicting them generated by ((http://www4.wiwiss.fu-berlin.de/flickrwrappr/ flickr wrappr)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/extraction_framework/file/dump/core/src/main/scala/org/dbpedia/extraction/mappings/FlickrWrapprLinkExtractor.scala Scala extractor)).//"), new CreateDownloadPage.Linkset("Links to Freebase", "freebase", "//Links between DBpedia and ((http://www.freebase.com/ Freebase (MIDs))). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/extraction_framework/file/dump/scripts/src/main/scala/org/dbpedia/extraction/scripts/CreateFreebaseLinks.scala Scala script)).//"), new CreateDownloadPage.Linkset("Links to GADM", "gadm", "//Links between DBpedia and ((http://gadm.geovocab.org/ GADM)). Update mechanism: copy over from previous release.//"), new CreateDownloadPage.Linkset("Links to GeoNames", "geonames", "//Links between geographic places in DBpedia and data about them from ((http://www.geonames.org/ GeoNames)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/geonames Silk link specifications)).//"), new CreateDownloadPage.Linkset("Links to GeoSpecies", "geospecies", "//Links between DBpedia and ((http://lod.geospecies.org/ GeoSpecies)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/geospecies Silk link specification)).//"), new CreateDownloadPage.Linkset("Links to Project Gutenberg", "gutenberg", "//Links between writers in DBpedia and data about them from ((www4.wiwiss.fu-berlin.de/gutendata/ Project Gutenberg)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/gutenberg Silk link specification)).//"), new CreateDownloadPage.Linkset("Links to Italian Public Schools", "italian_public_schools", "//Links between DBpedia and ((http://www.linkedopendata.it/datasets/scuole Italian Public Schools)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/italian-public-schools Silk link specification)).//"), new CreateDownloadPage.Linkset("Links to LinkedGeoData", "linkedgeodata", "//Links between DBpedia and ((http://linkedgeodata.org LinkedGeoData)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/linkedgeodata Silk link specifications)).//"), new CreateDownloadPage.Linkset("Links to LinkedMDB", "linkedmdb", "//Links between DBpedia and ((http://www.linkedmdb.org LinkedMDB)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/linkedmdb Silk link specifications)).//"), new CreateDownloadPage.Linkset("Links to MusicBrainz", "musicbrainz", "//Links between artists, albums and songs in DBpedia and data about them from ((http://zitgist.com/music/ MusicBrainz)). Update mechanism: copy over from previous release.//"), new CreateDownloadPage.Linkset("Links to New York Times", "nytimes", "//Links between ((http://www.nytimes.com/ New York Times)) subject headings and DBpedia concepts. Links copied from the original data set.//"), new CreateDownloadPage.Linkset("Links to OpenCyc", "opencyc", "//Links between DBpedia and ((http://opencyc.org/ OpenCyc)) concepts. ((OpenCyc Details)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/opencyc PHP script)).//"), new CreateDownloadPage.Linkset("Links to OpenEI (Open Energy Info)", "openei", "//Links between DBpedia and ((http://en.openei.org OpenEI)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/openei Silk link specifications)).//"), new CreateDownloadPage.Linkset("Links to Revyu", "revyu", "//Links between DBpedia and ((http://revyu.com Revyu)). Update mechanism: copy over from previous release.//"), new CreateDownloadPage.Linkset("Links to SIDER", "sider", "//Links between DBpedia and ((http://www4.wiwiss.fu-berlin.de/sider/ SIDER)). Links created by ((http://dbpedia.hg.sourceforge.net/hgweb/dbpedia/dbpedia/external_datasets/sider Silk link specifications)).//"), new CreateDownloadPage.Linkset("Links to RDF-TCM", "tcm", "//Links between DBpedia and ((http://code.google.com/p/junsbriefcase/wiki/RDFTCMData TCMGeneDIT)). Links copied from the original data set.//"), new CreateDownloadPage.Linkset("Links to UMBEL", "umbel", "//Links between DBpedia and ((http://umbel.org/ UMBEL)). Update mechanism: copy over from previous release.//"), new CreateDownloadPage.Linkset("Links to US Census", "uscensus", "//Links between US cities and states in DBpedia and data about them from ((http://www.rdfabout.com/demo/census/ US Census)). Update mechanism: copy over from previous release.//"), new CreateDownloadPage.Linkset("Links to WikiCompany", "wikicompany", "//Links between companies in DBpedia and companies in ((http://www4.wiwiss.fu-berlin.de/wikicompany/ WikiCompany)). Update mechanism: copy over from previous release.//"), new CreateDownloadPage.Linkset("Links to WordNet Classes", "wordnet", "//Classification links to ((http://www.w3.org/TR/wordnet-rdf/ RDF representations)) of ((http://wordnet.princeton.edu/ WordNet)) classes. Update mechanism: copy over from previous release.//"), new CreateDownloadPage.Linkset("Links to YAGO2", "yago", "//Dataset containing links between DBpedia and YAGO, YAGO type information for DBpedia resources and the YAGO class hierarchy. Currently maintained by Johannes Hoffart.//")}));
        this.OntologyPage = "Ontology";
        this.DataC14NPage = "DataC14N";
        this.DataI18NPage = "DataI18N";
        this.LinksPage = "Links";
        this.DescPage = "Desc";
        this.NLPPage = "NLP";
    }
}

