/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.scripts;

import java.io.File;
import java.io.OutputStreamWriter;
import org.dbpedia.extraction.destinations.Quad;
import org.dbpedia.extraction.ontology.RdfNamespace$;
import org.dbpedia.extraction.scripts.CountTypes$;
import org.dbpedia.extraction.scripts.Counter;
import org.dbpedia.extraction.scripts.Counter$;
import org.dbpedia.extraction.scripts.IOUtils$;
import org.dbpedia.extraction.scripts.QuadReader$;
import org.dbpedia.extraction.util.ConfigUtils$;
import org.dbpedia.extraction.util.FileLike;
import org.dbpedia.extraction.util.Finder;
import org.dbpedia.extraction.util.Language;
import org.dbpedia.extraction.util.RichFile;
import org.dbpedia.extraction.util.RichFile$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.SortedMap;
import scala.collection.immutable.SortedMap$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassManifest$;
import scala.reflect.OptManifest;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CountTypes$
implements ScalaObject {
    public static final CountTypes$ MODULE$;

    static {
        new CountTypes$();
    }

    private String[] split(String arg) {
        return (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])arg.split(",")).map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(String string) {
                return string.trim();
            }
        }, Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(String.class)))).filter((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String string) {
                return Predef$.MODULE$.augmentString(string).nonEmpty();
            }
        });
    }

    public void main(String[] args) {
        Predef$.MODULE$.require(args != null && args.length >= 5, (Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "need at least five args: base dir, input dataset name (e.g. 'instance-types'); input file suffix (e.g. '.nt.gz', '.ttl', '.ttl.bz2'); output text file name (e.g. 'instance-types-counted.txt' - one file per language dir, plus one file for total count in base dir); boolean flag: if true, write total type count to file in base dir, otherwise don't; languages or article count ranges (e.g. 'en,fr' or '10000-')";
            }
        });
        File baseDir$1 = new File(args[0]);
        String input$1 = args[1];
        Predef$.MODULE$.require(Predef$.MODULE$.augmentString(input$1).nonEmpty(), (Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "no input dataset";
            }
        });
        String suffix$1 = args[2];
        Predef$.MODULE$.require(Predef$.MODULE$.augmentString(suffix$1).nonEmpty(), (Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "no input file suffix";
            }
        });
        String output$1 = args[3];
        Predef$.MODULE$.require(Predef$.MODULE$.augmentString(output$1).nonEmpty(), (Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "no output file name";
            }
        });
        boolean total$1 = Predef$.MODULE$.augmentString(args[4]).toBoolean();
        Language[] languages = ConfigUtils$.MODULE$.parseLanguages(baseDir$1, (String[])Predef$.MODULE$.refArrayOps((Object[])args).drop(5));
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])languages).nonEmpty(), (Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "no languages";
            }
        });
        String rdfType$1 = RdfNamespace$.MODULE$.RDF().append("type");
        HashMap totalTypes$1 = total$1 ? new HashMap() : null;
        Predef$.MODULE$.refArrayOps((Object[])languages).foreach((Function1)new Serializable(baseDir$1, input$1, suffix$1, output$1, total$1, rdfType$1, totalTypes$1){
            public static final long serialVersionUID;
            private final File baseDir$1;
            private final String input$1;
            private final String suffix$1;
            private final String output$1;
            public final boolean total$1;
            public final String rdfType$1;
            public final HashMap totalTypes$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Language language) {
                HashMap languageTypes$1 = new HashMap();
                Finder finder = new Finder((Object)this.baseDir$1, language, (Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final RichFile apply(File file) {
                        return RichFile$.MODULE$.wrapFile(file);
                    }
                });
                List dates = finder.dates(new StringBuilder().append((Object)this.input$1).append((Object)this.suffix$1).toString(), false);
                if (dates.isEmpty()) {
                    Console$.MODULE$.err().println(new StringBuilder().append((Object)language.wikiCode()).append((Object)": WARNING: no file [").append((Object)this.input$1).append((Object)"] found").toString());
                } else {
                    String date = (String)dates.last();
                    File file = (File)finder.file(date, new StringBuilder().append((Object)this.input$1).append((Object)this.suffix$1).toString());
                    QuadReader$.MODULE$.readQuads(language.wikiCode(), (FileLike<?>)RichFile$.MODULE$.wrapFile(file), (Function1<Quad, BoxedUnit>)new Serializable(this, languageTypes$1){
                        public static final long serialVersionUID;
                        private final anonfun.main.6 $outer;
                        private final HashMap languageTypes$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply(Quad quad) {
                            if (quad.datatype() == null) {
                                String string = quad.predicate();
                                String string2 = this.$outer.rdfType$1;
                                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                    CountTypes$.MODULE$.org$dbpedia$extraction$scripts$CountTypes$$countType(quad.value(), (scala.collection.mutable.Map<String, Counter>)this.languageTypes$1);
                                    if (this.$outer.total$1) {
                                        CountTypes$.MODULE$.org$dbpedia$extraction$scripts$CountTypes$$countType(quad.value(), (scala.collection.mutable.Map<String, Counter>)this.$outer.totalTypes$1);
                                    }
                                    return;
                                }
                                throw new IllegalArgumentException(new StringBuilder().append((Object)"expected object uri, found object literal: ").append((Object)quad).toString());
                            }
                            throw new IllegalArgumentException(new StringBuilder().append((Object)"expected object uri, found object literal: ").append((Object)quad).toString());
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.languageTypes$1 = hashMap;
                        }
                    });
                    CountTypes$.MODULE$.org$dbpedia$extraction$scripts$CountTypes$$printTypes((File)finder.file(date, this.output$1), new StringBuilder().append((Object)language.wikiCode()).append((Object)" ").append((Object)this.input$1).toString(), (Map<String, Counter>)languageTypes$1);
                }
            }
            {
                this.baseDir$1 = file;
                this.input$1 = string;
                this.suffix$1 = string2;
                this.output$1 = string3;
                this.total$1 = bl;
                this.rdfType$1 = string4;
                this.totalTypes$1 = hashMap;
            }
        });
        if (total$1) {
            this.org$dbpedia$extraction$scripts$CountTypes$$printTypes(new File(baseDir$1, output$1), "total", (Map<String, Counter>)totalTypes$1);
        }
    }

    public final void org$dbpedia$extraction$scripts$CountTypes$$countType(String uri, scala.collection.mutable.Map<String, Counter> types) {
        Counter counter = (Counter)types.getOrElseUpdate((Object)uri, (Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Counter apply() {
                return new Counter(Counter$.MODULE$.init$default$1());
            }
        });
        counter.num_$eq(counter.num() + 1L);
    }

    public final void org$dbpedia$extraction$scripts$CountTypes$$printTypes(File file, String tag, Map<String, Counter> types) {
        SortedMap sorted = (SortedMap)SortedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])types.toArray(ClassManifest$.MODULE$.classType(Tuple2.class, (OptManifest)ClassManifest$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{ClassManifest$.MODULE$.classType(Counter.class)})))), (Ordering)Ordering.String$.MODULE$);
        OutputStreamWriter writer$1 = IOUtils$.MODULE$.write((FileLike<?>)RichFile$.MODULE$.wrapFile(file), IOUtils$.MODULE$.write$default$2());
        try {
            ((IterableLike)sorted.filter((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Tuple2<String, Counter> tuple2) {
                    Tuple2<String, Counter> tuple22 = tuple2;
                    return tuple22 != null;
                }
            })).foreach((Function1)new Serializable(writer$1){
                public static final long serialVersionUID;
                private final OutputStreamWriter writer$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Tuple2<String, Counter> tuple2) {
                    Tuple2<String, Counter> tuple22 = tuple2;
                    if (tuple22 != null) {
                        this.writer$1.write(new StringBuilder().append((Object)((String)tuple22._1())).append((Object)"\t").append((Object)BoxesRunTime.boxToLong((long)((Counter)tuple22._2()).num())).append((Object)"\n").toString());
                        return;
                    }
                    throw new MatchError(tuple22);
                }
                {
                    this.writer$1 = outputStreamWriter;
                }
            });
            return;
        }
        finally {
            writer$1.close();
        }
    }

    private CountTypes$() {
        MODULE$ = this;
    }
}

