/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.util.iterators;

import java.util.Iterator;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import org.dbpedia.extraction.live.util.ExceptionUtil;
import org.dbpedia.extraction.live.util.iterators.NodeListIterator;
import org.dbpedia.extraction.live.util.iterators.PrefetchIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathQueryIterator
extends PrefetchIterator<Node> {
    private static Logger logger = LoggerFactory.getLogger(XPathQueryIterator.class);
    private XPathExpression xPathExpression;
    private Iterator<Document> itDocument;

    public XPathQueryIterator(Iterator<Document> itDocument, XPathExpression xPathExpression) {
        this.itDocument = itDocument;
        this.xPathExpression = xPathExpression;
    }

    protected NodeListIterator prefetch() {
        while (this.itDocument.hasNext()) {
            Document document = this.itDocument.next();
            NodeList nodeList = null;
            try {
                nodeList = (NodeList)this.xPathExpression.evaluate(document, XPathConstants.NODESET);
            }
            catch (Exception e) {
                logger.warn(ExceptionUtil.toString(e));
            }
            if (nodeList == null || nodeList.getLength() == 0) continue;
            return new NodeListIterator(nodeList);
        }
        return null;
    }
}

