/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.util.iterators;

import java.io.BufferedReader;
import java.util.Collections;
import java.util.Iterator;
import org.dbpedia.extraction.live.util.iterators.PrefetchIterator;

public class WikiDumpPageIterator
extends PrefetchIterator<String> {
    private BufferedReader reader;

    public WikiDumpPageIterator(BufferedReader reader) {
        this.reader = reader;
    }

    @Override
    protected Iterator<String> prefetch() throws Exception {
        String line;
        String result = "";
        while ((line = this.reader.readLine()) != null) {
            if (!line.trim().startsWith("<page>")) continue;
            result = result + line + "\n";
            while ((line = this.reader.readLine()) != null) {
                if (line.trim().startsWith("</page>")) {
                    result = result + line + "\n";
                    return Collections.singleton(result).iterator();
                }
                result = result + line + "\n";
            }
        }
        return null;
    }
}

