/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.util.iterators;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.dbpedia.extraction.live.util.DBPediaXPathUtil;
import org.dbpedia.extraction.live.util.OAIUtil;
import org.dbpedia.extraction.live.util.XPathUtil;
import org.dbpedia.extraction.live.util.collections.TimeStampMap;
import org.dbpedia.extraction.live.util.iterators.PrefetchIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TimeWindowIterator
extends PrefetchIterator<Document> {
    private TimeStampMap<String, Document, Date, Long> map;
    private Iterator<Document> iterator;

    public TimeWindowIterator(Iterator<Document> iterator, long maxDistance, boolean inclusive, boolean allowRenewal) {
        this.map = TimeStampMap.create(String.class, Document.class, maxDistance, inclusive, allowRenewal);
        this.iterator = iterator;
    }

    public TimeStampMap<String, Document, Date, Long> getQueued() {
        return this.map;
    }

    @Override
    protected Iterator<Document> prefetch() throws Exception {
        while (this.iterator.hasNext()) {
            Document node = this.iterator.next();
            String id = XPathUtil.evalToString((Node)node, DBPediaXPathUtil.getPageIdExpr());
            String dateString = XPathUtil.evalToString((Node)node, DBPediaXPathUtil.getTimestampExpr());
            Date time = OAIUtil.getOAIDateFormat().parse(dateString);
            Map<String, Document> ids = this.map.setCurrentTime(time);
            this.map.put(id, node);
            if (ids.isEmpty()) continue;
            return ids.values().iterator();
        }
        return null;
    }
}

