/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.util.collections;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.Iterator;
import org.dbpedia.extraction.live.util.ExceptionUtil;
import org.dbpedia.extraction.live.util.collections.PersistentQueue;
import org.dbpedia.extraction.live.util.iterators.PrefetchIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentQueueIterator
extends PrefetchIterator<Object> {
    private static Logger logger = LoggerFactory.getLogger(PersistentQueueIterator.class);
    private PersistentQueue queue;
    private int startIndex;

    PersistentQueueIterator(PersistentQueue queue) {
        this.queue = queue;
        this.startIndex = queue.getStartIndex();
    }

    @Override
    protected Iterator<Object> prefetch() {
        try {
            if (this.startIndex == this.queue.getEndIndex()) {
                return null;
            }
            RandomAccessFile file = this.queue.getFile();
            file.seek(this.startIndex);
            int length = file.readInt();
            byte[] buffer = new byte[length];
            file.read(buffer, 0, length);
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(buffer));
            Object result = ois.readObject();
            this.startIndex += length + 4;
            return Collections.singleton(result).iterator();
        }
        catch (Exception e) {
            logger.warn(ExceptionUtil.toString(e));
            return null;
        }
    }
}

