/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.util.collections;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.Iterator;
import org.dbpedia.extraction.live.util.collections.PersistentQueueIterator;

public class PersistentQueue {
    private int startIndex = 0;
    private int endIndex;
    private int objectCount;
    private RandomAccessFile file;
    private final String magic = "http://dbpedia.org/persistent-array-queue/alpha";

    int getStartIndex() {
        return this.startIndex;
    }

    int getEndIndex() {
        return this.endIndex;
    }

    public int getObjectCount() {
        return this.objectCount;
    }

    RandomAccessFile getFile() {
        return this.file;
    }

    public PersistentQueue(String filename) throws Exception {
        File f = new File(filename);
        if (f.exists()) {
            this.file = new RandomAccessFile(filename, "rw");
            this.readHeader();
        } else {
            this.file = new RandomAccessFile(filename, "rw");
            this.writeHeader();
        }
    }

    private void readHeader() throws IOException {
        this.file.seek(0L);
        String m = this.file.readUTF();
        System.out.println(m.length());
        System.out.println("http://dbpedia.org/persistent-array-queue/alpha".length());
        if (!m.equals("http://dbpedia.org/persistent-array-queue/alpha")) {
            throw new RuntimeException("Unsupported magic value");
        }
        this.file.seek(52L);
        this.startIndex = this.file.readInt();
        this.endIndex = this.file.readInt();
        this.objectCount = this.file.readInt();
    }

    private void writeHeader() throws IOException {
        this.file.seek(0L);
        this.file.writeUTF("http://dbpedia.org/persistent-array-queue/alpha");
        this.setStartIndex(64);
        this.setEndIndex(64);
        this.setObjectCount(0);
    }

    private void setStartIndex(int value) throws IOException {
        this.file.seek(52L);
        this.file.writeInt(value);
        this.endIndex = value;
    }

    private void setEndIndex(int value) throws IOException {
        this.file.seek(56L);
        this.file.writeInt(value);
        this.endIndex = value;
    }

    private void setObjectCount(int value) throws IOException {
        this.file.seek(60L);
        this.file.writeInt(value);
        this.objectCount = value;
    }

    public void push(Object o) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(o);
        byte[] data = baos.toByteArray();
        this.file.seek(this.endIndex);
        this.file.writeInt(data.length);
        this.file.write(data);
        this.setEndIndex(this.endIndex + data.length + 4);
        this.setObjectCount(this.objectCount + 1);
    }

    public void clear() throws Exception {
        this.file.setLength(64L);
        this.writeHeader();
    }

    public Object pop() {
        throw new RuntimeException("Unsupported operation");
    }

    public Iterator<Object> iterator() {
        return new PersistentQueueIterator(this);
    }
}

