/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.util.collections;

import java.util.HashMap;
import java.util.Map;
import org.dbpedia.extraction.live.util.collections.IOneToOneMap;

public class OneToOneMap<TKey, TValue>
extends HashMap<TKey, TValue>
implements IOneToOneMap<TKey, TValue> {
    private Map<TValue, TKey> value_2_key = new HashMap<TValue, TKey>();

    @Override
    public TValue put(TKey key, TValue value) {
        if (this.value_2_key.containsKey(value)) {
            throw new RuntimeException("Multiple keys for the same value");
        }
        super.put(key, value);
        this.value_2_key.put(value, key);
        return value;
    }

    @Override
    public TKey getKey(Object value) {
        return this.value_2_key.get(value);
    }

    @Override
    public boolean contains(Object key, Object value) {
        return value == this.get(key);
    }

    @Override
    public TKey removeValue(Object key) {
        TKey k = this.value_2_key.remove(key);
        this.remove(k);
        return k;
    }

    @Override
    public void clear() {
        super.clear();
        this.value_2_key.clear();
    }
}

