/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.util;

import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.dbpedia.extraction.live.util.ExceptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBPediaXPathUtil {
    private static Logger logger = LoggerFactory.getLogger(DBPediaXPathUtil.class);
    private static Map<String, XPathExpression> map = new HashMap<String, XPathExpression>();

    private static XPathExpression compile(String expression) {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            return xPath.compile(expression);
        }
        catch (Exception e) {
            logger.error(ExceptionUtil.toString(e), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static XPathExpression get(String id, String query) {
        XPathExpression expr = map.get(id);
        if (expr == null) {
            expr = DBPediaXPathUtil.compile(query);
            map.put(id, expr);
        }
        return expr;
    }

    public static XPathExpression getOAIResponseDateExpr() {
        return DBPediaXPathUtil.get("oaiResponseDate", "//*[local-name()='responseDate']/text()");
    }

    public static XPathExpression getOAIIdentifierExpr() {
        return DBPediaXPathUtil.get("oaiIdentifier", "//*[local-name()='header']/*[local-name()='identifier']/text()");
    }

    public static XPathExpression getOAIIsRecordDeletedExpr() {
        return DBPediaXPathUtil.get("recordDeleted", "//*[local-name()='header']/@status");
    }

    public static XPathExpression getOAIDatestampExpr() {
        return DBPediaXPathUtil.get("datestamp", "//*[local-name()='datestamp']");
    }

    public static XPathExpression getRecordExpr() {
        return DBPediaXPathUtil.get("record", "//*[local-name()='record']");
    }

    public static XPathExpression getPageIdExpr() {
        return DBPediaXPathUtil.get("pageId", "//*[local-name()='page']/*[local-name()='id']/text()");
    }

    public static XPathExpression getTitleExpr() {
        return DBPediaXPathUtil.get("title", "//*[local-name()='title']");
    }

    public static XPathExpression getRevisionExpr() {
        return DBPediaXPathUtil.get("revision", "//*[local-name()='revision']/*[local-name()='id']");
    }

    public static XPathExpression getTimestampExpr() {
        return DBPediaXPathUtil.get("timestamp", "//*[local-name()='header']/*[local-name()='datestamp']/text()");
    }

    public static XPathExpression getIdentifierExpr() {
        return DBPediaXPathUtil.get("identifier", "//*[local-name()='identifier']");
    }

    public static XPathExpression getContributorNameExpr() {
        return DBPediaXPathUtil.get("contributorName", "//*[local-name()='contributor']/*[local-name()='username']");
    }

    public static XPathExpression getContributorIdExpr() {
        return DBPediaXPathUtil.get("contributorId", "//*[local-name()='contributor']/*[local-name()='id']");
    }

    public static XPathExpression getContributorIpExpr() {
        return DBPediaXPathUtil.get("contributorIp", "//*[local-name()='contributor']/*[local-name()='ip']");
    }

    public static XPathExpression getTextExpr() {
        return DBPediaXPathUtil.get("text", "//*[local-name()='text']/text()");
    }

    public static XPathExpression getLanguageExpr() {
        return DBPediaXPathUtil.get("lang", "//@*[local-name()= 'lang']");
    }
}

