/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.transformer;

import java.util.Iterator;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import org.apache.commons.collections15.Transformer;
import org.dbpedia.extraction.live.util.ExceptionUtil;
import org.dbpedia.extraction.live.util.XMLUtil;
import org.dbpedia.extraction.live.util.XPathUtil;
import org.dbpedia.extraction.live.util.iterators.NodeListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathTransformer
implements Transformer<Node, Iterator<Node>> {
    private Logger logger = LoggerFactory.getLogger(XPathTransformer.class);
    private XPathExpression xPathExpression;

    public XPathTransformer(String expr) throws Exception {
        this.xPathExpression = XPathUtil.compile(expr);
    }

    public XPathTransformer(XPathExpression xPathExpression) {
        this.xPathExpression = xPathExpression;
    }

    public NodeListIterator transform(Node node) {
        NodeList result = null;
        try {
            result = (NodeList)this.xPathExpression.evaluate(node, XPathConstants.NODESET);
            this.logger.debug(result.getLength() + " nodes matched");
        }
        catch (Exception e) {
            this.logger.warn(ExceptionUtil.toString(e));
        }
        if (result == null || result.getLength() == 0) {
            this.logger.warn("No nodes matched in a document");
            String data = XMLUtil.toString(node);
            this.logger.trace("Document was:\n" + data);
            return null;
        }
        return new NodeListIterator(result);
    }
}

