/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.transformer;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections15.Transformer;
import org.dbpedia.extraction.live.util.ExceptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class NodeToDocumentTransformer
implements Transformer<Node, Document> {
    private static Logger logger = LoggerFactory.getLogger(NodeToDocumentTransformer.class);

    public Document transform(Node node) {
        Document document = null;
        try {
            if (node == null) {
                return null;
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.newDocument();
            Node clone = document.importNode(node, true);
            document.appendChild(clone);
        }
        catch (ParserConfigurationException e) {
            logger.warn(ExceptionUtil.toString(e));
        }
        return document;
    }
}

