/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.storage;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.dbpedia.extraction.live.queue.LiveQueueItem;
import org.dbpedia.extraction.live.storage.DBpediaSQLQueries;
import org.dbpedia.extraction.live.storage.JDBCPoolConnection;
import org.dbpedia.extraction.live.storage.JSONCacheItem;
import org.dbpedia.extraction.live.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCUtil {
    private static Logger logger = LoggerFactory.getLogger(JDBCUtil.class);

    public static boolean execSQL(String query) {
        return JDBCUtil.execSQL(query, false);
    }

    public static boolean execSQL(String query, boolean sparql) {
        try {
            JDBCUtil._execSQL(query, sparql);
            return true;
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _execSQL(String query, boolean sparql) throws Exception {
        Connection conn = null;
        Statement stmt = null;
        ResultSet result = null;
        try {
            conn = JDBCPoolConnection.getCachePoolConnection();
            stmt = conn.createStatement();
            result = stmt.executeQuery(query);
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (Exception e) {
                throw new Exception(e.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                throw new Exception(e.getMessage());
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                throw new Exception(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean execPrepared(String preparedQuery, String[] parameterList) {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            int i;
            conn = JDBCPoolConnection.getCachePoolConnection();
            stmt = conn.prepareStatement(preparedQuery);
            for (i = 0; i < parameterList.length; ++i) {
                stmt.setString(i + 1, parameterList[i]);
            }
            stmt.execute();
            i = 1;
            return i != 0;
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONCacheItem getCacheContent(String query, long pageID) {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            conn = JDBCPoolConnection.getCachePoolConnection();
            stmt = conn.prepareStatement(query);
            stmt.setLong(1, pageID);
            result = stmt.executeQuery();
            if (result.next()) {
                int timesUpdated = result.getInt("timesUpdated");
                Blob jsonBlob = result.getBlob("json");
                byte[] jsonData = jsonBlob.getBytes(1L, (int)jsonBlob.length());
                String jsonString = new String(jsonData);
                Blob subjectsBlob = result.getBlob("subjects");
                byte[] subjectsData = subjectsBlob.getBytes(1L, (int)subjectsBlob.length());
                String subjects = new String(subjectsData);
                HashSet<String> subjectSet = new HashSet<String>();
                for (String item : subjects.split("\n")) {
                    String subject = item.trim();
                    if (subject.isEmpty()) continue;
                    subjectSet.add(StringEscapeUtils.unescapeJava((String)subject));
                }
                JSONCacheItem jSONCacheItem = new JSONCacheItem(pageID, timesUpdated, jsonString, subjectSet);
                return jSONCacheItem;
            }
            JSONCacheItem timesUpdated = null;
            return timesUpdated;
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
            JSONCacheItem jSONCacheItem = null;
            return jSONCacheItem;
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LiveQueueItem> getCacheUnmodified(int daysAgo, long limit) {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet result = null;
        ArrayList<LiveQueueItem> items = null;
        try {
            conn = JDBCPoolConnection.getCachePoolConnection();
            stmt = conn.prepareStatement(DBpediaSQLQueries.getJSONCacheUnmodified());
            stmt.setInt(1, daysAgo);
            stmt.setLong(2, limit);
            result = stmt.executeQuery();
            items = new ArrayList<LiveQueueItem>((int)limit);
            while (result.next()) {
                long pageID = result.getLong("pageID");
                Timestamp t = result.getTimestamp("updated");
                String timestamp = DateUtil.transformToUTC(t.getTime());
                items.add(new LiveQueueItem(pageID, timestamp));
            }
            ArrayList<LiveQueueItem> pageID = items;
            return pageID;
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
            List<LiveQueueItem> list = null;
            return list;
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
            }
        }
    }
}

