/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.storage;

import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.BoneCPConfig;
import java.sql.Connection;
import java.sql.SQLException;
import org.dbpedia.extraction.live.core.LiveOptions;
import org.dbpedia.extraction.live.main.Main;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCPoolConnection {
    private static Logger logger = LoggerFactory.getLogger(JDBCPoolConnection.class);
    private static volatile BoneCP connectionCachePool = null;

    private JDBCPoolConnection() {
    }

    private static void initCacheConnection() {
        try {
            BoneCPConfig config = new BoneCPConfig();
            Class.forName((String)LiveOptions.options.get((Object)"cache.class"));
            config.setJdbcUrl((String)LiveOptions.options.get((Object)"cache.dsn"));
            config.setUsername((String)LiveOptions.options.get((Object)"cache.user"));
            config.setPassword((String)LiveOptions.options.get((Object)"cache.pw"));
            connectionCachePool = new BoneCP(config);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            logger.error("Could not initialize DB connection! Exiting...");
            Main.stopLive();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Connection getCachePoolConnection() throws SQLException {
        if (connectionCachePool != null) return connectionCachePool.getConnection();
        Class<JDBCPoolConnection> clazz = JDBCPoolConnection.class;
        synchronized (JDBCPoolConnection.class) {
            if (connectionCachePool != null) return connectionCachePool.getConnection();
            JDBCPoolConnection.initCacheConnection();
            // ** MonitorExit[var0] (shouldn't be in output)
            return connectionCachePool.getConnection();
        }
    }

    public static void shutdown() {
        if (connectionCachePool != null) {
            try {
                connectionCachePool.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

