/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.statistics;

public class StatisticsItem
implements Comparable<StatisticsItem> {
    private String pageName = "";
    private String pageDBpedia = "";
    private String pageWikipedia = "";
    private int pageID = 0;
    private long pageTimestamp = 0L;
    private boolean pageHasDelta = false;

    public StatisticsItem(String name, String dbpediaURI, String wikipediaURI, int id, long timestamp, boolean delta) {
        this.pageName = name;
        this.pageDBpedia = dbpediaURI;
        this.pageWikipedia = wikipediaURI;
        this.pageID = id;
        this.pageTimestamp = timestamp;
        this.pageHasDelta = delta;
    }

    public StatisticsItem(String name, String dbpediaURI, String wikipediaURI, int id, long timestamp) {
        this(name, dbpediaURI, wikipediaURI, id, timestamp, false);
    }

    public StatisticsItem() {
        this("", "", "", 0, System.currentTimeMillis(), false);
    }

    public boolean getHasDelta() {
        return this.pageHasDelta;
    }

    public void setHasDelta(boolean hasDelta) {
        this.pageHasDelta = hasDelta;
    }

    public long getTimestamp() {
        return this.pageTimestamp;
    }

    public boolean isOlderThanMillis(long refTime, long duration) {
        return refTime - this.pageTimestamp > duration;
    }

    public String getPageTitle() {
        return this.pageName;
    }

    public String getDBpediaURI() {
        return this.pageDBpedia;
    }

    public String getWikipediaURI() {
        return this.pageWikipedia;
    }

    public int getPageID() {
        return this.pageID;
    }

    @Override
    public int compareTo(StatisticsItem item) {
        if (item.getTimestamp() == this.getTimestamp()) {
            return 0;
        }
        return item.getTimestamp() > this.getTimestamp() ? 1 : -1;
    }

    public boolean equals(Object item) {
        try {
            return this.getPageID() == ((StatisticsItem)item).getPageID();
        }
        catch (Exception exp) {
            return false;
        }
    }

    public String toString() {
        return this.pageName + "\t" + this.pageDBpedia + "\t" + this.pageWikipedia + "\t" + this.pageTimestamp + "\t" + this.pageHasDelta;
    }
}

